<?php
/* Autor...: William L. Taype Perez */
/* Esquema.: ALM_AlmacenMast.xml */
/* Generado: 2020-08-18 04:21:23 */

/* Validacion del contenido de los campos campos de la tabla ALM_AlmacenMast */
abstract class BaseALM_AlmacenMastBV extends ALM_AlmacenMastBN
{
    /* Contiene la clase que valida el tipo de dato */
    private $o_Validator; // Contiene el objeto que realizara la validacion de tipo de dato.
    private $s_ValidatorMessage; // Contiene la ultima observacion de la validacion del tipo de dato.

    /* Constructor ( Establece la clase que valida los tipos de datos y establece los valores por defecto ) */
    public function __construct()
    {
        /* Establecemos el objeto que realizara la validacion del tipo de dato */
        $this->o_Validator = new utilValidDataType();

        /* Establecemos los valores por defecto */
    }

    /* Valida en tipo de dato */
    private function validateData( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull )
    {
        $this->s_ValidatorMessage = null;
        if( !$this->o_Validator->validate( $u_Data, $s_DataType, $i_Length, $i_Decimal, $b_NotNull ) )
        {
            $this->s_ValidatorMessage = $this->o_Validator->getMessage();
        }
        return is_null( $this->s_ValidatorMessage );
    }

    /* Valida y establece el valor del campo IdAlmacen */
    public function setIdAlmacen( $s_IdAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacen, "CHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacen( $s_IdAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdCompania, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdCompania ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdCompania( $i_IdCompania );
        return true;
    }

    /* Valida y establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdSucursal, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdSucursal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdSucursal( $i_IdSucursal );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidadCrianza */
    public function setIdUnidadCrianza( $i_IdUnidadCrianza, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidadCrianza, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo IdUnidadCrianza ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidadCrianza( $i_IdUnidadCrianza );
        return true;
    }

    /* Valida y establece el valor del campo IdAlmacenGrupo */
    public function setIdAlmacenGrupo( $s_IdAlmacenGrupo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_IdAlmacenGrupo, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo IdAlmacenGrupo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdAlmacenGrupo( $s_IdAlmacenGrupo );
        return true;
    }

    /* Valida y establece el valor del campo MultiCompaniaFlag */
    public function setMultiCompaniaFlag( $s_MultiCompaniaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_MultiCompaniaFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo MultiCompaniaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setMultiCompaniaFlag( $s_MultiCompaniaFlag );
        return true;
    }

    /* Valida y establece el valor del campo CompaniaSocio */
    public function setCompaniaSocio( $s_CompaniaSocio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CompaniaSocio, "VARCHAR", 8, 0, false ) )
            {
                throw new Exception( "El campo CompaniaSocio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCompaniaSocio( $s_CompaniaSocio );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionLocal */
    public function setDescripcionLocal( $s_DescripcionLocal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionLocal, "VARCHAR", 40, 0, false ) )
            {
                throw new Exception( "El campo DescripcionLocal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionLocal( $s_DescripcionLocal );
        return true;
    }

    /* Valida y establece el valor del campo DescripcionIngles */
    public function setDescripcionIngles( $s_DescripcionIngles, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DescripcionIngles, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo DescripcionIngles ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDescripcionIngles( $s_DescripcionIngles );
        return true;
    }

    /* Valida y establece el valor del campo Direccion */
    public function setDireccion( $s_Direccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Direccion, "VARCHAR", 100, 0, false ) )
            {
                throw new Exception( "El campo Direccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDireccion( $s_Direccion );
        return true;
    }

    /* Valida y establece el valor del campo UnidadNegocio */
    public function setUnidadNegocio( $s_UnidadNegocio, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UnidadNegocio, "VARCHAR", 4, 0, false ) )
            {
                throw new Exception( "El campo UnidadNegocio ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUnidadNegocio( $s_UnidadNegocio );
        return true;
    }

    /* Valida y establece el valor del campo TipoAlmacen */
    public function setTipoAlmacen( $s_TipoAlmacen, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoAlmacen, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo TipoAlmacen ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoAlmacen( $s_TipoAlmacen );
        return true;
    }

    /* Valida y establece el valor del campo TipoUnidadCrianza */
    public function setTipoUnidadCrianza( $s_TipoUnidadCrianza, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_TipoUnidadCrianza, "VARCHAR", 15, 0, false ) )
            {
                throw new Exception( "El campo TipoUnidadCrianza ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setTipoUnidadCrianza( $s_TipoUnidadCrianza );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenTransitoPrincipal */
    public function setAlmacenTransitoPrincipal( $s_AlmacenTransitoPrincipal, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenTransitoPrincipal, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo AlmacenTransitoPrincipal ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenTransitoPrincipal( $s_AlmacenTransitoPrincipal );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenVentaFlag */
    public function setAlmacenVentaFlag( $s_AlmacenVentaFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenVentaFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AlmacenVentaFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenVentaFlag( $s_AlmacenVentaFlag );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenProduccionFlag */
    public function setAlmacenProduccionFlag( $s_AlmacenProduccionFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenProduccionFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AlmacenProduccionFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenProduccionFlag( $s_AlmacenProduccionFlag );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenConsignacionFlag */
    public function setAlmacenConsignacionFlag( $s_AlmacenConsignacionFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenConsignacionFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AlmacenConsignacionFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenConsignacionFlag( $s_AlmacenConsignacionFlag );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenCommodityFlag */
    public function setAlmacenCommodityFlag( $s_AlmacenCommodityFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenCommodityFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AlmacenCommodityFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenCommodityFlag( $s_AlmacenCommodityFlag );
        return true;
    }

    /* Valida y establece el valor del campo DisponiblePlanProduccionFlag */
    public function setDisponiblePlanProduccionFlag( $s_DisponiblePlanProduccionFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_DisponiblePlanProduccionFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo DisponiblePlanProduccionFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setDisponiblePlanProduccionFlag( $s_DisponiblePlanProduccionFlag );
        return true;
    }

    /* Valida y establece el valor del campo SubAlmacenFlag */
    public function setSubAlmacenFlag( $s_SubAlmacenFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_SubAlmacenFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo SubAlmacenFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setSubAlmacenFlag( $s_SubAlmacenFlag );
        return true;
    }

    /* Valida y establece el valor del campo CuentaInventario */
    public function setCuentaInventario( $s_CuentaInventario, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaInventario, "VARCHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo CuentaInventario ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaInventario( $s_CuentaInventario );
        return true;
    }

    /* Valida y establece el valor del campo CuentaGasto */
    public function setCuentaGasto( $s_CuentaGasto, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CuentaGasto, "CHAR", 20, 0, false ) )
            {
                throw new Exception( "El campo CuentaGasto ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCuentaGasto( $s_CuentaGasto );
        return true;
    }

    /* Valida y establece el valor del campo NumeroMesesStock */
    public function setNumeroMesesStock( $i_NumeroMesesStock, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_NumeroMesesStock, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo NumeroMesesStock ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setNumeroMesesStock( $i_NumeroMesesStock );
        return true;
    }

    /* Valida y establece el valor del campo ComercialCajero */
    public function setComercialCajero( $i_ComercialCajero, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ComercialCajero, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ComercialCajero ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComercialCajero( $i_ComercialCajero );
        return true;
    }

    /* Valida y establece el valor del campo Encargado */
    public function setEncargado( $i_Encargado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_Encargado, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo Encargado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEncargado( $i_Encargado );
        return true;
    }

    /* Valida y establece el valor del campo ComercialCobrador */
    public function setComercialCobrador( $i_ComercialCobrador, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_ComercialCobrador, "INT", 11, 0, false ) )
            {
                throw new Exception( "El campo ComercialCobrador ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setComercialCobrador( $i_ComercialCobrador );
        return true;
    }

    /* Valida y establece el valor del campo AlmacenGastoFlag */
    public function setAlmacenGastoFlag( $s_AlmacenGastoFlag, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_AlmacenGastoFlag, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo AlmacenGastoFlag ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setAlmacenGastoFlag( $s_AlmacenGastoFlag );
        return true;
    }

    /* Valida y establece el valor del campo Estado */
    public function setEstado( $s_Estado, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Estado, "VARCHAR", 1, 0, false ) )
            {
                throw new Exception( "El campo Estado ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setEstado( $s_Estado );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioModificacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioModificacion( $s_UsuarioModificacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaModificacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaModificacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaModificacion( $d_FechaModificacion );
        return true;
    }

    /* Valida y establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_UsuarioCreacion, "VARCHAR", 30, 0, false ) )
            {
                throw new Exception( "El campo UsuarioCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setUsuarioCreacion( $s_UsuarioCreacion );
        return true;
    }

    /* Valida y establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $d_FechaCreacion, "TIMESTAMP", 0, 0, false ) )
            {
                throw new Exception( "El campo FechaCreacion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setFechaCreacion( $d_FechaCreacion );
        return true;
    }

    /* Valida y establece el valor del campo Codigo */
    public function setCodigo( $s_Codigo, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_Codigo, "VARCHAR", 6, 0, false ) )
            {
                throw new Exception( "El campo Codigo ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigo( $s_Codigo );
        return true;
    }

    /* Valida y establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $s_CodigoSunat, "VARCHAR", 10, 0, false ) )
            {
                throw new Exception( "El campo CodigoSunat ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setCodigoSunat( $s_CodigoSunat );
        return true;
    }

    /* Valida y establece el valor del campo IdUnidadProduccion */
    public function setIdUnidadProduccion( $i_IdUnidadProduccion, $b_ValidateData = true )
    {
        if ( $b_ValidateData == true )
        {
            if ( !$this->validateData( $i_IdUnidadProduccion, "INT", 30, 0, false ) )
            {
                throw new Exception( "El campo IdUnidadProduccion ".strtolower( $this->s_ValidatorMessage ) );
            }
        }
        parent::setIdUnidadProduccion( $i_IdUnidadProduccion );
        return true;
    }

    /* Valida el contenido del registro */
    public function validateRecord()
    {
        $this->setIdAlmacen( $this->getIdAlmacen(), false );
        $this->setIdCompania( $this->getIdCompania(), true );
        $this->setIdSucursal( $this->getIdSucursal(), true );
        $this->setIdUnidadCrianza( $this->getIdUnidadCrianza(), true );
        $this->setIdAlmacenGrupo( $this->getIdAlmacenGrupo(), true );
        $this->setMultiCompaniaFlag( $this->getMultiCompaniaFlag(), true );
        $this->setCompaniaSocio( $this->getCompaniaSocio(), true );
        $this->setDescripcionLocal( $this->getDescripcionLocal(), true );
        $this->setDescripcionIngles( $this->getDescripcionIngles(), true );
        $this->setDireccion( $this->getDireccion(), true );
        $this->setUnidadNegocio( $this->getUnidadNegocio(), true );
        $this->setTipoAlmacen( $this->getTipoAlmacen(), true );
        $this->setTipoUnidadCrianza( $this->getTipoUnidadCrianza(), true );
        $this->setAlmacenTransitoPrincipal( $this->getAlmacenTransitoPrincipal(), true );
        $this->setAlmacenVentaFlag( $this->getAlmacenVentaFlag(), true );
        $this->setAlmacenProduccionFlag( $this->getAlmacenProduccionFlag(), true );
        $this->setAlmacenConsignacionFlag( $this->getAlmacenConsignacionFlag(), true );
        $this->setAlmacenCommodityFlag( $this->getAlmacenCommodityFlag(), true );
        $this->setDisponiblePlanProduccionFlag( $this->getDisponiblePlanProduccionFlag(), true );
        $this->setSubAlmacenFlag( $this->getSubAlmacenFlag(), true );
        $this->setCuentaInventario( $this->getCuentaInventario(), true );
        $this->setCuentaGasto( $this->getCuentaGasto(), true );
        $this->setNumeroMesesStock( $this->getNumeroMesesStock(), true );
        $this->setComercialCajero( $this->getComercialCajero(), true );
        $this->setEncargado( $this->getEncargado(), true );
        $this->setComercialCobrador( $this->getComercialCobrador(), true );
        $this->setAlmacenGastoFlag( $this->getAlmacenGastoFlag(), true );
        $this->setEstado( $this->getEstado(), true );
        $this->setUsuarioModificacion( $this->getUsuarioModificacion(), true );
        $this->setFechaModificacion( $this->getFechaModificacion(), true );
        $this->setUsuarioCreacion( $this->getUsuarioCreacion(), true );
        $this->setFechaCreacion( $this->getFechaCreacion(), true );
        $this->setCodigo( $this->getCodigo(), true );
        $this->setCodigoSunat( $this->getCodigoSunat(), true );
        $this->setIdUnidadProduccion( $this->getIdUnidadProduccion(), true );
        return true;
    }
}
?>