<?php
/* Autor...:  */
/* Esquema.: VTA_DocumentoCuotas.xml */
/* Generado: 2022-09-29 19:36:24 */

/* Metodos de acceso a los campos de la tabla VTA_DocumentoCuotas */
abstract class BaseVTA_DocumentoCuotasBN
{
    /* Campos de la tabla */
    private $i_CuotaId;    // CuotaId: ( no definido )
    private $i_NumeroDocumentoId;    // NumeroDocumentoId: ( no definido )
    private $f_CuotaMonto;    // CuotaMonto: ( no definido )
    private $d_CuotaFecha;    // CuotaFecha: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )

    /* Establece el valor del campo CuotaId */
    public function setCuotaId( $i_CuotaId )
    {
        $this->i_CuotaId = $i_CuotaId;
    }

    /* Obtiene el valor del campo CuotaId */
    public function getCuotaId()
    {
        return $this->i_CuotaId;
    }

    /* Establece el valor del campo NumeroDocumentoId */
    public function setNumeroDocumentoId( $i_NumeroDocumentoId )
    {
        $this->i_NumeroDocumentoId = $i_NumeroDocumentoId;
    }

    /* Obtiene el valor del campo NumeroDocumentoId */
    public function getNumeroDocumentoId()
    {
        return $this->i_NumeroDocumentoId;
    }

    /* Establece el valor del campo CuotaMonto */
    public function setCuotaMonto( $f_CuotaMonto )
    {
        $this->f_CuotaMonto = $f_CuotaMonto;
    }

    /* Obtiene el valor del campo CuotaMonto */
    public function getCuotaMonto()
    {
        return $this->f_CuotaMonto;
    }

    /* Establece el valor del campo CuotaFecha */
    public function setCuotaFecha( $d_CuotaFecha )
    {
        $this->d_CuotaFecha = $d_CuotaFecha;
    }

    /* Obtiene el valor del campo CuotaFecha */
    public function getCuotaFecha()
    {
        return $this->d_CuotaFecha;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'CuotaId' => $this->getCuotaId(),
            'NumeroDocumentoId' => $this->getNumeroDocumentoId(),
            'CuotaMonto' => $this->getCuotaMonto(),
            'CuotaFecha' => $this->getCuotaFecha(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaCreacion' => $this->getFechaCreacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto VTA_DocumentoCuotasBN desde un RecordSet */
    public static function retrieveByRs( $o_VTA_DocumentoCuotasRs )
    {
        $o_VTA_DocumentoCuotasBN = new VTA_DocumentoCuotasBN();
        $o_VTA_DocumentoCuotasBN->setCuotaId( ( integer ) $o_VTA_DocumentoCuotasRs[ "CuotaId" ] );
        $o_VTA_DocumentoCuotasBN->setNumeroDocumentoId( ( integer ) $o_VTA_DocumentoCuotasRs[ "NumeroDocumentoId" ] );
        $o_VTA_DocumentoCuotasBN->setCuotaMonto( ( float ) $o_VTA_DocumentoCuotasRs[ "CuotaMonto" ] );
        $o_VTA_DocumentoCuotasBN->setCuotaFecha( utilTimestamp::getTimestamp( $o_VTA_DocumentoCuotasRs[ "CuotaFecha" ], "Y-m-d" ) );
        $o_VTA_DocumentoCuotasBN->setUsuarioCreacion( $o_VTA_DocumentoCuotasRs[ "UsuarioCreacion" ] );
        $o_VTA_DocumentoCuotasBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_VTA_DocumentoCuotasRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        return $o_VTA_DocumentoCuotasBN;
    }
}
?>