<?php
/* Autor...:  */
/* Esquema.: products.xml */
/* Generado: 2020-08-18 04:21:32 */

/* Metodos de acceso a los campos de la tabla products */
abstract class BaseProductsBN
{
    /* Campos de la tabla */
    private $i_Id;    // id: ( no definido )
    private $s_Name;    // name: ( no definido )

    /* Establece el valor del campo id */
    public function setId( $i_Id )
    {
        $this->i_Id = $i_Id;
    }

    /* Obtiene el valor del campo id */
    public function getId()
    {
        return $this->i_Id;
    }

    /* Establece el valor del campo name */
    public function setName( $s_Name )
    {
        $this->s_Name = $s_Name;
    }

    /* Obtiene el valor del campo name */
    public function getName()
    {
        return $this->s_Name;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'Id' => $this->getId(),
            'Name' => $this->getName(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto ProductsBN desde un RecordSet */
    public static function retrieveByRs( $o_ProductsRs )
    {
        $o_ProductsBN = new ProductsBN();
        $o_ProductsBN->setId( ( integer ) $o_ProductsRs[ "Id" ] );
        $o_ProductsBN->setName( $o_ProductsRs[ "Name" ] );
        return $o_ProductsBN;
    }
}
?>