<?php
/* Autor...:  */
/* Esquema.: MST_PlazoEnt.xml */
/* Generado: 2021-09-07 05:02:28 */

/* Metodos de acceso a los campos de la tabla MST_PlazoEnt */
abstract class BaseMST_PlazoEntBN
{
    /* Campos de la tabla */
    private $i_PlazoId;    // PlazoId: ( no definido )
    private $s_Descripcion;    // Descripcion: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )

    /* Establece el valor del campo PlazoId */
    public function setPlazoId( $i_PlazoId )
    {
        $this->i_PlazoId = $i_PlazoId;
    }

    /* Obtiene el valor del campo PlazoId */
    public function getPlazoId()
    {
        return $this->i_PlazoId;
    }

    /* Establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion )
    {
        $this->s_Descripcion = $s_Descripcion;
    }

    /* Obtiene el valor del campo Descripcion */
    public function getDescripcion()
    {
        return $this->s_Descripcion;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'PlazoId' => $this->getPlazoId(),
            'Descripcion' => $this->getDescripcion(),
            'Estado' => $this->getEstado(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto MST_PlazoEntBN desde un RecordSet */
    public static function retrieveByRs( $o_MST_PlazoEntRs )
    {
        $o_MST_PlazoEntBN = new MST_PlazoEntBN();
        $o_MST_PlazoEntBN->setPlazoId( ( integer ) $o_MST_PlazoEntRs[ "PlazoId" ] );
        $o_MST_PlazoEntBN->setDescripcion( $o_MST_PlazoEntRs[ "Descripcion" ] );
        $o_MST_PlazoEntBN->setEstado( $o_MST_PlazoEntRs[ "Estado" ] );
        $o_MST_PlazoEntBN->setUsuarioCreacion( $o_MST_PlazoEntRs[ "UsuarioCreacion" ] );
        $o_MST_PlazoEntBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_MST_PlazoEntRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_MST_PlazoEntBN->setUsuarioModificacion( $o_MST_PlazoEntRs[ "UsuarioModificacion" ] );
        $o_MST_PlazoEntBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_MST_PlazoEntRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        return $o_MST_PlazoEntBN;
    }
}
?>