<?php
/* Autor...:  */
/* Esquema.: MST_Division.xml */
/* Generado: 2020-08-18 04:21:27 */

/* Metodos de acceso a los campos de la tabla MST_Division */
abstract class BaseMST_DivisionBN
{
    /* Campos de la tabla */
    private $i_DivisionId;    // DivisionId: ( no definido )
    private $s_DivisionDescripcion;    // DivisionDescripcion: ( no definido )
    private $s_DivisionEstado;    // DivisionEstado: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )

    /* Establece el valor del campo DivisionId */
    public function setDivisionId( $i_DivisionId )
    {
        $this->i_DivisionId = $i_DivisionId;
    }

    /* Obtiene el valor del campo DivisionId */
    public function getDivisionId()
    {
        return $this->i_DivisionId;
    }

    /* Establece el valor del campo DivisionDescripcion */
    public function setDivisionDescripcion( $s_DivisionDescripcion )
    {
        $this->s_DivisionDescripcion = $s_DivisionDescripcion;
    }

    /* Obtiene el valor del campo DivisionDescripcion */
    public function getDivisionDescripcion()
    {
        return $this->s_DivisionDescripcion;
    }

    /* Establece el valor del campo DivisionEstado */
    public function setDivisionEstado( $s_DivisionEstado )
    {
        $this->s_DivisionEstado = $s_DivisionEstado;
    }

    /* Obtiene el valor del campo DivisionEstado */
    public function getDivisionEstado()
    {
        return $this->s_DivisionEstado;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'DivisionId' => $this->getDivisionId(),
            'DivisionDescripcion' => $this->getDivisionDescripcion(),
            'DivisionEstado' => $this->getDivisionEstado(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto MST_DivisionBN desde un RecordSet */
    public static function retrieveByRs( $o_MST_DivisionRs )
    {
        $o_MST_DivisionBN = new MST_DivisionBN();
        $o_MST_DivisionBN->setDivisionId( ( integer ) $o_MST_DivisionRs[ "DivisionId" ] );
        $o_MST_DivisionBN->setDivisionDescripcion( $o_MST_DivisionRs[ "DivisionDescripcion" ] );
        $o_MST_DivisionBN->setDivisionEstado( $o_MST_DivisionRs[ "DivisionEstado" ] );
        $o_MST_DivisionBN->setUsuarioCreacion( $o_MST_DivisionRs[ "UsuarioCreacion" ] );
        $o_MST_DivisionBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_MST_DivisionRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_MST_DivisionBN->setUsuarioModificacion( $o_MST_DivisionRs[ "UsuarioModificacion" ] );
        $o_MST_DivisionBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_MST_DivisionRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        return $o_MST_DivisionBN;
    }
}
?>