<?php
/* Autor...:  */
/* Esquema.: MST_Cartera.xml */
/* Generado: 2024-10-18 17:06:00 */

/* Metodos de acceso a los campos de la tabla MST_Cartera */
abstract class BaseMST_CarteraBN
{
    /* Campos de la tabla */
    private $i_IdCartera;    // IdCartera: ( no definido )
    private $s_Nombre;    // Nombre: ( no definido )
    private $i_FlagRango;    // FlagRango: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )

    /* Establece el valor del campo IdCartera */
    public function setIdCartera( $i_IdCartera )
    {
        $this->i_IdCartera = $i_IdCartera;
    }

    /* Obtiene el valor del campo IdCartera */
    public function getIdCartera()
    {
        return $this->i_IdCartera;
    }

    /* Establece el valor del campo Nombre */
    public function setNombre( $s_Nombre )
    {
        $this->s_Nombre = $s_Nombre;
    }

    /* Obtiene el valor del campo Nombre */
    public function getNombre()
    {
        return $this->s_Nombre;
    }

    /* Establece el valor del campo FlagRango */
    public function setFlagRango( $i_FlagRango )
    {
        $this->i_FlagRango = $i_FlagRango;
    }

    /* Obtiene el valor del campo FlagRango */
    public function getFlagRango()
    {
        return $this->i_FlagRango;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdCartera' => $this->getIdCartera(),
            'Nombre' => $this->getNombre(),
            'FlagRango' => $this->getFlagRango(),
            'Estado' => $this->getEstado(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto MST_CarteraBN desde un RecordSet */
    public static function retrieveByRs( $o_MST_CarteraRs )
    {
        $o_MST_CarteraBN = new MST_CarteraBN();
        $o_MST_CarteraBN->setIdCartera( ( integer ) $o_MST_CarteraRs[ "IdCartera" ] );
        $o_MST_CarteraBN->setNombre( $o_MST_CarteraRs[ "Nombre" ] );
        $o_MST_CarteraBN->setFlagRango( ( integer ) $o_MST_CarteraRs[ "FlagRango" ] );
        $o_MST_CarteraBN->setEstado( $o_MST_CarteraRs[ "Estado" ] );
        $o_MST_CarteraBN->setUsuarioCreacion( $o_MST_CarteraRs[ "UsuarioCreacion" ] );
        $o_MST_CarteraBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_MST_CarteraRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_MST_CarteraBN->setUsuarioModificacion( $o_MST_CarteraRs[ "UsuarioModificacion" ] );
        $o_MST_CarteraBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_MST_CarteraRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        return $o_MST_CarteraBN;
    }
}
?>