<?php
/* Autor...:  */
/* Esquema.: GSS_Ticketera.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Metodos de acceso a los campos de la tabla GSS_Ticketera */
abstract class BaseGSS_TicketeraBN
{
    /* Campos de la tabla */
    private $i_IdTicketera;    // IdTicketera: ( no definido )
    private $i_IdSucursal;    // IdSucursal: ( no definido )
    private $s_AutorizacionSunat;    // AutorizacionSunat: ( no definido )
    private $s_SerieTicket;    // SerieTicket: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )

    /* Establece el valor del campo IdTicketera */
    public function setIdTicketera( $i_IdTicketera )
    {
        $this->i_IdTicketera = $i_IdTicketera;
    }

    /* Obtiene el valor del campo IdTicketera */
    public function getIdTicketera()
    {
        return $this->i_IdTicketera;
    }

    /* Establece el valor del campo IdSucursal */
    public function setIdSucursal( $i_IdSucursal )
    {
        $this->i_IdSucursal = $i_IdSucursal;
    }

    /* Obtiene el valor del campo IdSucursal */
    public function getIdSucursal()
    {
        return $this->i_IdSucursal;
    }

    /* Establece el valor del campo AutorizacionSunat */
    public function setAutorizacionSunat( $s_AutorizacionSunat )
    {
        $this->s_AutorizacionSunat = $s_AutorizacionSunat;
    }

    /* Obtiene el valor del campo AutorizacionSunat */
    public function getAutorizacionSunat()
    {
        return $this->s_AutorizacionSunat;
    }

    /* Establece el valor del campo SerieTicket */
    public function setSerieTicket( $s_SerieTicket )
    {
        $this->s_SerieTicket = $s_SerieTicket;
    }

    /* Obtiene el valor del campo SerieTicket */
    public function getSerieTicket()
    {
        return $this->s_SerieTicket;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdTicketera' => $this->getIdTicketera(),
            'IdSucursal' => $this->getIdSucursal(),
            'AutorizacionSunat' => $this->getAutorizacionSunat(),
            'SerieTicket' => $this->getSerieTicket(),
            'Estado' => $this->getEstado(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto GSS_TicketeraBN desde un RecordSet */
    public static function retrieveByRs( $o_GSS_TicketeraRs )
    {
        $o_GSS_TicketeraBN = new GSS_TicketeraBN();
        $o_GSS_TicketeraBN->setIdTicketera( ( integer ) $o_GSS_TicketeraRs[ "IdTicketera" ] );
        $o_GSS_TicketeraBN->setIdSucursal( ( integer ) $o_GSS_TicketeraRs[ "IdSucursal" ] );
        $o_GSS_TicketeraBN->setAutorizacionSunat( $o_GSS_TicketeraRs[ "AutorizacionSunat" ] );
        $o_GSS_TicketeraBN->setSerieTicket( $o_GSS_TicketeraRs[ "SerieTicket" ] );
        $o_GSS_TicketeraBN->setEstado( $o_GSS_TicketeraRs[ "Estado" ] );
        $o_GSS_TicketeraBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_GSS_TicketeraRs[ "FechaCreacion" ], "Y-m-d" ) );
        $o_GSS_TicketeraBN->setUsuarioCreacion( $o_GSS_TicketeraRs[ "UsuarioCreacion" ] );
        $o_GSS_TicketeraBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_GSS_TicketeraRs[ "FechaModificacion" ], "Y-m-d" ) );
        $o_GSS_TicketeraBN->setUsuarioModificacion( $o_GSS_TicketeraRs[ "UsuarioModificacion" ] );
        return $o_GSS_TicketeraBN;
    }
}
?>