<?php
/* Autor...:  */
/* Esquema.: GSS_Impuesto.xml */
/* Generado: 2021-10-11 19:18:18 */

/* Metodos de acceso a los campos de la tabla GSS_Impuesto */
abstract class BaseGSS_ImpuestoBN
{
    /* Campos de la tabla */
    private $i_IdImpuesto;    // IdImpuesto: ( no definido )
    private $s_Codigo;    // Codigo: ( no definido )
    private $s_Descripcion;    // Descripcion: ( no definido )
    private $f_Valor;    // Valor: ( no definido )
    private $s_CodigoSunat;    // CodigoSunat: ( no definido )
    private $s_CuentaContable;    // CuentaContable: ( no definido )
    private $s_TipoRegistro;    // TipoRegistro: ( no definido )
    private $d_FechaDesde;    // FechaDesde: ( no definido )
    private $d_FechaHasta;    // FechaHasta: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )

    /* Establece el valor del campo IdImpuesto */
    public function setIdImpuesto( $i_IdImpuesto )
    {
        $this->i_IdImpuesto = $i_IdImpuesto;
    }

    /* Obtiene el valor del campo IdImpuesto */
    public function getIdImpuesto()
    {
        return $this->i_IdImpuesto;
    }

    /* Establece el valor del campo Codigo */
    public function setCodigo( $s_Codigo )
    {
        $this->s_Codigo = $s_Codigo;
    }

    /* Obtiene el valor del campo Codigo */
    public function getCodigo()
    {
        return $this->s_Codigo;
    }

    /* Establece el valor del campo Descripcion */
    public function setDescripcion( $s_Descripcion )
    {
        $this->s_Descripcion = $s_Descripcion;
    }

    /* Obtiene el valor del campo Descripcion */
    public function getDescripcion()
    {
        return $this->s_Descripcion;
    }

    /* Establece el valor del campo Valor */
    public function setValor( $f_Valor )
    {
        $this->f_Valor = $f_Valor;
    }

    /* Obtiene el valor del campo Valor */
    public function getValor()
    {
        return $this->f_Valor;
    }

    /* Establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat )
    {
        $this->s_CodigoSunat = $s_CodigoSunat;
    }

    /* Obtiene el valor del campo CodigoSunat */
    public function getCodigoSunat()
    {
        return $this->s_CodigoSunat;
    }

    /* Establece el valor del campo CuentaContable */
    public function setCuentaContable( $s_CuentaContable )
    {
        $this->s_CuentaContable = $s_CuentaContable;
    }

    /* Obtiene el valor del campo CuentaContable */
    public function getCuentaContable()
    {
        return $this->s_CuentaContable;
    }

    /* Establece el valor del campo TipoRegistro */
    public function setTipoRegistro( $s_TipoRegistro )
    {
        $this->s_TipoRegistro = $s_TipoRegistro;
    }

    /* Obtiene el valor del campo TipoRegistro */
    public function getTipoRegistro()
    {
        return $this->s_TipoRegistro;
    }

    /* Establece el valor del campo FechaDesde */
    public function setFechaDesde( $d_FechaDesde )
    {
        $this->d_FechaDesde = $d_FechaDesde;
    }

    /* Obtiene el valor del campo FechaDesde */
    public function getFechaDesde()
    {
        return $this->d_FechaDesde;
    }

    /* Establece el valor del campo FechaHasta */
    public function setFechaHasta( $d_FechaHasta )
    {
        $this->d_FechaHasta = $d_FechaHasta;
    }

    /* Obtiene el valor del campo FechaHasta */
    public function getFechaHasta()
    {
        return $this->d_FechaHasta;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdImpuesto' => $this->getIdImpuesto(),
            'Codigo' => $this->getCodigo(),
            'Descripcion' => $this->getDescripcion(),
            'Valor' => $this->getValor(),
            'CodigoSunat' => $this->getCodigoSunat(),
            'CuentaContable' => $this->getCuentaContable(),
            'TipoRegistro' => $this->getTipoRegistro(),
            'FechaDesde' => $this->getFechaDesde(),
            'FechaHasta' => $this->getFechaHasta(),
            'Estado' => $this->getEstado(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto GSS_ImpuestoBN desde un RecordSet */
    public static function retrieveByRs( $o_GSS_ImpuestoRs )
    {
        $o_GSS_ImpuestoBN = new GSS_ImpuestoBN();
        $o_GSS_ImpuestoBN->setIdImpuesto( ( integer ) $o_GSS_ImpuestoRs[ "IdImpuesto" ] );
        $o_GSS_ImpuestoBN->setCodigo( $o_GSS_ImpuestoRs[ "Codigo" ] );
        $o_GSS_ImpuestoBN->setDescripcion( $o_GSS_ImpuestoRs[ "Descripcion" ] );
        $o_GSS_ImpuestoBN->setValor( ( float ) $o_GSS_ImpuestoRs[ "Valor" ] );
        $o_GSS_ImpuestoBN->setCodigoSunat( $o_GSS_ImpuestoRs[ "CodigoSunat" ] );
        $o_GSS_ImpuestoBN->setCuentaContable( $o_GSS_ImpuestoRs[ "CuentaContable" ] );
        $o_GSS_ImpuestoBN->setTipoRegistro( $o_GSS_ImpuestoRs[ "TipoRegistro" ] );
        $o_GSS_ImpuestoBN->setFechaDesde( utilTimestamp::getTimestamp( $o_GSS_ImpuestoRs[ "FechaDesde" ], "Y-m-d" ) );
        $o_GSS_ImpuestoBN->setFechaHasta( utilTimestamp::getTimestamp( $o_GSS_ImpuestoRs[ "FechaHasta" ], "Y-m-d" ) );
        $o_GSS_ImpuestoBN->setEstado( $o_GSS_ImpuestoRs[ "Estado" ] );
        $o_GSS_ImpuestoBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_GSS_ImpuestoRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_ImpuestoBN->setUsuarioCreacion( $o_GSS_ImpuestoRs[ "UsuarioCreacion" ] );
        $o_GSS_ImpuestoBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_GSS_ImpuestoRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_ImpuestoBN->setUsuarioModificacion( $o_GSS_ImpuestoRs[ "UsuarioModificacion" ] );
        return $o_GSS_ImpuestoBN;
    }
}
?>