<?php
/* Autor...:  */
/* Esquema.: GSS_Banco.xml */
/* Generado: 2020-11-19 07:05:44 */

/* Metodos de acceso a los campos de la tabla GSS_Banco */
abstract class BaseGSS_BancoBN
{
    /* Campos de la tabla */
    private $i_IdBanco;    // IdBanco: ( no definido )
    private $s_DescripcionLocal;    // DescripcionLocal: ( no definido )
    private $s_Codigo;    // Codigo: ( no definido )
    private $s_CodigoSunat;    // CodigoSunat: ( no definido )
    private $s_Estado;    // Estado: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )
    private $d_FechaModificacion;    // FechaModificacion: ( no definido )
    private $s_UsuarioModificacion;    // UsuarioModificacion: ( no definido )

    /* Establece el valor del campo IdBanco */
    public function setIdBanco( $i_IdBanco )
    {
        $this->i_IdBanco = $i_IdBanco;
    }

    /* Obtiene el valor del campo IdBanco */
    public function getIdBanco()
    {
        return $this->i_IdBanco;
    }

    /* Establece el valor del campo DescripcionLocal */
    public function setDescripcionLocal( $s_DescripcionLocal )
    {
        $this->s_DescripcionLocal = $s_DescripcionLocal;
    }

    /* Obtiene el valor del campo DescripcionLocal */
    public function getDescripcionLocal()
    {
        return $this->s_DescripcionLocal;
    }

    /* Establece el valor del campo Codigo */
    public function setCodigo( $s_Codigo )
    {
        $this->s_Codigo = $s_Codigo;
    }

    /* Obtiene el valor del campo Codigo */
    public function getCodigo()
    {
        return $this->s_Codigo;
    }

    /* Establece el valor del campo CodigoSunat */
    public function setCodigoSunat( $s_CodigoSunat )
    {
        $this->s_CodigoSunat = $s_CodigoSunat;
    }

    /* Obtiene el valor del campo CodigoSunat */
    public function getCodigoSunat()
    {
        return $this->s_CodigoSunat;
    }

    /* Establece el valor del campo Estado */
    public function setEstado( $s_Estado )
    {
        $this->s_Estado = $s_Estado;
    }

    /* Obtiene el valor del campo Estado */
    public function getEstado()
    {
        return $this->s_Estado;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    /* Establece el valor del campo FechaModificacion */
    public function setFechaModificacion( $d_FechaModificacion )
    {
        $this->d_FechaModificacion = $d_FechaModificacion;
    }

    /* Obtiene el valor del campo FechaModificacion */
    public function getFechaModificacion()
    {
        return $this->d_FechaModificacion;
    }

    /* Establece el valor del campo UsuarioModificacion */
    public function setUsuarioModificacion( $s_UsuarioModificacion )
    {
        $this->s_UsuarioModificacion = $s_UsuarioModificacion;
    }

    /* Obtiene el valor del campo UsuarioModificacion */
    public function getUsuarioModificacion()
    {
        return $this->s_UsuarioModificacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdBanco' => $this->getIdBanco(),
            'DescripcionLocal' => $this->getDescripcionLocal(),
            'Codigo' => $this->getCodigo(),
            'CodigoSunat' => $this->getCodigoSunat(),
            'Estado' => $this->getEstado(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
            'FechaModificacion' => $this->getFechaModificacion(),
            'UsuarioModificacion' => $this->getUsuarioModificacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto GSS_BancoBN desde un RecordSet */
    public static function retrieveByRs( $o_GSS_BancoRs )
    {
        $o_GSS_BancoBN = new GSS_BancoBN();
        $o_GSS_BancoBN->setIdBanco( ( integer ) $o_GSS_BancoRs[ "IdBanco" ] );
        $o_GSS_BancoBN->setDescripcionLocal( $o_GSS_BancoRs[ "DescripcionLocal" ] );
        $o_GSS_BancoBN->setCodigo( $o_GSS_BancoRs[ "Codigo" ] );
        $o_GSS_BancoBN->setCodigoSunat( $o_GSS_BancoRs[ "CodigoSunat" ] );
        $o_GSS_BancoBN->setEstado( $o_GSS_BancoRs[ "Estado" ] );
        $o_GSS_BancoBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_GSS_BancoRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_BancoBN->setUsuarioCreacion( $o_GSS_BancoRs[ "UsuarioCreacion" ] );
        $o_GSS_BancoBN->setFechaModificacion( utilTimestamp::getTimestamp( $o_GSS_BancoRs[ "FechaModificacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_BancoBN->setUsuarioModificacion( $o_GSS_BancoRs[ "UsuarioModificacion" ] );
        return $o_GSS_BancoBN;
    }
}
?>