<?php
/* Autor...:  */
/* Esquema.: GSS_Auditoria.xml */
/* Generado: 2020-08-18 04:21:26 */

/* Metodos de acceso a los campos de la tabla GSS_Auditoria */
abstract class BaseGSS_AuditoriaBN
{
    /* Campos de la tabla */
    private $i_IdAuditoria;    // IdAuditoria: ( no definido )
    private $i_IdCompania;    // IdCompania: ( no definido )
    private $s_Modulo;    // Modulo: ( no definido )
    private $u_Sentencia;    // Sentencia: ( no definido )
    private $d_FechaCreacion;    // FechaCreacion: ( no definido )
    private $s_UsuarioCreacion;    // UsuarioCreacion: ( no definido )

    /* Establece el valor del campo IdAuditoria */
    public function setIdAuditoria( $i_IdAuditoria )
    {
        $this->i_IdAuditoria = $i_IdAuditoria;
    }

    /* Obtiene el valor del campo IdAuditoria */
    public function getIdAuditoria()
    {
        return $this->i_IdAuditoria;
    }

    /* Establece el valor del campo IdCompania */
    public function setIdCompania( $i_IdCompania )
    {
        $this->i_IdCompania = $i_IdCompania;
    }

    /* Obtiene el valor del campo IdCompania */
    public function getIdCompania()
    {
        return $this->i_IdCompania;
    }

    /* Establece el valor del campo Modulo */
    public function setModulo( $s_Modulo )
    {
        $this->s_Modulo = $s_Modulo;
    }

    /* Obtiene el valor del campo Modulo */
    public function getModulo()
    {
        return $this->s_Modulo;
    }

    /* Establece el valor del campo Sentencia */
    public function setSentencia( $u_Sentencia )
    {
        $this->u_Sentencia = $u_Sentencia;
    }

    /* Obtiene el valor del campo Sentencia */
    public function getSentencia()
    {
        return $this->u_Sentencia;
    }

    /* Establece el valor del campo FechaCreacion */
    public function setFechaCreacion( $d_FechaCreacion )
    {
        $this->d_FechaCreacion = $d_FechaCreacion;
    }

    /* Obtiene el valor del campo FechaCreacion */
    public function getFechaCreacion()
    {
        return $this->d_FechaCreacion;
    }

    /* Establece el valor del campo UsuarioCreacion */
    public function setUsuarioCreacion( $s_UsuarioCreacion )
    {
        $this->s_UsuarioCreacion = $s_UsuarioCreacion;
    }

    /* Obtiene el valor del campo UsuarioCreacion */
    public function getUsuarioCreacion()
    {
        return $this->s_UsuarioCreacion;
    }

    public function getJsonSerialize()
    {
        return 
        [
            'IdAuditoria' => $this->getIdAuditoria(),
            'IdCompania' => $this->getIdCompania(),
            'Modulo' => $this->getModulo(),
            'Sentencia' => $this->getSentencia(),
            'FechaCreacion' => $this->getFechaCreacion(),
            'UsuarioCreacion' => $this->getUsuarioCreacion(),
        ];
    }

    public function toArray()
    {
        return $this->processArray( get_object_vars( $this ) ); 
    }

    private function processArray( $array )
    {
        foreach( $array as $key => $value ) 
        {
            if ( is_object( $value ) )
            {
                $array[$key] = $value->toArray();
            }
            if ( is_array( $value ) ) 
            {
                $array[$key] = $this->processArray( $value );
            }
        }
        return $array;
    }

    public function __toString()
    {
        return json_encode( $this->toArray() ); 
    }

    /* Recupera un objeto GSS_AuditoriaBN desde un RecordSet */
    public static function retrieveByRs( $o_GSS_AuditoriaRs )
    {
        $o_GSS_AuditoriaBN = new GSS_AuditoriaBN();
        $o_GSS_AuditoriaBN->setIdAuditoria( ( integer ) $o_GSS_AuditoriaRs[ "IdAuditoria" ] );
        $o_GSS_AuditoriaBN->setIdCompania( ( integer ) $o_GSS_AuditoriaRs[ "IdCompania" ] );
        $o_GSS_AuditoriaBN->setModulo( $o_GSS_AuditoriaRs[ "Modulo" ] );
        $o_GSS_AuditoriaBN->setSentencia( $o_GSS_AuditoriaRs[ "Sentencia" ] );
        $o_GSS_AuditoriaBN->setFechaCreacion( utilTimestamp::getTimestamp( $o_GSS_AuditoriaRs[ "FechaCreacion" ], "Y-m-d H:i:s" ) );
        $o_GSS_AuditoriaBN->setUsuarioCreacion( $o_GSS_AuditoriaRs[ "UsuarioCreacion" ] );
        return $o_GSS_AuditoriaBN;
    }
}
?>