<?php
class Factura
{
    public function firmar(DOMDocument $domDocument, $ruc="", $modo)
    {
        //echo "modo:".$modo;
        $ReferenceNodeName = 'ExtensionContent';
        //              $privateKey = file_get_contents('prueba/server_key.pem');
        //		$publicKey = file_get_contents('prueba/server.pem');

        $modo = ($modo == 1) ? 'produccion' : 'prueba';
        //$privateKey = file_get_contents(APPPATH ."libraries/certificado_digital/$modo/server_key.pem");
        $privateKey = file_get_contents(SF_ROOT_DIR ."/web/cpe/certificado_digital/$modo/server_key.pem");
        //$publicKey = file_get_contents(APPPATH ."libraries/certificado_digital/$modo/server.pem");
        $publicKey = file_get_contents(SF_ROOT_DIR ."/web/cpe/certificado_digital/$modo/server.pem");

        $objSign = new XMLSecurityDSig($ruc);
        $objSign->setCanonicalMethod(XMLSecurityDSig::C14N);
        $objSign->addReference(
            $domDocument,
            XMLSecurityDSig::SHA1,
            array('http://www.w3.org/2000/09/xmldsig#enveloped-signature'),
            $options = array('force_uri' => true)
        );

        $objKey = new XMLSecurityKey(XMLSecurityKey::RSA_SHA1, array('type'=>'private'));
        $objKey->loadKey($privateKey);

        // Sign the XML file
        $Node = $domDocument->getElementsByTagName($ReferenceNodeName)->item(1);
        if (!($Node)) $Node = $domDocument->getElementsByTagName($ReferenceNodeName)->item(0);
        $objSign->sign($objKey, $Node);
        // Add the associated public key to the signature
        $objSign->add509Cert($publicKey);
        return $domDocument;
    }
}