<?php
class Variables_diversas_model
{
    public function priceAmount( $precio_base, $codigo_de_tributo, $percent, $icbper, $descuento = 0 )
    {
        $precio_base       = floatval($precio_base);
        $codigo_de_tributo = floatval($codigo_de_tributo);
        $percent           = floatval($percent);
        $icbper            = floatval($icbper);
        $priceAmount = '';
        if($codigo_de_tributo == 1000){
            $priceAmount = number_format((($precio_base - $descuento) * ( 1 + $percent)),2, '.', '') + $icbper;
        }else{
            $priceAmount = $precio_base - $descuento + $icbper;
        }
        return $priceAmount;
    }

    public function taxAmount( $cantidad, $precio_base, $codigo_de_tributo, $percent, $descuento = 0 )
    {
        $taxAmount = '';
        switch ($codigo_de_tributo) {
            case 1000:
                $taxAmount = $cantidad* ($precio_base - $descuento) *$percent;
            break;
            case 9995:
                $taxAmount = 0.0;
            break;
            case 9996:
                $taxAmount = $cantidad*($precio_base/(1 + $percent))*$percent;
            break;
            case 9997:
                $taxAmount = 0.0;
            break;
            case 9998:
                $taxAmount = 0.0;
            break;
        }
        return $taxAmount;
    }

    public function price_priceAmount( $precio_base, $codigo_de_tributo )
    {
        $price_priceAmount = ($codigo_de_tributo == 9996) ? 0.0 : $precio_base;
        return $price_priceAmount;
    }
}
