<?php
class Guias_model
{
    public function query_standar_cabecera( $s_GuiaRemisionId )
    {
        $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
        $o_SR_GuiaRemisionHBN = $o_SR_GuiaRemisionHFN->selectByPK( $s_GuiaRemisionId );

        $o_TR_ChoferBN   = $o_SR_GuiaRemisionHBN->getObjectChofer();
        $o_TR_VehiculoBN = $o_SR_GuiaRemisionHBN->getObjectVehiculo();

        if( !$o_TR_ChoferBN->getIdChofer() )
        {
            $o_TR_ChoferBN->setChoferDocumento( "00000000" );
            $o_TR_ChoferBN->setChoferNombre( "-" );
        }
        if( !$o_TR_VehiculoBN->getIdVehiculo() )
        {
            $o_TR_VehiculoBN->setVehiculoPlaca( "-" );
        }

        $a_MotivoTraslado   = SR_GuiaRemisionHBN::getArrayMotivoTraslado( $o_SR_GuiaRemisionHBN->getMotivoTrasladoId() );
        $a_TipoDeTransporte = SR_GuiaRemisionHBN::getArrayTipoDeTransporte( $o_SR_GuiaRemisionHBN->getModalidadTransporteId() );

        $a_Data = array(
            "serie"                       => $o_SR_GuiaRemisionHBN->getGuiaSerie(),
            "numero"                      => intval( $o_SR_GuiaRemisionHBN->getGuiaNumero() ),
            "fecha_emision_sf"            => substr( $o_SR_GuiaRemisionHBN->getGuiaFecha(), 0, 10 ),
            "numero_documento"            => $o_SR_GuiaRemisionHBN->getClienteNumDocumento(),
            "entidad"                     => $o_SR_GuiaRemisionHBN->getClienteNombre(),
            "codigo_gmt"                  => $a_MotivoTraslado['CodigoSunat'],
            "guia_motivo_traslado"        => $o_SR_GuiaRemisionHBN->getMotivoTrasladoDesc(),
            "peso_total"                  => $o_SR_GuiaRemisionHBN->getPesoTotal(),
            "guia_motivo_traslado_id"     => $o_SR_GuiaRemisionHBN->getMotivoTrasladoId(),
            "numero_bultos"               => $o_SR_GuiaRemisionHBN->getNumeroBultos(),
            "guia_modalidad_traslado_id"  => $a_TipoDeTransporte['CodigoSunat'],
            "fecha_traslado_sf"           => $o_SR_GuiaRemisionHBN->getFechaIniTraslado(),
            "numero_documento_transporte" => $o_TR_ChoferBN->getChoferDocumento(),
            "entidad_transporte"          => $o_TR_ChoferBN->getChoferNombre(),
            "vehiculo_placa"              => $o_TR_VehiculoBN->getVehiculoPlaca(),
            "dni_conductor"               => $o_TR_ChoferBN->getChoferDocumento(),
            "llegada_ubigeo"              => $o_SR_GuiaRemisionHBN->getUbigeoDestino(),
            "llegada_direccion"           => $o_SR_GuiaRemisionHBN->getDireccionDestino(),
            "partida_ubigeo"              => $o_SR_GuiaRemisionHBN->getUbigeoOrigen(),
            "partida_direccion"           => $o_SR_GuiaRemisionHBN->getDireccionOrigen()
        );

        return $a_Data;
    }
}