<?php
class iDespacho
{
    public $empresas_model;
    public $guias_model;
    public $guia_detalles_model;

    public function __construct()
    {
        $this->empresas_model      = iSunatCPE::empresas_model();
        $this->guias_model         = iSunatCPE::guias_model();
        $this->guia_detalles_model = iSunatCPE::guia_detalles_model();
    }

    public function enviarSunatGuiaRemision( $s_GuiaRemisionId )
    {
        $a_Rs = array( "error" => false );
        try
        {
            $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
            $o_SR_GuiaRemisionHBN = $o_SR_GuiaRemisionHFN->selectByPK( $s_GuiaRemisionId );

            if( !$o_SR_GuiaRemisionHBN )
            {
                throw new Exception( "No se encontro la Guia de Remision." );
            }

            $s_IdMovimientoSerie = $o_SR_GuiaRemisionHBN->getMovimientoId();

            $o_SR_MovimientoFN = new SR_MovimientoFN();
            $o_SR_MovimientoBN = $o_SR_MovimientoFN->selectByPK( $s_IdMovimientoSerie );

            $s_NumeroDocumento = $o_SR_GuiaRemisionHBN->getReferenciaNumeroDocumento();
            $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $s_NumeroDocumento );

            $i_IdCompania = $o_VTA_DocumentoBN->getIdCompania();
            $o_GSS_CompaniaFN = new GSS_CompaniaFN();
            $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $i_IdCompania );

            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $o_VTA_DocumentoBN->getClienteNumero() );

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            /// validacion por direccion, se le da direccion del proyecto
            if( $o_VTA_DocumentoBN->getIdTipoDocumento() == VTA_DocumentoBN::TIPO_DOCUMENTO_BOLETA_VAL || $o_VTA_DocumentoBN->getIdTipoDocumento() == "NV" )
            {
                /*if( !$o_VTA_DocumentoBN->getClienteDireccion() )
                {
                    if( $o_VTA_DocumentoBN->getIdProyecto() )
                    {
                        $o_VTA_PrsProyectosFN       = new VTA_PrsProyectosFN();
                        $o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $o_VTA_DocumentoBN->getIdProyecto() );

                        $o_VTA_DocumentoBN->setClienteDireccion( $o_VTA_PrsProyectosBN->getDireccion() );

                        $o_MST_PersonaMastBN->setDepartamento( $o_VTA_PrsProyectosBN->getDepartamento() );
                        $o_MST_PersonaMastBN->setProvincia( $o_VTA_PrsProyectosBN->getProvincia() );
                        $o_MST_PersonaMastBN->setDistrito( $o_VTA_PrsProyectosBN->getDistrito() );
                        $o_MST_PersonaMastBN->setDireccion( $o_VTA_PrsProyectosBN->getDireccion()." - ".$o_VTA_PrsProyectosBN->getDepartamentoDesc()." - ".$o_VTA_PrsProyectosBN->getProvinciaDesc()." - ".$o_VTA_PrsProyectosBN->getDistritoDesc() );
                    }
                }*/
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //ahora se recupera la direccion de Partida
            $s_PuntoPartidaUbigeo = $o_SR_GuiaRemisionHBN->getUbigeoOrigen();
            $s_DireccionOrigen    = $o_SR_GuiaRemisionHBN->getDireccionOrigen();
            //ahora se recupera la direccion de Destino
            $s_PuntoLlegadaUbigeo = $o_SR_GuiaRemisionHBN->getUbigeoDestino();
            $s_DireccionDestino   = $o_SR_GuiaRemisionHBN->getDireccionDestino();

            //cliente
            $s_ClienteDireccion  = $o_MST_PersonaMastBN->getDireccion();
            $s_ClienteEmail      = !$o_MST_PersonaMastBN->getEmail() ? "" : $o_MST_PersonaMastBN->getEmail();
            $s_ClienteUbigeo     = $o_MST_PersonaMastBN->getDistrito();
            $s_ClienteCelular    = !$o_MST_PersonaMastBN->getCelular() ? "" : $o_MST_PersonaMastBN->getCelular();
            $s_TipoDocumento     = $o_VTA_DocumentoBN->getClienteTipoDoc();
            $s_ClienteDocumento  = $o_VTA_DocumentoBN->getClienteRUC();
            $s_ClienteNombre     = $o_VTA_DocumentoBN->getClienteNombre();
            //$s_TipoDocumentoDesc = $o_VTA_DocumentoBN->getTipoDocumentoDesc();
            //$s_TipoSerieNumero   = $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero();

            //emisor
            $s_EmpresaNumDocumento  = $o_GSS_CompaniaBN->getRuc();
            $s_EmpresaDireccion     = $o_GSS_CompaniaBN->getDireccionComun();
            $s_EmpresaInfoAdicional = $o_GSS_CompaniaBN->getDireccionAdicional();
            $s_EmpresaUbigeo        = $o_GSS_CompaniaBN->getDistrito();
            $s_EmpresaCorreo        = $o_GSS_CompaniaBN->getEmailEmpresa();
            $s_EmpresaTelefono      = $o_GSS_CompaniaBN->getTelefono1();

            $s_Serie               = $o_SR_GuiaRemisionHBN->getGuiaSerie();
            $s_Numero              = $o_SR_GuiaRemisionHBN->getGuiaNumero();
            $s_FechaGuia           = $o_SR_GuiaRemisionHBN->getGuiaFecha();
            $s_FechaInicioTraslado = $o_SR_GuiaRemisionHBN->getFechaIniTraslado();
            $s_Observaciones       = $o_SR_GuiaRemisionHBN->getComentario();
            $s_MotivoTrasladoId    = $o_SR_GuiaRemisionHBN->getMotivoTrasladoId();
            $a_DataMotivo          = SR_GuiaRemisionHBN::getArrayMotivoTraslado( $s_MotivoTrasladoId );
            $s_MotivoTrasladoProv  = $a_DataMotivo['CodigoSunatPr'];
            $s_DescripcionMotivo   = $a_DataMotivo['Descripcion'];
            $f_NumeroBultos        = $o_SR_GuiaRemisionHBN->getNumeroBultos();

            $s_TipoDeTransporte   = $o_SR_GuiaRemisionHBN->getModalidadTransporteId();
            $a_DataTipoTransporte = SR_GuiaRemisionHBN::getArrayTipoDeTransporte( $s_TipoDeTransporte );
            $s_TipoDeTransporteId = $a_DataTipoTransporte['CodigoSunatPr'];

            $i_IdChofer   = null;
            $i_IdVehiculo = null;

            $s_ConductorDocumentoTipo   = $o_SR_GuiaRemisionHBN->getConductorDocumentoTipo(); //1 DNI | 6 = RUC  |
            $s_ConductorDocumentoNumero = $o_SR_GuiaRemisionHBN->getConductorDocumentoNumero();
            $s_ConductorDenominacion    = $o_SR_GuiaRemisionHBN->getConductorDenominacion(); //nombre del conductor
            $s_ConductorNombre          = $o_SR_GuiaRemisionHBN->getConductorNombre();
            $s_ConductorApellido        = $o_SR_GuiaRemisionHBN->getConductorApellido();
            $s_ConductorNroLicencia     = $o_SR_GuiaRemisionHBN->getConductorNumeroLicencia();

            $s_TransportistaDocumentoTipo   = $o_SR_GuiaRemisionHBN->getTransportistaDocumentoTipo(); //1 DNI | 6 = RUC  |
            $s_TransportistaDocumentoNumero = $o_SR_GuiaRemisionHBN->getTransportistaDocumentoNumero();
            $s_TransportistaDenominacion    = $o_SR_GuiaRemisionHBN->getTransportistaDenominacion(); //nombre del transportista
            $s_TransportistaPlacaNumero     = $o_SR_GuiaRemisionHBN->getTransportistaPlacaNumero();

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $a_SR_GuiaRemisionDet = $o_SR_GuiaRemisionHBN->getArrayObjectDetalles();
            $f_SumaPesoTotal = 0;
            foreach( $a_SR_GuiaRemisionDet as $o_SR_GuiaRemisionDetBN )
            {
                $f_SumaPesoTotal = $f_SumaPesoTotal + $o_SR_GuiaRemisionDetBN->getPesoTotal();
            }
            if( $f_SumaPesoTotal <= 0 )
            {
                $f_SumaPesoTotal = 1;
            }

            $s_EnlaceDelPdf = "";
            if( $o_VTA_DocumentoBN->getIdTipoDocumento() == "FC" || $o_VTA_DocumentoBN->getIdTipoDocumento() == "BV" )
            {
                if( !$o_GSS_CompaniaBN->getEnviarCompDirectoSunatFlag() )
                {
                    //ahora se envia al proveedor de guia electronica
                    $a_data = array
                    (
                        "serie_documento"       => $s_Serie,
                        "numero_documento"      => intval( $s_Numero ),
                        "fecha_de_emision"      => substr( $s_FechaGuia, 0, 10 ),
                        "hora_de_emision"       => substr( $s_FechaGuia, 11, 8 ),
                        "codigo_tipo_documento" => "09",
                        "datos_del_emisor"      => array
                        (
                            "codigo_pais"                 => "PE",
                            "ubigeo"                      => $s_EmpresaUbigeo,
                            "direccion"                   => $s_EmpresaDireccion,
                            "correo_electronico"          => $s_EmpresaCorreo,
                            "telefono"                    => $s_EmpresaTelefono,
                            "codigo_del_domicilio_fiscal" => "0000"
                        ),
                        "datos_del_cliente_o_receptor" => array
                        (
                            "codigo_tipo_documento_identidad"    => MST_PersonaMastBN::getArrayTipoDocumento( $o_VTA_DocumentoBN->getClienteTipoDoc() ),
                            "numero_documento"                   => $s_ClienteDocumento,
                            "apellidos_y_nombres_o_razon_social" => $s_ClienteNombre,
                            "nombre_comercial"                   => $s_ClienteNombre,
                            "codigo_pais"                        => "PE",
                            "ubigeo"                             => $s_ClienteUbigeo,
                            "direccion"                          => $s_ClienteDireccion,
                            "correo_electronico"                 => $s_ClienteEmail,
                            "telefono"                           => $s_ClienteCelular
                        ),
                        "observaciones"                 => $s_Observaciones,
                        "codigo_modo_transporte"        => $s_TipoDeTransporteId,
                        "codigo_motivo_traslado"        => $s_MotivoTrasladoProv,
                        "descripcion_motivo_traslado"   => $s_DescripcionMotivo,
                        "fecha_de_traslado"             => $s_FechaInicioTraslado,
                        "codigo_de_puerto"              => "",
                        "indicador_de_transbordo"       => false,
                        "unidad_peso_total"             => "KGM",
                        "peso_total"                    => $f_SumaPesoTotal,
                        "numero_de_bultos"              => 1,
                        "numero_de_contenedor"          => "",
                    );

                    $a_data['direccion_partida'] = array
                    (
                        "ubigeo"    => $s_PuntoPartidaUbigeo,
                        "direccion" => $s_DireccionOrigen,
                        "codigo_del_domicilio_fiscal" => "0000"
                    );

                    $a_data['direccion_llegada'] = array
                    (
                        "ubigeo"    => $s_PuntoLlegadaUbigeo,
                        "direccion" => $s_DireccionDestino,
                        "codigo_del_domicilio_fiscal" => "0000"
                    );

                    if( $s_TipoDeTransporteId == "01" )
                    {
                        $a_data['transportista'] = array
                        (
                            "codigo_tipo_documento_identidad"       => $s_TransportistaDocumentoTipo,
                            "numero_documento"                      => $s_TransportistaDocumentoNumero,
                            "numero_mtc"                            => "1518996CNG",//"3006",
                            "apellidos_y_nombres_o_razon_social"    => $s_TransportistaDenominacion
                        );
                    }

                    if( $s_TipoDeTransporteId == "02" )
                    {
                        $a_data['chofer'] = array
                        (
                            "codigo_tipo_documento_identidad" => $s_ConductorDocumentoTipo,
                            "numero_documento"                => $s_ConductorDocumentoNumero,
                            "nombres"                         => $s_ConductorNombre,
                            "apellidos"                       => $s_ConductorApellido,
                            "numero_licencia"                 => $s_ConductorNroLicencia
                        );
                    }

                    $a_data['numero_de_placa'] = str_replace( "-", "", $s_TransportistaPlacaNumero );

                    //SOLO 24 LINEAS SOPORTA LA GUIA ELECTRONICA
                    $data_det = array();
                    foreach( $a_SR_GuiaRemisionDet as $o_SR_GuiaRemisionDetBN )
                    {
                        //SE RECUPERA SERIES SI SE ENCUENTRA:
                        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_SR_GuiaRemisionDetBN->getIdItem() );

                        $s_SerieConcat = "";
                        if( $o_ALM_ItemMastBN->SiManejaSerie() )
                        {
                            $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
                            $o_VTA_DocumentoDetalleBN->setItemCodigo( $o_ALM_ItemMastBN->getIdItem() );
                            $a_Series = $o_VTA_DocumentoDetalleBN->getSeriesEscaneadasxIdMov( $o_SR_GuiaRemisionDetBN->getMovimientoId() );
                            $s_Series = implode( " ", $a_Series );

                            $s_SerieConcat = "\n$s_Series"; //<br>
                        }

                        $data_det[] = array
                        (
                            "codigo_interno" => $o_SR_GuiaRemisionDetBN->getIdItem(),
                            "cantidad"       => $o_SR_GuiaRemisionDetBN->getCantidad()
                        );
                    }
                    $a_data['items'] = $data_det;

                    $o_VTA_FacturacionElectronicaBN = $o_VTA_DocumentoBN->getObjetFacturacionElectronica();
                    if( $o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() == "SI" )
                    {
                        //AHORA SE AGREGA DOCUMENTO RELACIONADO
                        //$data_doc_rel   = array();
                        $a_data['documento_afectado'] = array(
                            "codigo_tipo_documento"   => $o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal(),
                            "serie_documento"         => $o_VTA_DocumentoBN->getDocumentoSerie(),
                            "numero_documento"        => intval( $o_VTA_DocumentoBN->getDocumentoNumero() )
                        );
                    }

                    $s_data_json = json_encode( $a_data );
                    pr( $a_data ); exit;

                    $b_Control = true;

                    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //Invocamos el servicio de NUBEFACT
                    $a_respuesta = $this->executeCurl( $s_data_json, $o_SR_GuiaRemisionHBN );

                    if( $a_respuesta )
                    {
                        $this->updateDocument( $a_respuesta, $o_SR_GuiaRemisionHBN );
                    }
                    else
                    {
                        throw new Exception( "No hay respuesta del Servidor de Facturacion Electronica." );
                    }
                    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                }
                else
                {
                    $a_respuesta['success'] = 1;
                    $a_respuesta['links']['pdf']            = buildUrlComplet( "alm.php/transporte/printGuiaPDF", "Id=".$s_GuiaRemisionId );
                    $a_respuesta['links']['xml']            = "";
                    $a_respuesta['links']['cdr']            = "";
                    $a_respuesta['data']['number']          = "";
                    $a_respuesta['data']['filename']        = "";
                    $a_respuesta['data']['external_id']     = "";
                    $a_respuesta['response']['notes']       = array();
                    $a_respuesta['response']['description'] = "localhost";

                    $this->updateDocument( $a_respuesta, $o_SR_GuiaRemisionHBN );
                }

                $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
                $o_SR_GuiaRemisionHBN = $o_SR_GuiaRemisionHFN->selectByPK( $s_GuiaRemisionId );

                $s_EnlaceDelPdf = $o_SR_GuiaRemisionHBN->getEnlaceDelPdf();
            }
            else
            {
                $s_EnlaceDelPdf = buildUrlComplet( "alm.php/transporte/printGuiaPDF", "Id=".$s_GuiaRemisionId );
            }

            $a_Rs['EnlaceDelPdf'] = $s_EnlaceDelPdf;

        }
        catch ( Exception $o_Exception )
        {
            throw new Exception( $o_Exception->getMessage() );
        }

        return $a_Rs;
    }

    private function updateDocument( $a_respuesta, SR_GuiaRemisionHBN $o_SR_GuiaRemisionHBN ): void
    {
        $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
        $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $o_SR_GuiaRemisionHBN->getGuiaRemisionId() );
        $o_SR_GuiaRemisionHDP->setEstadoSunat( "E" );

        if( isset( $a_respuesta['success'] ) )
        {
            if( $a_respuesta['success'] )
            {
                if( !isset( $a_respuesta['links']['pdf'] ) )
                {
                    $o_GSS_SucursalFN = new GSS_SucursalFN();
                    $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $o_SR_GuiaRemisionHBN->getIdSucursal() );

                    $RUTA_API  = $o_GSS_SucursalBN->getRutaProveedorExt()."/print/dispatch/";
                    $TOKEN_API = $o_GSS_SucursalBN->getTokenProveedorExt();

                    $a_respuesta['links']['pdf'] = $RUTA_API.$a_respuesta['data']['external_id'];
                    $a_respuesta['links']['xml'] = "";
                    $a_respuesta['links']['cdr'] = "";
                    $a_respuesta['response']['notes'] = array();
                    $a_respuesta['response']['description'] = "";
                }
                $o_SR_GuiaRemisionHDP->setNotaImportante( $a_respuesta['response']['description'] );
                $o_SR_GuiaRemisionHDP->setTipoDeComprobante( 0 );
                $o_SR_GuiaRemisionHDP->setErrorsResponse( "" );
                $o_SR_GuiaRemisionHDP->setErrorsCodigo( "" );
                $o_SR_GuiaRemisionHDP->setEnlace( $a_respuesta['data']['number'] );
                $o_SR_GuiaRemisionHDP->setAceptadaPorSunat( $a_respuesta['success'] ? "SI" : "NO" );
                $o_SR_GuiaRemisionHDP->setSunatDescription( addslashes( $a_respuesta['data']['filename'] ) );
                $o_SR_GuiaRemisionHDP->setSunatNote( implode( " | ", $a_respuesta['response']['notes'] )  );
                $o_SR_GuiaRemisionHDP->setSunatResponseCode( $a_respuesta['data']['external_id'] );
                $o_SR_GuiaRemisionHDP->setSunatSoapError( "" );
                //$o_SR_GuiaRemisionHDP->setPdfZipBase64( $a_respuesta['pdf_zip_base64'] );
                //$o_SR_GuiaRemisionHDP->setXmlZipBase64( $a_respuesta['xml_zip_base64'] );
                //$o_SR_GuiaRemisionHDP->setCdrZipBase64( $a_respuesta['cdr_zip_base64'] );
                $o_SR_GuiaRemisionHDP->setEnlaceDelPdf( $a_respuesta['links']['pdf'] );
                $o_SR_GuiaRemisionHDP->setEnlaceDelXml( $a_respuesta['links']['xml'] );
                $o_SR_GuiaRemisionHDP->setEnlaceDelCdr( $a_respuesta['links']['cdr'] );
            }
            else
            {
                $s_MensajeError = "";
                if( isset( $a_respuesta['message'] ) )
                {
                    $s_MensajeError.= $a_respuesta['message'];
                }
                if( isset( $a_respuesta['file'] ) )
                {
                    $s_MensajeError.= "\n".$a_respuesta['file'];
                    if( isset( $a_respuesta['file'] ) )
                    {
                        $s_MensajeError.= " - ".$a_respuesta['line'];
                    }
                }
                throw new Exception( "Error: ".$s_MensajeError );
            }
        }
        else
        {
            throw new Exception( "No se encontro resultado del proveedor." );
        }

        $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_SR_GuiaRemisionHDP->update();
    }

    private function executeCurl( $s_data_json, SR_GuiaRemisionHBN $o_SR_GuiaRemisionHBN )
    {
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        ///recuperamos los parametros
        if( $o_SR_GuiaRemisionHBN->getIdSucursal() )
        {
            $o_GSS_SucursalFN = new GSS_SucursalFN();
            $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $o_SR_GuiaRemisionHBN->getIdSucursal() );

            $RUTA_API  = $o_GSS_SucursalBN->getRutaProveedorExt()."/api/dispatches";
            $TOKEN_API = $o_GSS_SucursalBN->getTokenProveedorExt();
        }
        else
        {
            throw new Exception( "La Sucursal no esta seleccionada." );
        }

        if( empty( $RUTA_API ) )
        {
            throw new Exception( "No tiene RUTA para registrar al Proveedor." );
        }

        if( empty( $TOKEN_API ) )
        {
            throw new Exception( "No tiene TOKEN para registrar al Proveedor." );
        }

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Invocamos el servicio de
        $ch = curl_init();
        // Check if initialization had gone wrong*
        if ( $ch === false )
        {
            throw new Exception('failed to initialize');
        }
        // Better to explicitly set URL
        curl_setopt( $ch, CURLOPT_URL, $RUTA_API );
        curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, "POST" );
        curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, 0 );
        curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 0 );
        curl_setopt( $ch, CURLOPT_POSTFIELDS, $s_data_json );

        $authorization = "Authorization: Bearer ".$TOKEN_API; // Prepare the authorisation token
        //curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt( $ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json; charset=utf-8',
                'Content-Length: ' . strlen( $s_data_json ),
                $authorization
            )
        );
        curl_setopt( $ch, CURLOPT_TIMEOUT, 900 );
        curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 500 );

        $respuesta  = curl_exec( $ch );
        curl_close( $ch );
        if( $respuesta === false )
        {
            throw new Exception( curl_error( $ch ), curl_errno( $ch ) );
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $a_respuesta = json_decode( $respuesta, true );

        //ahora se actualiza la respuesta
        $o_SR_GuiaRemisionHDP = new SR_GuiaRemisionHDP();
        $o_SR_GuiaRemisionHDP->setGuiaRemisionId( $o_SR_GuiaRemisionHBN->getGuiaRemisionId() );
        $o_SR_GuiaRemisionHDP->setDataJson( $s_data_json." | ".$respuesta );
        $o_SR_GuiaRemisionHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_SR_GuiaRemisionHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_SR_GuiaRemisionHDP->update();

        return $a_respuesta;
    }
}
