<?php
class iRestClient
{
    private const FORM_CONTENT_TYPE = 'application/x-www-form-urlencoded';
    private const USER_AGENT = 'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.9) Gecko/20071025 Firefox/3.0.0.1';
    private const HTTP_VERSION = 1.1;
    
    public function getJsonDecode( string $url, array $headers = [] )
    {
        $s_ResponseJson = $this->get( $url, $headers );
        $a_Data = json_decode( $s_ResponseJson, true );
        return $a_Data;
    }
    
    public function get( string $url, array $headers = [] )
    {
        $ctx = $this->getContext( 'GET', null, $headers );
        
        return $this->getResponseAndSaveCookies( $url, $ctx );
    }

    /*
     $json = $this->client->post(
            $url, 
            json_encode(['CODDNI' => $dni]),
            [
                'Content-Type' => 'application/json;chartset=utf-8',
                'Requestverificationtoken' => $this->requestToken,
            ]);
    */
    public function post(string $url, $data, array $headers = [])
    {
        if (is_array( $data ) ) 
        {
            $headers['Content-type'] = self::FORM_CONTENT_TYPE;
        }
        
        $ctx = $this->getContext( 'POST', $data, $headers );
        
        return $this->getResponseAndSaveCookies( $url, $ctx );
    }
    
    private function getContext( string $method, $data, array $headers )
    {
        $headers['Connection'] = 'close';
        $defaultOptions = 
        [
            'http' => 
            [
                'header'            => $this->join( ': ', $headers ),
                'method'            => $method,
                'content'           => $this->getRawData( $data ),
                'user_agent'        => self::USER_AGENT,
                'protocol_version'  => self::HTTP_VERSION,
            ],
        ];

        return stream_context_create( $defaultOptions );
    }
    
    private function getResponseAndSaveCookies( string $url, $ctx )
    {
        set_error_handler
        (
            function ( $severity, $message, $file, $line ) 
            {
                //pr( func_get_args() );
                //pr( "$message, $severity, $severity, $file, $line" );
                //$message = mb_convert_encoding( $message, "windows-1251", "utf-8" );
                //pr( $message );
                //throw new Exception( $message );
                return array( "error" => 1, "error_mensaje" => $message );
            }
        );
        //pr($url);
        $response = @file_get_contents( $url, false, $ctx );
        //pr($response);
        //restore_error_handler();
        return $response;
    }
    
    private function getRawData( $data )
    {
        return is_array( $data ) ? http_build_query( $data ) : $data;
    }
    
    private function join( string $glue, array $items, string $end = "\r\n" ): ?string
    {
        $append = '';
        foreach ( $items as $key => $value ) 
        {
            $append .= $key . $glue . $value . $end;
        }
        
        return $append;
    }
}