<?php

/**
 * Clase Utilitaria para el Manejo de Clases y Objetos
 *
 */
class utilObject{
	
	/**
	 * Retorna un Array  ingresando un array de Objetos, los metodos
	 *
	 * @param unknown_type $options
	 * @param unknown_type $value_method
	 * @param unknown_type $text_method
	 * @return unknown
	 */
	public  static function genArrayByObjs($a_Objs = array(), $value_method, $text_method = null)
	{
	  $options = array();
	  foreach ($a_Objs as $option)
	  {
	    // text method exists?
	    if ($text_method && !is_callable(array($option, $text_method)))
	    {
	      $error = sprintf('Metodo no existe clase', $text_method, get_class($option));
	      throw new sfViewException($error);
	    }
	
	    // value method exists?
	    if (!is_callable(array($option, $value_method)))
	    {
	      $error = sprintf('Metodo no existe clase', $text_method, get_class($option));
	      throw new sfViewException($error);
	    }
	
	    $value = $option->$value_method();
	    $key   = ($text_method != null) ? $option->$text_method() : $value;
	    
	    $value = trim($value);
	    $key   = trim($key);
	    
	    $options[$value] = $key;
	  }
	
	  return $options;
	}
	
	/**
	 * Retorna un Array  Matriz
	 *
	 * @param unknown_type $options   genArrayMulByObjs($aDocPago,array('getdocPagoId','getestado'))
	 * @param unknown_type $value_method
	 * @param unknown_type $text_method
	 * @return unknown
	 */
	public  static function genArrayMulByObjs($a_Objs = array(), $a_methods = array())
	{
	  $options 	= array();
	  if($a_Objs){
		  foreach ($a_Objs as $option)
		  {
		  	 $opt 		= array(); 
		  	 foreach ($a_methods as $key=>$value_method){ 
		  	 	
			    // value method exists?
			    if (!is_callable(array($option, $value_method)))
			    {
			      $error = sprintf('Metodo no existe clase', $text_method, get_class($option));
			      throw new sfViewException($error);
			    }
			    $opt[] = $option->$value_method();		      
		  	 }  
		  	 $options[]=$opt; 
		  }	
	  }
	  return $options;
	}
	
	/**
	 * retorna el valor del objeto array('method',array('param1','param2'))
	 *
	 * @param unknown_type $object
	 * @param unknown_type $method
	 * @param unknown_type $default_value
	 * @param unknown_type $param
	 * @return unknown
	 */
	function _get_object_value($object, $method, $default_value = null, $param = null)
	{
	  // compatibility with the array syntax
	  if (is_string($method))
	  {
	    $param = ($param == null ? array() : array($param));
	    $method = array($method, $param);
	  }
	  
	  // method exists?
	  if (!is_callable(array($object, $method[0])))
	  {
	    $error = 'Method "%s" doesn\'t exist for object of class "%s"';
	    $error = sprintf($error, $method[0], _get_class_decorated($object));
	
	    throw new sfViewException($error);
	  }
	
	  $object_value = call_user_func_array(array($object, $method[0]), $method[1]);
	
	  return ($default_value !== null && $object_value === null) ? $default_value : $object_value;
	}
	
	
	
	/**
	 * Function que verifica si existe la clase y sus metodos().
	 *
	 * @param  array $var[0]=clase , $var[1]= metodo
	 * @return bool
	 */
	public static function is_callback($var)
	{
	    if (is_array($var) && count($var) == 2) {
	        $var = array_values($var);
	        if ((!is_string($var[0]) && !is_object($var[0])) || (is_string($var[0]) && !class_exists($var[0]))) {
	            return false;
	        }
	        $isObj = is_object($var[0]);
	        $class = new ReflectionClass($isObj ? get_class($var[0]) : $var[0]);
	        if ($class->isAbstract()) {
	            return false;
	        }
	        try {
	            $method = $class->getMethod($var[1]);
	            if (!$method->isPublic() || $method->isAbstract()) {
	                return false;
	            }
	            if (!$isObj && !$method->isStatic()) {
	                return false;
	            }
	        } catch (ReflectionException $e) {
	            return false;
	        }
	        return true;
	    } elseif (is_string($var) && function_exists($var)) {
	        return true;
	    }
	    return false;
	}
	
	
	function call_user_func_array1($func, $args)
	{
		if(is_callable($func[0], $func[1])){
	        $argString = '';
	        $comma = '';
	        for ($i = 0; $i < count($args); $i ++) {
	            $argString .= $comma . "\$args[$i]";
	            $comma = ', ';
	        }
	
	        if (is_array($func)) {
	            $obj =& $func[0];
	            $meth = $func[1];
	            if (is_string($func[0])) {
	                eval("\$retval = $obj::\$meth($argString);");
	            } else {
	                eval("\$retval = \$obj->\$meth($argString);");
	            }
	        } else {
	            eval("\$retval = \$func($argString);");
	        }
		}
        return $retval;
    }
	
}