<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0">ALERTA DE RECEPCION</h4>
        </div>
        <div class="container">
            
                <div class="row">
                    <div class="col-sm-1 border bg-warning">&nbsp;</div>
                    <div class="col-sm-3 border text-center">Aviso</div>
                    <div class="col-sm-1 border bg-info">&nbsp;</div>
                    <div class="col-sm-3 border text-center">Advertencia</div>
                    <div class="col-sm-1 border bg-danger">&nbsp;</div>
                    <div class="col-sm-3 border text-center">Peligro</div>
                </div>
            
        </div>
    </div>
</div>

<form name="form1" id="form1" method="POST" action="" onsubmit="">
    <input type="hidden" name="Control" id="Control" value="ok">
    <div class="form-row align-items-center">
        <div class="col-auto my-1">
            <select class="custom-select mr-sm-2" id="Tipo" name="Tipo">
                <option value="" selected=""> - TIPO - </option>
                <?php foreach ( MST_TipoUbicacionFN::selectActivos( 1 ) as $o_MST_TipoUbicacionBN ) { ?>
                    <option value="<?=$o_MST_TipoUbicacionBN->getIdTipoUbicacion()?>" <?php if( $o_MST_TipoUbicacionBN->getIdTipoUbicacion()==$Tipo ){ echo "SELECTED"; } ?> > <?=$o_MST_TipoUbicacionBN->getNombre()?> </option>
                <?php } ?>
            </select>
        </div>
        <div class="col-auto my-1">
            <select class="custom-select mr-sm-2" id="EstadoUbiccion" name="EstadoUbiccion">
                <option value="3" <?php if( $s_EstadoUbiccion=='3' ){ echo "SELECTED"; } ?> > OCUPADO </option>
                <option value="2" <?php if( $s_EstadoUbiccion=='2' ){ echo "SELECTED"; } ?> > SUCIO </option>
                <option value="1" <?php if( $s_EstadoUbiccion=='1' ){ echo "SELECTED"; } ?> > LIMPIEZA </option>
            </select>
        </div>
        <div class="col-auto my-1">
            <button type="submit" class="btn btn-primary">BUSCAR</button>
        </div>
    </div>
</form>

<div class="table-responsive">
    <table class="table  table-bordered table-hover">
        <thead class="table-primary">
            <tr>
                <th scope="col">#</th>
                <th scope="col">Ubicacion</th>
                <th scope="col">Cliente</th>
                <th scope="col">Hora Ingreso</th>
                <?php if( $s_EstadoUbiccion == 3 ){ ?>
                <th scope="col">Hora</th>
                <th scope="col">Tarifa</th>
                <th scope="col">Hora Salida</th>
                <th scope="col">Tolerancia</th>
                <th scope="col">Hora Salida</th>
                <th scope="col">Minutos Extras</th>
                <th scope="col">Monto Soles</th>
                <?php } ?>
            </tr>
        </thead>
        <tbody>
            <?php foreach ( $a_SRV_UbicacionClienteH as $i_Key => $o_SRV_UbicacionClienteHBN ) { ?>
                <?php 
                $o_MST_ItemUbicacionBN = $o_SRV_UbicacionClienteHBN->getObjectUbicacion();

                //recuperamos la fecha salida mas tolerancia
                $f_FechaHoraTolerancia = UtilDate::sumar_minuto( $o_SRV_UbicacionClienteHBN->getToleranciaUbicacion(), $o_SRV_UbicacionClienteHBN->getFechaHoraSalida() );

                //se agrega el procedimiento para ver si hay tiempo extras 2020-02-19
                $f_MinutosExtra      = 0;
                $f_MinutosExtraMonto = 0;
                if( $o_SRV_UbicacionClienteHBN->getMinutosExtra() )
                {
                    $f_MinutosExtra      = $o_SRV_UbicacionClienteHBN->getMinutosExtra();
                    $f_MinutosExtraMonto = $o_SRV_UbicacionClienteHBN->getMinutosExtraMonto();
                }
                else
                {
                    //aqui se realiza el calculo
                    $s_FechaHoraSalida = UtilDate::sumar_minuto( $o_SRV_UbicacionClienteHBN->getToleranciaUbicacion(), $o_SRV_UbicacionClienteHBN->getFechaHoraSalida() );
                    $s_FechaHoraActual = date( "Y-m-d H:i:s" );
                    $i_MinutosExtras   = 0;
                    if( UtilDate::validarFecha1Mayor( $s_FechaHoraActual, $s_FechaHoraSalida ) )
                    {
                        $o_stdClass     = UtilDate::datetimeDiff( $s_FechaHoraSalida, $s_FechaHoraActual );
                        $f_MinutosExtra = floatval( $o_stdClass->total_min );

                        $f_PrecioTarifa  = $o_SRV_UbicacionClienteHBN->getPrecioTarifa();
                        $i_HoraUbicacion = $o_SRV_UbicacionClienteHBN->getHoraUbicacion();
                        $f_TarifaPorHora = round( $f_PrecioTarifa / $i_HoraUbicacion, 2 );
                        $f_TarifaPorMinu = round( $f_TarifaPorHora / 60, 2 );
                        $f_MinutosExtraMonto = $f_MinutosExtra * $f_TarifaPorMinu;
                    }
                }

                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //procedimiento para las alertas con colores 2020-02-19
                $s_BackgroundColor = "";

                $o_Obj = UtilDate::datetimeDiff( $o_SRV_UbicacionClienteHBN->getFechaHoraSalida(), date( "Y-m-d H:i:s" ) );
                $i_TotalMinutos = $o_Obj->total_min;

                $b_ControlFecha1 = UtilDate::validarFecha1Mayor( $o_SRV_UbicacionClienteHBN->getFechaHoraSalida(), date( "Y-m-d H:i:s" ) );
                if( $b_ControlFecha1 )
                {
                    //negativo
                    if( $i_TotalMinutos <= 15 && $i_TotalMinutos >= 0 )
                    {
                        //amarillo
                        $s_BackgroundColor = "text-warning";
                    }
                }
                else
                {
                    $b_ControlFecha2 = UtilDate::validarFecha1Mayor( $f_FechaHoraTolerancia, date( "Y-m-d H:i:s" ) );
                    if( $b_ControlFecha2 )
                    {
                        $s_BackgroundColor = "text-info";
                    }
                }

                $b_ControlFecha3 = UtilDate::validarFecha1Mayor( date( "Y-m-d H:i:s" ), $f_FechaHoraTolerancia  );
                if( $b_ControlFecha3 )
                {
                    $s_BackgroundColor = "text-danger";
                }

                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                ?>
            <tr class="<?=$s_BackgroundColor?>">
                <th scope="row"><?=$i_Key+1?></th>
                <td><?=$o_MST_ItemUbicacionBN->getObjectPiso()->getNombre()?> - <?=$o_MST_ItemUbicacionBN->getNombre()?> - <?=$o_MST_ItemUbicacionBN->getCategoriaUbicacionDescripcion()?></td>
                <td><?=$o_SRV_UbicacionClienteHBN->getNumeroDocuCliente()." - ".$o_SRV_UbicacionClienteHBN->getNombreCliente()?></td>
                <?php if( $s_EstadoUbiccion == 3 ){ ?>                
                <td><?=$o_SRV_UbicacionClienteHBN->getFechaHoraDocumento()?></td>
                <?php }else{ ?>
                <td><?=$o_SRV_UbicacionClienteHBN->getEstadoUbicacionFecha()?></td>
                <?php } ?>
                <?php if( $s_EstadoUbiccion == 3 ){ ?>
                <td align="center"><?=$o_SRV_UbicacionClienteHBN->getHoraUbicacion()?></td>
                <td align="center"><?=number_format( $o_SRV_UbicacionClienteHBN->getPrecioTarifa(), 2 )?></td>
                <td><?=$o_SRV_UbicacionClienteHBN->getFechaHoraSalida()?></td>
                <td align="center"><?=$o_SRV_UbicacionClienteHBN->getToleranciaUbicacion()?></td>
                <td><?=$f_FechaHoraTolerancia?></td>

                <td align="center"><?=$f_MinutosExtra?> <?php //$i_TotalMinutos?> </td>
                <td align="center"><?=number_format( $f_MinutosExtraMonto, 2 )?></td></td>

                <?php } ?>
            </tr>    
            <?php } ?>
        </tbody>
    </table>
</div>