<?php
class GuardarAsociarClienteAction extends wtActions
{
    public function execute()
    {
        
        $s_IdHabitacion     = $this->getRequestParameter( 'IdHabitacion' );
        $s_ClienteNumero    = $this->getRequestParameter( 'ClienteNumero' );
        $s_TipoDocCliente   = $this->getRequestParameter( 'TipoDocCliente' );
        $s_NumDocuCliente   = $this->getRequestParameter( 'NumDocuCliente' );
        $s_NombreCliente    = $this->getRequestParameter( 'NombreCliente' );
        $s_DireccionCliente = $this->getRequestParameter( 'DireccionCliente' );

        $s_IdTipoDocumento  = $this->getRequestParameter( 'IdTipoDocumento' );
        $s_TipoDocumentoCod = $this->getRequestParameter( 'TipoDocumentoCod' );
        $s_DocumentoSerie   = $this->getRequestParameter( 'DocumentoSerie' );
        $s_DocumentoNumero  = $this->getRequestParameter( 'DocumentoNumero' );

        $s_ItemIdTarifa  = $this->getRequestParameter( 'ItemTarifa' );
        $s_HoraUbicacion = $this->getRequestParameter( 'HoraUbicacion' );
        $s_PrecioConIGV  = $this->getRequestParameter( 'PrecioConIGV' );
        $s_FechaEmision  = $this->getRequestParameter( 'FechaEmision' );
        //$s_HoraEmision   = $this->getRequestParameter( 'HoraEmision' );
        $s_HoraEmision   = date( " H:i:s" );
        /*
        $date              = date( $s_FechaEmision." H:i:s" ); 
        $newDate           = strtotime ( "+$s_HoraUbicacion hour" , strtotime ( $date ) );
        $s_FechaHoraSalida = date ( 'Y-m-j H:i:s' , $newDate ); 
        */
        $s_FechaHoraSalida = UtilDate::sumar_hora( $s_HoraUbicacion, $s_FechaEmision." ".$s_HoraEmision );
        
        $con = Conexion::getConexion();
        $con->begin();

        try 
        {
            myUser::getUser()->validar_session();

            //ahora recuperamos la tolerancia
            $o_MST_UbicacionFN = new MST_UbicacionFN();
            $o_MST_UbicacionBN = $o_MST_UbicacionFN->selectByPK( $s_IdHabitacion );
            $i_Tolerancia = $o_MST_UbicacionBN->getTolerancia();

            //una simple validacion
            $o_SRV_UbicacionClienteHFN = new SRV_UbicacionClienteHFN();
            $o_SRV_UbicacionClienteHFN->setIdUbicacion( ( int ) $s_IdHabitacion );
            //$o_SRV_UbicacionClienteHFN->setNumeroDocuCliente( $s_NumDocuCliente );
            $o_SRV_UbicacionClienteHFN->setEstado( SRV_UbicacionClienteHBN::ESTADO_PENDIENTE );
            $a_SRV_UbicacionClienteH = $o_SRV_UbicacionClienteHFN->select();
            if( $a_SRV_UbicacionClienteH )
            {
                throw new Exception( "Actualmente existe Ubicacion asociado a un Cliente." );
            }

            //$s_IdAlmacen  = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $a_ALM_AlmacenMast = ALM_AlmacenMastFN::recuperarAlmacenParaVentas( myUser::getUser()->getIdSucursal() );
            if( count( $a_ALM_AlmacenMast ) == 1 )
            {
                $s_IdAlmacen = $a_ALM_AlmacenMast[0]->getIdAlmacen();
            }
            else
            {
                throw new Exception( "Se tiene que seleccionar un Almacen." );
            }
            $i_IdCompania = myUser::getUser()->getIdBusiness();
            $i_IdSucursal = myUser::getUser()->getIdSucursal();

            $s_Periodo = UtilDate::getFormatDate( $s_FechaEmision, "Ym" );

            //$s_IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se registra el comprobante cabecera
            ParameterWR::getInstance()->setVar( "IdVendedor", myUser::getUser()->getUserId() );
            ParameterWR::getInstance()->setVar( "TipoVenta", "MER" );
            ParameterWR::getInstance()->setVar( "s_TipoProc", "nvo" );
            ParameterWR::getInstance()->setVar( "MonedaDocumento", "LO" );
            ParameterWR::getInstance()->setVar( "MonedaCambioValor", 1 );
            ParameterWR::getInstance()->setVar( "FechaDocumento", $s_FechaEmision );
            ParameterWR::getInstance()->setVar( "ClienteNombre", $s_NombreCliente );
            ParameterWR::getInstance()->setVar( "ClienteTipoDoc", $s_TipoDocCliente );
            ParameterWR::getInstance()->setVar( "ClienteRUC", $s_NumDocuCliente );

            ob_start();
            $o_proActions = new proActions();
            $o_proActions->executeSaveAddEdit();
            $s_Json = ob_get_contents();
            ob_end_clean();

            $a_Json = json_decode( $s_Json, true );

            $s_ConcatIdComprobante = isset( $a_Json['id'] ) ? $a_Json['id'] : "0";
            $s_Estado              = isset( $a_Json['estado'] ) ? $a_Json['estado'] : "ERROR";
            $b_Error               = $a_Json['error'];

            if( $b_Error )
            {
                throw new Exception( $a_Json['mensaje_error'] );
            }

            $a_Ids = explode( "_", $s_ConcatIdComprobante );
            $s_IdTipoDocumento = $a_Ids[0];
            //$s_IdCompania      = $a_Ids[1];
            $s_NumeroDocumento = $a_Ids[2];

            ParameterWR::getInstance()->destroy();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se procede a registrar la cabecera
            $i_IdUbicacionClienteH = SRV_UbicacionClienteHDP::recuperarId();

            $o_SRV_UbicacionClienteHDP = new SRV_UbicacionClienteHDP();
            $o_SRV_UbicacionClienteHDP->setIdUbicacionClienteH( $i_IdUbicacionClienteH );
            $o_SRV_UbicacionClienteHDP->setIdCompania( $i_IdCompania );
            $o_SRV_UbicacionClienteHDP->setIdSucursal( $i_IdSucursal );
            $o_SRV_UbicacionClienteHDP->setIdAlmacen( $s_IdAlmacen );
            $o_SRV_UbicacionClienteHDP->setIdUbicacion( ( int ) $s_IdHabitacion );
            $o_SRV_UbicacionClienteHDP->setIdTipoDocumento( $s_IdTipoDocumento );

            $o_SRV_UbicacionClienteHDP->setDocumentoCod( $s_TipoDocumentoCod );
            $o_SRV_UbicacionClienteHDP->setDocumentoSerie( $s_DocumentoSerie );
            $o_SRV_UbicacionClienteHDP->setDocumentoNumero( $s_DocumentoNumero );
            $o_SRV_UbicacionClienteHDP->setNumeroDocumentoRef( $s_NumeroDocumento );

            $o_SRV_UbicacionClienteHDP->setPeriodo( $s_Periodo );
            $o_SRV_UbicacionClienteHDP->setFechaDocumento( $s_FechaEmision );
            $o_SRV_UbicacionClienteHDP->setFechaHoraDocumento( $s_FechaEmision." ".$s_HoraEmision );
            $o_SRV_UbicacionClienteHDP->setHoraUbicacion( ( int ) $s_HoraUbicacion );
            $o_SRV_UbicacionClienteHDP->setFechaHoraSalida( $s_FechaHoraSalida );
            $o_SRV_UbicacionClienteHDP->setToleranciaUbicacion( $i_Tolerancia );
            $o_SRV_UbicacionClienteHDP->setIdCliente( ( int ) $s_ClienteNumero );
            $o_SRV_UbicacionClienteHDP->setTipoDocCliente( $s_TipoDocCliente );
            $o_SRV_UbicacionClienteHDP->setNumeroDocuCliente( $s_NumDocuCliente );
            $o_SRV_UbicacionClienteHDP->setNombreCliente( $s_NombreCliente );
            $o_SRV_UbicacionClienteHDP->setDireccionCliente( $s_DireccionCliente );
            $o_SRV_UbicacionClienteHDP->setIdItemTarifa( $s_ItemIdTarifa );
            $o_SRV_UbicacionClienteHDP->setPrecioTarifa( floatval( $s_PrecioConIGV ) );
            $o_SRV_UbicacionClienteHDP->setEstado( SRV_UbicacionClienteHBN::ESTADO_PENDIENTE );
            $o_SRV_UbicacionClienteHDP->setEstadoProceso( SRV_UbicacionClienteHBN::ESTADO_PENDIENTE );
            $o_SRV_UbicacionClienteHDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionClienteHDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionClienteHDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionClienteHDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionClienteHDP->save();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se procede a realizar la relacion entre ubicacion y el medio de pago
            $o_SRV_UbicacionClienteDetDP = new SRV_UbicacionClienteDetDP();
            $o_SRV_UbicacionClienteDetDP->setIdUbicacionClienteH( $i_IdUbicacionClienteH );
            $o_SRV_UbicacionClienteDetDP->setIdUbicacion( ( int ) $s_IdHabitacion );
            $o_SRV_UbicacionClienteDetDP->setIdTipoDocumento( $s_IdTipoDocumento );
            $o_SRV_UbicacionClienteDetDP->setIdCompania( $i_IdCompania );
            $o_SRV_UbicacionClienteDetDP->setIdSucursal( $i_IdSucursal );
            $o_SRV_UbicacionClienteDetDP->setNumeroDocumento( $s_NumeroDocumento );
            $o_SRV_UbicacionClienteDetDP->setDocumentoCod( $s_TipoDocumentoCod );
            $o_SRV_UbicacionClienteDetDP->setDocumentoSerie( $s_DocumentoSerie );
            $o_SRV_UbicacionClienteDetDP->setDocumentoNumero( $s_DocumentoNumero );
            $o_SRV_UbicacionClienteDetDP->setIdPersona( ( int ) $s_ClienteNumero );
            $o_SRV_UbicacionClienteDetDP->setNombreCompleto( $s_NombreCliente );
            $o_SRV_UbicacionClienteDetDP->setEstado( $s_Estado );
            $o_SRV_UbicacionClienteDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionClienteDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionClienteDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionClienteDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionClienteDetDP->save();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se registra el detalle por el servicio
            $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
            $o_VTA_DocumentoDetalleBN->setIdSucursal( $i_IdSucursal );
            //$o_VTA_DocumentoDetalleBN->setSecuencia( $Secuencia );
            $o_VTA_DocumentoDetalleBN->setItemCodigo( $s_ItemIdTarifa );
            $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $s_IdAlmacen );
            $o_VTA_DocumentoDetalleBN->setIdCompania( $i_IdCompania );
            //$o_VTA_DocumentoDetalleBN->setLote( $IdLote );
            //$o_VTA_DocumentoDetalleBN->setLoteAlias( $IdLote );
            $o_VTA_DocumentoDetalleBN->setIdUnidad( 58 );
            $o_VTA_DocumentoDetalleBN->setCantidadPedida( 1 );
            $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $s_NumeroDocumento );
            $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $s_IdTipoDocumento );
            
            //$o_VTA_DocumentoDetalleBN->setPrecioUnitario( $PrecioUnitario );
            $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();
            $o_OrdenVentaDetalleBL->iniciarProceso( $o_VTA_DocumentoDetalleBN );
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora se reserva la ubicacion
            $o_SRV_UbicacionEstadoDP = new SRV_UbicacionEstadoDP();
            $o_SRV_UbicacionEstadoDP->setIdUbicacion( ( int ) $s_IdHabitacion );
            $o_SRV_UbicacionEstadoDP->delete();

            $o_SRV_UbicacionEstadoDP->setIdEstados( 3 );
            $o_SRV_UbicacionEstadoDP->setEstadoNombre( 'OCUPADO' );
            $o_SRV_UbicacionEstadoDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionEstadoDP->save();

            //ahora se guarda el log
            $i_IdLog = SRV_UbicacionEstadoLogDP::recuperarId();
            $o_SRV_UbicacionEstadoLogDP = new SRV_UbicacionEstadoLogDP();
            $o_SRV_UbicacionEstadoLogDP->setIdUbicacionEstLog( $i_IdLog );
            $o_SRV_UbicacionEstadoLogDP->setIdUbicacion( ( int ) $s_IdHabitacion );
            $o_SRV_UbicacionEstadoLogDP->setIdEstados( 3 );
            $o_SRV_UbicacionEstadoLogDP->setEstadoNombre( 'OCUPADO' );
            $o_SRV_UbicacionEstadoLogDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionEstadoLogDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionEstadoLogDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_SRV_UbicacionEstadoLogDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_SRV_UbicacionEstadoLogDP->save();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $con->commit();

            //$a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']             = false;
            $a_Rs['id_ubicacion_clie'] = $i_IdUbicacionClienteH;
            $a_Rs['id_ubicacion']      = $s_IdHabitacion;
            $a_Rs['id_comprobante']    = $s_ConcatIdComprobante;
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;

    }
}