<?php
class GenerarComprobanteAction extends wtActions
{
    public function execute()
    {
        error_reporting(E_ALL);
        ini_set('display_errors','On'); //PARA PRODUCCION "Off"
        $a_Rs = array( "error" => false );

        $con = Conexion::getConexion();
        $con->begin();
		//exit;
        try
        {
            myUser::getUser()->validar_session();

            $orden_id           = trim( $this->getRequestParameter( 'orden_id' ) );
            $txt_orden          = trim( $this->getRequestParameter( 'txt_orden' ) );

            $a_MetodoPago     = $this->getRequestParameter( 'MetodoPago' );
            
            
			if( $a_MetodoPago[0] == "6" || $a_MetodoPago[0] == "7")
			{
    			
                ///////////////////////////////////////////////////////////////////////////////////////////
                
                    $s_NombreCompleto = $_FILES['customFile']['name'];
                    $s_TipoCompleto   = $_FILES['customFile']['type'];
                    $i_TamanioFile    = intval( $_FILES['customFile']['size'] );
                    $fileTmpPath      = $_FILES['customFile']['tmp_name'];
                    
                    $phpFileUploadErrors = array
                    (
                            0 => 'There is no error, the file uploaded with success',
                            1 => 'El fichero subido excede la directiva upload_max_filesize de php.ini.',
                            2 => 'El fichero subido excede la directiva MAX_FILE_SIZE especificada en el formulario HTML.',
                            3 => 'El fichero fue subio parcialmente subido.',
                            4 => 'No se subio ningun fichero.',
                            6 => 'Falta la carpeta temporal.',
                            7 => 'No se pudo escribir el fichero en el disco.',
                            8 => 'Una extension de PHP detuvo la subida de ficheros. PHP no proporciona una forma de determinar la extension que causo la parada de la subida de ficheros; el examen de la lista de extensiones cargadas con phpinfo() puede ayudar.',
                    );
                    
                    if ( $_FILES['customFile']['error'] )
                    {
                        //echo $_FILES['customFile']['error'];
                        //print_r($_FILES);
                        //echo $phpFileUploadErrors[$_FILES['customFile']['error']] ;
                        throw new Exception( $phpFileUploadErrors[$_FILES['customFile']['error']] );
                    }
                    
                    $a_Archivo = explode( ".", $s_NombreCompleto );
                    
                    $s_TipoArchivo = $a_Archivo[1];
                    
                    $s_CarpetaFisica   = SF_ROOT_DIR.DIRECTORY_SEPARATOR."web".DIRECTORY_SEPARATOR."files".DIRECTORY_SEPARATOR."orden".DIRECTORY_SEPARATOR.$orden_id;
                    $s_UbicacionFisica = $s_CarpetaFisica.DIRECTORY_SEPARATOR.$s_NombreCompleto;
                    
                    if ( !file_exists( $s_CarpetaFisica ) )
                    {
                        mkdir( $s_CarpetaFisica, 0777, true );
                    }
                    
                    $s_UbicacionURL = Constantes::ROOT_DIR_FILES."orden/$orden_id/$s_NombreCompleto";
                    
                    /* 
                     * Funci���n personalizada para comprimir y 
                     * subir una imagen mediante PHP
                     */ 
                    function compressImage($source, $destination, $quality) { 
                        // Obtenemos la informaci���n de la imagen
                        $imgInfo = getimagesize($source); 
                        $mime = $imgInfo['mime']; 
                         
                        // Creamos una imagen
                        switch($mime){ 
                            case 'image/jpeg': 
                                $image = imagecreatefromjpeg($source); 
                                break; 
                            case 'image/png': 
                                $image = imagecreatefrompng($source); 
                                break; 
                            case 'image/gif': 
                                $image = imagecreatefromgif($source); 
                                break; 
                            default: 
                                $image = imagecreatefromjpeg($source); 
                        } 
                         
                        // Guardamos la imagen
                        imagejpeg($image, $destination, $quality); 
                         
                        // Devolvemos la imagen comprimida
                        return $destination; 
                    }
                    
                    //ahora se guarda el archivo seleccionado
                    if ( copy( $fileTmpPath, $s_UbicacionFisica ) )
                    //if(compressImage($fileTmpPath, $s_UbicacionFisica, 70))
                    {
                        $s_TipoArchivoId = 4;
                        $i_Secuencia = VTA_OrdenArchivosDP::recuperarId( (int)$orden_id );
                        $o_ALM_CajaChicaArhivosDP = new VTA_OrdenArchivosDP();
                        $o_ALM_CajaChicaArhivosDP->setOrdenId( (int)$orden_id );
                        $o_ALM_CajaChicaArhivosDP->setTipoArchivoId( ( int ) $s_TipoArchivoId );
                        $o_ALM_CajaChicaArhivosDP->setIdSecuencia( $i_Secuencia );
                        $o_ALM_CajaChicaArhivosDP->setNombre( $s_NombreCompleto );
                        $o_ALM_CajaChicaArhivosDP->setTipo( strtoupper( $s_TipoArchivo ) );
                        $o_ALM_CajaChicaArhivosDP->setTipoCompleto( $s_TipoCompleto );
                        $o_ALM_CajaChicaArhivosDP->setTamanio( $i_TamanioFile );
                        $o_ALM_CajaChicaArhivosDP->setUbicacionURL( $s_UbicacionURL );
                        $o_ALM_CajaChicaArhivosDP->setUbicacionFisica( addslashes( $s_UbicacionFisica ) );
                        $o_ALM_CajaChicaArhivosDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                        $o_ALM_CajaChicaArhivosDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_CajaChicaArhivosDP->save();
                        
                        //Guardar el archivo
                        
                        $a_archivoYapePlin = VTA_OrdenArchivosFN::getArrayObjArchhivos( $orden_id, $s_TipoArchivoId );
                        
                        //pr($a_archivoYapePlin);
                        
                        if(is_array($a_archivoYapePlin))
                        {
                            $o_VTA_OrdenArchivosFN = $a_archivoYapePlin[0];
                            $UbicacionURL = $o_VTA_OrdenArchivosFN->getUbicacionURL();
                            
                            $o_VTA_OrdenDP = new VTA_OrdenDP();
                            $o_VTA_OrdenDP->setOrdenId( ( int ) $orden_id );
                            $o_VTA_OrdenDP->setBilletraDigitalArchivo($UbicacionURL);
                            $o_VTA_OrdenDP->update();
                            
                        }
                        
                        //////////////////////////////////////////////////////////////
                    }
                    else
                    {
                        throw new Exception( "No se puedo copiar el archivo temporal." );
                    }
                
                ////////////////////////////////////////////////////////////////////////////
			}
            
            $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $txt_orden );
            $f_OrdenTotalaPagar = $o_VTA_OrdenBN->getOrdenTotalaPagar();

            //validaciones, por q ahora ya viene los parametros de pago
            $s_FormaPago      = $this->getRequestParameter( 'FormaPago' );
            
            $a_ReferenciaPago = $this->getRequestParameter( 'ReferenciaPago' );
            $a_MontoAplicado  = $this->getRequestParameter( 'MontoAplicado' );
            $b_EsContado      = $s_FormaPago == '008' ? true : false; //se refiere a la condicion de pago
            //si es a credito por defecto esta a 016 - CREDITO A 30 DIAS
			
			if( $a_MetodoPago[0] == "6" || $a_MetodoPago[0] == "7"){
				if(!$o_VTA_OrdenBN->getBilletraDigitalArchivo()){
					throw new Exception( "Se debe cargar una foto del comprobante de la billetera digital en 'Archivos'." );
				}
			}

            if( $b_EsContado )
            {
                if( !is_array( $a_MontoAplicado ) )
                {
                    throw new Exception( "No se encontro productos." );
                }
                $f_TotalAplicar = 0;
                $a_MetodosExis = array();
                foreach ( $a_MontoAplicado as $i_Key => $s_MontoAplicar )
                {
                    if( isset( $a_MetodosExis[$a_MetodoPago[$i_Key]] ) )
                    {
                        throw new Exception( "Se encontro un metodo de pago repetido." );
                    }
                    $f_MontoAplicar = floatval( $s_MontoAplicar );
                    if( $f_MontoAplicar <= 0 )
                    {
                        throw new Exception( "El metodo de pago tiene un valor 0." );
                    }
                    $f_TotalAplicar = $f_TotalAplicar + $f_MontoAplicar;
                    $a_MetodosExis[$a_MetodoPago[$i_Key]] = $a_MetodoPago[$i_Key];
                }
                if ( $f_TotalAplicar > $f_OrdenTotalaPagar )
                {
                    if( $a_MetodoPago[$i_Key] != 1 ) //metodo de pago efectivo
                    {
                        throw new Exception( "El total a aplicar es superior al total a pagar." );
                    }
                }
                if ( $f_TotalAplicar < $f_OrdenTotalaPagar )
                {
                    throw new Exception( "El total a aplicar no cubre el total a pagar." );
                }
            }

            $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
            $o_VTA_FormaPagoBN = $o_VTA_FormaPagoFN->selectByPK( $s_FormaPago );
            if( !$o_VTA_FormaPagoBN )
            {
                throw new Exception( "El Medio de Pago no existe." );
            }
            $o_VTA_OrdenDP = new VTA_OrdenDP();
            $o_VTA_OrdenDP->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
            //$o_VTA_OrdenDP->setContactoNombre( $s_FormaPagoId );
            $o_VTA_OrdenDP->setCondicionVentaId( $s_FormaPago );
            $o_VTA_OrdenDP->setFormaPagoDesc( $o_VTA_FormaPagoBN->getDescripcionLocal() );
            $o_VTA_OrdenDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
            $o_VTA_OrdenDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
            $o_VTA_OrdenDP->update();

            $o_VTA_OrdenBN->setCondicionVentaId( $s_FormaPago );
            $o_VTA_OrdenBN->setFormaPagoDesc( $o_VTA_FormaPagoBN->getDescripcionLocal() );

            if( $o_VTA_OrdenBN->getClienteDocCod() == "RUC" )
            {
                $IdTipoDocumento = "FC";
            }
            else
            {
                $IdTipoDocumento = "BV";
                if( $o_VTA_OrdenBN->getReferenciaTipoDocId() )
                {
                    $IdTipoDocumento = $o_VTA_OrdenBN->getReferenciaTipoDocId(); //AQUI SE ASOCIA EL DOCUMENTO QUE SELECCIONO
                }
            }

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora el procedimiento cambia para recuperar serie - numero [PUNO - JULIACA]
            $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
            $o_GSS_UsuarioSucuDocumentoFN->setIdusuario( myUser::getUser()->getUserId() );
            $o_GSS_UsuarioSucuDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $a_GSS_UsuarioSucuDocumento = $o_GSS_UsuarioSucuDocumentoFN->select();

            $o_GSS_SucursalDocumentoBN = null;

            if( count( $a_GSS_UsuarioSucuDocumento ) == 1 )
            {
                //se establece el tipo de documento por defecto
                $o_GSS_UsuarioSucuDocumentoBN = $a_GSS_UsuarioSucuDocumento[0];

                $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                $o_GSS_SucursalDocumentoBN = $o_GSS_SucursalDocumentoFN->selectByPK( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );

                $IdTipoDocumento = $o_GSS_SucursalDocumentoBN->getIdTipoDocumento();
            }
            else
            {
                foreach( $a_GSS_UsuarioSucuDocumento as $key => $o_GSS_UsuarioSucuDocumentoBN )
                {
                    $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                    $o_GSS_SucursalDocumentoBN = $o_GSS_SucursalDocumentoFN->selectByPK( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );

                    if( $o_GSS_SucursalDocumentoBN->getIdTipoDocumento() == $IdTipoDocumento )
                    {
                        break; //se interrumpe el bucle por que ya se encontro el tipo de documento que se buscaba
                    }
                }
            }

            if( $o_GSS_SucursalDocumentoBN )
            {
                //$o_GSS_SucursalDocumentoBN = $a_GSS_SucursalDocumento[0];

                $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
                $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $IdTipoDocumento );
                $s_TipoCod = "";
                if( $o_VTA_TipoDocumentoBN )
                {
                    $s_TipoCod = $o_VTA_TipoDocumentoBN->getTipoDocumentoCod();
                }

                $s_Serie  = str_pad( $o_GSS_SucursalDocumentoBN->getSerieFormato(), 4, "0", STR_PAD_LEFT );
                $s_Numero = str_pad( ( $o_GSS_SucursalDocumentoBN->getNumeroActual() + 1 ), 10, "0", STR_PAD_LEFT );

                //$a_lst = array( "Result" => true, "Serie" => $s_Serie, "Numero" => $s_Numero, "IdTipoDocumento" => $IdTipoDocumento, "TipoDocumentoCod" => $s_TipoCod );
            }
            else
            {
                throw new Exception( "No encontro Tipo de Documentos asociados a la Compañia." );
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $IdCompania         = myUser::getUser()->getIdBusiness();
            $ClienteNumero      = $o_VTA_OrdenBN->getClienteId();

            $Comentario         = "";
            //$f_TipoCambio       = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );

            $TipoDocumentoCod   = $s_TipoCod;
            $DocumentoSerie     = $s_Serie;
            $DocumentoNumero    = $s_Numero;
            $NaceAnulado        = false;

            $TipoVenta          = "MER";
            //$IdAlmacen          = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $IdVendedor         = myUser::getUser()->getUserId();

            //$s_MonedaDocumento  = $this->getRequestParameter( 'MonedaDocumento' );
            //$f_TipodeCambio     = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );
            //$f_Descuento        = floatval( $this->getRequestParameter( 'txt_descuento' ) );
            //$f_MontoSubTotal    = floatval( $this->getRequestParameter( 'txt_subtotal' ) );
            //$f_TotalImpuesto    = floatval( $this->getRequestParameter( 'txt_impuesto' ) );
            //$f_MontoTotal       = floatval( $this->getRequestParameter( 'txt_total' ) );

            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setDocumentoParentId( ( int ) $orden_id );
            $o_VTA_DocumentoBN->setDocumentoParentCod( $txt_orden );
            $o_VTA_DocumentoBN->setFacturacionDirecta( true );
            //$o_VTA_DocumentoBN->setForzarMovimientoInventario( true );

            //PARAMETROS PARA LA DETRACCION
            $DetracconTipoId     = 0;
            $DetracconPorcentaje = 0;
            $DetracconMedPagoId  = 0;
            $DetracconTotal      = 0;

            //SETEO PARA DETRACCIONES
            $o_VTA_DocumentoBN->setDetraccionTipoId( intval( $DetracconTipoId ) );
            $o_VTA_DocumentoBN->setDetraccionMedPagoId( intval( $DetracconMedPagoId ) );
            $o_VTA_DocumentoBN->setDetraccionPorcentaje( floatval( $DetracconPorcentaje ) );
            $o_VTA_DocumentoBN->setDetraccionTotal( floatval( $DetracconTotal ) );

            //PARAMETROS PARA RETENCION
            $RetencionTipoId        = 0;
            $RetencionBaseImponible = 0;
            $RetencionTotal         = 0;

            //SETEO PARA RETENCION
            $o_VTA_DocumentoBN->setRetencionTipoId( intval( $RetencionTipoId ) );
            $o_VTA_DocumentoBN->setRetencionBaseImponible( floatval( $RetencionBaseImponible ) );
            $o_VTA_DocumentoBN->setRetencionTotal( floatval( $RetencionTotal ) );

            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            //$o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
            $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_PREPARACION ); //por defecto
            //$o_VTA_DocumentoBN->setIdAlmacen( $IdAlmacen );
            //$o_VTA_DocumentoBN->setClienteNumero( $ClienteNumero );

            //$o_VTA_DocumentoBN->setMonedaDocumento( $s_MonedaDocumento );
            //$o_VTA_DocumentoBN->setTipodeCambio( $f_TipodeCambio );
            //$o_VTA_DocumentoBN->setMontoSubTotal( $f_MontoSubTotal );
            //$o_VTA_DocumentoBN->setMontoImpuestos( $f_TotalImpuesto );
            //$o_VTA_DocumentoBN->setMontoTotal( $f_MontoTotal );

            $FechaDocumento   = date( "Y-m-d H:i:s" );
            $FechaVencimiento = $FechaDocumento;

            $o_VTA_DocumentoBN->setFechaDocumento( $FechaDocumento );
            $o_VTA_DocumentoBN->setTipoFacturacion( "N" );
            $o_VTA_DocumentoBN->setDocumentoCod( $TipoDocumentoCod );
            $o_VTA_DocumentoBN->setDocumentoSerie( $DocumentoSerie );
            $o_VTA_DocumentoBN->setDocumentoNumero( $DocumentoNumero );
            $o_VTA_DocumentoBN->setNumeroComprobante( $DocumentoSerie."-".$DocumentoNumero );
            $o_VTA_DocumentoBN->setFechaVencimiento( $FechaVencimiento );
            $o_VTA_DocumentoBN->setTipoVenta( $TipoVenta );
            $o_VTA_DocumentoBN->setComentario( $Comentario );
            $o_VTA_DocumentoBN->setVendedor( myUser::getUser()->getUserId() );
			
            $o_VTA_DocumentoBN->setComision( floatval( $o_VTA_OrdenBN->getComision() ) );
			
			
            if( $this->getRequestParameter( 'IdVendedor' ) )
            {
                $o_VTA_DocumentoBN->setVendedor( $IdVendedor );
            }

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->guardarDocumentoPorOrden( $o_VTA_DocumentoBN );

            $a_Rs['id_concat'] = $o_VTA_DocumentoBN->getIdConcat();
            $a_Rs['id_comprobante'] = $o_VTA_DocumentoBN->getNumeroDocumento();

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //AQUI SE HACE UNA VALIDACION, DE Q LOS DETALLES DE LA ORDEN SON IGUALES A LA DEL COMPROBANTE
            $a_VTA_OrdenDetalle = $o_VTA_OrdenBN->getArrayDetalles();

            $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();

            if( count( $a_VTA_OrdenDetalle ) != count( $a_VTA_DocumentoDetalle ) )
            {
                throw new Exception( "La cantidad de Detalles en el comprobante no es igual." );
            }

            foreach( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
            {
                $b_ControlExiste = false;
                foreach( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
                {
                    if( $o_VTA_DocumentoDetalleBN->getItemCodigo() == $o_VTA_OrdenDetalleBN->getItemCod() )
                    {
                        $b_ControlExiste = true;
                        continue;
                    }
                }
                if( !$b_ControlExiste )
                {
                    throw new Exception( "No se encontro relacion [".$o_VTA_DocumentoDetalleBN->getItemCodigo()."] entre Orden de Venta y Comprobante" );
                }
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //pr( $a_VTA_DocumentoDetalle );  exit;

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            /// AHORA SE HACE EL REGISTRO DE GENERAR LA COBRANZA
            if( $b_EsContado )
            {
                //$s_IdOrden = $this->getRequestParameter( 'IdOrden' );
                //$s_OrdNum  = $this->getRequestParameter( 'OrdNum' );
                //$a_Monto   = $this->getRequestParameter( 'monto' );
                //$a_Recibo  = $this->getRequestParameter( 'recibo' );

                foreach ( $a_MetodoPago as $i_Key => $i_IdTipoPago )
                {
                    $a_Monto[$i_IdTipoPago]  = $a_MontoAplicado[$i_Key];
                    $a_Recibo[$i_IdTipoPago] = $a_ReferenciaPago[$i_Key];
                }

                //$o_VTA_OrdenBN     = VTA_OrdenFN::findOrdenByNum( $s_OrdNum );
                $o_VTA_DocumentoBN = VTA_DocumentoFN::findByDocumentoParentCod( $o_VTA_OrdenBN->getOrdenNum() ); //SE RECUPERA EL COMPROBANTE DEL CLIENTE

                $i_IdPersona        = $o_VTA_OrdenBN->getClienteId();
                $s_IdMoneda         = $o_VTA_OrdenBN->getMonedaCod(); //moneda del recibo
                $i_IdTipoPago       = 1;
                $i_IdBanco          = null;
                $i_IdCuenta         = null;
                $i_TerminoPago      = 0;
                $s_ReciboNumero     = "";
                $s_ReciboFecha      = date( "Y-m-d" );
                $s_FechaVenc        = null;
                $f_TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
                $s_Descripcion      = "COBRO POR FACTURA";

                $f_MontoTotalPagar  = $o_VTA_DocumentoBN->getMontoTotal();
                $f_NvoDocuPagado    = $f_MontoTotalPagar;
                $f_NvoDocuPagadoMN  = $f_MontoTotalPagar;
                $f_NvoDocuSaldo     = $o_VTA_DocumentoBN->getMontoSaldo();
                $f_NvoDocuSaldoMN   = $o_VTA_DocumentoBN->getMontoSaldoMN();

                if( !GSS_TipoCambioFN::getStaticTipoCambioCobranza() )
                {
                    $s_FechaSel = date( "Y-m-d" );

                    $o_iVentas = new iVentas();
                    $o_iVentas->registrarTipoCambio( $s_FechaSel );

                    $f_TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
                }

                if( !$f_TipodeCambio )
                {
                    throw new Exception( "El tipo de cambio no esta registrado." );
                }

                if( $o_VTA_DocumentoBN->getCobranzaEstado() == VTA_DocumentoBN::ESTADO_COB_COBRADO )
                {
                    throw new Exception( "El comprobante ya se encuentra Cobrado." );
                }

                $f_SumaTotalaAplicar = 0;
                foreach( $a_Monto as $i_IdTipoPago => $s_MontoAplicar )
                {
                    if( $i_IdTipoPago == 1 )
                    {
                        $i_IdBanco = 15;
                        $i_IdCuenta = 10;
                    }
                    else
                    {
                        if( isset( $a_Recibo[$i_IdTipoPago] ) )
                        {
                            $s_ReciboNumero = trim( $a_Recibo[$i_IdTipoPago] );
                        }
                    }

                    //POR DEFECTO
                    $i_IdBanco  = 15;
                    $i_IdCuenta = 10;

                    $f_Monto            = floatval( $s_MontoAplicar );

                    if( $f_Monto > $f_NvoDocuSaldo )
                    {
                        $f_Monto = $f_NvoDocuSaldo;
                    }

                    $f_SumaTotalaAplicar = $f_Monto + $f_SumaTotalaAplicar;

                    $f_NvoDocuSaldo     = round( $f_NvoDocuSaldo - $f_Monto, 2 );
                    $f_NvoDocuSaldoMN   = $f_NvoDocuSaldo;

                    $f_SaldoMonto       = 0;
                    $f_MontoSoles       = $f_Monto;
                    $f_SaldoMontoSoles  = 0;
                    $f_MontoDolar       = round( $f_Monto / $f_TipodeCambio, 2 );
                    $f_SaldoMontoDolar  = 0;

                    //se recupera info de la moneda del recibo
                    $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
                    $o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $s_IdMoneda );

                    //los datos de tipo de pago
                    $o_FCO_TipoPagoFN = new FCO_TipoPagoFN();
                    $o_FCO_TipoPagoBN = $o_FCO_TipoPagoFN->selectByPK( $i_IdTipoPago );

                    $i_IdTipoPago  = $o_FCO_TipoPagoBN->getIdTipoPago();
                    $s_TipoPagoNom = $o_FCO_TipoPagoBN->getNombre();
                    $s_ClaseNombre = $o_FCO_TipoPagoBN->getClaseNombre();

                    //se busca el cliente
                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdPersona );

                    $s_NumTipoDocCliente = $o_MST_PersonaMastBN->getDocumento();
                    $s_TipoDocCliente    = $o_MST_PersonaMastBN->getTipoDocumento();
                    $s_NombreCliente     = $o_MST_PersonaMastBN->getNombreCompletoLLeno();

                    //ahora se busca el numero de cuenta
                    $s_NumeroCuenta = null;
                    if( $i_IdCuenta )
                    {
                        $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
                        $o_MST_CuentaBancariaBN = $o_MST_CuentaBancariaFN->selectByPK( $i_IdCuenta );
                        $s_NumeroCuenta = $o_MST_CuentaBancariaBN->getNumeroCuenta();
                    }

                    ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                    $o_FCO_DocReciboDP = new FCO_DocReciboDP();

                    //se hace un insert
                    //en el caso de una cobranza nueva
                    $i_IdDocRecibo = FCO_DocReciboDP::recuperarId();

                    $o_FCO_DocReciboDP->setIdDocRecibo( $i_IdDocRecibo );

                    if( $i_IdTipoPago == 1 )
                    {
                        $s_ReciboNumero = ( string ) $i_IdDocRecibo;
                    }

                    if( $s_ReciboNumero == "" )
                    {
                        throw new Exception( "Debe ingresar el Numero de Operacion." );
                    }

                    $o_FCO_DocReciboDP->setReciboNumero( $s_ReciboNumero );
                    $o_FCO_DocReciboDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                    $o_FCO_DocReciboDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                    $o_FCO_DocReciboDP->setIdTipoPago( $i_IdTipoPago );
                    $o_FCO_DocReciboDP->setIdMoneda( $s_IdMoneda );
                    $o_FCO_DocReciboDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );
                    $o_FCO_DocReciboDP->setIdBanco( $i_IdBanco );
                    $o_FCO_DocReciboDP->setIdCuenta( $i_IdCuenta );
                    $o_FCO_DocReciboDP->setNumeroCuenta( $s_NumeroCuenta );
                    $o_FCO_DocReciboDP->setClaseNombre( $s_ClaseNombre );
                    $o_FCO_DocReciboDP->setTipoCambio( $f_TipodeCambio );
                    $o_FCO_DocReciboDP->setIdPersona( $i_IdPersona );
                    $o_FCO_DocReciboDP->setTipoDocCliente( $s_TipoDocCliente );
                    $o_FCO_DocReciboDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
                    $o_FCO_DocReciboDP->setNombreCliente( $s_NombreCliente );
                    $o_FCO_DocReciboDP->setDescripcion( $s_Descripcion );
                    $o_FCO_DocReciboDP->setReciboFecha( $s_ReciboFecha );
                    $o_FCO_DocReciboDP->setTerminoPago( $i_TerminoPago );
                    $o_FCO_DocReciboDP->setFechaVencimiento( $s_FechaVenc );
                    //$o_FCO_DocReciboDP->setFlujoEstado( "PE" ); //PE NDIENTE - AP ROBADO - REC HAZADO
                    $o_FCO_DocReciboDP->setFlujoEstado( FCO_DocReciboBN::FLUESTADO_APROBADO ); //PE NDIENTE - AP ROBADO - REC HAZADO
                    $o_FCO_DocReciboDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) ); //nace aprobado
                    $o_FCO_DocReciboDP->setApruebaUsuario( myUser::getUser()->getUserId() );
                    $o_FCO_DocReciboDP->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO ); //AC TIVO - AN ULADO
                    $o_FCO_DocReciboDP->setCobranzaEstado( FCO_DocReciboBN::ESTADO_COB_COBRADO );
                    $o_FCO_DocReciboDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );

                    $o_FCO_DocReciboDP->setMonto( $f_Monto );
                    $o_FCO_DocReciboDP->setSaldo( $f_SaldoMonto );
                    $o_FCO_DocReciboDP->setMontoMN( $f_MontoSoles );
                    $o_FCO_DocReciboDP->setSaldoMN( $f_SaldoMontoSoles );
                    $o_FCO_DocReciboDP->setMontoME( $f_MontoDolar );
                    $o_FCO_DocReciboDP->setSaldoME( $f_SaldoMontoDolar );

                    $o_FCO_DocReciboDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_DocReciboDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_FCO_DocReciboDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_DocReciboDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    //pr( $o_FCO_DocReciboDP );
                    $o_FCO_DocReciboDP->save();
                    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //AHORA SE REGISTRA LA APLICACION
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //recupero el id de caja y el turno
                    $o_FCO_CierreFN = new FCO_CierreFN();
                    $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
                    $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
                    $a_FCO_Cierre = $o_FCO_CierreFN->select();
                    if( !$a_FCO_Cierre )
                    {
                        throw new Exception( "No se aperturo ninguna Caja." );
                    }
                    if( count( $a_FCO_Cierre ) > 1 )
                    {
                        throw new Exception( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
                    }
                    if( count( $a_FCO_Cierre ) == 1 )
                    {
                        $o_FCO_CierreBN = $a_FCO_Cierre[0];
                        $i_IdCaja       = $o_FCO_CierreBN->getIdCaja();
                        $i_IdTurno      = $o_FCO_CierreBN->getIdTurno();
                        $s_CodVendedor  = $o_FCO_CierreBN->getCodVendedor();
                    }
                    ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

                    $f_MontoAplicar   = $f_Monto;
                    $f_MontoAplicarMN = $f_Monto;
                    $f_MontoAplicarME = round( $f_MontoAplicar / $f_TipodeCambio, 2 );

                    //ahora se guarda la aplicacion
                    $i_IdAplicacion = FCO_AplicacionDP::recuperarId();

                    $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                    $o_FCO_AplicacionDP->setIdAplicacion( $i_IdAplicacion );
                    $o_FCO_AplicacionDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                    $o_FCO_AplicacionDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                    $o_FCO_AplicacionDP->setIdCaja( $i_IdCaja );
                    $o_FCO_AplicacionDP->setIdTurno( $i_IdTurno );
                    $o_FCO_AplicacionDP->setIdBanco( $i_IdBanco );
                    $o_FCO_AplicacionDP->setIdCuenta( $i_IdCuenta );
                    $o_FCO_AplicacionDP->setIdMoneda( $s_IdMoneda );
                    $o_FCO_AplicacionDP->setMonedaDes( $o_GSS_MonedaMastBN->getDescripcion() );

                    $o_FCO_AplicacionDP->setIdTipoPago( $i_IdTipoPago );
                    $o_FCO_AplicacionDP->setTipoPagoNombre( $s_TipoPagoNom );
                    $o_FCO_AplicacionDP->setClaseNombre( $s_ClaseNombre ); //BANCOS - EFECTIVO - TARJETA - AJUSTES - NC
                    $o_FCO_AplicacionDP->setNombreTipo( FCO_AplicacionBN::T_APLICACION_PAGO ); //PAGO - NOTA_CREDITO
                    $o_FCO_AplicacionDP->setDescripcion( $s_Descripcion );

                    $o_FCO_AplicacionDP->setIdPersona( $i_IdPersona );
                    $o_FCO_AplicacionDP->setTipoDocCliente( $s_TipoDocCliente );
                    $o_FCO_AplicacionDP->setNumTipoDocCliente( $s_NumTipoDocCliente );
                    $o_FCO_AplicacionDP->setNombreCliente( $s_NombreCliente );
                    $o_FCO_AplicacionDP->setReciboNumero( $s_ReciboNumero ); //es el numero de operacion de un recibo o una nota de credito, info de donde del padre
                    $o_FCO_AplicacionDP->setIdDocRecibo( $i_IdDocRecibo ); //no esta nullo cuando es un pago normal para un recibo, es nulo cuando se aplica por una nota de cred
                    //$o_FCO_AplicacionDP->setIdNumeroDocumento(  ); //cuando nace por una nota de credito se setea el id del comprobante
                    $o_FCO_AplicacionDP->setIdDocNumRef( $o_VTA_DocumentoBN->getNumeroDocumento() );
                    $o_FCO_AplicacionDP->setCodDocRef( $o_VTA_DocumentoBN->getDocumentoCod() );
                    $o_FCO_AplicacionDP->setSerieNumeroDocRef( $o_VTA_DocumentoBN->getDocumentoSerieNumero() );
                    $o_FCO_AplicacionDP->setMontoTotalDocRef( $o_VTA_DocumentoBN->getMontoTotal() );
                    $o_FCO_AplicacionDP->setSaldoDocRef( $f_NvoDocuSaldo );
                    $o_FCO_AplicacionDP->setFechaDocRef( $o_VTA_DocumentoBN->getFechaDocumento() );
                    $o_FCO_AplicacionDP->setFechaDocVenRef( $o_VTA_DocumentoBN->getFechaVencimiento() );
                    $o_FCO_AplicacionDP->setIdMonedaRef( $o_VTA_DocumentoBN->getMonedaDocumento() );
                    $o_FCO_AplicacionDP->setTipoCambioRef( $o_VTA_DocumentoBN->getTipodeCambio() );
                    $o_FCO_AplicacionDP->setCodVendedorRef( $o_VTA_DocumentoBN->getVendedor() );
                    $o_FCO_AplicacionDP->setIdAlmacenRef( $o_VTA_DocumentoBN->getIdAlmacen() );
                    $o_FCO_AplicacionDP->setTipoCambio( $f_TipodeCambio ); //POR DEFECTO 1 POR SER EN SOLES
                    $o_FCO_AplicacionDP->setPeriodo( date( "Ym" ) );
                    $o_FCO_AplicacionDP->setFechaAplicacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_AplicacionDP->setMontoAplicado( $f_MontoAplicar );
                    $o_FCO_AplicacionDP->setMontoAplicacionMN( $f_MontoAplicarMN );
                    $o_FCO_AplicacionDP->setMontoAplicacionME( $f_MontoAplicarME );
                    $o_FCO_AplicacionDP->setMostrar( "Y" ); //al parecer cuando se hace la reversion en reportes especiales no se muestra
                    $o_FCO_AplicacionDP->setEstado( FCO_AplicacionBN::ESTADO_APLICADO ); //PE NDIENTE - AP LICADO - AN ULADO
                    $o_FCO_AplicacionDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_AplicacionDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_FCO_AplicacionDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_FCO_AplicacionDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    //pr( $o_FCO_AplicacionDP );
                    $o_FCO_AplicacionDP->save();
                    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                }

                if( $f_SumaTotalaAplicar < $f_MontoTotalPagar )
                {
                    throw new Exception( "El monto a aplicar no cubre el monto total del Documento." );
                }

                //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                //ahora se actualiza los saldos del comprobante
                $o_VTA_DocumentoDP = new VTA_DocumentoDP();
                $o_VTA_DocumentoDP->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                $o_VTA_DocumentoDP->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                $o_VTA_DocumentoDP->setIdCaja($i_IdCaja);
                $o_VTA_DocumentoDP->setIdTurno($i_IdTurno);
                $o_VTA_DocumentoDP->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                $o_VTA_DocumentoDP->setMontoPagado( $f_NvoDocuPagado );
                $o_VTA_DocumentoDP->setMontoPagadoMN( $f_NvoDocuPagadoMN );
                $o_VTA_DocumentoDP->setMontoSaldo( $f_NvoDocuSaldo );
                $o_VTA_DocumentoDP->setMontoSaldoMN( $f_NvoDocuSaldoMN );
                if( $o_VTA_DocumentoBN->getMontoTotal() == $f_NvoDocuPagado || $o_VTA_DocumentoBN->getMontoPagadoMN() == $f_NvoDocuPagadoMN )
                {
                    $o_VTA_DocumentoDP->setFechaAprobacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDP->setFechaCobranza( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDP->setCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_COBRADO );
                }
                $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );

                $o_VTA_DocumentoDP->update();
            }
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            if( myUser::getUser()->getObjectCompania()->getEnviarProveedorAutoFlag() )
            {
                if( !myUser::getUser()->getObjectCompania()->getEnviarCompDirectoSunatFlag() )
                {
                    //CASO 1 - SE ENVIA AL UN PROVEEDOR PSE
                    $s_DirArchivo = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR."vta".DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR."fael".DIRECTORY_SEPARATOR."actions".DIRECTORY_SEPARATOR."actions.class.php";
                    //ob_start();
                    //require( $s_DirArchivo );
                    //$s_Contenido = ob_get_clean();
                    $o_faelActions             = new faelActions();
                    $o_faelActions->id_request = $o_VTA_DocumentoBN->getNumeroDocumento();
                    $o_faelActions->executeProcAPI();
                    if( $o_faelActions->mensaje_error )
                    {
                        throw new Exception( $o_faelActions->mensaje_error );
                    }
                }
                else
                {
                    //CASO 2 - ENVIO DIRECTO A LA SUNAT
                    $s_DirArchivo = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR."vta".DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR."cpe".DIRECTORY_SEPARATOR."actions".DIRECTORY_SEPARATOR."ProcAPISunatAction.class.php";
                    //ob_start();
                    //require( $s_DirArchivo );
                    //$s_Contenido = ob_get_clean();
                    $o_ProcAPISunatAction             = new ProcAPISunatAction();
                    $o_ProcAPISunatAction->id_request = $o_VTA_DocumentoBN->getNumeroDocumento();
                    $o_ProcAPISunatAction->execute();
                }
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}