<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>

<script>
    ejecutarGuardar = function()
    {
        x = confirm( "Esta seguro de Generar Nota de Debito?" );
        if( x )
        {
            blockContent( 'form1' );
            blockContent( 'content_buttons' );
            var strFormSerialize = $( 'form' ).serialize();
            executeAjaxJson(
                "<?php echo buildUrl( 'pro/generarND', "" ) ?>",
                strFormSerialize,
                function( o_json )
                {
                    unBlockContent( 'form1' );
                    console.log( o_json );
                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        return false;
                    }

                    showAlertBootStrap( 'content_alert', 'alert-success', "Se creo la Nota de Debito satisfactoriamente." );

                    setTimeout(
                        function(  )
                        {
                            parent.findControl();
                            parent.closeWindow();
                        },
                        1500
                    )

                }
            );
        }
        return false;
    }

    recuperarInfoVentaSerie = function()
    {
        blockContent( 'form1' );
        blockContent( 'content_buttons' );
        executeAjaxJson
        (
            '<?php echo buildUrl( 'pro/request', '' ) ?>',
            'TipoProc=getSerieNumeroNC&IdTipoDocumento=ND&i_Id=<?=$i_Id?>',
            function( o_json )
            {
                unBlockContent( 'form1' );
                if( o_json.error )
                {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }
                if( o_json.Result )
                {
                    $( "#content_tipo_doc" ).html( "NOTA DE DEBITO: " + o_json.Serie + " - " + o_json.Numero );
                    $( "#SerieNC" ).val( o_json.Serie );
                    $( "#NumeroNC" ).val( o_json.Numero );
                }
                unBlockContent( 'content_buttons' );
            }
        );
    }
</script>

<style type="text/css">
    #example_wrapper .row
    {
        margin-right: 0;
        margin-left: 0;
    }
    table.dataTable tbody tr:hover
    {
        background-color: #DAE6FE !important;;
    }
    .table td, .table th
    {
        /*padding: 8px;*/
        /*font-size: 13px;*/
        font-size: 0.9rem;
        vertical-align: middle;
        font-family: 'Poppins', sans-serif;
        padding: .35rem;
    }
    th { white-space: nowrap; }
</style>

<form id="form1" name="form1" method="POST" onsubmit="return ejecutarGuardar();"  enctype="multipart/form-data">
    <input type="hidden" name="s_TipoProc" id="s_TipoProc" value="<?=$s_TipoProc?>">
    <input type="hidden" name="i_Id" id="i_Id" value="<?=$i_Id?>">
    <input type="hidden" name="TypeSub" id="TypeSub" value="0">
    <input type="hidden" name="DocumentoTipoSerieNumero" id="DocumentoTipoSerieNumero" value="<?=$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()?>">
    <input type="hidden" name="SerieNC" id="SerieNC" value="">
    <input type="hidden" name="NumeroNC" id="NumeroNC" value="">

    <div class="card" id="content_datos_cab">
        <h5 class="card-header card text-white bg-primary" id="content_tipo_doc">NOTA DE DEBITO </h5>
        <div class="card-body" style="padding: 10px;">

            <div class="table-responsive" id="content_form">
                <table class="table table-borderless" style="margin-bottom: 0px; ">
                    <tbody>
                    <tr>
                        <th class="text-nowrap" scope="row">Cliente:</th>
                        <td class="text-nowrap"><?=$o_VTA_DocumentoBN->getClienteNombre()?></td>
                        <th class="text-nowrap" scope="row"><?=$o_VTA_DocumentoBN->getClienteTipoDoc();?>:</th>
                        <td class="text-nowrap" > <?=$o_VTA_DocumentoBN->getClienteRUC();?> </td>
                        <th class="text-nowrap" scope="row">Vendedor</th>
                        <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getVendedor()?></td>
                    </tr>
                    <tr>
                        <th class="text-nowrap" scope="row">Facturaci&oacute;n:</th>
                        <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getAlmacenDesc()?> </td>
                        <th class="text-nowrap" scope="row">Almacen:</th>
                        <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getAlmacenDespachoDesc()?> </td>
                        <th class="text-nowrap" scope="row">Moneda:</th>
                        <td class="text-nowrap" ><?=$o_VTA_DocumentoBN->getObjectMoneda()->getDescripcion()?> </td>
                        <th class="text-nowrap" scope="row">Tipo Cambio:</th>
                        <td class="text-nowrap" ><?=GSS_TipoCambioFN::getStaticTipoCambioCobranza()?></td>
                    </tr>
                    <tr>
                        <th class="text-nowrap" scope="row">Direccion Cliente:</th>
                        <td class="text-nowrap" colspan="7" ><?=$o_VTA_DocumentoBN->getClienteDireccion()?> - <?=$o_VTA_DocumentoBN->getClienteReferencia()?></td>
                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <div class="dropdown-divider"></div>
    <div id="content_alert" style=""></div>

    <div class="card" id="content_datos_cab">
        <div class="card-body" style="padding: 10px;">

            <div class="form-row mx-0" style="">
                <div class="col-md-3 mb-1">
                    <label for="FechaDocumento" class="col-form-label">Fecha Emision:</label>
                    <input type="text" id="FechaDocumento" name="FechaDocumento" class="form-control text-center" autocomplete="off" onfocus="this.select();" value="<?=date( "Y-m-d" )?>" required>
                    <script>
                        $( "#FechaDocumento" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-1:+1", changeMonth: true, onClose: function (){ this.focus(); } } );
                    </script>
                </div>
                <div class="col-md-3 mb-1">
                    <label for="IdMotivo" class="col-form-label">Motivo:</label>
                    <select class="form-control form-control-sm custom-select my-0 mr-sm-2" name="IdMotivo" id="IdMotivo" onchange="" required>
                        <option value=""> - SELECCIONE - </option>
                        <?php foreach ( VTA_TipoDocumentoMotivoFN::selectActivoND() as $o_VTA_TipoDocumentoMotivoBN ){ ?>
                            <option value="<?=$o_VTA_TipoDocumentoMotivoBN->getIdTipoDocumentoMotivo()?>" > <?=$o_VTA_TipoDocumentoMotivoBN->getDescripcion()?> </option>
                        <?php } ?>
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label for="" class="col-form-label">Condici&oacute;n:</label>
                    <select class="custom-select" name="cboFormaPago" id="cboFormaPago"  >
                        <option value=""> - SELECCIONE - </option>
                        <?php foreach ( VTA_FormaPagoFN::selectActivos() as $o_VTA_FormaPagoBN ) { ?>
                            <option value="<?=$o_VTA_FormaPagoBN->getIdFormaPago()?>"   ><?=$o_VTA_FormaPagoBN->getDescripcionLocal()?></option>
                        <?php } ?>
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <label for="" class="col-form-label">Comprobante Ref:</label>
                    <input type="text" id="" name="" class="form-control text-center" autocomplete="off" value="<?=$o_VTA_DocumentoBN->getDocumentoTipoSerieNumero()?>" readonly>
                </div>
            </div>
        </div>
    </div>

    <div class="dropdown-divider"></div>

    <div class="card" id="content_datos_cab">
        <div class="card-body" style="padding: 10px;">

            <div class="table-responsive">
                <table class="table table-sm table-bordered">
                    <thead class="thead-light">
                    <tr>
                        <th width="25%" align="" scope="col"><b>Servicio</b></th>
                        <th width="8%"  style="text-align: center;" scope="col"><b>Cant</b></th>
                        <th width="8%"  style="text-align: center;" scope="col"><b>Precio</b></th>
                        <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>IGV</b></th>
                        <th width="8%"  style="text-align: center;" scope="col" nowrap=""><b>Total</b></th>
                    </tr>
                    </thead>
                    <tbody id="content_detail">
                    <tr>
                        <td>
                            <select class="form-control form-control-sm custom-select my-0 mr-sm-2" name="IdServicio" id="IdMotivo" onchange="" required>
                                <?php foreach ( $a_ALM_ItemMast as $o_ALM_ItemMastBN ){ ?>
                                    <option value="<?=$o_ALM_ItemMastBN->getIdItem()?>" > <?=$o_ALM_ItemMastBN->getIdItem()?> - <?=$o_ALM_ItemMastBN->getDescripcionCompleta()?> </option>
                                <?php } ?>
                            </select>
                        </td>
                        <td align="center">1</td>
                        <td align="center">
                            <input type="text" id="valor_unit" name="valor_unit" class="form-control text-center" autocomplete="off" onblur="calcularMontos( false )" onfocus="this.select();" value="" required>
                        </td>
                        <td align="center">
                            <input type="text" id="monto_igv" name="monto_igv" class="form-control text-center" autocomplete="off" onfocus="this.select();" value="" readonly>
                        </td>
                        <td align="center">
                            <input type="text" id="txt_precio" name="txt_precio" class="form-control text-center" autocomplete="off" onblur="calcularMontos( true )" onfocus="this.select();" value="" required>
                        </td>
                    </tr>
                    </tbody>
                </table>
            </div>

        </div>
    </div>

    <div class="dropdown-divider"></div>

    <div class="card" id="content_buttons">
        <div class="card-body form-row mx-0" style="padding: 10px;">

            <div class="col-md-6 mb-1">
                <button type="button" class="btn btn-danger btn-lg btn-block" onclick="parent.closeWindow();">CANCELAR</button>
            </div>
            <div class="col-md-6 mb-1">
                <button type="submit" class="btn btn-primary btn-lg btn-block" onclick="">GENERAR ND</button>
            </div>

        </div>
    </div>


</form>

<script>
    calcularMontos = function( conIGV )
    {
        var id_precio_venta_igv = "txt_precio";
        var id_precio_venta     = "valor_unit";
        var id_monto_igv        = "monto_igv";

        var ValorIGV        = <?=GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" )?>; //0.18
        var ValorIGVMasUno  = ValorIGV + 1; //1.18

        if( conIGV )
        {
            if( $( "#" + id_precio_venta_igv ).val() == "" )
            {
                return false;
            }

            var precio_venta_igv = parseFloat( $( "#" + id_precio_venta_igv ).val() );
            if( "<?=$AfectoIGV?>" == "Y" )
            {
                var precio_venta = redondear( ( precio_venta_igv / ValorIGVMasUno ), 2 );
                var monto_igv    = redondear( precio_venta_igv - precio_venta, 2 );
            }
            else
            {
                var precio_venta = precio_venta_igv;
                var monto_igv    = 0;
            }

            $( "#" + id_precio_venta ).val( precio_venta );
            $( "#" + id_monto_igv ).val( monto_igv );
        }
        else
        {
            if( $( "#" + id_precio_venta ).val() == "" )
            {
                return false;
            }

            var precio_venta = parseFloat( $( "#" + id_precio_venta ).val() );
            if( "<?=$AfectoIGV?>" == "Y" )
            {
                var precio_venta_igv = redondear( precio_venta * ValorIGVMasUno, 2 );
                var monto_igv        = redondear( precio_venta_igv - precio_venta, 2 );
            }
            else
            {
                var precio_venta_igv = precio_venta;
                var monto_igv        = 0;
            }

            $( "#" + id_precio_venta_igv ).val( precio_venta_igv );
            $( "#" + id_monto_igv ).val( monto_igv );
        }
    }
</script>

<script type="text/javascript">
    recuperarInfoVentaSerie();
</script>