<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>

<?php
/**
 * @var VTA_TipoDocumentoBN[] $a_VTA_TipoDocumento
 */

$b_Control = true;
if( $o_VTA_DocumentoBN->getIdConcat() )
{
    $b_Control = false;
}
?>

<style type="text/css">
.ui-dialog .ui-dialog-titlebar-close 
{
    position: absolute;
    right: .3em;
    top: 50%;
    width: 20px;
    margin: -10px 0 0 0;
    padding: 1px;
    height: 20px;
    background-position: -96px -128px;
    /*background-image: url("images/ui-icons_056b93_256x240.png");*/
    background-image: url("<?=Constantes::ROOT_DIR_APP?>web/css/jquery/themes/start_1.12.1/images/ui-icons_056b93_256x240.png");
}
</style>

<script type="text/javascript">
var ControlAnticipo = 0;
</script>

<script type="text/javascript">
changeIcon = function( elm, name )
{
    var elms    = $( elm ).find( "svg" );
    var elm_sel = elms.first();
    if( $( "#" + name ).is( ":visible" ) )
    {
        $( "#fndPorOrden" ).val( 0 );
        $( "#txt_orden" ).val( "<?=$s_OrdenNo?>" );
        $( elm_sel ).removeClass( "fa-angle-down" );
        $( elm_sel ).addClass( "fa-angle-right" );
        $( "#txt_orden" ).prop( "disabled", true );
        limpiarValores();

        $( "#btnGuardarFactPorOrden" ).hide();
        //$( "#btnEscanearSerie" ).hide();
        $( "#btnMostrarOrdenLineas" ).hide();
        $( "#btnGuardarFact" ).show();

        $( "#content_resumen_totales" ).collapse( 'hide' );
        $( "#content_listado_pagos" ).collapse( 'hide' );
    }
    else
    {
        $( "#fndPorOrden" ).val( 1 );
        $( elm_sel ).removeClass( "fa-angle-right" );
        $( elm_sel ).addClass( "fa-angle-down" );
        $( "#txt_orden" ).prop( "disabled", false );
        setTimeout
        (
            function()
            {
            	$( "#txt_orden" ).val( "<?=$s_OrdenNo?>" );
                $( "#txt_orden" ).focus();
                <?php if( $s_OrdenNo ){ ?>
                buscarOrdenVenta();
                $( 'html, body' ).animate( { scrollTop : 10000 }, 800 );
                <?php } ?>
            },
            500
        );
        //$( "#content_resumen_totales" ).collapse( 'show' );
        //$( "#content_listado_pagos" ).collapse( 'show' );
    }
}
</script>

<script type="text/javascript">
saveForm = function()
{
	//showAlertBootStrap( 'content_alert', 'alert-danger', "Debe de ingresar una Cotización" );
    //return false;
    ///////////////////////////////////////////////////////////////
    //NC
    if( $( "#IdTipoDocumento" ).val() == "NC" )  
    {
        if( !$( '#NaceAnulado' ).is( ":checked" ) )
        {
            alert( "Solo se permite generar Nota de Credito con un estado Anulado." );
            return false;
        }
    }
    ///////////////////////////////////////////////////////////////
    blockContent( "content_buttons" );
    var strFormSerialize = $( 'form' ).serialize();

    var TipoVenta = $( "#TipoVenta" ).val();

    if( TipoVenta != "VAL" )
    {
        executeAjaxJson
        (
            "<?php echo buildUrl( 'pro/saveAddEdit', "" ) ?>",
            strFormSerialize,
            function (o_json) {
                pr(o_json);
                unBlockContent("content_buttons");
                if (o_json.error) {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }

                if (o_json.type_sub == "1") {
                    location.href = "<?=buildUrl( 'pro/detailVta', "s_TipoProc=upd&i_Id=" )?>" + o_json.id;
                } else {
                    location.href = "<?=buildUrl( 'pro/list', "" )?>";
                }
            }
        );
    }
    else
    {
        $( "#MonedaDocumento" ).val( "LO" );
        $( "#MonedaDocumento" ).prop( 'readonly', true );
        executeAjaxJson
        (
            "<?php echo buildUrl( 'pro/saveCustomValoriz', "" ) ?>",
            strFormSerialize,
            function (o_json) {
                pr(o_json);
                unBlockContent("content_buttons");
                if (o_json.error) {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }

                $( "#id_concat" ).val( o_json.id_concat );
                configurarElmPorOrdenFacturada();
            }
        );
    }

    return false;
}
</script>

<div id="content_alert" style=""></div>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0"><?=$s_Titulo?></h4>
        </div>
    </div>
</div>

<form name="form1" id="form1" method="POST" action="" onsubmit="return saveForm();">
    <input type="hidden" name="s_TipoProc" id="s_TipoProc" value="<?=$s_TipoProc?>">
    <input type="hidden" name="TypeSub" id="TypeSub" value="1">
    <input type="hidden" name="i_Id" id="i_Id" value="<?=$i_Id?>">
    <input type="hidden" name="factura_id" id="factura_id" value="<?=$o_VTA_DocumentoBN->getIdConcat()?>">
    <input type="hidden" name="IdUbigeo" id="IdUbigeo" value="">

    <div class="card">
        
        <div class="form-row p-1 mx-0">
            <div class="col-md-6">
                <div class="card">
                    <h5 class="card-header">Documento</h5>
                    <div class="card-body" style="padding: 10px;">
                        <div class="form-group">
                            <label for="MonedaCod" class="col-form-label">Clase:</label>
                            <select class="form-control custom-select my-0 mr-sm-2" name="IdTipoDocumento" id="IdTipoDocumento" onchange="recuperarInfoVentaSerie();" required>
                                <option value="">  - SELECCIONE - </option>
                                <?php foreach ( $a_VTA_TipoDocumento as $i_Key => $o_VTA_TipoDocumentoBN ){ ?>
                                    <?php if( $o_VTA_TipoDocumentoBN->getIdTipoDocumento() == "GR" ) continue; ?>
                                <option value="<?=$o_VTA_TipoDocumentoBN->getIdTipoDocumento()?>" <?php if( $o_VTA_DocumentoBN->getIdTipoDocumento()==$o_VTA_TipoDocumentoBN->getIdTipoDocumento() ){ echo "SELECTED"; }?> > <?=$o_VTA_TipoDocumentoBN->getDescripcionLocal() ?> </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-row mx-0">
                            <input type="hidden" name="TipoDocumentoCod" id="TipoDocumentoCod" value="">
                            <div class="col-md-4 mb-1">
                                <label for="OrdenTipoId" class="col-form-label">Serie:</label>
                                <input type="text" class="form-control" name="DocumentoSerie" id="DocumentoSerie" placeholder="" readonly="">
                            </div>
                            <div class="col-md-8 mb-1">
                                <label for="OrdenTipoId" class="col-form-label">Numero:</label>
                                <input type="text" class="form-control" name="DocumentoNumero" id="DocumentoNumero" placeholder="" readonly="" onfocus="this.select();">
                            </div>
                        </div>
                    </div>

                    <h5 class="card-header"  style="border-top: 1px solid rgba(0,0,0,.125)">Datos de Cliente</h5>
                    <div class="card-body" style="padding: 10px;">
                        <div class="form-row mx-0">
                            <div class="col-md-4 mb-1">
                                <label class="col-form-label" for="ClienteTipoDoc">Tipo Doc:</label>
                                <input type="text" id="ClienteTipoDoc" name="ClienteTipoDoc" class="form-control" placeholder="" aria-label="" aria-describedby="basic-addon2" readonly="" style="text-align: center;">
                            </div>
                            <div class="col-md-8 mb-1">
                                <label class="col-form-label" for="ClienteRUC">Documento:</label>
                                <div class="input-group mb-0">
                                    <input type="hidden" name="ClienteNumero" id="ClienteNumero" value="">
                                    <input type="text" id="ClienteRUC" name="ClienteRUC" class="form-control" autocomplete="off" aria-label="" aria-describedby="basic-addon2"  style="text-align:center;" readonly
                                           onfocus="this.select();"
                                           onblur=""
                                           required
                                    >
                                    <!--<div class="input-group-append">
                                        <button class="btn btn-outline-secondary" id="btnNvoClie" type="button">Nuevo</button>
                                        <script type="text/javascript">
                                            $( "#btnNvoClie" ).click
                                            (
                                                function()
                                                {
                                                    var frameSrc = "<?=buildUrl( 'pro/addeditclie', 's_TipoProc=nvo' )?>";
                                                    $( "#exampleModalLongTitle" ).html( "Nuevo Cliente" );
                                                    $( '#iframe_id' ).attr( "src", frameSrc );
                                                    $( '#exampleModalCenter' ).modal( { show:true } );

                                                    //$( '#myIframe2' ).attr( 'src', '<?=buildUrl( 'pro/addeditclie', 's_TipoProc=nvo' )?>' );
                                                    //$( '#dialog2' ).dialog( 'open' );
                                                }
                                            );
                                            $( "#ClienteRUC" ).keypress
                                            (
                                                function( e )
                                                {
                                                    //console.log( e.which );
                                                    if( e.which == 13 )
                                                    {
                                                        buscarInfoPoNumeroDoc();
                                                    }
                                                }
                                            );
                                        </script>
                                    </div>-->
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="ClienteNombre" class="col-form-label">Nombres:</label>
                            <input type="text" class="form-control" id="ClienteNombre" placeholder="" name="ClienteNombre" value="" onblur="" readonly >
                        </div>

                        <input type="hidden" name="sDireccion" id="sDireccion" value="">
                        <input type="hidden" name="ProyectoDesc" id="ProyectoDesc" value="">
                        <input type="hidden" name="TipoVenta" id="TipoVenta" value="">
                        <input type="hidden" name="Comentario" id="Comentario" value="">

                    </div>
                </div>

            </div>

            <div class="col-md-6" id="accordion">
                <div class="card">
                    <h5 class="card-header"> &nbsp; </h5>
                    <div class="card-body" style="padding: 10px;">

                        <?php if( myUser::getUser()->getObjectCompania()->getOpeCierreCaja() ){ ?>
                        <div class="form-group">
                            <?php if( $o_VTA_DocumentoBN->b_ControlCaja ){ ?>
                                <label for="" class="col-form-label">Caja:</label>
                                <input type="hidden" name="IdCajaSelect"  value="<?=$o_VTA_DocumentoBN->IdCajaSelect?>">
                                <input type="hidden" name="IdTurnoSelect" value="<?=$o_VTA_DocumentoBN->IdTurnoSelect?>">
                                <input type="text" id="" name="" disabled="" class="form-control" placeholder="" aria-label="" aria-describedby="basic-addon2" value="<?=$o_VTA_DocumentoBN->DesCajaSelect?> - <?=$o_VTA_DocumentoBN->DescTurnoSelect?>">
                                <!--<label style="font-weight: bold;"></label>-->
                            <?php }else{ ?>
                                <label for="" class="col-form-label">Aperturar Caja:</label>
                                <button type="button" class="form-control btn btn-primary" onclick="aperturarCaja();">...</button>
                            <?php } ?>
                        </div>
                        <?php } ?>

                        <div class="form-group" id="content_cotizacion">
                            <a data-toggle="collapse" href="#collapseThree" aria-expanded="true" aria-controls="collapse1" class="text-info" onclick="changeIcon( this,'collapseThree' );" id="cotent_a_collapse" >
                                <h5 class="mb-0"> Nro Pedido <i class="fas fa-angle-right pull-right"></i></h5>
                            </a>
                            <div id="collapseThree" class="collapse input-group mb-0" data-parent="#accordion">
                                <input type="hidden" name="orden_id" id="orden_id" value="">
                                <input type="hidden" name="orden_ref" id="orden_ref" value="">
                                <input type="hidden" name="fndPorOrden" id="fndPorOrden" value="0">
                                <input type="text" class="form-control" name="txt_orden" id="txt_orden" style="text-align: center;" aria-describedby="basic-addon2" onfocus="this.select();" value="<?=$s_OrdenNo?>" autocomplete="off">
                                <div class="input-group-append">
                                    <button class="btn btn-outline-secondary" id="btn_fnd_orden" onclick="" type="button">Buscar</button>
                                    <script>
                                    $( "#btn_fnd_orden" )
                                    .click
                                    (
                                        function()
                                        {
                                            var param = "ClienteRUC=" + $( "#ClienteRUC" ).val();
                                        	var frameSrc = "<?=buildUrl( 'pro/listCotizacion', '' )?>?" + param;
                                            $( "#exampleModalLongTitle" ).html( "Buscar Cotizaci&oacute;n" );
                                            $( '#iframe_id' ).attr( "src", frameSrc );
                                            $( '#exampleModalCenter' ).modal( { show:true } );
                                        }
                                    )
                                    asignarCotizacion = function( IdCotizacion, CodCotizacion, ParaAnticipo )
                                    {
                                    	//$( "#content_button_anticipo" ).hide();
                                    	ControlAnticipo = ParaAnticipo;
                                        $( "#txt_orden" ).val( CodCotizacion );
                                        buscarOrdenVenta();
                                        ocultarModal();
                                        if( ParaAnticipo )
                                        {
                                            $( "#TipoVenta" ).val( "ANT" );
                                            //$( "#content_button_anticipo" ).show();

                                            $( "#txt_subtotal" ).prop( 'readonly', false );
                                            $( "#txt_impuesto" ).prop( 'readonly', false );
                                            $( "#txt_total" ).prop( 'readonly', false );
                                        }
                                        else
                                        {
                                        	$( "#txt_subtotal" ).prop( 'readonly', true );
                                            $( "#txt_impuesto" ).prop( 'readonly', true );
                                            $( "#txt_total" ).prop( 'readonly', true );
                                        }
                                    }
                                    </script>
                                </div>
                            </div>
                        </div>
                    </div>

                    <h5 class="card-header"  style="border-top: 1px solid rgba(0,0,0,.125)">Datos de Generales</h5>
                    <div class="card-body" style="padding: 10px;">

                        <div class="form-group">
                            <label for="FechaDocumento" class="col-form-label">Fecha:</label>
                            <input type="text" style="text-align: center;" class="form-control" id="FechaDocumento" placeholder="" name="FechaDocumento" value="<?=date( "Y-m-d" )?>" readonly="" >
                            <script type="text/javascript">
                                //$( "#FechaDocumento" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-1:+1", changeMonth: true, onClose: function ( s_date ){ this.focus(); $( "#FechaDocumento" ).val( s_date ); } } );
                                $( "#FechaDocumento" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-1:+1", changeMonth: true, onClose: function ( s_date ){ this.focus(); $( "#FechaVencimiento" ).val( s_date ); } } );
                            </script>
                        </div>

                        <input type="hidden" name="FechaVencimiento" id="FechaVencimiento" value="<?=date( "Y-m-d" )?>">
                        <input type="hidden" name="FormaPago" id="FormaPago" value="">
                        <input type="hidden" name="MonedaDocumento" value="LO">
                        <input type="hidden" name="MonedaCambioValor" value="1">

                        <div class="dropdown-divider"></div>

                        <div class="form-group">
                            <label for="IdVendedor" class="col-form-label">Vendedor:</label>
                            <select class="form-control custom-select my-0 mr-sm-2" name="IdVendedor" id="IdVendedor" onchange="" required>
                                <option value=""> - Seleccione - </option>
                                <?php foreach ( VTA_VendedorFN::select_all() as $a_Vendedor ) { ?>
                                    <?php
                                    $s_CodVendedorSel = myUser::getUser()->getUserId();
                                    ?>
                                    <option value="<?=$a_Vendedor['IdUsuario']?>"
                                        <?php if( $s_CodVendedorSel == $a_Vendedor['IdUsuario'] ){ echo "SELECTED"; } ?>
                                        >
                                        <?=$a_Vendedor['NombreCompleto']?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>

                    </div>
                </div>
            </div>

        </div>
    </div>

    <?php if( $s_MensajeAdv ){ ?>
    <div class="alert alert-warning fade show mt-2 mb-2" role="alert">
        <?=$s_MensajeAdv?>
    </div>
    <?php } ?>

    <div class="card collapse"  id="content_resumen_totales">
        <div class="p-1 mx-0">
            <div class="card mt-2">
                <h5 class="card-header">Resumen de Totales</h5>
                <div class="card-body" style="padding: 10px;">
                    <div class="form-row mx-0">
                        <input type="hidden" name="txt_anticipo" id="txt_anticipo" value="">
                        <input type="hidden" name="txt_descuento" id="txt_descuento" value="">
                        <div class="col-md-12">
                            <div class="form-row">
                                <div class="col-md-4 mb-1" <?php if( !myUser::getUser()->getObjectCompania()->esAfectoIGV() ){ ?> style="display: none;" <?php } ?>>
                                    <label for="">Sub-Total</label>
                                    <input type="text" class="form-control" id="txt_subtotal" name="txt_subtotal" value="" readonly="readonly" onblur="calcularMontos( false )" style="text-align: center;" onfocus="this.select()" autocomplete="off">
                                </div>
                                <div class="col-md-4 mb-1" <?php if( !myUser::getUser()->getObjectCompania()->esAfectoIGV() ){ ?> style="display: none;" <?php } ?>>
                                    <label for="">IGV</label>
                                    <input type="text" class="form-control" id="txt_impuesto" name="txt_impuesto" value="" readonly="readonly" style="text-align: center;" onfocus="this.select()" autocomplete="off">
                                </div>
                                <div class="col-md-4 mb-1">
                                    <label for="">Total a Pagar</label>
                                    <input type="text" class="form-control" id="txt_total" name="txt_total" value="" readonly="readonly" onblur="calcularMontos( true )" style="text-align: center;" onfocus="this.select()" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        calcularMontos = function( conIGV )
        {
            if( $( "#txt_total" ).is('[readonly]') || $( "#txt_subtotal" ).is('[readonly]')  )
            {
                return false;
            }

            id_precio_venta_igv = "txt_total";
            id_precio_venta     = "txt_subtotal";
            id_monto_igv        = "txt_impuesto";

            if( conIGV )
            {
                if( $( "#" + id_precio_venta_igv ).val() == "" )
                {
                    return false;
                }

                var precio_venta_igv = parseFloat( $( "#" + id_precio_venta_igv ).val() );
                precio_venta = redondear( ( precio_venta_igv / 1.18 ), 2 );
                monto_igv = redondear( precio_venta_igv - precio_venta, 2 );

                $( "#" + id_precio_venta ).val( precio_venta );
                $( "#" + id_monto_igv ).val( monto_igv );
            }
            else
            {
                if( $( "#" + id_precio_venta ).val() == "" )
                {
                    return false;
                }

                var precio_venta = parseFloat( $( "#" + id_precio_venta ).val() );
                monto_igv = redondear( ( precio_venta * 0.18 ), 2 );
                precio_venta_igv = redondear( precio_venta + monto_igv, 2 );

                $( "#" + id_precio_venta_igv ).val( precio_venta_igv );
                $( "#" + id_monto_igv ).val( monto_igv );
            }
        }
        calcularDescuento = function()
        {
            if( $( "#txt_descuento" ).is('[readonly]') )
            {
                return false;
            }

            id_txt_descuento    = "txt_descuento";
            id_precio_venta_igv = "txt_total";
            id_precio_venta     = "txt_subtotal";
            id_monto_igv        = "txt_impuesto";

            if( $( "#txt_descuento" ).val() != "" )
            {
                var TotalDescuento = parseFloat( $( "#txt_descuento" ).val() );
                var precio_venta = parseFloat( $( "#" + id_precio_venta ).val() );
                precio_venta = precio_venta - TotalDescuento;
                monto_igv = redondear( ( precio_venta * 0.18 ), 2 );
                precio_venta_igv = redondear( precio_venta + monto_igv, 2 );

                $( "#" + id_precio_venta ).val( precio_venta );
                $( "#" + id_monto_igv ).val( monto_igv );
                $( "#" + id_precio_venta_igv ).val( precio_venta_igv );
            }
        }
    </script>

    <div class="card collapse"  id="content_resumen_detraccion">
        <input type="hidden" name="ControlDetraccion" id="ControlDetraccion" value="0">
        <div class="p-1 mx-0">
            <div class="card mt-2">
                <h5 class="card-header">Resumen Detracci&oacute;n</h5>
                <div class="card-body" style="padding: 10px;">
                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="">Tipo de Detracci&oacute;n</label>
                            <select class="form-control custom-select my-0 mr-sm-2" name="DetracconTipoId" id="DetracconTipoId" onchange="detraccionAsignarPor();" > <!--required-->
                                <option value=""> - Seleccione - </option>
                                <?php foreach ( GSS_DetraccionFN::selectActivos() as $o_GSS_DetraccionBN ){ ?>
                                    <option value="<?=$o_GSS_DetraccionBN->getIdDetraccion()?>" porcentaje="<?=$o_GSS_DetraccionBN->getPorcentaje()?>" >
                                        <?=$o_GSS_DetraccionBN->getCodigoSunat()?> - <?=strtoupper( $o_GSS_DetraccionBN->getDescripcion() )?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="">Porcentaje Detracci&oacute;n</label>
                            <!--<input type="text" class="form-control" id="DetracconPorcentaje" name="DetracconPorcentaje" value=""  style="text-align: center;" onfocus="this.select()" onblur="calcularTotalDetraccion();" autocomplete="off">-->
                            <div class="input-group">
                                <input type="text" class="form-control text-center" id="DetracconPorcentaje" name="DetracconPorcentaje" value="" onfocus="this.select()" onblur="calcularTotalDetraccion();" autocomplete="off">
                                <div class="input-group-prepend">
                                    <span class="input-group-text" id="">%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-row mx-0">
                        <div class="form-group col-md-4">
                            <label for="DetracconMedPagoId">Medio de Pago</label>
                            <select class="custom-select my-0 mr-sm-2" name="DetracconMedPagoId" id="DetracconMedPagoId" onchange="" > <!--required-->
                                <option value=""> - Seleccione - </option>
                                <?php foreach( VTA_DocumentoBN::getArrayDetraccionMediosPago() as $i_IdMedPagoDet => $a_DataMedioPagoDet ){ ?>
                                <option value="<?=$i_IdMedPagoDet?>"> <?=$a_DataMedioPagoDet['CodigoSunat']?> - <?=$a_DataMedioPagoDet['Descripcion']?> </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label for="DetracconTotal">Total Detracci&oacute;n</label>
                            <input type="text" class="form-control" id="DetracconTotal" name="DetracconTotal" value="" style="text-align: center;" onfocus="this.select()" readonly autocomplete="off">
                        </div>
                        <div class="col-md-4">
                            <label for="NetoTotalPagar">Neto a Pagar</label>
                            <input type="text" class="form-control" id="NetoTotalPagar" name="NetoTotalPagar" value="" readonly="readonly" onblur="calcularMontos( true )" style="text-align: center;" onfocus="this.select()" autocomplete="off">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        detraccionAsignarPor = function()
        {
            var Porcentaje = floatval( $( "#DetracconTipoId" ).find( 'option:selected' ).attr( "porcentaje" ) );
            $( "#DetracconPorcentaje" ).val( Porcentaje );

            calcularTotalDetraccion();
        }
        redondearUp = function( Num )
        {
            var Diferencia = Num - parseInt( Num );
            if( Diferencia <= 0.5 )
            {
                return Math.floor( Num );
            }
            else
            {
                return Math.ceil( Num );
            }
        }
        calcularTotalDetraccion = function()
        {
            if( $( "#DetracconPorcentaje" ).val().trim() != "" )
            {
                var Porcentaje = ( floatval( $( "#DetracconPorcentaje" ).val() ) / 100 );
                var MontoTotal = floatval( $( "#txt_total" ).val() );
                var DetracconTotal = redondearUp( MontoTotal * Porcentaje );
                pr( DetracconTotal );
                $( "#DetracconTotal" ).val( DetracconTotal );
                $( "#NetoTotalPagar" ).val( redondear( MontoTotal - DetracconTotal, 2 ) );
            }
            else
            {
                $( "#DetracconPorcentaje" ).val( "" )
            }

        }
    </script>

    <div class="card collapse"  id="content_resumen_retencion">
        <div class="p-1 mx-0">
            <div class="card mt-2">
                <h5 class="card-header">Resumen Retenci&oacute;n</h5>
                <div class="card-body" style="padding: 10px;">
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label for="RetencionTipoId">Tipo de Retenci&oacute;n:</label>
                            <select class="form-control custom-select my-0 mr-sm-2" name="RetencionTipoId" id="RetencionTipoId" onchange="retencionAsignarPor();" > <!--required-->
                                <option value=""> - Seleccione - </option>
                                <?php foreach ( MST_PersonaMastBN::getArrayRetenciones() as $IdRetencion => $a_DataRetencion ){ ?>
                                    <option value="<?=$IdRetencion?>" porcentaje="<?=$a_DataRetencion['Tasa']?>" >
                                        <?=$a_DataRetencion['CodigoSunat']?> - <?=strtoupper( $a_DataRetencion['Descripcion'] )?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="RetencionBaseImponible">Base Imponible:</label>
                            <input type="text" class="form-control" id="RetencionBaseImponible" name="RetencionBaseImponible" value=""  style="text-align: center;" readonly autocomplete="off">
                        </div>
                        <div class="form-group col-md-4">
                            <label for="RetencionTotal">Retenci&oacute;n Total:</label>
                            <input type="text" class="form-control" id="RetencionTotal" name="RetencionTotal" value=""  style="text-align: center;" readonly autocomplete="off">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        retencionAsignarPor = function()
        {
            if( $( "#RetencionTipoId" ).val().trim() != "" )
            {
                var Porcentaje = floatval( $( "#RetencionTipoId" ).find( 'option:selected' ).attr( "porcentaje" ) ) / 100;
                var MontoTotal = floatval( $( "#txt_total" ).val() );

                $( "#RetencionBaseImponible" ).val( $( "#txt_total" ).val() );
                $( "#RetencionTotal" ).val( redondear( MontoTotal * Porcentaje, 2 ) );
            }
            else
            {
                $( "#RetencionBaseImponible" ).val( "" );
                $( "#RetencionTotal" ).val( "" );
            }
        }
    </script>
</form>

<div class="card collapse" id="content_listado_pagos">
    <div class="p-1 mx-0">
        <div class="card mt-2">
            <h5 class="card-header">Listado de Documentos de Pago</h5>
            <div class="card-body" style="padding: 10px;" id="content_data_list_pagos">
                <!--
                <div class="form-row">
                    <div class="form-group col-md-4">
                        <label for="">Sub-Total:</label>
                        <input type="text" class="form-control" id="" disabled="" value="50.55" style="text-align: center;">
                    </div>
                    <div class="form-group col-md-4">
                        <label for="">IGV</label>
                        <input type="text" class="form-control" id="" disabled="" value="50.55" style="text-align: center;">
                    </div>
                    <div class="form-group col-md-4">
                        <label for="">Total</label>
                        <input type="text" class="form-control" id="" disabled="" value="50.55" style="text-align: center;">
                    </div>
                </div>
                -->
            </div>
        </div>
    </div>
</div>

<div class="card" id="content_alert_success" style="display: none;">
    <div class="p-1 mx-0">
        <div class="alert alert-success" role="alert">
            Se genero la Factura Satisfactoriamente!
        </div>
    </div>
</div>

<div class="card mt-2" id="content_buttons">
    <div class="form-row mx-0">
        <div class="col-md-6 mb-1">
            <button type="button" class="btn btn-secondary btn-lg btn-block" id="btnCancelar" onclick="location.href='<?php echo buildUrl( 'pro/list' ) ?>'">CANCELAR</button>
        </div>
        <div class="col-md-6 mb-1">
            <button type="button" class="btn btn-primary btn-lg btn-block" id="btnGuardarFact" onclick="$( '#form1' ).submit(); ">GUARDAR Y SIGUIENTE</button>
            <button type="button" class="btn btn-primary btn-lg btn-block" id="btnGuardarFactPorOrden" style="" onclick="guardarFacturaPorOrden();">GENERAR COMPROBANTE</button>
            <button type="button" class="btn btn-primary btn-lg btn-block" id="btnImprimirFact" onclick="verPDFOrdenVenta();" style="display:none;">VER PDF</button>
        </div>
    </div>
    <div class="form-row mx-0">
        <div class="col-md-6 mb-1">
            <!--<button type="button" class="btn btn-primary btn-lg btn-block" id="btnEscanearSerie" onclick="escanearSeriesPorOrden();">ESCANEAR SERIES</button>-->
            <!--<button type="button" class="btn btn-primary btn-lg btn-block" id="btnCobrarDocumento" onclick="cobrarDocumento();" style="display:none;">IR A COBRAR</button>-->
        </div>
        <div class="col-md-6 mb-1">
            <button type="button" class="btn btn-primary btn-lg btn-block" id="btnMostrarOrdenLineas" onclick="mostrarLineas();">MOSTRAR LINEAS</button>
            <input type="hidden" id="id_concat" value="">
            <!--<button type="button" class="btn btn-primary btn-lg btn-block" id="btnMostrarDocumentoLineas" style="margin-top: 0;" onclick="mostrarDocumentoLineas();">VER DETALLES</button>-->
        </div>
    </div>
</div>

<script type="text/javascript">
var IdComprobante = 0;
cobrarDocumento = function()
{
    if( IdComprobante )
    {
        location.href = "<?php echo buildUrlComplet( 'tsr.php/caja/addedit', 's_TipoProc=nvo&IdComprobante=' ) ?>" + IdComprobante;
    }
    else
    {
        showAlertBootStrap( 'content_alert', 'alert-danger', "No se encontro el Id del Comprobante." );
    }
}

verPDFOrdenVenta = function()
{
	var id_concat = $( "#id_concat" ).val();
    window.open('<?=buildUrl( 'pro/printPDF' )?>i_Id/' + id_concat, '_blank', '');
}
</script>

<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<style type="text/css">
.modal
{
 padding: 0 !important;
}
.modal-dialog {
  max-width: 95% !important;
  height: 90%;
/*  padding: 0;
  margin: 0;*/
}

.modal-content {
  /*border-radius: 0 !important;*/
  height: 90%;
}
</style>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<!-- Modal - NUEVO CLIENTE -->
<div class="modal hide fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Nuevo Cliente</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id" src="" style="" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
asignarValores = function( idpersona )
{
    $( "#ClienteNumero" ).val( idpersona );
    buscarInfoCliente();
    ocultarModal();
}
ocultarModal = function()
{
    $( '#exampleModalCenter' ).modal( 'hide' );
}
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<!--APERTURA DE CAJA-->
<div class="modal hide fade" id="exampleModalCenter2" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle2" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle2">Aperturar Caja</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id2" src="" style="" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
aperturarCaja = function()
{
    $( '#iframe_id2' ).attr( "src", "<?=buildUrlComplet( 'tsr.php/caja/aperturarCaja' )?>" );
    $( '#exampleModalCenter2' ).modal( { show:true } );
}
recargarPagina = function()
{
    location.reload();
}
cerrarPopupBootstrap = function()
{
    $( '#exampleModalCenter2' ).modal( 'hide' );
}
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<!-- Modal - MOSTRAR LINEA DE LA ORDEN -->
<div class="modal hide fade" id="exampleModalCenter3" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle3" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle3">Detalles</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id3" src="" style="" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <!--<div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary">Save changes</button>
            </div>-->
        </div>
    </div>
</div>
<script type="text/javascript">
mostrarLineas = function()
{
    var id_orden = $( "#orden_id" ).val();
    if( id_orden )
    {
    	$( "#exampleModalLongTitle3" ).html( "Cotizaci&oacute;n Detalle" );
        $( '#iframe_id3' ).attr( "src", '<?=buildUrl( 'cot/detailVta', "readonly=1" )?>/i_Id/' + id_orden );
        $( '#exampleModalCenter3' ).modal( { show:true } );
    }
}

escanearSeriesPorOrden = function()
{
    var id_orden = $( "#orden_id" ).val();
    var no_orden = $( "#txt_orden" ).val();
    if( id_orden && no_orden )
    {
        $( '#iframe_id3' ).attr( "src", '<?=buildUrl( 'pro/asociarSerie' )?>orden_id/' + id_orden + '/orden_no/' + no_orden );
        $( '#exampleModalCenter3' ).modal( { show:true } );
    }
}

//este boton deberia de mostrar los detalles de la factura emitidA
mostrarDocumentoLineas = function()
{
    var id_concat = $( "#id_concat" ).val();
    if( id_concat )
    {
        $( '#iframe_id3' ).attr( "src", '<?=buildUrl( 'pro/detailVta', "s_TipoProc=shw" )?>/i_Id/' + id_concat );
        $( '#exampleModalCenter3' ).modal( { show:true } );
    }
}
cerrarPopupDetalles = function()
{
    $( '#exampleModalCenter3' ).modal( 'hide' );
}
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<script>
$( "#ClienteRUC" ).autocomplete
(
    {
        source: function(request, response) 
        {
            $.getJSON
            (
                "<?=buildUrl( 'recephabit/requestUbicacion' )?>",
                { term:request.term, tipo_proc:'AutocompleteDoc', tipo_doc: $( '#TipoDocCliente' ).val() }, 
                response
            );
        },
        minLength: 2,
        select: function( event, ui ) 
        {
            console.log( ui );
            $( "#ClienteNumero" ).val( ui.item.id );
            buscarInfoCliente();
            
        }
    }
);
$( "#ClienteNombre" ).autocomplete
(
    {
        source: "<?=buildUrl( 'pro/request', "TipoProc=Autocomplete" )?>",
        minLength: 2,
        select: function( event, ui ) 
        {
            console.log( ui.item.id );
            $( "#ClienteNumero" ).val( ui.item.id );
            buscarInfoCliente();
        }
    }
);
buscarInfoPoNumeroDoc = function()
{
    blockContent( 'content_buttons' );
    var TipoDocuCliente  = $( "#TipoDocCliente" ).val();
    var NumDocuCliente   = $( "#ClienteRUC" ).val();
    var strFormSerialize = "tipo_proc=getClienteInfoPoDocNum&NumDocuCliente=" + NumDocuCliente + "&TipoDocuCliente=" + TipoDocuCliente;
    executeAjaxJson
    ( 
        "<?php echo buildUrl( 'recephabit/requestUbicacion', "" ) ?>", 
        strFormSerialize,
        function( o_json )
        {
            unBlockContent( 'content_buttons' );
            if( o_json.error )
            {
                showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                return false;
            }
            console.log( o_json );
            $( "#ClienteNumero" ).val( o_json.IdPersona );
            buscarInfoCliente();
        }
    );
}
limpiarValores = function()
{
    //LIMPIAR
    $( "#ClienteNombre" ).val( "" );
    $( "#ClienteRUC" ).val( "" );
    $( "#sDireccion" ).val( "" );
    //$( "#sDepartamento" ).val( "" );
    //$( "#sProvincia" ).val( "" );
    //$( "#sDistrito" ).val( "" );
    //$( "#sPais" ).val( "PERU" );
    $( "#ClienteTipoDoc" ).val( "" );
}
buscarInfoCliente = function()
{
    limpiarValores();
    /////////
    mostrarCargaImg();
    var IdPersona = $( "#ClienteNumero" ).val();
    var IdTipoDocumento = $( "#IdTipoDocumento" ).val();
    if( IdTipoDocumento == "" )
    {
        ocultarCargaImg();
        showAlertBootStrap( 'content_alert', 'alert-danger', "Por favor seleccione el Tipo de Comprobante." );
        return false;
    }
    var strFormSerialize = "TipoProc=getClienteInfo&IdPersona=" + IdPersona + "&IdTipoDocumento=" + IdTipoDocumento;
    executeAjaxJson
    ( 
        "<?php echo buildUrl( 'pro/request', "" ) ?>", 
        strFormSerialize,
        function( o_json )
        {
            console.log( o_json );
            ocultarCargaImg();
            if( o_json.error )
            {
                $( '#IdTipoDocumento' ).val( '' );
                showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                return false;
            }
            
            //validaciones por clase de documento y tipo de documento del cliente - 2020-08-07
            if( o_json.TipoDocumento == "RUC" ) //cliente juridico
            {
                if( IdTipoDocumento != "FC" ) //solo se permite asociar el tipo factura
                {
                    $( '#IdTipoDocumento' ).val( '' );
                    showAlertBootStrap( 'content_alert', 'alert-danger', "Actualmente el Cliente seleccionado es de tipo Juridico, debe de seleccionar la clase Factura Electronica." );
                    return false;
                    /*if( $( "#TipoVenta" ).val() != "DOC" )
                    {
                        if( $("#IdTipoDocumento option[value='FC']").length > 0 )
                        {
                            $( "#IdTipoDocumento" ).val( "FC" );
                            $( "#IdTipoDocumento" ).trigger( "change" );
                        }
                    }*/
                }
            }
            
            $( "#ClienteNombre" ).val( o_json.Nombre );
            $( "#ClienteRUC" ).val( o_json.Documento );
            $( "#ClienteTipoDoc" ).val( o_json.TipoDocumento );
            $( "#sDireccion" ).val( o_json.Direccion );
            //$( "#sDepartamento" ).val( o_json.DepartamentoDesc );
            //$( "#sProvincia" ).val( o_json.ProvinciaDesc );
            //$( "#sDistrito" ).val( o_json.DistritoDesc );
            $( "#IdUbigeo" ).val( o_json.IdUbigeo );
            //$( "#cboCanal" ).val( o_json.CanalCliente );
            //$( "#sPais" ).val( "PERU" );
            //$( "#IdVendedor" ).val( o_json.UsuarioVendedor ); //se quito por el hotel 2020-01-22
            $( "#IdVendedor" ).val( "<?=myUser::getUser()->getUserId()?>" );
        } 
    );
}
</script>

<script>
var b_ControlBuscarSerie = true;
recuperarInfoVentaSerie = function()
{
    if( b_ControlBuscarSerie )
    {
    	<?php if( !$s_OrdenNo ){ ?>
        limpiarValores();
        regresarValoresPorDefault();
        <?php } ?>

        var value = $( "#IdTipoDocumento" ).val();
        executeAjaxJson
        ( 
            '<?php echo buildUrl( 'pro/request' ) ?>', 
            'TipoProc=getSerieNumero&IdTipoDocumento=' + value, 
            function( o_json )
            {
                console.log( o_json );
                if( o_json.error )
                {
                    alert( o_json.mensaje_error );
                    location.href='<?php echo buildUrl( 'pro/list' ) ?>';
                    return false;
                }
                if( o_json.Result )
                {
                    $( "#DocumentoSerie" ).val( o_json.Serie );
                    $( "#DocumentoNumero" ).val( o_json.Numero );
                    $( "#TipoDocumentoCod" ).val( o_json.TipoDocumentoCod );
                    //$( "#txt_orden" ).focus();
                    if( o_json.TipoDocumentoCod == "BOL" || o_json.TipoDocumentoCod == "FAC" )
                    {
                        $( "#DocumentoSerie" ).prop( 'readonly', false );
                        $( "#DocumentoNumero" ).prop( 'readonly', false );
                        $( "#DocumentoNumero" ).focus();
                    }
                    else
                    {
                        $( "#DocumentoSerie" ).prop( 'readonly', true );
                        $( "#DocumentoNumero" ).prop( 'readonly', false );
                    }
                    buscarOrdenVenta();
                }
            }
        );
    }        
}
regresarValoresPorDefault = function()
{
    $( "#orden_id" ).val( "" );
    $( "#orden_ref" ).val( "" );
    $( "#txt_orden" ).val( "" );

    $( "#TipoVenta" ).val( "" );
    //activarProcedimientos( $( "#TipoVenta" )[0] );

    $( "#btnGuardarFact" ).show();
    $( "#btnGuardarFactPorOrden" ).hide();
    //$( "#btnEscanearSerie" ).hide();
    $( "#btnMostrarOrdenLineas" ).hide();
    //$( "#btnMostrarDocumentoLineas" ).hide();
}

buscarOrdenVenta = function()
{
    var orden = trim( $( "#txt_orden" ).val() );

    var IdTipoDocumento = $( "#IdTipoDocumento" ).val();

    if( IdTipoDocumento == "" )
    {
        showAlertBootStrap( 'content_alert', 'alert-danger', "Debe de Seleccionar el Tipo de Comprobante primero." );
        return false;
    }
    
    if( orden == "" )
    {
        showAlertBootStrap( 'content_alert', 'alert-danger', "Ingrese numero de Orden." );
        return false;
    }
    
    blockContent( 'form1' );
    var param = "orden=" + orden;
    param += "&anticipo=" + ControlAnticipo;
    executeAjaxJson
    ( 
        "<?php echo buildUrl( 'pro/buscarOrdenVenta', "" ) ?>", 
        param,
        function( o_json )
        {
            unBlockContent( 'form1' );
            if( o_json.error )
            {
                limpiarValores();
                showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );

                $( "#btnGuardarFact" ).show();

                regresarValoresPorDefault();

                $( "#content_resumen_totales" ).collapse( 'hide' );
                $( "#content_listado_pagos" ).collapse( 'hide' );
                
                return false;
            }

            if( ControlAnticipo )
            {
                $( "#TipoVenta" ).val( "ANT" );
            }
            else
            {
            	$( "#TipoVenta" ).val( o_json.FactRegla );
            }

            //validaciones por clase de documento y tipo de documento del cliente - 2020-08-07
            if( o_json.ClienteDocCod == "RUC" ) //cliente juridico
            {
                if( IdTipoDocumento != "FC" ) //solo se permite asociar el tipo factura
                {
                    showAlertBootStrap( 'content_alert', 'alert-danger', "Actualmente el Cliente seleccionado es de tipo Juridico, debe de seleccionar la clase Factura Electronica." );
                    $( "#IdTipoDocumento" ).val( '' );
                    return false;
                    /*if( $("#IdTipoDocumento option[value='FC']").length > 0 )
                    {
                        $( "#IdTipoDocumento" ).val( "FC" );
                    }
                    $( "#IdTipoDocumento" ).trigger( "change" );*/
                }
            }
            else
            {
                /*if( o_json.ReferenciaTipoDocId )
                {
                    //o_json.ReferenciaTipoDocId = "BV";
                    $( "#IdTipoDocumento" ).val( o_json.ReferenciaTipoDocId );
                }
                $( "#IdTipoDocumento" ).trigger( "change" );*/
            }

            //info del proyecto
            $( "#ProyectoDesc" ).val( o_json.ProyectoDesc );

            //aqui es para recuperar la info del cliente
            $( "#ClienteNumero" ).val( o_json.ClienteId );
            buscarInfoCliente();

            //aqui se guarda el id orden, el nro de orden de referencia
            $( "#orden_id" ).val( trim( o_json.OrdenId ) );
            $( "#orden_ref" ).val( trim( orden ) );
            $( "#txt_orden" ).val( orden );

            //aqui se cambia el boton para guardar la factura y asi usar el metodo para este caso
            $( "#btnGuardarFact" ).hide();
            $( "#btnGuardarFactPorOrden" ).show();

            //se setea los varos en los campor correspondientes
            //$( "#Comentario" ).val( o_json.OrdenObs );
            setTimeout
            (
                function()
                {
                    $( "#IdVendedor" ).val( o_json.VendedorOrden );
                },
                800
            );

            $( "#MonedaDocumento" ).val( o_json.MonedaCod );

            if( !ControlAnticipo )
            {            
                /*$( "#txt_anticipo" ).val( o_json.SiglaMoneda + " " + number_format( o_json.MontoAnticipo, 2 ) );
                $( "#txt_descuento" ).val( o_json.SiglaMoneda + " " + number_format( o_json.OrdenDscto, 2 ) );
                $( "#txt_subtotal" ).val( o_json.SiglaMoneda + " " + number_format( o_json.OrdenBaseImponible, 2 ) );
                $( "#txt_impuesto" ).val( o_json.SiglaMoneda + " " + number_format( o_json.OrdenImpuestoConDscto, 2 ) );
                $( "#txt_total" ).val( o_json.SiglaMoneda + " " + number_format( o_json.OrdenTotalaPagar, 2 ) );*/
                $( "#txt_anticipo" ).val( redondear( o_json.MontoAnticipo, 2 ) );
                $( "#txt_descuento" ).val( redondear( floatval( o_json.OrdenDscto ) + floatval( o_json.OrdenDsctoLinea ), 2 ) );
                $( "#txt_subtotal" ).val( redondear( o_json.OrdenBaseImponible, 2 ) );
                $( "#txt_impuesto" ).val( redondear( o_json.OrdenImpuestoConDscto, 2 ) );
                $( "#txt_total" ).val( redondear( o_json.OrdenTotalaPagar, 2 ) );
            }
            else
            {
                $( "#txt_anticipo" ).val( "" );
                $( "#txt_descuento" ).val( "" );
                $( "#txt_subtotal" ).val( "" );
                $( "#txt_impuesto" ).val( "" );
                $( "#txt_total" ).val( "" );
            }
            
            //ahora se muestra el resumen de totales
            $( "#content_resumen_totales" ).collapse( 'show' );

            //$( "#btnEscanearSerie" ).hide();
            $( "#btnMostrarOrdenLineas" ).hide();

            //se implementa la retencion 2021-10-10
            if( o_json.EsAgenteRetenedor )
            {
                $( "#content_resumen_retencion" ).collapse( 'show' );
            }

            if( o_json.OrdenEstado == "F" )
            {
                showAlertBootStrap( 'content_alert', 'alert-danger', "La Orden se encuentra Facturado." );
                configurarElmPorOrdenFacturada();
                return false;
            }

            //se mustra el boton de de ver lineas
            $( "#btnMostrarOrdenLineas" ).show();

            /*if( o_json.escanear_serie )
            {
                //entonces se muestra el boton para escanear series
                //$( "#btnEscanearSerie" ).show();

                //ahora nos aseguramos que tenga cabera en la serie ----------> DE TODAS MANERAS SE TIENE QUE EJECUTAR
                blockContent( 'content_buttons' );
                executeAjaxJson
                ( 
                    "<?php echo buildUrl( 'pro/request', 'TipoProc=validar_serie' ) ?>", 
                    "id_orden=" + o_json.OrdenId,
                    function( o_tmp_json )
                    {
                        unBlockContent( 'content_buttons' );
                        if( o_tmp_json.error )
                        {
                            showAlertBootStrap( 'content_alert', 'alert-danger', o_tmp_json.mensaje_error );
                            return false;
                        }
                    } 
                );
            }*/

            <?php if( !myUser::getUser()->getObjectCompania()->getUsarCreditoConCuotas() ){ ?>
            //AHORA ACTUALIZAMOS LA FECHA DE VENCIMIENTO
            if( o_json.FormaPagoCod == "CRE" )
            {
                dias = o_json.FormaPagoDias;
                dia = parseInt('<?php echo date( 'j' )?>') + parseInt(dias);
                mes = parseInt('<?php echo date( 'n' )?>') - 1;
                anio = parseInt('<?php echo date( 'Y' )?>');

                var fechaCalculada = new Date(anio, mes, dia);

                diaS = String(fechaCalculada.getDate());
                mesS = String(fechaCalculada.getMonth() + 1);
                anioS = String(fechaCalculada.getFullYear());

                dia = str_pad(diaS, 2, '0', 'STR_PAD_LEFT');
                mes = str_pad(mesS, 2, '0', 'STR_PAD_LEFT');
                anio = str_pad(anioS, 2, '0', 'STR_PAD_LEFT');

                $('#FechaVencimiento').val(anio + "-" + mes + "-" + dia);
            }
            //FORMA DE PAGO DESCRIPCION
            $( "#FormaPago" ).val( o_json.FormaPagoDesc ); //de la tabla VTA_Orden
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            <?php }else{ ?>
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $( "#FormaPago" ).val( "008" );
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////
            <?php } ?>

            //AHORA SE RECUPERA LOS METODOS DE PAGOS
            blockContent( 'content_buttons' );

            var a_Params = [];
            a_Params.push( "ord_id=" + o_json.OrdenId );
            a_Params.push( "ord_num=" + o_json.OrdenNum );
            executeAjaxUpdater
            ( 
                "content_data_list_pagos", 
                "<?php echo buildUrl( 'cot/listFcoDetail' ) ?>", 
                a_Params.join( "&" ), 
                function( response )
                {
                    //se comenta por el cliente semaqui | 2021-05-18
                    //$( "#content_listado_pagos" ).collapse( 'show' );
                } 
            );

            unBlockContent( 'content_buttons' );
        } 
    );
}

guardarFacturaPorOrden = function()
{
    ///////////////////////////////////////////////////////////////
    //NC
    if( $( "#IdTipoDocumento" ).val() == "NC" )  
    {
        if( !$( '#NaceAnulado' ).is( ":checked" ) )
        {
            alert( "Solo se permite generar Nota de Credito con un estado Anulado." );
            return false;
        }
    }
    ///////////////////////////////////////////////////////////////

    x = confirm( "Esta Seguro de realizar la Facturacion?" );
    if( x )
    {
        blockContent( 'form1' );
        blockContent( 'content_buttons' );
        var strFormSerialize = $( 'form' ).serialize();
        executeAjaxJson
        ( 
            "<?php echo buildUrl( 'pro/saveBillingByOrder' ) ?>", 
            strFormSerialize,
            function( o_json )
            {
                unBlockContent( 'form1' );
                unBlockContent( 'content_buttons' );

                if( o_json.error )
                {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }

                //$( "#btnMostrarOrdenLineas" ).hide();
                //$( "#btnMostrarDocumentoLineas" ).show();

                $( "#id_concat" ).val( o_json.id_concat );
                IdComprobante = o_json.id_comprobante;

                location.href = '<?php echo buildUrl( 'pro/list' ) ?>';
                //configurarElmPorOrdenFacturada();
            }
        );
    }
}
configurarElmPorOrdenFacturada = function()
{
    $( "#txt_orden" ).prop( 'disabled', true );
    $( "#orden_ref" ).prop( 'disabled', true );

    $( "#btn_fnd_orden" ).prop( 'disabled', true );
    $( "#IdTipoDocumento" ).prop( 'disabled', true );
    $( "#DocumentoSerie" ).prop( 'disabled', true );
    $( "#DocumentoNumero" ).prop( 'disabled', true );
    $( "#btnCliente" ).prop( 'disabled', true );
    $( "#btnNvoClie" ).prop( 'disabled', true );
    $( "#ClienteRUC" ).prop( 'disabled', true );
    $( "#ClienteNombre" ).prop( 'disabled', true );
    $( "#sDireccion" ).prop( 'disabled', true );
    $( "#sDistrito" ).prop( 'disabled', true );
    $( "#sDepartamento" ).prop( 'disabled', true );
    $( "#sProvincia" ).prop( 'disabled', true );
    $( "#sPais" ).prop( 'disabled', true );
    $( "#Comentario" ).prop( 'disabled', true );
    $( "#MonedaDocumento" ).prop( 'disabled', true );
    $( "#MonedaCambioValor" ).prop( 'disabled', true );
    
    $( "#TipoVenta" ).prop( 'disabled', true );
    $( "#IdVendedor" ).prop( 'disabled', true );

    $( "#btnGuardarFact" ).hide();
    //$( "#btnEscanearSerie" ).hide();
    $( "#btnGuardarFactPorOrden" ).hide();
    $( "#btnCancelar" ).html( "SALIR" );

    $( "#content_alert_success" ).show();
    $( "#btnImprimirFact" ).show();
    $( "#btnCobrarDocumento" ).show();

    verPDFOrdenVenta();
    
    //si bien, se tiene que desbloquear
    unBlockContent( 'form1' );
}
</script>

<script>
<?php if( $b_Control ){ ?>
//recuperarInfoVentaSerie();
<?php }else{ ?>
b_ControlBuscarSerie = false;
//$( '#IdTipoDocumento' ).attr( "disabled", true );
$( "#IdTipoDocumento" ).click
(
    function( e ) 
    {
        $( "#IdTipoDocumento" ).val( '<?=$o_VTA_DocumentoBN->getIdTipoDocumento()?>' );
        //$( $( this ).data( "default" ) ).prop( "selected", true );
    }
);

$( "#MonedaDocumento" ).change
(
    function(e) 
    {
        $( $( this ).data( "default" ) ).prop( "selected", true );
    }
);
<?php } ?>

<?php if( $s_Anticipo ){ ?>
ControlAnticipo = 1;
$( "#TipoVenta" ).val( "ANT" );
$( "#txt_subtotal" ).prop( 'readonly', false );
$( "#txt_impuesto" ).prop( 'readonly', false );
$( "#txt_total" ).prop( 'readonly', false );
<?php } ?>

<?php if( $s_OrdenNo ){ ?>
$( "#cotent_a_collapse" ).trigger( "click" );
$( "#txt_orden" ).val( '<?=$s_OrdenNo?>' );
<?php }else{ ?>
$( "#cotent_a_collapse" ).trigger( "click" );
<?php } ?>

</script>

<script>
$( "#txt_orden" ).keypress
( 
    function( e ) 
    {
        if( e.which == 32 ){ return false; }
        if( e.which == 13 ) 
        {
            buscarOrdenVenta();
            return false;
        }
        return true;
    }
);

//SE RECUPERA LA SERIE Y EL NUMERO DE CORRELATIVO POR EL TIPO DE DOCUMENTO
//$( "#IdTipoDocumento" ).trigger( "change" );

//POR DEFECTO EL CURSOR ESTA PARA BUSCAR EL NOMBRE
setTimeout
(
    function()
    {
        //$( "#ClienteNombre" ).focus();
    },
    700
);
</script>

<script>
//ESCAPE, DETECTA EL F5, CTRL+F5
$( document ).bind
(
    'keyup', 
    function( e ) 
    {
        pr( e.which );
        if( e.which === 116 ) 
        {
           
        }
        if( e.which === 82 && e.ctrlKey ) 
        {
           
        }
        if( e.which === 119 ) 
        {
           
        }
        if( e.which === 107 ) 
        {
            $( "#cotent_a_collapse" ).trigger( "click" );
        }
        if( e.which === 109 ) 
        {
            $( "#cotent_a_collapse" ).trigger( "click" );
        }
    }
);
</script>
