<?php
class SaveBillingByOrderAction extends wtActions
{
    public function execute()
    {
        $a_Rs = array( "error" => false );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $orden_id           = trim( $this->getRequestParameter( 'orden_id' ) );
            $txt_orden          = trim( $this->getRequestParameter( 'txt_orden' ) );

            $IdCompania         = myUser::getUser()->getIdBusiness();
            $ClienteNumero      = $this->getRequestParameter( 'ClienteNumero' );
            
            $FechaDocumento     = $this->getRequestParameter( 'FechaDocumento' ); //
            $IdTipoDocumento    = $this->getRequestParameter( 'IdTipoDocumento' );
            $Comentario         = addslashes( $this->getRequestParameter( 'Comentario' ) );
            //$f_TipoCambio       = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );
            
            $TipoDocumentoCod   = $this->getRequestParameter( 'TipoDocumentoCod' );
            $DocumentoSerie     = $this->getRequestParameter( 'DocumentoSerie' );
            $DocumentoNumero    = $this->getRequestParameter( 'DocumentoNumero' );
            $NaceAnulado        = $this->getRequestParameter( 'NaceAnulado' );
            $FechaVencimiento   = $this->getRequestParameter( 'FechaVencimiento' );
            
            $TipoVenta          = $this->getRequestParameter( 'TipoVenta' );
            //$IdAlmacen          = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );            
            $IdVendedor         = $this->getRequestParameter( 'IdVendedor' );
            
            $s_MonedaDocumento  = $this->getRequestParameter( 'MonedaDocumento' );
            $f_TipodeCambio     = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );
            $f_Descuento        = floatval( $this->getRequestParameter( 'txt_descuento' ) );
            $f_MontoSubTotal    = floatval( $this->getRequestParameter( 'txt_subtotal' ) );
            $f_TotalImpuesto    = floatval( $this->getRequestParameter( 'txt_impuesto' ) );
            $f_MontoTotal       = floatval( $this->getRequestParameter( 'txt_total' ) );

            //PARAMETROS PARA LA DETRACCION
            $DetracconTipoId     = $this->getRequestParameter( 'DetracconTipoId' );
            $DetracconPorcentaje = $this->getRequestParameter( 'DetracconPorcentaje' );
            $DetracconMedPagoId  = $this->getRequestParameter( 'DetracconMedPagoId' );
            $DetracconTotal      = $this->getRequestParameter( 'DetracconTotal' );

            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setDocumentoParentId( ( int ) $orden_id );
            $o_VTA_DocumentoBN->setDocumentoParentCod( $txt_orden );

            //SETEO PARA DETRACCIONES
            $o_VTA_DocumentoBN->setDetraccionTipoId( intval( $DetracconTipoId ) );
            $o_VTA_DocumentoBN->setDetraccionMedPagoId( intval( $DetracconMedPagoId ) );
            $o_VTA_DocumentoBN->setDetraccionPorcentaje( floatval( $DetracconPorcentaje ) );
            $o_VTA_DocumentoBN->setDetraccionTotal( floatval( $DetracconTotal ) );

            //PARAMETROS PARA RETENCION
            $RetencionTipoId        = $this->getRequestParameter( 'RetencionTipoId' );
            $RetencionBaseImponible = $this->getRequestParameter( 'RetencionBaseImponible' );
            $RetencionTotal         = $this->getRequestParameter( 'RetencionTotal' );

            //SETEO PARA RETENCION
            $o_VTA_DocumentoBN->setRetencionTipoId( intval( $RetencionTipoId ) );
            $o_VTA_DocumentoBN->setRetencionBaseImponible( floatval( $RetencionBaseImponible ) );
            $o_VTA_DocumentoBN->setRetencionTotal( floatval( $RetencionTotal ) );

            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            //$o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
            $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_PREPARACION ); //por defecto
            //$o_VTA_DocumentoBN->setIdAlmacen( $IdAlmacen );
            //$o_VTA_DocumentoBN->setClienteNumero( $ClienteNumero );
            
            $o_VTA_DocumentoBN->setMonedaDocumento( $s_MonedaDocumento );
            $o_VTA_DocumentoBN->setTipodeCambio( $f_TipodeCambio );
            $o_VTA_DocumentoBN->setMontoSubTotal( $f_MontoSubTotal );
            $o_VTA_DocumentoBN->setMontoImpuestos( $f_TotalImpuesto );
            $o_VTA_DocumentoBN->setMontoTotal( $f_MontoTotal );

            //$FechaDocumento   = date( "Y-m-d H:i:s" );
            //$FechaVencimiento = $FechaDocumento;
            
            $o_VTA_DocumentoBN->setFechaDocumento( $FechaDocumento );
            $o_VTA_DocumentoBN->setTipoFacturacion( "N" );
            $o_VTA_DocumentoBN->setDocumentoCod( $TipoDocumentoCod );
            $o_VTA_DocumentoBN->setDocumentoSerie( $DocumentoSerie );
            $o_VTA_DocumentoBN->setDocumentoNumero( $DocumentoNumero );
            $o_VTA_DocumentoBN->setNumeroComprobante( $DocumentoSerie."-".$DocumentoNumero );
            $o_VTA_DocumentoBN->setFechaVencimiento( $FechaVencimiento );
            $o_VTA_DocumentoBN->setTipoVenta( $TipoVenta );
            $o_VTA_DocumentoBN->setComentario( $Comentario );
            if( $NaceAnulado )
            {
                $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_ANULADO );
                $o_VTA_DocumentoBN->setAnulacionComentario( $Comentario );
            }

            $o_VTA_DocumentoBN->setVendedor( myUser::getUser()->getUserId() );
            if( $this->getRequestParameter( 'IdVendedor' ) )
            {
                $o_VTA_DocumentoBN->setVendedor( $IdVendedor );
            }

            $o_VTA_DocumentoBN->setIdFormaPago( $this->getRequestParameter( "FormaPago" ) );
            if( $this->getRequestParameter( "CuotaFecha" ) )
            {
                $a_VTA_DocumentoCuotas = array();
                $a_CuotaTotal = $this->getRequestParameter( "CuotaTotal" );
                foreach( $this->getRequestParameter( "CuotaFecha" ) as $i_Key => $s_FechaCuota )
                {
                    $o_VTA_DocumentoCuotasBN = new VTA_DocumentoCuotasBN();
                    $o_VTA_DocumentoCuotasBN->setCuotaFecha( $s_FechaCuota );
                    $o_VTA_DocumentoCuotasBN->setCuotaMonto( floatval( $a_CuotaTotal[$i_Key] ) );
                    $a_VTA_DocumentoCuotas[] = $o_VTA_DocumentoCuotasBN;
                }
                $o_VTA_DocumentoBN->setArrayDocumentoCuotasBN( $a_VTA_DocumentoCuotas );
            }

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->guardarDocumentoPorOrden( $o_VTA_DocumentoBN );

            $a_Rs['id_concat'] = $o_VTA_DocumentoBN->getIdConcat();
            $a_Rs['id_comprobante'] = $o_VTA_DocumentoBN->getNumeroDocumento();

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            if( myUser::getUser()->getObjectCompania()->getEnviarProveedorAutoFlag() )
            {
                if( !myUser::getUser()->getObjectCompania()->getEnviarCompDirectoSunatFlag() )
                {
                    //CASO 1 - SE ENVIA AL UN PROVEEDOR PSE
                    //$s_DirArchivo = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR."vta".DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR."fael".DIRECTORY_SEPARATOR."actions".DIRECTORY_SEPARATOR."actions.class.php";
                    //ob_start();
                    //require( $s_DirArchivo );
                    //$s_Contenido = ob_get_clean();
                    $o_faelActions             = new faelActions();
                    $o_faelActions->id_request = $o_VTA_DocumentoBN->getNumeroDocumento();
                    $o_faelActions->executeProcAPI();
                    if( $o_faelActions->mensaje_error )
                    {
                        throw new Exception( $o_faelActions->mensaje_error );
                    }
                }
                else
                {
                    //CASO 2 - ENVIO DIRECTO A LA SUNAT
                    //$s_DirArchivo = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR."vta".DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR."cpe".DIRECTORY_SEPARATOR."actions".DIRECTORY_SEPARATOR."ProcAPISunatAction.class.php";
                    //ob_start();
                    //require( $s_DirArchivo );
                    //$s_Contenido = ob_get_clean();
                    $o_ProcAPISunatAction             = new ProcAPISunatAction();
                    $o_ProcAPISunatAction->id_request = $o_VTA_DocumentoBN->getNumeroDocumento();
                    $o_ProcAPISunatAction->execute();
                }
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}