<?php
class RequestAction extends wtActions 
{
    public function execute()
    {
        set_header_utf8();
        $block                  = $this->getRequestParameter( 'block' );
        $IdTransaccionOperacion = $this->getRequestParameter( 'IdTransaccionOperacion' );
        $IdTransaccion          = $this->getRequestParameter( 'IdTransaccion' );
        $TipoProc               = $this->getRequestParameter( 'TipoProc' );
        
        $IdTipoDocumento        = $this->getRequestParameter( 'IdTipoDocumento' );

        $a_lst                  = array( "Result" => false, "error" => false );

        try
        {
            switch ( $TipoProc )
            {
                case "registrar_tc":

                    //if( !GSS_ParametroMastFN::getValorParam( "MONEDA", "MULTIMONEDA" ) )

                    $s_FechaSel  = $this->getRequestParameter( 'fecha' );
                    if( !$s_FechaSel )
                    {
                        $s_FechaSel = date( "Y-m-d" );
                    }

                    $o_iVentas = new iVentas();
                    $o_iVentas->registrarTipoCambio( $s_FechaSel );

                    $o_GSS_TipoCambioFN = new GSS_TipoCambioFN();
                    $o_GSS_TipoCambioBN = $o_GSS_TipoCambioFN->selectByPK( "EX", "LO", $s_FechaSel, myUser::getUser()->getIdCompania() );

                    echo json_encode( $o_GSS_TipoCambioBN->toArray() );

                    exit;

                break;
                case "anular_doc_limit":
                    $s_ValidarReserva  = $this->getRequestParameter( 'ValidarReserva' );
                    pr( "Inicio del Proceso ".date( "Y-m-d H:i:s" ) );
                    $a_VTA_Documento = VTA_DocumentoFN::getIdsDocumentosParaAnular();
                    foreach ( $a_VTA_Documento as $a_Value ) 
                    {
                        try 
                        {
                            $IdTipoDocumento = $a_Value['IdTipoDocumento'];
                            $IdCompania      = $a_Value['IdCompania'];
                            $NumeroDocumento = $a_Value['NumeroDocumento'];
                    
                            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
                            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
                            $o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
                            $o_VTA_DocumentoBN->setNumeroDocumento( $NumeroDocumento );

                            $o_OrdenVentaBL = new OrdenVentaBL();
                            $o_OrdenVentaBL->AnularDocumentoEstadoPR( $o_VTA_DocumentoBN );
                        }
                        catch ( Exception $o_Exception )
                        {
                            pr( $o_Exception->getMessage() );
                        }
                    }

                    if( is_null( $s_ValidarReserva ) || !$s_ValidarReserva )
                    {
                        exit;
                    }

                    //los procesos que continua es para ver si hay problemas de proceso en el inventario
                    //si se encuentra data en el proceso de abajo, hay problemas de guardar el stock la reserva, solucionar de inmediato

                    $a_ALM_ReservaItemStock = VTA_DocumentoFN::getArrayDataReservaParaAnular();
                    foreach ( $a_ALM_ReservaItemStock as $key => $a_Value ) 
                    {
                        $o_ALM_ItemAlmacenStockFN = new ALM_ItemAlmacenStockFN();
                        $o_ALM_ItemAlmacenStockFN->setIdItem( $a_Value['IdItem'] );
                        $o_ALM_ItemAlmacenStockFN->setIdLote( $a_Value['IdLote'] );
                        $o_ALM_ItemAlmacenStockFN->setIdAlmacen( $a_Value['IdAlmacen'] );
                        $a_ALM_ItemAlmacenStock = $o_ALM_ItemAlmacenStockFN->select();
                        if( count( $a_ALM_ItemAlmacenStock ) > 1 )
                        {
                            pr( "El Codigo ".$a_Value['IdItem']." tiene varios lotes." );
                            pr( $a_Value );
                            continue;
                        }
                        if( $a_ALM_ItemAlmacenStock )
                        {
                            $o_ALM_ItemAlmacenStockBN = $a_ALM_ItemAlmacenStock[0];
                            if( $o_ALM_ItemAlmacenStockBN->getStockFisico() == 0 )
                            {
                                pr( "Stock => 0" );
                                $o_ALM_ReservaItemStockDP = new ALM_ReservaItemStockDP();
                                $o_ALM_ReservaItemStockDP->setReservaId( ( int ) $a_Value['ReservaId'] );
                                //$o_ALM_ReservaItemStockDP->delete();
                                //continue;
                                pr( $a_Value );
                                pr( $o_ALM_ItemAlmacenStockBN );
                                exit;
                            }
                            
                            pr( "if( {$o_ALM_ItemAlmacenStockBN->getStockReservado()} == {$a_Value['ReservaCantidad']} )" );
                            if( $o_ALM_ItemAlmacenStockBN->getStockReservado() == $a_Value['ReservaCantidad'] )
                            {
                                pr( "Stock Reservado == ReservaCantidad" );
                                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                                $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $a_Value['ReservaDocTipo'], $a_Value['IdCompania'], $a_Value['ReservaRefNumero'], $a_Value['ReservaSecuencia'] );
                                if( !$o_VTA_DocumentoDetalleBN )
                                {
                                    $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( "BV", $a_Value['IdCompania'], $a_Value['ReservaRefNumero'], $a_Value['ReservaSecuencia'] );
                                }
                                if( !$o_VTA_DocumentoDetalleBN )
                                {
                                    $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( "BA", $a_Value['IdCompania'], $a_Value['ReservaRefNumero'], $a_Value['ReservaSecuencia'] );
                                }
                                if( !$o_VTA_DocumentoDetalleBN )
                                {
                                    $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( "FC", $a_Value['IdCompania'], $a_Value['ReservaRefNumero'], $a_Value['ReservaSecuencia'] );
                                }
                                
                                if( $o_VTA_DocumentoDetalleBN )
                                {
                                    pr( "Existe -> o_VTA_DocumentoDetalleBN" );

                                    $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();
                                    //$o_OrdenVentaDetalleBL->iniciarReservaStockAlmacen( $o_VTA_DocumentoDetalleBN, "D" );

                                    pr( $o_ALM_ItemAlmacenStockBN );
                                    pr( $a_Value );
                                    pr( $o_VTA_DocumentoDetalleBN );
                                    exit;
                                }
                                else
                                {
                                    pr( "No Existe -> o_VTA_DocumentoDetalleBN" );
                                    pr( $o_ALM_ItemAlmacenStockBN );
                                    pr( $a_Value );
                                    pr( $o_VTA_DocumentoDetalleBN );
                                    exit;
                                }
                            }
                            else
                            {
                                pr( "Stock Reservado != ReservaCantidad" );
                                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                                $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $a_Value['ReservaDocTipo'], $a_Value['IdCompania'], $a_Value['ReservaRefNumero'], $a_Value['ReservaSecuencia'] );
                                if( !$o_VTA_DocumentoDetalleBN )
                                {
                                    $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( "BV", $a_Value['IdCompania'], $a_Value['ReservaRefNumero'], $a_Value['ReservaSecuencia'] );
                                }
                                if( !$o_VTA_DocumentoDetalleBN )
                                {
                                    $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( "BA", $a_Value['IdCompania'], $a_Value['ReservaRefNumero'], $a_Value['ReservaSecuencia'] );
                                }
                                if( !$o_VTA_DocumentoDetalleBN )
                                {
                                    $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( "FC", $a_Value['IdCompania'], $a_Value['ReservaRefNumero'], $a_Value['ReservaSecuencia'] );
                                }

                                if( $o_VTA_DocumentoDetalleBN )
                                {
                                    pr( "Existe -> o_VTA_DocumentoDetalleBN" );
                                    pr( $o_ALM_ItemAlmacenStockBN );
                                    pr( $a_Value );
                                    pr( $o_VTA_DocumentoDetalleBN );
                                    $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();
                                    //$o_OrdenVentaDetalleBL->iniciarReservaStockAlmacen( $o_VTA_DocumentoDetalleBN, "D" );
                                    exit;
                                }
                                else
                                {
                                    pr( "No Existe -> o_VTA_DocumentoDetalleBN" );
                                    pr( $o_ALM_ItemAlmacenStockBN );
                                    pr( $a_Value );
                                    pr( $o_VTA_DocumentoDetalleBN );
                                    //se procede a eliminar 
                                    $s_Sql = "delete from ALM_ReservaItemStock where IdItem='".$a_Value['IdItem']."' and ReservaId='".$a_Value['ReservaId']."' and ReservaRefNumero='".$a_Value['ReservaRefNumero']."'";
                                    //Conexion::getConexion()->createStatement()->executeQuery( $s_Sql );
                                    exit;
                                }
                            }
                        }
                    }

                    $a_Data = VTA_DocumentoFN::getArrayDataCorregirItemAlmacen();
                    foreach ( $a_Data as $key => $a_Value ) 
                    {
                        $f_SumaStocksRvDis = $a_Value['StockReservado'] + $a_Value['StockDisponible'];
                        
                        if( $a_Value['StockFisico'] != $f_SumaStocksRvDis )
                        {
                            pr( "if( {$a_Value['StockFisico']} != $f_SumaStocksRvDis )" );
                            //$s_Sql = "SELECT * FROM ALM_ReservaItemStock WHERE IdItem='".$a_Value['IdItem']."' AND IdAlmacen='".$a_Value['IdAlmacen']."' AND IdLote='".$a_Value['IdLote']."' "
                            //pr( $a_Value );
                        }

                        $o_ALM_ReservaItemStockFN = new ALM_ReservaItemStockFN();
                        $o_ALM_ReservaItemStockFN->setIdItem( $a_Value['IdItem'] );
                        $o_ALM_ReservaItemStockFN->setIdLote( $a_Value['IdLote'] );
                        $o_ALM_ReservaItemStockFN->setIdAlmacen( $a_Value['IdAlmacen'] );
                        $a_ALM_ReservaItemStock = $o_ALM_ReservaItemStockFN->select();

                        if( !$a_ALM_ReservaItemStock )
                        {
                            $s_Sql = "update ALM_ItemAlmacenStock set StockDisponible=StockFisico, StockReservado=0 where IdItem='".$a_Value['IdItem']."' and IdAlmacen='".$a_Value['IdAlmacen']."' and IdLote='".$a_Value['IdLote']."'";
                            //Conexion::getConexion()->createStatement()->executeQuery( $s_Sql );
                            pr( $s_Sql );
                            pr( $a_Value );
                            exit;
                        }

                        $f_SumaReserva = 0;
                        foreach ( $a_ALM_ReservaItemStock as $a_ALM_ReservaItemStockBN ) 
                        {
                            $f_SumaReserva = $f_SumaReserva + $a_ALM_ReservaItemStockBN->getReservaCantidad();
                        }

                        if( $a_Value['StockReservado'] != $f_SumaReserva )
                        {
                            $f_StockDisponible = $a_Value['StockFisico'] - $f_SumaReserva;
                            pr( "Suma reservas:" );
                            pr( "if( {$a_Value['StockReservado']} != $f_SumaReserva )" );
                            pr( $a_Value );
                            $s_Sql = "update ALM_ItemAlmacenStock set StockReservado=$f_SumaReserva, StockDisponible=$f_StockDisponible where IdItem='".$a_Value['IdItem']."' and IdAlmacen='".$a_Value['IdAlmacen']."' and IdLote='".$a_Value['IdLote']."'";
                            //Conexion::getConexion()->createStatement()->executeQuery( $s_Sql );
                            exit;
                        }
                    }

                    //aqui se agrega el procedimiento para los items con estado inactivo se actualiza el stock a 0
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastFN->setEstado( ALM_ItemMastBN::ESTADO_INACTIVO ); //ESCOGER SOLO EL ESTADO INACTIVO
                    $a_ALM_ItemMast = $o_ALM_ItemMastFN->select();
                    foreach( $a_ALM_ItemMast as $o_ALM_ItemMastBN )
                    {
                        //ALM_ItemAlmacenStockDP::actualizarStockPorEstadoFinal( $o_ALM_ItemMastBN->getIdItem() );
                    }
                break;
                case "buscar_api_cliente":
                    $con = Conexion::getConexion();
                    $con->begin();
                    try
                    {
                        $s_TextDocumento = trim( $this->getRequestParameter( 'txt' ) );
                        $i_CntCarac      = strlen( $s_TextDocumento );

                        switch ( $i_CntCarac ) 
                        {
                            case 8: //DNI
                                $o_MST_PersonaMastBN = MST_PersonaMastFN::buscarClientePorNroDocumento( $s_TextDocumento );
                                if( $o_MST_PersonaMastBN )
                                {
                                    if( is_array( $o_MST_PersonaMastBN ) )
                                    {
                                        throw new Exception( "El Cliente tiene multiple Registro con el numero de Documento [{$a_Result["ruc"]}] Por favor Revisar." );
                                    }
                                    $a_lst['id_cliente'] = $o_MST_PersonaMastBN->getIdPersona();
                                }

                                $a_Result = "";
                                if( !$o_MST_PersonaMastBN )
                                {
                                    //throw new Exception( "Por ahora no se encuentra disponible la busqueda por DNI en la Reniec." );

                                    $o_consulta_reniec = new consulta_reniec();
                                    $o_consulta_reniec->setDNI( $s_TextDocumento );
                                    $a_Result = $o_consulta_reniec->get_content();
                                }

                                if( $a_Result )
                                {
                                    if( $a_Result["error"] )
                                    {
                                        throw new Exception( $a_Result["mensaje_error"] );
                                    }
                                    //se registra en la tabla de Persona 
                                    if( isset( $a_Result["dni"] ) )
                                    {
                                        /*if( $a_Result["contribuyente_estado"] != "ACTIVO" )
                                        {
                                            throw new Exception( "El Cliente tiene un Estado Diferencte de ACTIVO en la SUNAT." );
                                        }*/

                                        $b_Control = true;

                                        if( $b_Control )
                                        {
                                            $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                                            $o_MST_PersonaMastDP->setTipoPersona( "N" );
                                            $o_MST_PersonaMastDP->setNombreCompleto( "" );
                                            $o_MST_PersonaMastDP->setNombres( $a_Result["nombres"] );
                                            $o_MST_PersonaMastDP->setApellidoPaterno( $a_Result["ape_paterno"] );
                                            $o_MST_PersonaMastDP->setApellidoMaterno( $a_Result["ape_materno"] );
                                            $o_MST_PersonaMastDP->setSexo( " " );
                                            $o_MST_PersonaMastDP->setTipoDocumento( "DNI" );
                                            $o_MST_PersonaMastDP->setDocumento( $a_Result["dni"] );
                                            $o_MST_PersonaMastDP->setFechaNacimiento( date( "Y-m-d" ) );
                                            $o_MST_PersonaMastDP->setEsCliente( "SI" );
                                            $o_MST_PersonaMastDP->setEsProveedor( "NO" );
                                            $o_MST_PersonaMastDP->setEsEmpleado( "NO" );
                                            $o_MST_PersonaMastDP->setEsOtro( "NO" );
                                            $o_MST_PersonaMastDP->setDireccion( "-" );
                                            $o_MST_PersonaMastDP->setEstado( "A" );

                                            $i_Id = MST_PersonaMastFN::recuperarId();
                                            $o_MST_PersonaMastDP->setIdPersona( ( int ) $i_Id );
                                            $o_MST_PersonaMastDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                                            $o_MST_PersonaMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                            $o_MST_PersonaMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                            $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                            $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                            //pr( $o_MST_PersonaMastDP );
                                            $b_Result = $o_MST_PersonaMastDP->save();

                                            //se recuperar el Vendedor
                                            $o_MST_PersonaMastBN = MST_PersonaMastFN::buscarPersonaPorIdUsuario( myUser::getUser()->getUserId() );
                                            if( is_array( $o_MST_PersonaMastBN ) )
                                            {
                                                throw new Exception( "8: El Usuario Vendedor tiene multiple Registro con el ID de Usuario [{myUser::getUser()->getUserId()}] Por favor Revisar." );
                                            }

                                            $DivisionId    = "1";
                                            $NivelPrecioId = "1";
                                            $cboVendedorId = $o_MST_PersonaMastBN->getIdPersona();
                                            $CreditoHold   = "NO";

                                            $o_MST_ClienteMastFN = new MST_ClienteMastFN();
                                            $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $i_Id );
                                            if( $o_MST_ClienteMastBN )
                                            {
                                                //pr( "upd" );
                                                //SE ACTUALIZA
                                                $o_MST_ClienteMastDP = new MST_ClienteMastDP();
                                                $o_MST_ClienteMastDP->setIdCliente( ( int ) $i_Id );
                                                $o_MST_ClienteMastDP->setCanal( $DivisionId );
                                                $o_MST_ClienteMastDP->setTipoVenta( $NivelPrecioId );
                                                $o_MST_ClienteMastDP->setVendedor( ( int ) $cboVendedorId );
                                                $o_MST_ClienteMastDP->setCreditoHold( $CreditoHold );
                                                $o_MST_ClienteMastDP->setUsuarioModificacion( myUser::getUser()->getUserId());
                                                $o_MST_ClienteMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ));
                                                $b_Result = $o_MST_ClienteMastDP->update();
                                            }
                                            else 
                                            {
                                                //pr( "ins" );
                                                //SE INGRESA NUEVO REGISTRO
                                                $o_MST_ClienteMastDP = new MST_ClienteMastDP();
                                                $o_MST_ClienteMastDP->setIdCliente( ( int ) $i_Id );
                                                $o_MST_ClienteMastDP->setCanal( $DivisionId );
                                                $o_MST_ClienteMastDP->setTipoVenta( $NivelPrecioId );
                                                $o_MST_ClienteMastDP->setVendedor( ( int ) $cboVendedorId );
                                                $o_MST_ClienteMastDP->setCreditoHold( $CreditoHold );
                                                $o_MST_ClienteMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                                $o_MST_ClienteMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                                $o_MST_ClienteMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                                $o_MST_ClienteMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                                $b_Result = $o_MST_ClienteMastDP->save();
                                            }
                                            //pr( $o_MST_ClienteMastDP );
                                            $a_lst['id_cliente'] = $i_Id;
                                        }
                                    }
                                    else
                                    {
                                        throw new Exception( "8: No se encontro en el resultado los valores esperados para registrar el Cliente [$s_TextDocumento]" );
                                    }
                                }
                            break;
                            case 11: //RUC
                                //ahora buscamos el RUC ingresado
                                $o_MST_PersonaMastBN = MST_PersonaMastFN::buscarClientePorNroDocumento( $s_TextDocumento );
                                if( $o_MST_PersonaMastBN )
                                {
                                    if( is_array( $o_MST_PersonaMastBN ) )
                                    {
                                        throw new Exception( "11: El Cliente tiene multiple Registro con el numero de Documento [{$a_Result["ruc"]}] Por favor Revisar." );
                                    }
                                    $a_lst['id_cliente'] = $o_MST_PersonaMastBN->getIdPersona();
                                }

                                $a_Result = "";
                                if( !$o_MST_PersonaMastBN )
                                {
                                    $o_consulta_sunat = new consulta_sunat();
                                    $o_consulta_sunat->setRuc( $s_TextDocumento );
                                    $a_Result = $o_consulta_sunat->get_content();
                                }
                                
                                if( $a_Result )
                                {
                                    if( $a_Result["error"] )
                                    {
                                        throw new Exception( $a_Result["mensaje_error"] );
                                    }
                                    //se registra en la tabla de Persona 
                                    if( isset( $a_Result["ruc"] ) )
                                    {
                                        if( $a_Result["contribuyente_estado"] != "ACTIVO" )
                                        {
                                            throw new Exception( "11: El Cliente tiene un Estado Diferencte de ACTIVO en la SUNAT." );
                                        }

                                        $b_Control = true;

                                        if( $b_Control )
                                        {
                                            $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                                            $o_MST_PersonaMastDP->setTipoPersona( "J" );
                                            $o_MST_PersonaMastDP->setNombreCompleto( $a_Result["razon_social"] );
                                            $o_MST_PersonaMastDP->setNombres( "" );
                                            $o_MST_PersonaMastDP->setApellidoPaterno( "" );
                                            $o_MST_PersonaMastDP->setApellidoMaterno( "" );
                                            $o_MST_PersonaMastDP->setSexo( " " );
                                            $o_MST_PersonaMastDP->setTipoDocumento( "RUC" );
                                            $o_MST_PersonaMastDP->setDocumento( $a_Result["ruc"] );
                                            $o_MST_PersonaMastDP->setFechaNacimiento( $a_Result["fecha_actividad"] );
                                            $o_MST_PersonaMastDP->setEsCliente( "SI" );
                                            $o_MST_PersonaMastDP->setEsProveedor( "NO" );
                                            $o_MST_PersonaMastDP->setEsEmpleado( "NO" );
                                            $o_MST_PersonaMastDP->setEsOtro( "NO" );
                                            $o_MST_PersonaMastDP->setDireccion( $a_Result["domicilio_fiscal"] );
                                            $o_MST_PersonaMastDP->setEstado( "A" );

                                            $i_Id = MST_PersonaMastFN::recuperarId();
                                            $o_MST_PersonaMastDP->setIdPersona( ( int ) $i_Id );
                                            $o_MST_PersonaMastDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                                            $o_MST_PersonaMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                            $o_MST_PersonaMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                            $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                            $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                            //pr( $o_MST_PersonaMastDP );
                                            $b_Result = $o_MST_PersonaMastDP->save();

                                            //se recuperar el Vendedor
                                            $o_MST_PersonaMastBN = MST_PersonaMastFN::buscarPersonaPorIdUsuario( myUser::getUser()->getUserId() );
                                            if( is_array( $o_MST_PersonaMastBN ) )
                                            {
                                                throw new Exception( "11: El Usuario Vendedor tiene multiple Registro con el ID de Usuario [{myUser::getUser()->getUserId()}] Por favor Revisar." );
                                            }

                                            $DivisionId    = "1";
                                            $NivelPrecioId = "1";
                                            $cboVendedorId = $o_MST_PersonaMastBN->getIdPersona();
                                            $CreditoHold   = "NO";

                                            $o_MST_ClienteMastFN = new MST_ClienteMastFN();
                                            $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $i_Id );
                                            if( $o_MST_ClienteMastBN )
                                            {
                                                //pr( "upd" );
                                                //SE ACTUALIZA
                                                $o_MST_ClienteMastDP = new MST_ClienteMastDP();
                                                $o_MST_ClienteMastDP->setIdCliente( ( int ) $i_Id );
                                                $o_MST_ClienteMastDP->setCanal( $DivisionId );
                                                $o_MST_ClienteMastDP->setTipoVenta( $NivelPrecioId );
                                                $o_MST_ClienteMastDP->setVendedor( ( int ) $cboVendedorId );
                                                $o_MST_ClienteMastDP->setCreditoHold( $CreditoHold );
                                                $o_MST_ClienteMastDP->setUsuarioModificacion( myUser::getUser()->getUserId());
                                                $o_MST_ClienteMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ));
                                                $b_Result = $o_MST_ClienteMastDP->update();
                                            }
                                            else 
                                            {
                                                //pr( "ins" );
                                                //SE INGRESA NUEVO REGISTRO
                                                $o_MST_ClienteMastDP = new MST_ClienteMastDP();
                                                $o_MST_ClienteMastDP->setIdCliente( ( int ) $i_Id );
                                                $o_MST_ClienteMastDP->setCanal( $DivisionId );
                                                $o_MST_ClienteMastDP->setTipoVenta( $NivelPrecioId );
                                                $o_MST_ClienteMastDP->setVendedor( ( int ) $cboVendedorId );
                                                $o_MST_ClienteMastDP->setCreditoHold( $CreditoHold );
                                                $o_MST_ClienteMastDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                                                $o_MST_ClienteMastDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                                                $o_MST_ClienteMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                                $o_MST_ClienteMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                                $b_Result = $o_MST_ClienteMastDP->save();
                                            }
                                            //pr( $o_MST_ClienteMastDP );
                                            $a_lst['id_cliente'] = $i_Id;
                                        }
                                    }
                                    else
                                    {
                                        throw new Exception( "11: No se encontro en el resultado los valores esperados para registrar el Cliente [$s_TextDocumento]" );
                                    }
                                }
                            break;

                            default:
                                throw new Exception( "FN-CL: El texto ingresado no corresponde a un Numero de Documento valido" );
                            break;
                        }
                        $con->commit();
                    }
                    catch( Exception $o_Exception )
                    {
                        $con->rollback();
                        $a_lst['error']         = true;
                        $a_lst['mensaje_error'] = $o_Exception->getMessage();
                    }
                break;
                case "getDivision":
                    $a_data = MST_DivisionFN::select_all();
                    $a_lst = array();
                    foreach ( $a_data as $o_MST_DivisionBN ) 
                    {
                        $a_lst[$o_MST_DivisionBN->getDivisionId()] = $o_MST_DivisionBN->getDivisionDescripcion();
                    }
                break;
                case "IdTransaccion":
                    $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
                    $o_ALM_TransaccionMastFN->setIngresoEgresoFlag( $IdTransaccionOperacion );
                    $a_Result  = $o_ALM_TransaccionMastFN->select();
                    $s_NameId  = "getIdTransaccion";
                    $s_NameDes = "getDescripcionLocal";
                    
                    foreach ( $a_Result as $i_Key => $o_ObjectBN )
                    {
                        $a_lst[$o_ObjectBN->$s_NameId()] = utf8_encode( ( $o_ObjectBN->$s_NameDes() ) );
                    }
                break;
                case "IdTipoDocumento":
                    $o_ALM_TransaccionMastFN = new ALM_TransaccionMastFN();
                    $o_ALM_TransaccionMastBN = $o_ALM_TransaccionMastFN->selectByPK( $IdTransaccion );
                    $s_TipoDocumentoGenerado = $o_ALM_TransaccionMastBN->getTipoDocumentoGenerado();
                    
                    $o_ALM_TipoDocumentoFN = new ALM_TipoDocumentoFN();
                    $o_ALM_TipoDocumentoBN = $o_ALM_TipoDocumentoFN->selectByPK( $s_TipoDocumentoGenerado );
                    
                    $o_stdClass = new stdClass();
                    $o_stdClass->IdTipoDocumento = $o_ALM_TipoDocumentoBN->getIdTipoDocumento();
                    $o_stdClass->Descripcion     = strtoupper ( $o_ALM_TipoDocumentoBN->getDescripcion() );
                    
                    $a_lst = $o_stdClass;
                break;
                case "getSerieNumeroNC":
                    $i_Id       = $this->getRequestParameter( 'i_Id' );

                    $a_Ids = explode( "_", $i_Id );
                    $IdTipoDocumentoRef = $a_Ids[0];
                    $IdCompania         = $a_Ids[1];
                    $NumeroDocumento    = $a_Ids[2];

                    myUser::getUser()->validar_session();

                    if( !GSS_TipoCambioFN::getStaticTipoCambioCobranza() )
                    {
                        throw new Exception( "Debe de registrar el Tipo de Cambio de hoy." );
                    }

                    $o_VTA_DocumentoFN = new VTA_DocumentoFN();
                    $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumentoRef, $IdCompania, $NumeroDocumento );

                    $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                    $o_GSS_SucursalDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                    if( myUser::getUser()->getIdSucursal() )
                    {
                        $o_GSS_SucursalDocumentoFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                    }
                    $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( $IdTipoDocumento );
                    //$o_GSS_SucursalDocumentoFN->setSerieFormato( $o_VTA_DocumentoBN->getDocumentoSerie() );
                    $o_GSS_SucursalDocumentoFN->addCondition( "SUBSTRING(SerieFormato, 1, 1 )", "=", substr( $o_VTA_DocumentoBN->getDocumentoSerie(), 0, 1 ) );
                    $a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();
                    if( count( $a_GSS_SucursalDocumento ) == 1 )
                    {
                        $o_GSS_SucursalDocumentoBN = $a_GSS_SucursalDocumento[0];
                        $s_Serie  = str_pad( $o_GSS_SucursalDocumentoBN->getSerieFormato(), 4, "0", STR_PAD_LEFT );
                        $s_Numero = str_pad( ( $o_GSS_SucursalDocumentoBN->getNumeroActual() + 1 ), 10, "0", STR_PAD_LEFT );

                        $a_lst = array( "Result" => true, "Serie" => $s_Serie, "Numero" => $s_Numero, "IdTipoDocumento" => $IdTipoDocumento );
                    }
                    else
                    {
                        throw new Exception( "No se puede generar el Documento, no se encontro la configuración." );
                    }
                break;
                case "getSerieNumero":
                    try 
                    {
                        myUser::getUser()->validar_session();
                        //SE VALIDA QUE EL ULTIMO DOCUMENTO ESTE MARCADO CON IMPRESION FISICA
                        $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                        $o_GSS_SucursalDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                        if( myUser::getUser()->getIdSucursal() )
                        {
                            $o_GSS_SucursalDocumentoFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                        }
                        $o_GSS_SucursalDocumentoFN->setIdTipoDocumento( $IdTipoDocumento );
                        $a_GSS_SucursalDocumento = $o_GSS_SucursalDocumentoFN->select();

                        //ahora el procedimiento cambia para recuperar serie - numero [PUNO - JULIACA]
                        $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
                        $o_GSS_UsuarioSucuDocumentoFN->setIdusuario( myUser::getUser()->getUserId() );
                        $o_GSS_UsuarioSucuDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                        $o_GSS_UsuarioSucuDocumentoFN->addOrderBy( GSS_UsuarioSucuDocumentoFN::IdTipoDocumento );
                        $a_GSS_UsuarioSucuDocumento = $o_GSS_UsuarioSucuDocumentoFN->select();

                        $o_GSS_SucursalDocumentoBN = null;
                        foreach ( $a_GSS_UsuarioSucuDocumento as $key => $o_GSS_UsuarioSucuDocumentoBN ) 
                        {
                            $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                            $o_GSS_SucursalDocumentoBN = $o_GSS_SucursalDocumentoFN->selectByPK( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );

                            if( count( $a_GSS_UsuarioSucuDocumento ) == 1 )
                            {
                                $IdTipoDocumento = $o_GSS_UsuarioSucuDocumentoBN->getIdTipoDocumento();
                            }
                            if( !$IdTipoDocumento || $IdTipoDocumento == "null" )
                            {
                                $IdTipoDocumento = $o_GSS_UsuarioSucuDocumentoBN->getIdTipoDocumento();
                            }

                            if( $o_GSS_SucursalDocumentoBN->getIdTipoDocumento() == $IdTipoDocumento )
                            {
                                break; //se interrumpe el bucle por que ya se encontro el tipo de documento que se buscaba
                            }
                        }

                        if( $o_GSS_SucursalDocumentoBN )
                        {
                            //$o_GSS_SucursalDocumentoBN = $a_GSS_SucursalDocumento[0];

                            $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
                            $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $IdTipoDocumento );
                            $s_TipoCod = "";
                            if( $o_VTA_TipoDocumentoBN )
                            {
                                $s_TipoCod = $o_VTA_TipoDocumentoBN->getTipoDocumentoCod();
                            }

                            $s_Serie  = str_pad( $o_GSS_SucursalDocumentoBN->getSerieFormato(), 4, "0", STR_PAD_LEFT );
                            $s_Numero = str_pad( ( $o_GSS_SucursalDocumentoBN->getNumeroActual() + 1 ), 10, "0", STR_PAD_LEFT );
                            
                            $a_lst = array( "Result" => true, "Serie" => $s_Serie, "Numero" => $s_Numero, "IdTipoDocumento" => $IdTipoDocumento, "TipoDocumentoCod" => $s_TipoCod );
                        }
                        else
                        {
                            throw new Exception( "No encontro Tipo de Documentos asociados a la Compañia." );
                        }
                    }
                    catch ( Exception $o_Exception )
                    {
                        $a_lst['error']         = true;
                        $a_lst['mensaje_error'] = $o_Exception->getMessage();
                    }
                break;
                case "actualizarFormaPago":
                    $i_Id          = $this->getRequestParameter( 'i_Id' );
                    $s_IdFormaPago = $this->getRequestParameter( 'IdFormaPago' );
                    $IdAlmacen     = $this->getRequestParameter( 'IdAlmacen' );
                    
                    $a_Ids = explode( "_", $i_Id );
                    $s_IdTipoDocumento = $a_Ids[0];
                    $i_IdCompania      = ( int ) $a_Ids[1];
                    $s_NumeroDocumento = $a_Ids[2];
                    //$IdAlmacen       = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
                    
                    try 
                    {
                        //pr( $_REQUEST );

                        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
                        $o_VTA_FormaPagoBN = $o_VTA_FormaPagoFN->selectByPK( $s_IdFormaPago );
                        //pr( $o_VTA_FormaPagoBN );

                        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
                        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $s_IdTipoDocumento, $i_IdCompania, $s_NumeroDocumento );

                        //pr( $o_VTA_DocumentoBN->getClienteNumero() );

                        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                        $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $o_VTA_DocumentoBN->getClienteNumero() );

                        //pr( $o_MST_PersonaMastBN->getCreditoHold() );
                        if( $o_VTA_FormaPagoBN->getContadoFlag() == "N" )
                        {
                            if( $o_MST_PersonaMastBN->getCreditoHold() == "SI" )
                            {
                                throw new Exception( "El Cliente tiene como Credito HOLD, no se puede dar Credito." );
                            }
                        }

                        $o_VTA_DocumentoDP = new VTA_DocumentoDP();
                        $o_VTA_DocumentoDP->setIdTipoDocumento( $s_IdTipoDocumento );
                        $o_VTA_DocumentoDP->setIdCompania( $i_IdCompania );
                        $o_VTA_DocumentoDP->setNumeroDocumento( $s_NumeroDocumento );
                        $o_VTA_DocumentoDP->setIdFormaPago( $s_IdFormaPago );
                        $o_VTA_DocumentoDP->setIdAlmacen( $IdAlmacen );
                        $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $b_Result = $o_VTA_DocumentoDP->update();
                        
                        $a_lst['result'] = $b_Result;
                        $a_lst['error']  = false;
                    }
                    catch ( Exception $o_Exception )
                    {
                        $a_lst['error']         = true;
                        $a_lst['mensaje_error'] = $o_Exception->getMessage();
                    }
                break;
                case "actualizarLoteAlias":
                    $i_Id        = $this->getRequestParameter( 'id_det' );
                    $s_IdLote    = $this->getRequestParameter( 'num_lote_alias' );

                    $a_Ids = explode( "_", $i_Id );
                    $IdTipoDocumento = $a_Ids[0];
                    $IdCompania      = ( int ) $a_Ids[1];
                    $NumeroDocumento = $a_Ids[2];
                    $i_Secuencia     = ( int ) $a_Ids[3];

                    //aqui actualizo el lote alias
                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP();
                    $o_VTA_DocumentoDetalleDP->setIdTipoDocumento( $IdTipoDocumento );
                    $o_VTA_DocumentoDetalleDP->setIdCompania( $IdCompania );
                    $o_VTA_DocumentoDetalleDP->setNumeroDocumento( $NumeroDocumento );
                    $o_VTA_DocumentoDetalleDP->setSecuencia( $i_Secuencia );
                    $o_VTA_DocumentoDetalleDP->setLoteAlias( $s_IdLote );
                    $o_VTA_DocumentoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_VTA_DocumentoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $b_Result = $o_VTA_DocumentoDetalleDP->update();

                break;
                case "actualizarLotexLinea":
                    $i_Id        = $this->getRequestParameter( 'i_Id' );
                    $i_Secuencia = ( int ) $this->getRequestParameter( 'Secuencia' );
                    $s_IdLote    = $this->getRequestParameter( 'IdLote' );
                    
                    $a_Ids = explode( "_", $i_Id );
                    $IdTipoDocumento = $a_Ids[0];
                    $IdCompania      = ( int ) $a_Ids[1];
                    $NumeroDocumento = $a_Ids[2];
                    $IdAlmacen       = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
                    
                    $con = Conexion::getConexion();
                    $con->begin();
                    try
                    {

                        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                        $o_Tmp_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento, $i_Secuencia );
                        if( $o_Tmp_VTA_DocumentoDetalleBN )
                        {
                            //AHORA SI SE TIENE PROMOCIONES ASOCIADOS, SE ACTUALIZA EL LOTE
                            //para el caso que este implementado el descuento
                            /*
                            $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                            $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $o_Tmp_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                            $o_VTA_DocumentoDetalleFN->setIdCompania( $o_Tmp_VTA_DocumentoDetalleBN->getIdCompania() );
                            $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_Tmp_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                            $o_VTA_DocumentoDetalleFN->setRefParent( $o_Tmp_VTA_DocumentoDetalleBN->getSecuencia() );
                            $o_VTA_DocumentoDetalleFN->setTipoDetalle( VTA_DocumentoDetalleBN::TIPO_DETALLE_DESCUENTO );
                            $o_VTA_DocumentoDetalleFN->setItemCodigo( VTA_DocumentoDetalleBN::ITEM_ZZDSCTO );
                            $o_VTA_DocumentoDetalleFN->setLote( $o_Tmp_VTA_DocumentoDetalleBN->getLote() );
                            //$o_VTA_DocumentoDetalleFN->setNumeroPromocion( $o_Tmp_VTA_DocumentoDetalleBN->getNumeroPromocion() );
                            $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                            if( $a_VTA_DocumentoDetalle )
                            {
                                foreach ( $a_VTA_DocumentoDetalle as $i_Key => $o_VTA_DocumentoDetalleBN )
                                {
                                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP();
                                    $o_VTA_DocumentoDetalleDP->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                                    $o_VTA_DocumentoDetalleDP->setIdCompania( $IdCompania );
                                    $o_VTA_DocumentoDetalleDP->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                                    $o_VTA_DocumentoDetalleDP->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );
                                    $o_VTA_DocumentoDetalleDP->setLote( $s_IdLote );
                                    $o_VTA_DocumentoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                    $o_VTA_DocumentoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                    $b_Result = $o_VTA_DocumentoDetalleDP->update();
                                }
                            }
                            */
                        }

                        $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();

                        //aqui ante de cambiar, se elimina la reverva con el lote anterior
                        $o_OrdenVentaDetalleBL->iniciarReservaStockAlmacen( $o_Tmp_VTA_DocumentoDetalleBN, "D" );
                        
                        //aqui actualizo el lote, pero ahora el sistema maneja reservas
                        $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP();
                        $o_VTA_DocumentoDetalleDP->setIdTipoDocumento( $IdTipoDocumento );
                        $o_VTA_DocumentoDetalleDP->setIdCompania( $IdCompania );
                        $o_VTA_DocumentoDetalleDP->setNumeroDocumento( $NumeroDocumento );
                        $o_VTA_DocumentoDetalleDP->setSecuencia( $i_Secuencia );
                        $o_VTA_DocumentoDetalleDP->setLote( $s_IdLote );
                        $o_VTA_DocumentoDetalleDP->setLoteAlias( $s_IdLote );
                        $o_VTA_DocumentoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_VTA_DocumentoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $b_Result = $o_VTA_DocumentoDetalleDP->update();
                        
                        //ahora se reverva al lote nuevo
                        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                        $o_Tmp_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento, $i_Secuencia );
                        $o_OrdenVentaDetalleBL->iniciarReservaStockAlmacen( $o_Tmp_VTA_DocumentoDetalleBN, "I" );

                        $con->commit();
                    }
                    catch ( Exception $o_Exception )
                    {
                        $con->rollback();
                        throw new Exception( $o_Exception->getMessage() );
                    }
                    $a_lst['error'] = false;
                break;
                case "getStockActual":
                    $s_IdItem      = $this->getRequestParameter( 'IdItem' );
                    $i_IdCompania  = $this->getRequestParameter( 'IdCompania' );
                    $s_IdAlmacen   = $this->getRequestParameter( 'IdAlmacen' );
                    $s_IdLote      = $this->getRequestParameter( 'IdLote' );
                    $i_Id          = $this->getRequestParameter( 'i_Id' );
                    $s_Secuencia   = $this->getRequestParameter( 'Secuencia' );

                    $a_Ids = explode( "_", $i_Id );

                    $IdTipoDocumento = $a_Ids[0];
                    $IdCompania      = ( int ) $a_Ids[1];
                    $NumeroDocumento = $a_Ids[2];

                    //$i_StockDispon = ALM_ItemAlmacenStockFN::recuperarStockDisponible( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdLote );
                    //$s_FechaVencimientoLote = ALM_ItemAlmacenStockFN::recuperarFechaVencimientoLote( $i_IdCompania, $s_IdItem, $s_IdAlmacen, $s_IdLote );
                    //
                    $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                    $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
                    $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
                    $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
                    $o_VTA_DocumentoDetalleFN->setSecuencia( $s_Secuencia );
                    $o_VTA_DocumentoDetalleBN = $o_VTA_DocumentoDetalleFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento, $s_Secuencia );

                    $i_IdUnidadAsignado     = $o_VTA_DocumentoDetalleFN->getIdUnidadMedidaAsignado();
                    $i_UnidadVentaAsiganada = 58; //es la minima unidad de medida //tiene que ser dinamico
                    $f_CantidadAsiganada    = $o_VTA_DocumentoDetalleBN->getItemCantidadMedidaAsignada();

                    $f_StockDisponible = $o_VTA_DocumentoDetalleBN->getObjectItemAlmacen()->getStockDisponible();
                    if( $i_IdUnidadAsignado != $i_UnidadVentaAsiganada )
                    {
                        $f_StockDisponible = $f_StockDisponible / $f_CantidadAsiganada;
                    }
                
                    $a_lst['error']       = false;
                    $a_lst['result']      = true;
                    $a_lst['StockActual'] = $f_StockDisponible;
                    //$a_lst['FechaVencimientoLote'] = substr( $s_FechaVencimientoLote, 0, 10 );
                break;
                case "getClienteInfo":
                    $i_IdTipoDocumento = $this->getRequestParameter( 'IdTipoDocumento' );
                    $i_IdPersona       = $this->getRequestParameter( 'IdPersona' );

                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $i_IdPersona );

                    $s_NombreCompleto = trim( $o_MST_PersonaMastBN->getNombreConcatenado() );
                    $s_TipoDocumento  = $o_MST_PersonaMastBN->getTipoDocumento();
                    $s_Documento      = $o_MST_PersonaMastBN->getDocumento();

                    if( $o_MST_PersonaMastBN->getTipoDocumento() == "RUC" )
                    {
                        $s_NombreCompleto = trim( $o_MST_PersonaMastBN->getNombreCompleto() );
                    }
                    else 
                    {
                        $s_NombreCompleto = trim( $o_MST_PersonaMastBN->getNombreConcatenado() );
                    }

                    if( $this->getRequestParameter( 'IdTipoDocumento' ) )
                    {
                        if( $i_IdTipoDocumento == "FC" )
                        {
                            if( $o_MST_PersonaMastBN->getTipoPersona() == "N" && $o_MST_PersonaMastBN->getTipoDocumento() == "DNI" )
                            {
                                throw new Exception( "El Cliente esta como Persona Natural con DNI." );
                            }

                            $s_NombreCompleto = trim( $o_MST_PersonaMastBN->getNombreCompleto() );
                        }

                        if( $i_IdTipoDocumento == "BV" )
                        {
                            if( $o_MST_PersonaMastBN->getTipoPersona() == "N" && $o_MST_PersonaMastBN->getTipoDocumento() == "RUC" )
                            {
                                if( !$o_MST_PersonaMastBN->getDocumentoIdentidad() )
                                {
                                    throw new Exception( "El Cliente esta como Persona Natural con RUC, pero no se encuentra el Documento de Identidad." );
                                }

                                $s_TipoDocumento  = "DNI";
                                $s_Documento      = $o_MST_PersonaMastBN->getDocumentoIdentidad();
                            }
                        }
                    }

                    //ahora se recupera el vendedor por defecto
                    $s_IdUsuarioVen = "";
                    $o_MST_ClienteMastFN = new MST_ClienteMastFN();
                    $o_MST_ClienteMastBN = $o_MST_ClienteMastFN->selectByPK( $i_IdPersona );
                    if( $o_MST_ClienteMastBN )
                    {
                        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                        $o_MST_PersonaMastBN2 = $o_MST_PersonaMastFN->selectByPK( $o_MST_ClienteMastBN->getVendedor() );
                        if( $o_MST_PersonaMastBN2 )
                        {
                            $s_IdUsuarioVen = $o_MST_PersonaMastBN2->getIdUsuario();
                        }
                    }

                    $a_lst['Nombre']            = $s_NombreCompleto;
                    $a_lst['TipoDocumento']     = $s_TipoDocumento;
                    $a_lst['Documento']         = $s_Documento;
                    $a_lst['DepartamentoDesc']  = $o_MST_PersonaMastBN->getDepartamentoDesc();
                    $a_lst['ProvinciaDesc']     = $o_MST_PersonaMastBN->getProvinciaDesc();
                    $a_lst['DistritoDesc']      = $o_MST_PersonaMastBN->getDistritoDesc();
                    $a_lst['IdUbigeo']          = $o_MST_PersonaMastBN->getDistrito();
                    $a_lst['Direccion']         = $o_MST_PersonaMastBN->getDireccion();
                    $a_lst['CanalCliente']      = $o_MST_PersonaMastBN->getCanalCliente();
                    $a_lst['UsuarioVendedor']   = $s_IdUsuarioVen;
                break;
                case "Autocomplete":
                    $s_Termino = $this->getRequestParameter( 'term' );
                    
                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastFN->setEstado( "A" );
                    $o_MST_PersonaMastFN->setEsCliente( "SI" );
                    $o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                    $a_MST_PersonaMast = $o_MST_PersonaMastFN->selectAutocomplete( $s_Termino );
                    foreach ( $a_MST_PersonaMast as $i_Key => $o_MST_PersonaMastBN )
                    {
                        $a_lst[] = array( "value" => trim( $o_MST_PersonaMastBN->getNombreCompletoLLeno() ), "label" => trim( $o_MST_PersonaMastBN->getNombreCompletoLLeno() ), "id" => $o_MST_PersonaMastBN->getIdPersona() );
                    }
                break;
                case "getInfoCliexNumDoc":
                    $i_IdTipoDocumento = $this->getRequestParameter( 'IdTipoDocumento' );
                    $s_NumDniRuc = $this->getRequestParameter( 'NumDniRuc' );
                    
                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastFN->setEstado( "A" );
                    $o_MST_PersonaMastFN->setEsCliente( "SI" );
                    //$o_MST_PersonaMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
                    
                    if( $i_IdTipoDocumento == "FC" || $i_IdTipoDocumento == "TF" )
                    {
                        $o_MST_PersonaMastFN->setTipoDocumento( "RUC" );
                        $o_MST_PersonaMastFN->setDocumento( $s_NumDniRuc );
                        $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
                        if( $a_MST_PersonaMast )
                        {
                            $a_lst['error']      = false;
                            $a_lst['Result']     = true;
                            $o_MST_PersonaMastBN = $a_MST_PersonaMast[0];
                            $a_lst['idpersona'] = $o_MST_PersonaMastBN->getIdPersona();
                        }
                    }
                    //if( $i_IdTipoDocumento == "BV" || $i_IdTipoDocumento == "TB" || $i_IdTipoDocumento == "PE" )
                    else
                    {
                        $o_MST_PersonaMastFN->setTipoDocumento( "DNI" );
                        $o_MST_PersonaMastFN->setDocumento( $s_NumDniRuc );
                        $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
                        if( $a_MST_PersonaMast )
                        {
                            $o_MST_PersonaMastBN = $a_MST_PersonaMast[0];
                            $a_lst['error']      = false;
                            $a_lst['Result']     = true;
                            $a_lst['idpersona'] = $o_MST_PersonaMastBN->getIdPersona();
                        }
                        else 
                        {
                            $o_MST_PersonaMastFN->setTipoDocumento( "RUC" );
                            $o_MST_PersonaMastFN->setDocumento( $s_NumDniRuc );
                            $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
                            if( $a_MST_PersonaMast )
                            {
                                $o_MST_PersonaMastBN = $a_MST_PersonaMast[0];
                                $a_lst['error']      = false;
                                $a_lst['Result']     = true;
                                $a_lst['idpersona']  = $o_MST_PersonaMastBN->getIdPersona();
                            }
                        }
                    }
                break;
                case "getInfoCliexNumDocCustom":
                    $i_IdTipoDocumento = $this->getRequestParameter( 'IdTipoDocumento' );
                    $s_NumDniRuc = $this->getRequestParameter( 'NumDniRuc' );
                    
                    $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                    $o_MST_PersonaMastFN->setEstado( "A" );
                    $o_MST_PersonaMastFN->setEsCliente( "SI" );
                    $o_MST_PersonaMastFN->setDocumento( $s_NumDniRuc );
                    $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
                    if( $a_MST_PersonaMast )
                    {
                        $a_lst['error']      = false;
                        $a_lst['Result']     = true;
                        $o_MST_PersonaMastBN = $a_MST_PersonaMast[0];
                        $a_lst['idpersona'] = $o_MST_PersonaMastBN->getIdPersona();
                    }
                break;
                case "ConfirmacionTicket":
                    $i_Id  = $this->getRequestParameter( 'i_Id' );
                    $s_Est = $this->getRequestParameter( 'EstadoConfirm' );
                    
                    $a_Ids = explode( "_", $i_Id );
                    $IdTipoDocumento = $a_Ids[0];
                    $IdCompania      = ( int ) $a_Ids[1];
                    $NumeroDocumento = $a_Ids[2];
                    
                    try 
                    {
                        $o_VTA_DocumentoDP = new VTA_DocumentoDP();
                        $o_VTA_DocumentoDP->setIdTipoDocumento( $IdTipoDocumento );
                        $o_VTA_DocumentoDP->setIdCompania( ( int ) $IdCompania );
                        $o_VTA_DocumentoDP->setNumeroDocumento( $NumeroDocumento );
                        $o_VTA_DocumentoDP->setImpresionPendienteFlag( $s_Est );
                        $o_VTA_DocumentoDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_VTA_DocumentoDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $b_Result = $o_VTA_DocumentoDP->update();
                        
                            $a_lst['error']      = false;
                            $a_lst['Result']     = true;
                    }
                    catch( Exception $o_Exception )
                    {
                        $a_lst['error']  = true;
                        $a_lst['Result'] = false;
                    }
                    break;
                case "CrearArchivoPrintDocumento":
                    $i_Id  = $this->getRequestParameter( 'i_Id' );
                    
                    $a_Ids = explode( "_", $i_Id );
                    $IdTipoDocumento = $a_Ids[0];
                    $IdCompania      = ( int ) $a_Ids[1];
                    $NumeroDocumento = $a_Ids[2];
                    
                    try 
                    {
                        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
                        $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );            
                        
                        $s_IdTipoDocumento = $o_VTA_DocumentoBN->getIdTipoDocumento();
                        
                        $s_NombreArchivo = str_replace( " ", "_", $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero() );
                        
                        $f_IGV       = UtilIGV::getValorIGVActual();
                        $f_IGVMasUno = $f_IGV + 1;
                        
                        $o_UtilImprimir = new UtilImprimir();
                        
                        switch ( $s_IdTipoDocumento )
                        {
                            case "FC":
                                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                //PARAMETROS
                                $s_NombreEmpresa    = $o_VTA_DocumentoBN->getClienteNombre();
                                $s_ClienteDireccion = utf8_decode( $o_VTA_DocumentoBN->getClienteDireccion()." ".$o_VTA_DocumentoBN->getDireccionUbigeo() );
                                $s_ClienteDireccion = strlen( $s_ClienteDireccion )>55 ? substr( $s_ClienteDireccion, 0, 55 ) : $s_ClienteDireccion;
                                $s_ClienteDireccion = utilString::limpiar_caracteres_para_imprimir( $s_ClienteDireccion );
                                $s_FechaDocumento   = substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 );
                                $a_FechaDocumento   = explode( "-", $s_FechaDocumento );
                                $s_ClienteRUC       = $o_VTA_DocumentoBN->getClienteRUC();
                                $s_CodigoVendedor   = $o_VTA_DocumentoBN->getVendedor();
                                $s_FormaPagoDesc    = substr( $o_VTA_DocumentoBN->getFormaPagoDes(), 0, 14 );
                                $s_OrdenCompraRef   = $o_VTA_DocumentoBN->getOrdenCompraRef();
                                
                                $f_MontoAfecto      = $o_VTA_DocumentoBN->getMontoAfecto();
                                $s_MontoAfecto      = number_format( $o_VTA_DocumentoBN->getMontoAfecto(), 2 );
                                
                                //$f_Impuesto         = $o_VTA_DocumentoBN->getMontoImpuestoVentas();
                                $s_Impuesto         = number_format( $o_VTA_DocumentoBN->getMontoImpuestos(), 2 );
                                
                                $f_MontoTotal       = $o_VTA_DocumentoBN->getMontoTotal();
                                $s_MontoTotal       = number_format( $f_MontoTotal, 2 );
                                
                                $s_MontoEntero = explode( ".", number_format( $f_MontoTotal, 2, ".", "" ) );
                                
                                $o_NumberToLetter   = new NumberToLetterConverter();
                                $s_MontoTotalLetras = $o_NumberToLetter->to_word( $s_MontoEntero[0] );

                                $s_MonedaDocumento  = $o_VTA_DocumentoBN->getMonedaDocumento();
                                if( $s_MonedaDocumento == "LO" )
                                {
                                    $s_MontoTotalLetras .= " Y ".$s_MontoEntero[1]."/100 SOLES";
                                }
                                else
                                {
                                    $s_MontoTotalLetras .= " Y ".$s_MontoEntero[1]."/100 DOLARES";
                                }
                                
                                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();
                                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                //linea 95
                                //linea 70

                                //ahora se busca las guias impresas - 2020-08-07
                                $s_DocParent = $o_VTA_DocumentoBN->getDocumentoParentCod();
                                $o_SR_GuiaRemisionHFN = new SR_GuiaRemisionHFN();
                                if( $o_VTA_DocumentoBN->getDocumentoParentCod() )
                                {
                                    $o_SR_GuiaRemisionHFN->setReferenciaNumero( $s_DocParent );
                                }
                                else
                                {
                                    $o_SR_GuiaRemisionHFN->setReferenciaTipo( $o_VTA_DocumentoBN->getDocumentoCod() );
                                    $o_SR_GuiaRemisionHFN->setReferenciaNumero( $o_VTA_DocumentoBN->getDocumentoSerie()."-".$o_VTA_DocumentoBN->getDocumentoNumero() );
                                }
                                
                                $a_SR_GuiaRemisionH = $o_SR_GuiaRemisionHFN->select();
                                
                                $s_NumeroGuia = "";
                                if( $a_SR_GuiaRemisionH )
                                {
                                    $a_Data = array();
                                    foreach( $a_SR_GuiaRemisionH as $o_SR_GuiaRemisionHBN )
                                    {
                                        $s_NumeroGuia = $o_SR_GuiaRemisionHBN->getGuiaSerie()."-".$o_SR_GuiaRemisionHBN->getGuiaNumero();
                                        break;
                                    }
                                }

                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                //$o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );

                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 5=>$s_FechaDocumento ) )."\n" ); //fecha - linea 10
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 6=>$s_NombreEmpresa,    73=>$s_NumeroGuia ) )."\n" ); //nombre de la empresa
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 6=>$s_ClienteRUC,       73=>$s_OrdenCompraRef ) )."\n" ); //47=>$s_CodigoVendedor
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 6=>$s_ClienteDireccion, 73=>$s_FormaPagoDesc ) )."\n" );
                                
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                
                                //DETALLES - las lineas empieza en la posicion 16
                                $w = 1;
                                for ( $i=0; $i<36; $i++ )
                                {
                                    //if( $i==2 ){ $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" ); continue; }
                                    //if( $i==7 ){ $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" ); continue; }
                                    
                                    if( isset( $a_VTA_DocumentoDetalle[$i] ) )
                                    {
                                        $a_TMP_VTA_DocumentoDetalle = $a_VTA_DocumentoDetalle[$i];
                                        
                                        $s_ItemCodigo  = substr( $a_TMP_VTA_DocumentoDetalle->getItemCodigo(), 0, 9 );
                                        $i_Cantidad    = $a_TMP_VTA_DocumentoDetalle->getCantidadPedida();
                                        $s_Descripcion = substr( utf8_decode( $a_TMP_VTA_DocumentoDetalle->getDescripcion() ), 0, 55 );
                                        $s_PrecioUni   = number_format( $a_TMP_VTA_DocumentoDetalle->getPrecioUnitario(), 2 );
                                        $s_SubTotal    = number_format( $a_TMP_VTA_DocumentoDetalle->getPrecioSubTotalDocumento(), 2 );

                                        //1=>$s_ItemCodigo
                                        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 1=>$s_ItemCodigo, 12=>$i_Cantidad, 18=>$s_Descripcion, 74=>$s_PrecioUni, 85=>$s_SubTotal ) )."\n" );
                                    }
                                    else 
                                    {
                                        //$o_UtilImprimir->addTexts( self::fomat_linea_print( array( 1=>$w ) )."\n" );
                                        $o_UtilImprimir->addTexts( self::fomat_linea_print( )."\n" );
                                    }
                                    $w++;
                                }
                                //////////
                                
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 5=>$s_MontoTotalLetras, 85=>$s_MontoAfecto  ) )."\n" ); //linea 53
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                //$o_UtilImprimir->addTexts( self::fomat_linea_print( array( 36=>$a_FechaDocumento[2], 44=>UtilDate::getFormatDateMes( $s_FechaDocumento, "F" ), 56=>UtilDate::getFormatDate( $s_FechaDocumento, "y" ) ) )."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 78=>GSS_ParametroMastFN::getTextoIgvActual(), 86=>$s_Impuesto ) )."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 85=>$s_MontoTotal ) )."\n" );
                                
                            break;
                            case "BV":
                                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                //PARAMETROS
                                $s_NombreCliente    = $o_VTA_DocumentoBN->getClienteNombre();
                                $s_ClienteDireccion = utf8_decode ( $o_VTA_DocumentoBN->getClienteDireccion()." ".$o_VTA_DocumentoBN->getClienteReferencia() ); //CONCATENAR LA DIRECCION
                                $s_ClienteDireccion = strlen( $s_ClienteDireccion )>66 ? substr( $s_ClienteDireccion, 0, 66 ) : $s_ClienteDireccion;
                                $s_FechaDocumento   = substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 );
                                $a_FechaDocumento   = explode( "-", $s_FechaDocumento );
                                $s_ClienteDNI       = $o_VTA_DocumentoBN->getClienteRUC();
                                $s_CodigoVendedor   = $o_VTA_DocumentoBN->getVendedor();
                                $s_FormaPagoDesc    = substr( $o_VTA_DocumentoBN->getFormaPagoDes(), 0, 14 );
                                
                                $f_MontoAfecto      = $o_VTA_DocumentoBN->getMontoAfecto();
                                $s_MontoAfecto      = number_format( $o_VTA_DocumentoBN->getMontoAfecto(), 2 );
                                //pr( $o_VTA_DocumentoBN );
                                //$f_Impuesto         = $o_VTA_DocumentoBN->getMontoImpuestoVentas();
                                $s_Impuesto         = number_format( $o_VTA_DocumentoBN->getMontoImpuestos(), 2 );
                                
                                $f_MontoTotal       = $o_VTA_DocumentoBN->getMontoTotalMN();
                                $s_MontoTotal       = number_format( $f_MontoTotal, 2 );
                                $o_NumberToLetter   = new NumberToLetterConverter();
                                $s_MontoTotalLetras = $o_NumberToLetter->to_word( $f_MontoTotal );
                                
                                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();
                                ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                                //$a_FechaDocumento[2]          => 03
                                //UtilDate::getFormatDateMes( $s_FechaDocumento, "F" )  => Octubre
                                //UtilDate::getFormatDate( $s_FechaDocumento, "y" )     => 18

                                /*$o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );
                                $o_UtilImprimir->addTexts( "-----------------------------------------------------------------------------\n" );*/
                                


                                
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 11=>$s_NombreCliente, 59 => $s_FechaDocumento ) )."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 11=>$s_ClienteDireccion, 59 => $s_ClienteDNI ) )."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                
                                //DETALLES - a partir de la linea 12
                                $w = 0;
                                for ( $i=1; $i<8; $i++ )
                                {
                                    //if( $i==7 ){ $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" ); continue; }
                                    //if( $i==8 ){ $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" ); continue; }
                                    
                                    if( isset( $a_VTA_DocumentoDetalle[$w] ) )
                                    {
                                        $a_TMP_VTA_DocumentoDetalle = $a_VTA_DocumentoDetalle[$w];
                                        
                                        $i_Cantidad = $a_TMP_VTA_DocumentoDetalle->getCantidadPedida();
                                        $s_Descripcion = substr( utf8_decode( $a_TMP_VTA_DocumentoDetalle->getDescripcion() ), 0, 55 );
                                        $s_PrecioUni   = number_format( $a_TMP_VTA_DocumentoDetalle->getPrecioUnitarioMN() * $f_IGVMasUno, 2 );
                                        $s_SubTotal    = number_format( $a_TMP_VTA_DocumentoDetalle->getMontoTotalNetoMN() , 2 );
                                        
                                        $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 5 => $i_Cantidad, 11=>$s_Descripcion, 53=>$s_PrecioUni, 64=>$s_SubTotal ) )."\n" );
                                    }
                                    else 
                                    {
                                        $o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                    }
                                    $w++;
                                }
                                //////////
                                
                                
                                //$o_UtilImprimir->addTexts( self::fomat_linea_print()."\n" );
                                //18=>$s_FormaPagoDesc
                                $o_UtilImprimir->addTexts( self::fomat_linea_print( array( 64=>$s_MontoTotal ) )."\n" );
                                
                                //$o_UtilImprimir->addTexts( self::fomat_linea_print( array( 82=>$s_MontoTotal ) )."\n" );
                                //$o_UtilImprimir->addTexts( self::fomat_linea_print( array(  ) )."\n" );
                                //$o_UtilImprimir->addTexts( self::fomat_linea_print( array( 36=>$a_FechaDocumento[2], 43=>UtilDate::getFormatDateMes( $s_FechaDocumento, "F" ), 56=>UtilDate::getFormatDate( $s_FechaDocumento, "y" ) ) )."\n" ); //SE COMENTA POR REQUERIMIENTO
                            break;
                        }
                        
                        $o_UtilImprimir->saltoPagina();
                        $s_NombreArchivo = $o_UtilImprimir->crearArchivoWeb( $s_NombreArchivo );
                        
                        $a_lst['error'] = false;
                        $a_lst['nombre_archivo'] = $s_NombreArchivo;
                    }
                    catch ( Exception $o_Exception )
                    {
                        $a_lst['error'] = true;
                        $a_lst['mensaje_error'] = $o_Exception->getMessage();
                    }
                    echo json_encode( $a_lst );
                    exit;
                    return ViewResponse::NONE;
                break;
                case "validar_serie":
                    $this->validar_serie_h();
                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_lst['error']         = true;
            $a_lst['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
    
    public static function fomat_linea_print( $a_Param=null )
    {
        $i_LineaLargo = 59; //maximo hoja continua
        $i_LineaAncho = 95;
        $s_Tx = " ";
        
        $s_Text = "";
        
        for ( $i=1; $i<=95; $i++ )
        {
            $s_Text .= $s_Tx;
            if( $a_Param )
            {
                foreach ( $a_Param as $i_Key => $s_Value )
                {
                    if( $i == $i_Key )
                    {
                        $s_Text .= $s_Value;
                        $i_TamTexto = strlen( $s_Value );
                        $i = $i + $i_TamTexto;
                        $b_Control = false;
                    }
                }
            }
        }
        return $s_Text;
    }

    public function validar_serie_h()
    {
        $IdCompania = myUser::getUser()->getIdBusiness();
        $IdOrden    = $this->getRequestParameter( 'id_orden' );

        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $IdOrden );
        if( !$o_VTA_OrdenBN )
        {
            throw new Exception( "No se Encontro la Orden de Venta." );
        }

        $b_ControSerie = false;

        $o_SR_MovimientoBN = new SR_MovimientoBN();
        $o_SR_MovimientoBN->setTipoMovimiento( VTA_DocumentoBN::TRANSACCION_X_DEFECTO ); //referencia tabla ALM_TransaccionMast -> ROC, VTA
        $o_SR_MovimientoBN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA ); //SR_MovimientoBN::APROBACION_COMPLETADO
        //$o_SR_MovimientoBN->setAlmacen( $o_VTA_OrdenBN->getAlmacenCod() );
        $o_SR_MovimientoBN->setReferenciaTipo( $o_VTA_OrdenBN->getReferenciaTipoDocId() );
        $o_SR_MovimientoBN->setReferenciaNumero( $o_VTA_OrdenBN->getOrdenNum() );
        //$o_SR_MovimientoBN->setReferenciaId( ( string ) $o_VTA_OrdenBN->getOrdenId() );
        //$o_SR_MovimientoBN->setReferenciaFecha( $o_VTA_OrdenBN->getOrdenFecha() );
        //$o_SR_MovimientoBN->setEstado( "P" );

        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
        $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
        foreach ( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
        {
            $o_SR_MovimientoDetalleBN = new SR_MovimientoDetalleBN();
            $o_SR_MovimientoDetalleBN->setProductoId( $o_VTA_OrdenDetalleBN->getItemCod() );
            $o_SR_MovimientoDetalleBN->setCantidad( intval( $o_VTA_OrdenDetalleBN->getOrdenDetalleCantidad() ) );
            $o_SR_MovimientoDetalleBN->setPorSerie( "CO" );
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            /// PREGUNTA SI UNO DE LOS PRODUCTOS MANEJA SERIE
            $o_ALM_ItemMastBN = $o_VTA_OrdenDetalleBN->getObjectItem();
            if( $o_ALM_ItemMastBN->SiManejaSerie() )
            {
                $b_ControSerie = true;
                $o_SR_MovimientoDetalleBN->setPorSerie( "PE" ); //PE | CO
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $a_SR_MovimientoDetalle[] = $o_SR_MovimientoDetalleBN;
        }
        $o_SR_MovimientoBN->setMovimientoDetalleArray( $a_SR_MovimientoDetalle );

        $o_SR_MovimientoBN->setControlEstadoSerie( SR_MovimientoBN::CTRL_ESTADO_SERIE_NOEXISTE );
        if( $b_ControSerie )
        {
            $o_SR_MovimientoBN->setControlEstadoSerie( SR_MovimientoBN::CTRL_ESTADO_SERIE_PENDIENTE );
        }

        $o_SerieBL = new SerieBL();
        $o_SerieBL->validarMovimientoH( $o_SR_MovimientoBN );
    }
}