<?php
class ChangePriceAction extends wtActions 
{
    public function execute()
    {
        $s_IdItem       = $this->getRequestParameter( 'IdItem' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        $s_Secuencia    = $this->getRequestParameter( 'Secuencia' );
        $s_IdTipoPrecio = $this->getRequestParameter( 'IdTipoPrecio' );

        $s_EsPromocion  = $this->getRequestParameter( 'chk_espromo' );
        $s_TipPromocion = $this->getRequestParameter( 'cbo_tipopromo' );

        $i_IdUnidad     = intval( $this->getRequestParameter( 'IdUnidad' ) );
        $f_PrecioPersa  = floatval( $this->getRequestParameter( 'txt_precio' ) );
        
        $a_Ids = explode( "_", $i_Id );
        $s_IdTipoDocumento = $a_Ids[0];
        $s_IdCompania      = $a_Ids[1];
        $s_NumeroDocumento = $a_Ids[2];
        
        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
            $o_VTA_DocumentoDetalleBN->setSecuencia( ( int ) $s_Secuencia );
            $o_VTA_DocumentoDetalleBN->setItemCodigo( $s_IdItem );
            $o_VTA_DocumentoDetalleBN->setIdCompania( ( int ) $s_IdCompania );
            $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $s_IdTipoDocumento );
            $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $s_NumeroDocumento );
            $o_VTA_DocumentoDetalleBN->setCondicion( 1 );
            $o_VTA_DocumentoDetalleBN->setIdUnidad( $i_IdUnidad );
            $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( $s_IdTipoPrecio );
            $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( $f_PrecioPersa );
            $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( $f_PrecioPersa );

            if( $s_EsPromocion )
            {
                $o_VTA_DocumentoDetalleBN->setNumeroPromocion( '1' );
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( 0 );
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( 0 );
                $o_VTA_DocumentoDetalleBN->setTipoIGV( $s_TipPromocion );
            }
            
            $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();
            $o_OrdenVentaDetalleBL->iniciarCambioPrecio( $o_VTA_DocumentoDetalleBN );
            
            $con->commit();
            
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}