<?php
class ncredActions extends wtActions
{
    public function executeList()
    {
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_IdCompania = myUser::getUser()->getIdBusiness();
        
        $x = myUser::getUser()->getNameSucursal();
        
        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->setEstado( "A" );
        $o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::CodigoFiscal, "<>", "" );
        //$o_VTA_TipoDocumentoFN->setIdTipoDocumento( "NC" );
        $this->a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        
        //$this->a_Estados = VTA_DocumentoBN::getArrayEstados();
        //$this->a_Estados = array( VTA_DocumentoBN::ESTADO_CERRADO => "CERRADO", VTA_DocumentoBN::ESTADO_ANULADO => "ANULADO" );
        $this->a_Estados = array( VTA_DocumentoBN::ESTADO_CERRADO => VTA_DocumentoBN::getArrayEstados( VTA_DocumentoBN::ESTADO_CERRADO ) );
        
        $this->GlobalAccess = myUser::getUser()->hasGlobalAccess();
        
        $this->a_ALM_AlmacenMast = array();
        if( $this->GlobalAccess )
        {
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastFN->setIdCompania( $this->i_IdCompania );
            $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
            $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        }
        
        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoFN->setEstado( "A" );
        $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal );
        $this->a_VTA_FormaPago = $o_VTA_FormaPagoFN->select();
        
        $o_VTA_VendedorFN = new VTA_VendedorFN();
        $o_VTA_VendedorFN->addOrderBy( VTA_VendedorFN::FechaCreacion );
        $this->a_VTA_Vendedor = $o_VTA_VendedorFN->select();
    }
    
    public function executeDocNoCred()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nota de Credito";
        
        $a_Ids = explode( "_", $this->i_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];
        
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $this->o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $IdTipoDocumento, $IdCompania, $NumeroDocumento );
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_VTA_DocumentoBN->getMonedaDocumento() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $this->o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $this->o_VTA_DocumentoBN->getClienteNumero() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        //la forma de pago
        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoFN->setEstado( "A" );
        $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal  );
        $this->a_VTA_FormaPago = $o_VTA_FormaPagoFN->select();
        
        $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
        $o_VTA_DocumentoDetalleFN->setIdTipoDocumento( $IdTipoDocumento );
        $o_VTA_DocumentoDetalleFN->setIdCompania( $IdCompania );
        $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $NumeroDocumento );
        $a_Result = $o_VTA_DocumentoDetalleFN->select();
        $this->a_VTA_DocumentoDetalle = array();
        if( $a_Result )
        {
            $this->a_VTA_DocumentoDetalle = $a_Result;
        }
    }
    
    public function executeGenerarNC()
    {
        $s_Id       = $this->getRequestParameter( 'i_Id' );
        
        $a_Ids = explode( "_", $s_Id );
        $IdTipoDocumento = $a_Ids[0];
        $IdCompania      = ( int) $a_Ids[1];
        $NumeroDocumento = $a_Ids[2];
        
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            //SE SETEA DATOS PARA CABECERA
            $s_SerieNC  = $this->getRequestParameter( 'SerieNC' );
            $s_NumeroNC = $this->getRequestParameter( 'NumeroNC' );
            $s_FechaDoc = $this->getRequestParameter( 'FechaDocumentoNC' );
            $s_IdMotivo = $this->getRequestParameter( 'IdMotivo' );

            //VALIDACION DE FECHA
            $b_Result = UtilDate::validar_fecha( $s_FechaDoc );
            if( !$b_Result )
            {
                throw new Exception( "Ingrese una fecha valida para la emision de NC." );
            }
            //////////////////////

            $s_FechaDoc = $s_FechaDoc." ".date( "H:i:s" ); //SE AGREGA LA HORA

            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setIdCompania( $IdCompania );
            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            $o_VTA_DocumentoBN->setNumeroDocumento( $NumeroDocumento );
            $o_VTA_DocumentoBN->setIdMotivo( intval( $s_IdMotivo ) );
            $o_VTA_DocumentoBN->setFechaDocumento( $s_FechaDoc );
            $o_VTA_DocumentoBN->setDocumentoSerie( $s_SerieNC ); //SERIE ASIGNADO A LA NC
            $o_VTA_DocumentoBN->setDocumentoNumero( $s_NumeroNC ); //NUMERO ASIGNADO A LA NC
            $o_VTA_DocumentoBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            if( $this->getRequestParameter( 'ClienteNumero' ) )
            {
                $o_VTA_DocumentoBN->setClienteNumero( $this->getRequestParameter( 'ClienteNumero' ) );
            }
            
            //DATOS PARA LOS DETALLES
            $a_IdItem            = $this->getRequestParameter( 'IdItem' );
            $a_Secuencia         = $this->getRequestParameter( 'Secuencia' );
            $a_IdLote            = $this->getRequestParameter( 'IdLote' );
            $a_Cantidad          = $this->getRequestParameter( 'Cantidad' );

            $a_PrecioUnitario    = $this->getRequestParameter( 'PrecioUnitario' );
            $a_PrecioUnitarioInc = $this->getRequestParameter( 'PrecioUnitarioIncluido' );
            $a_PrecioUnitarioMN    = $this->getRequestParameter( 'PrecioUnitarioMN' );
            $a_PrecioUnitarioIncMN = $this->getRequestParameter( 'PrecioUnitarioIncluidoMN' );

            $a_IGVExoneradoFlag  = $this->getRequestParameter( 'IGVExoneradoFlag' );
            $a_AlmacenCodigo     = $this->getRequestParameter( 'AlmacenCodigo' );
            $a_Secuencia         = $this->getRequestParameter( 'Secuencia' );
            $a_VTA_DocumentoDetalle = array();
            if( count( $a_IdItem ) <= 0 )
            {
                throw new Exception( "No se puede generar NC si no se tiene detalles." );
            }
            foreach ( $a_IdItem as $i_Key => $IdItem )
            {
                $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
                $o_VTA_DocumentoDetalleBN->setItemCodigo( $IdItem );
                $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $a_AlmacenCodigo[$i_Key] );
                $o_VTA_DocumentoDetalleBN->setIdCompania( $IdCompania );
                $o_VTA_DocumentoDetalleBN->setLote( $a_IdLote[$i_Key] );
                $o_VTA_DocumentoDetalleBN->setCantidadPedida( floatval( $a_Cantidad[$i_Key] ) );
                //$o_VTA_DocumentoDetalleBN->setCantidadEntregada( 0 );
                $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( $a_IGVExoneradoFlag[$i_Key] );
                //$o_VTA_DocumentoDetalleBN->setNumeroDocumento( $NumeroDocumento );
                //$o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $IdTipoDocumento );

                $o_VTA_DocumentoDetalleBN->setPrecioUnitario( floatval( $a_PrecioUnitario[$i_Key] ) );
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( floatval( $a_PrecioUnitarioInc[$i_Key] ) );
                $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( floatval( $a_PrecioUnitarioMN[$i_Key] ) );
                $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( floatval( $a_PrecioUnitarioIncMN[$i_Key] ) );

                $o_VTA_DocumentoDetalleBN->setSecuencia( ( int ) $a_Secuencia[$i_Key] );
                
                $a_VTA_DocumentoDetalle[] = $o_VTA_DocumentoDetalleBN;
            }
            
            $o_VTA_DocumentoBN->setArrayDocumentoDetalle( $a_VTA_DocumentoDetalle );
            $o_VTA_DocumentoBN->setForzarMovimientoInventario( true );

            $o_OrdenVentaBL = new OrdenVentaBL();
            $b_Result = $o_OrdenVentaBL->generarNotaCredito( $o_VTA_DocumentoBN );
            
            $con->commit();
            
            $a_Rs['error']    = false;
            $a_Rs['id']       = $s_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}