<?php
class ProcAPISunatAction extends wtActions
{
    public function __construct()
    {
    }

    public function execute()
    {
        $this->executeProcAPI();
    }

    public function executeProcAPI()
    {

        $i_IdFact = null;
        if( $this->getRequestParameter( 'id' ) )
        {
            $i_IdFact = intval( $this->getRequestParameter( 'id' ) );
        }

        /*if( $this->id_request )
        {
            $i_IdFact = intval( $this->id_request );
        }*/

        $this->externo          = $this->getRequestParameter( 'externo' );
        $this->recargarExterno  = true;

        $b_ControlAnulado = false;
        $this->mensaje_error = "";
        $this->o_VTA_FacturacionElectronicaBN = new VTA_FacturacionElectronicaBN();

        $con = Conexion::getConexion();
        //$con->begin();
        try
        {
            myUser::getUser()->validar_session();

            if( !$i_IdFact )
            {
                throw new Exception( "El Id de Comprobante es importante." );
            }

            //buscamos en la bandeja
            $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
            $o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $i_IdFact );

            //ahora buscamos el documento
            $o_VTA_DocumentoFN = new VTA_DocumentoFN();
            $o_VTA_DocumentoBN = $o_VTA_DocumentoFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getTipo(), $o_VTA_FacturacionElectronicaBN->getIdCompania(), $o_VTA_FacturacionElectronicaBN->getFactElecId() );

            //se pregunta si esta anulado, si es true, tiene un procedimiento diferente
            if( $o_VTA_DocumentoBN->getEstado() == VTA_DocumentoBN::ESTADO_ANULADO )
            {
                $b_ControlAnulado = true;

                //aqui se agrega una validacion mas, si esta anulado en documentos, pero paso algo, y no se actualizo en fael
                if( $o_VTA_FacturacionElectronicaBN->getEstadoWeb() != $o_VTA_DocumentoBN->getEstado() )
                {
                    //se debe de actualiza a anulado
                    /*$o_VTA_FacturacionElectronicaBN->setEstadoWeb( VTA_DocumentoBN::ESTADO_ANULADO );
                    $o_VTA_FacturacionElectronicaBN->setAnuMotivo( $o_VTA_DocumentoBN->getAnulacionComentario() );
                    $o_VTA_FacturacionElectronicaBN->setAnuAceptadaPorSunat( "NO" );
                    //
                    $o_FacturacionElectronicaBL = new FacturacionElectronicaBL();
                    $o_FacturacionElectronicaBL->anularComprobante( $o_VTA_FacturacionElectronicaBN );*/
                }

                //aqui la factura o boleta tiene que estar en el proveedor para la baja del comprobante

                if( $o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() == "SI" )
                    //if( $o_VTA_FacturacionElectronicaBN->getEnlace() )
                {
                    //se valida que si ya tiene un proceso de anulacion, se hace diferentes proceso
                    if( $o_VTA_FacturacionElectronicaBN->getAnuSunatTicketNumero() )
                    {
                        if( $o_VTA_FacturacionElectronicaBN->getAnuAceptadaPorSunat() == "PE" )
                        {
                            $s_Api = "";
                            if( $o_VTA_FacturacionElectronicaBN->getTipo() == "BV" )
                            {
                                $s_Api  = "summaries/status";
                            }
                            if( $o_VTA_FacturacionElectronicaBN->getTipo() == "FC" )
                            {
                                $s_Api  = "voided/status";
                            }
                            //aqui se procede a realizar la consulta de la anulacion del documento
                            $a_data = array
                            (
                                "external_id" => $o_VTA_FacturacionElectronicaBN->getAnuSunatResponseCode(),
                                "ticket"      => $o_VTA_FacturacionElectronicaBN->getAnuSunatTicketNumero()
                            );

                            $s_data_json = json_encode( $a_data );

                            $a_respuesta = $this->executeCurl( $s_data_json, $o_VTA_FacturacionElectronicaBN->getIdCompania(), $s_Api );

                            $this->updateDocumentxAnullConTicket( $a_respuesta, $o_VTA_FacturacionElectronicaBN );
                        }

                        $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
                        $o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $i_IdFact );

                        $this->o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaBN;
                        return ViewResponse::SUCCESS;
                    }
                    else
                    {
                        //ahora se realiza le procedimiento de baja de los comprobantes
                        $s_Api = "";
                        $a_data = array();
                        if( $o_VTA_FacturacionElectronicaBN->getTipo() == "BV" )
                        {
                            $s_Api  = "summaries";
                            $a_data = array(
                                "fecha_de_emision_de_documentos" => substr( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), 0, 10 ),
                                "codigo_tipo_proceso"            => "3",
                                "documentos"                     => array(
                                    array(
                                        "external_id"      => $o_VTA_FacturacionElectronicaBN->getSunatResponseCode(),
                                        "motivo_anulacion" => $o_VTA_FacturacionElectronicaBN->getAnuMotivo()
                                    )
                                )
                            );
                        }
                        if( $o_VTA_FacturacionElectronicaBN->getTipo() == "FC" )
                        {
                            $s_Api  = "voided";
                            $a_data = array(
                                "fecha_de_emision_de_documentos" => substr( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), 0, 10 ),
                                "documentos"                     => array(
                                    array(
                                        "external_id"      => $o_VTA_FacturacionElectronicaBN->getSunatResponseCode(),
                                        "motivo_anulacion" => $o_VTA_FacturacionElectronicaBN->getAnuMotivo()
                                    )
                                )
                            );
                        }

                        //pr( $a_data, false );
                        $s_data_json = json_encode( $a_data );
                        //pr( $s_data_json );

                        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        //Invocamos el servicio de NUBEFACT - para la anulacion del documento
                        $a_respuesta = $this->executeCurl( $s_data_json, $o_VTA_FacturacionElectronicaBN->getIdCompania(), $s_Api );
                        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                        //se actualiza en la tabla bandeja
                        if( $a_respuesta )
                        {
                            $this->updateDocumentxAnull( $a_respuesta, $o_VTA_FacturacionElectronicaBN );

                            $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
                            $o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $i_IdFact );

                            $this->o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaBN;
                            return ViewResponse::SUCCESS;
                        }
                        else
                        {
                            throw new Exception( "No hay respuesta del Servidor de Facturacion Electronica." );
                        }
                    }
                }
                else
                {
                    //por ahora se comenta si aun no se ha enviado a la sunat
                    //throw new Exception( "El Comprobante esta Anulado, pero tiene que estar aceptado por Sunat para dar su baja." );
                }
                return ViewResponse::SUCCESS;
            }

            if( $o_VTA_FacturacionElectronicaBN->getAceptadaxSunat() == "SI" )
            {

                /*if( !$o_VTA_FacturacionElectronicaBN->getCDRResult() )
                {
                    //para boletas no es muy importante, ademas es por lote, varias boletas
                    //puede estar en un cdr
                    //facturas es de uno a uno en cdr
                    if( $o_VTA_FacturacionElectronicaBN->getTipo() != "BV" )
                    {
                        $this->mensaje_error = "";
                        $this->findDocument( $o_VTA_FacturacionElectronicaBN );
                    }
                }
                $this->recargarExterno  = false;
                $this->o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaBN;
                return ViewResponse::SUCCESS;*/
            }

            if( $o_VTA_FacturacionElectronicaBN->getEnlace() && $o_VTA_FacturacionElectronicaBN->getCodigoHashQR() )
            {
                //en este procedimiento indica que ya se envio al proveedor y que falta preguntar si la sunat ua acepto
                /*$this->mensaje_error = "";
                $this->findDocument( $o_VTA_FacturacionElectronicaBN );
                $this->o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaBN;
                return ViewResponse::SUCCESS;*/
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //parametros por defecto
            $a_errors = array();
            $a_errors[10] = "No se pudo autenticar, token incorrecto o eliminado";
            $a_errors[11] = "La ruta o URL que estás usando no es correcta o no existe. Ingresa a tu cuenta en www.nubefact.com en la opción Api-Integración para verificar este dato";
            $a_errors[12] = "Solicitud incorrecta, la cabecera (Header) no contiene un Content-Type correcto";
            $a_errors[20] = "El archivo enviado no cumple con el formato establecido";
            $a_errors[21] = "No se pudo completar la operación, se acompaña el problema con un mensaje";
            $a_errors[22] = "Documento enviado fuera del plazo permitido";
            $a_errors[23] = "Este documento ya existe en NubeFacT";
            $a_errors[24] = "El documento indicado no existe o no fue enviado a NubeFacT";
            $a_errors[40] = "Error interno desconocido";
            $a_errors[50] = "Su cuenta ha sido suspendida";
            $a_errors[51] = "Su cuenta ha sido suspendida por falta de pago";

            $a_SunatTpDoc = array( "RUC" => 6, "DNI" => 1, "" => "-", "OTRO" => "-", "EXP" => 0 );
            $a_Moneda     = array( "LO" => 'PEN', "EX" => "USD", "EU" => "EUR" );
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $s_MontoEntero = explode( ".", number_format( $o_VTA_FacturacionElectronicaBN->getMontoTotal(), 2, ".", "" ) );
            $o_NumberToLetter   = new NumberToLetterConverter();
            $s_MontoTotalLetras = $o_NumberToLetter->to_word( $s_MontoEntero[0] );

            $s_MonedaDocumento  = $o_VTA_FacturacionElectronicaBN->getTipoMoneda();
            if( $s_MonedaDocumento == "LO" )
            {
                $s_MontoTotalLetras .= " CON ".$s_MontoEntero[1]." / 100 SOLES";
            }
            else
            {
                $s_MontoTotalLetras .= " CON ".$s_MontoEntero[1]." / 100 DOLARES";
            }

            $s_ClienteTipoDocumento = $o_VTA_FacturacionElectronicaBN->getClienteTipoDoc();

            $s_SunatTransaction = "";
            switch ( $o_VTA_DocumentoBN->getTipoVenta() )
            {
                case "MER": //para el caso de -> VENTA INTERNA
                    $s_SunatTransaction = "1";
                    break;
                case "EXP": //EXPORTACIÓN
                    $s_SunatTransaction     = "2";
                    $s_ClienteTipoDocumento = "EXP";
                    break;
                case "ANT": //VENTA INTERNA – ANTICIPOS
                    $s_SunatTransaction     = "4";
                    //$s_ClienteTipoDocumento = "EXP";
                    break;
                case "DET": //DETRACCIONES
                    $s_SunatTransaction     = "30";
                    break;

            }

            //SE AGREGA UNA CONDICIONAL, SI TIENE MONTO ANTICIPO, SE CONSIDERA ANTICIPO REGULARIZACION
            if( $o_VTA_FacturacionElectronicaBN->getMontoAnticipo() > 0 )
            {
                $s_SunatTransaction     = "4";
            }

            if( $s_SunatTransaction == "" )
            {
                throw new Exception( "No se identifico el tipo de transaccion para la sunat." );
            }

            //$s_ComentarioDocumento = trim( $o_VTA_DocumentoBN->getComentario() );
            $s_ComentarioDocumento = "Vend: ".$o_VTA_DocumentoBN->getVendedor();

            $a_data = array
            (
                //"operacion"                         => "generar_comprobante",

                "serie_documento"                   => $o_VTA_FacturacionElectronicaBN->getSerie(),
                "numero_documento"                  => intval( $o_VTA_FacturacionElectronicaBN->getNumero() ),
                "fecha_de_emision"                  => substr( $o_VTA_FacturacionElectronicaBN->getFechaEmision(), 0, 10 ),
                "hora_de_emision"                   => UtilDate::getFormatDate( $o_VTA_FacturacionElectronicaBN->getFechaCreacion(), "H:i:s" ),
                "codigo_tipo_operacion"             => "0101",
                "codigo_tipo_documento"               => $o_VTA_DocumentoBN->getObjectTipoDocumento()->getCodigoFiscal(),
                "codigo_tipo_moneda"                => $a_Moneda[$o_VTA_FacturacionElectronicaBN->getTipoMoneda()],
                //"sunat_transaction"                 => $s_SunatTransaction,
                "fecha_de_vencimiento"              => substr( $o_VTA_FacturacionElectronicaBN->getFechaVencimiento(), 0, 10 ), //$o_VTA_FacturacionElectronicaBN->getFechaVencimiento() ? $o_VTA_FacturacionElectronicaBN->getFechaVencimiento() : "",
                //"tipo_de_cambio"                    => $o_VTA_FacturacionElectronicaBN->getTipoMoneda()=="EX" ? $o_VTA_FacturacionElectronicaBN->getTipoCambio() : "",
                //"numero_orden_de_compra"            => "",
                //"porcentaje_de_igv"                 => $o_VTA_FacturacionElectronicaBN->getPorcentajeIGV(),

                "datos_del_cliente_o_receptor"      => array(
                    "codigo_tipo_documento_identidad"       => $a_SunatTpDoc[$s_ClienteTipoDocumento],
                    "numero_documento"                      => $o_VTA_FacturacionElectronicaBN->getClienteDocNum(),
                    "apellidos_y_nombres_o_razon_social"    => $o_VTA_FacturacionElectronicaBN->getClienteNom(),
                    "codigo_pais"                           => "PE",
                    "ubigeo"                                => "",
                    "direccion"                             => $o_VTA_FacturacionElectronicaBN->getClienteDireccion(),
                    "correo_electronico"                    => "",
                    "telefono"                              => ""
                ),

                "totales"                           => array(
                    "total_descuentos" => "",
                    "total_exportacion" => "",
                    "total_operaciones_gravadas" => $o_VTA_FacturacionElectronicaBN->getMontoAfecto(),
                    "total_operaciones_inafectas" => $o_VTA_FacturacionElectronicaBN->getMontoInafecto(),
                    "total_operaciones_exoneradas" => $o_VTA_FacturacionElectronicaBN->getMontoExonerado(),
                    "total_operaciones_gratuitas" => 0.00,
                    "total_igv" => $o_VTA_FacturacionElectronicaBN->getImpuesto(),
                    "total_impuestos" => $o_VTA_FacturacionElectronicaBN->getImpuesto(),
                    "total_valor" => $o_VTA_FacturacionElectronicaBN->getMontoAfecto(),
                    "total_venta" => $o_VTA_FacturacionElectronicaBN->getMontoTotal(),
                ),
            );

            if( $o_VTA_FacturacionElectronicaBN->getMontoDescuento() )
            {

            }
            if( $o_VTA_DocumentoBN->getOrdenCompraRef() )
            {
                $a_data['numero_orden_de_compra'] = $o_VTA_DocumentoBN->getOrdenCompraRef();
            }
            ///////////////////////////////////////////////////////////////////////////
            //AHORA SE MUESTRA EL MEDIO DE PAGO - 2021-09-20
            $a_data['codigo_condicion_de_pago'] = "01"; //POR DEFECTO CONTADO

            $o_FCO_AplicacionFN = new FCO_AplicacionFN();
            $o_FCO_AplicacionFN->setIdDocNumRef( $o_VTA_DocumentoBN->getNumeroDocumento() );
            $o_FCO_AplicacionFN->setEstado( FCO_AplicacionBN::ESTADO_APLICADO );
            $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
            $s_MedioPago      = "";
            if( $a_FCO_Aplicacion )
            {
                foreach( $a_FCO_Aplicacion as $o_FCO_AplicacionBN )
                {
                    $s_Descripcion = $o_FCO_AplicacionBN->getTipoPagoNombre();
                    if( $o_FCO_AplicacionBN->getIdTipoPago() != 1 )
                    {
                        $s_Descripcion .= " OP: ".$o_FCO_AplicacionBN->getReciboNumero();
                    }

                    $a_DataMedioPago[] = $s_Descripcion;
                }
                $s_MedioPago = implode( " | ", $a_DataMedioPago );
            }
            else
            {
                if( $o_VTA_DocumentoBN->getFormaPagoCod() == VTA_DocumentoBN::FORMA_PAGO_COD_CON )
                {
                    //puede que sea al contado pero aun no ha pagado
                    $s_MedioPago = "Contado";
                }
                if( $o_VTA_DocumentoBN->getFormaPagoCod() == VTA_DocumentoBN::FORMA_PAGO_COD_CRE )
                {
                    //aqui es credito y buscamos las cuotas
                    $s_MedioPago                        = "Credito";
                    $a_data['codigo_condicion_de_pago'] = "02";

                    $o_VTA_DocumentoCuotasFN = new VTA_DocumentoCuotasFN();
                    $o_VTA_DocumentoCuotasFN->setNumeroDocumentoId( $o_VTA_DocumentoBN->getNumeroDocumento() );
                    $o_VTA_DocumentoCuotasFN->addOrderBy( VTA_DocumentoCuotasFN::CuotaId );
                    $a_VTA_DocumentoCuotas = $o_VTA_DocumentoCuotasFN->select();
                    if( $a_VTA_DocumentoCuotas )
                    {
                        $a_DataCuota = array();
                        foreach ( $a_VTA_DocumentoCuotas as $o_VTA_DocumentoCuotasBN )
                        {
                            $a_DataCuota[] = array(
                                "fecha" => $o_VTA_DocumentoCuotasBN->getCuotaFecha(),
                                "codigo_tipo_moneda" => $a_Moneda[$o_VTA_FacturacionElectronicaBN->getTipoMoneda()],
                                "monto" => $o_VTA_DocumentoCuotasBN->getCuotaMonto()
                            );
                        }
                        $a_data['cuotas'] = $a_DataCuota;
                    }
                    else
                    {
                        throw new Exception( "El comprobante esta configurado al credito, pero no se encontro las cuotas." );
                    }
                }

            }
            $a_data['informacion_adicional'] = "Forma de pago: ".$s_MedioPago." | ".$s_ComentarioDocumento;

            ///////////////////////////////////////////////////////////////////////////

            ///////////////////////////////////////////////////////////////////////////
            //AHORA SE AGREGA EL PROCEDIMIENTO PARA FACTURAS AL CREDITO
            $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
            $o_VTA_FormaPagoBN = $o_VTA_FormaPagoFN->selectByPK( $o_VTA_DocumentoBN->getIdFormaPago() );
            ///////////////////////////////////////////////////////////////////////////

            if( $o_VTA_DocumentoBN->getIdTipoDocumento() == "NC" )
            {
                unset( $a_data['fecha_de_vencimiento'] );
                unset( $a_data['codigo_condicion_de_pago'] );
                unset( $a_data['informacion_adicional'] );

                $o_VTA_TipoDocumentoMotivoFN = new VTA_TipoDocumentoMotivoFN();
                $o_VTA_TipoDocumentoMotivoBN = $o_VTA_TipoDocumentoMotivoFN->selectByPK( $o_VTA_DocumentoBN->getIdMotivo() );
                if( !$o_VTA_TipoDocumentoMotivoBN )
                {
                    throw new Exception( "No se encontro el motivo para la Nota de Credito." );
                }

                //ahora buscamos el documento relacionado
                $o_TMP_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
                $o_TMP_VTA_FacturacionElectronicaBN = $o_TMP_VTA_FacturacionElectronicaFN->selectByPK( $o_VTA_DocumentoBN->getDocumentoParentId() );
                if( $o_TMP_VTA_FacturacionElectronicaBN )
                {
                    $a_data['documento_afectado'] = array( "external_id" => $o_TMP_VTA_FacturacionElectronicaBN->getSunatResponseCode() );
                }

                $a_data['codigo_tipo_nota'] = $o_VTA_TipoDocumentoMotivoBN->getCodigoFiscal();
                $a_data['motivo_o_sustento_de_nota'] = $o_VTA_TipoDocumentoMotivoBN->getDescripcion();
                $a_data['acciones'] = array( "formato_pdf" => "a4" );
            }

            $a_VTA_DocumentoDet = $o_VTA_DocumentoBN->getArrayObjectDetalles();

            $f_TotalGratuito = 0;
            $data_det = array();

            foreach ( $a_VTA_DocumentoDet as $key => $o_VTA_DocumentoDetalleBN )
            {
                if( $o_VTA_DocumentoDetalleBN->getTipoDetalle() == VTA_DocumentoDetalleBN::TIPO_DETALLE_COMENTARIO )
                {
                    continue;
                }

                $f_PrecioUnitario = $o_VTA_DocumentoDetalleBN->getPrecioUnitario();
                if( $o_VTA_DocumentoDetalleBN->getTipoIGV() )
                {
                    $o_MST_TipoAfectacionIGVFN = new MST_TipoAfectacionIGVFN();
                    $o_MST_TipoAfectacionIGVBN = $o_MST_TipoAfectacionIGVFN->selectByPK( $o_VTA_DocumentoDetalleBN->getTipoIGV() );
                    if( $o_MST_TipoAfectacionIGVBN )
                    {
                        $s_tipo_igv = $o_MST_TipoAfectacionIGVBN->getCodigoSunat();
                    }
                }

                if( $o_VTA_DocumentoBN->getTipoVenta() == "EXP" )
                {
                    $s_tipo_igv = "16";
                }

                $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_VTA_DocumentoDetalleBN->getItemCodigo() );

                //buscamos si bonificaciones
                if( $o_VTA_DocumentoDetalleBN->getPrecioUnitario() <= 0 )
                {
                    //ahora se recupera el valor por referencia
                    $o_ALM_ItemMastBN = is_null( $o_ALM_ItemMastBN ) ? new ALM_ItemMastBN() : $o_ALM_ItemMastBN;
                    $f_PrecioUnitario = !$o_ALM_ItemMastBN->getPrecioCosto() ? 0 : $o_ALM_ItemMastBN->getPrecioCosto();

                    $f_TotalGratuito += $f_PrecioUnitario * $o_VTA_DocumentoDetalleBN->getCantidadPedida();

                    //$s_tipo_igv = "10";
                }

                $data_det[] = array
                (
                    "codigo_interno"            => $o_VTA_DocumentoDetalleBN->getItemCodigo(),
                    "descripcion"               => $o_VTA_DocumentoDetalleBN->getDescripcion(),
                    "codigo_producto_sunat"     => $o_ALM_ItemMastBN->getCodigoSunat(),
                    "unidad_de_medida"          => $o_VTA_DocumentoDetalleBN->getObjectUnidad()->getCodigoSunat(),
                    "cantidad"                  => $o_VTA_DocumentoDetalleBN->getCantidadPedida(),
                    "valor_unitario"            => $f_PrecioUnitario,
                    "codigo_tipo_precio"        => "01",
                    "precio_unitario"           => $o_VTA_DocumentoDetalleBN->getMontoIncImpuestoUnidad(),
                    "codigo_tipo_afectacion_igv"=> $s_tipo_igv,
                    "total_base_igv"            => $o_VTA_DocumentoDetalleBN->getMontoSubTotal(),
                    "porcentaje_igv"            => "18",
                    "total_igv"                 => $o_VTA_DocumentoDetalleBN->getMontoSubTotalImpuesto(),
                    "total_impuestos"           => $o_VTA_DocumentoDetalleBN->getMontoSubTotalImpuesto(),
                    "total_valor_item"          => $o_VTA_DocumentoDetalleBN->getMontoSubTotal(),
                    "total_item"                => $o_VTA_DocumentoDetalleBN->getMontoTotalNeto()
                );
            }

            $a_data['items'] = $data_det;

            $s_data_json = json_encode( $a_data );
            //pr( $a_data ); exit;

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //Invocamos el servicio de NUBEFACT
            $a_respuesta = $this->executeCurl( $s_data_json, $o_VTA_FacturacionElectronicaBN );
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            if( $a_respuesta )
            {
                $a_respuesta['es_anulado'] = false;
                if( $b_ControlAnulado )
                {
                    $a_respuesta['es_anulado'] = true;
                }
                $this->updateDocument( $a_respuesta, $o_VTA_FacturacionElectronicaBN );
            }
            else
            {
                throw new Exception( "No hay respuesta del Servidor de Facturacion Electronica." );
            }

            $this->o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $i_IdFact );
        }
        catch ( Exception $o_Exception )
        {
            //pr( $o_Exception );
            $this->mensaje_error = $o_Exception->getMessage();
        }
    }

    public function executeProcDemo()
    {
        error_reporting( E_ALL ^ E_NOTICE );
        $bodyRequest = file_get_contents( "php://input" );
        //pr( $bodyRequest );
        $cab = json_decode( $bodyRequest, true );
        //pr( $cab );

        return ViewResponse::NONE;
    }

    private function executeCurl( $s_data_json, $o_VTA_FacturacionElectronicaBN )
    {
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        ///recuperamos los parametros
        if( $o_VTA_FacturacionElectronicaBN->getIdSucursal() )
        {
            $o_GSS_SucursalFN = new GSS_SucursalFN();
            $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getIdSucursal() );

            $RUTA_API  = $o_GSS_SucursalBN->getRutaProveedorExt()."/api/documents";
            $TOKEN_API = $o_GSS_SucursalBN->getTokenProveedorExt();
        }
        else
        {
            throw new Exception( "La Sucursal no esta seleccionada." );
        }

        if( empty( $RUTA_API ) )
        {
            throw new Exception( "No tiene RUTA para registrar al Proveedor." );
        }

        if( empty( $TOKEN_API ) )
        {
            throw new Exception( "No tiene TOKEN para registrar al Proveedor." );
        }

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Invocamos el servicio de
        $ch = curl_init();
        // Check if initialization had gone wrong*
        if ($ch === false) {
            throw new Exception('failed to initialize');
        }
        // Better to explicitly set URL
        curl_setopt( $ch, CURLOPT_URL, $RUTA_API );
        curl_setopt( $ch, CURLOPT_CUSTOMREQUEST, "POST" );
        curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt( $ch, CURLOPT_FOLLOWLOCATION, 1 );
        curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, 0 );
        curl_setopt( $ch, CURLOPT_SSL_VERIFYHOST, 0 );
        curl_setopt( $ch, CURLOPT_POSTFIELDS, $s_data_json );

        $authorization = "Authorization: Bearer ".$TOKEN_API; // Prepare the authorisation token
        //curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);
        curl_setopt( $ch, CURLOPT_RETURNTRANSFER, true );
        curl_setopt( $ch, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json; charset=utf-8',
                'Content-Length: ' . strlen( $s_data_json ),
                $authorization
            )
        );
        curl_setopt( $ch, CURLOPT_TIMEOUT, 900 );
        curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 500 );

        $respuesta  = curl_exec( $ch );
        curl_close( $ch );
        if( $respuesta === false )
        {
            throw new Exception(curl_error( $ch ), curl_errno( $ch ) );
        }
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_respuesta = json_decode( $respuesta, true );
        //pr( $respuesta );
        //pr( $a_respuesta );

        //ahora se guarda el json
        $o_VTA_FacturacionElectronicaDP = new VTA_FacturacionElectronicaDP();
        $o_VTA_FacturacionElectronicaDP->setFactElecId( $o_VTA_FacturacionElectronicaBN->getFactElecId() );
        $o_VTA_FacturacionElectronicaDP->setDataJson( $respuesta );
        $o_VTA_FacturacionElectronicaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_VTA_FacturacionElectronicaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_FacturacionElectronicaDP->update();
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        return $a_respuesta;
    }

    private function updateDocumentxAnullConTicket( $a_respuesta, $o_VTA_FacturacionElectronicaBN )
    {
        $o_VTA_FacturacionElectronicaDP = new VTA_FacturacionElectronicaDP();
        $o_VTA_FacturacionElectronicaDP->setFactElecId( $o_VTA_FacturacionElectronicaBN->getFactElecId() );

        if( isset( $a_respuesta['success'] ) && $a_respuesta['success'] )
        {
            $o_VTA_FacturacionElectronicaDP->setEstado( VTA_FacturacionElectronicaBN::ESTADO_ANULADO );
            //$o_VTA_FacturacionElectronicaDP->setAnuNumero( intval( $a_respuesta['numero'] ) );
            $o_VTA_FacturacionElectronicaDP->setAnuAceptadaPorSunat( "SI" );
            $o_VTA_FacturacionElectronicaDP->setAnuEnlace( $a_respuesta['data']['filename'] );
            $o_VTA_FacturacionElectronicaDP->setAnuXMLResult( $a_respuesta['links']['xml'] );
            $o_VTA_FacturacionElectronicaDP->setAnuCDRResult( $a_respuesta['links']['cdr'] );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatDescripcion( $a_respuesta['response']['description'] );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatNote( json_encode( $a_respuesta['response']['notes'] ) );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatResponseCode( $a_respuesta['response']['code']."|".$a_respuesta['response']['is_accepted']."|".$a_respuesta['response']['status_code'] );
            //$o_VTA_FacturacionElectronicaDP->setAnuKey( $a_respuesta['response']['sent'] );
        }
        $o_VTA_FacturacionElectronicaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_VTA_FacturacionElectronicaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_FacturacionElectronicaDP->update();

        return true;
    }
    
    private function updateDocumentxAnull( $a_respuesta, $o_VTA_FacturacionElectronicaBN )
    {
        $o_VTA_FacturacionElectronicaDP = new VTA_FacturacionElectronicaDP();
        $o_VTA_FacturacionElectronicaDP->setFactElecId( $o_VTA_FacturacionElectronicaBN->getFactElecId() );

        if( isset( $a_respuesta['success'] ) && $a_respuesta['success'] )
        {
            $o_VTA_FacturacionElectronicaDP->setEstado( VTA_FacturacionElectronicaBN::ESTADO_ANULADO );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatTicketNumero( $a_respuesta['data']['ticket'] );
            $o_VTA_FacturacionElectronicaDP->setAnuAceptadaPorSunat( "PE" );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatResponseCode( $a_respuesta['data']['external_id'] );
        }

        /*if( isset( $a_respuesta['errors'] ) )
        {
            $o_VTA_FacturacionElectronicaDP->setAnuSunatTicketNumero( "000000" );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatSoapError( str_replace( array( "'", "`" ), array( "", "" ), $a_respuesta['errors'] ) );
            $o_VTA_FacturacionElectronicaDP->setCodigoError( $a_respuesta['codigo']."" );
        }
        else
        {
            $o_VTA_FacturacionElectronicaDP->setEstado( VTA_FacturacionElectronicaBN::ESTADO_ANULADO );
            $o_VTA_FacturacionElectronicaDP->setAnuNumero( intval( $a_respuesta['numero'] ) );
            $o_VTA_FacturacionElectronicaDP->setAnuEnlace( $a_respuesta['enlace'] );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatTicketNumero( $a_respuesta['sunat_ticket_numero'] );
            $o_VTA_FacturacionElectronicaDP->setAnuAceptadaPorSunat( $a_respuesta['aceptada_por_sunat'] ? "SI" : "NO" );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatDescripcion( $a_respuesta['sunat_description'] );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatNote( $a_respuesta['sunat_note'] );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatResponseCode( $a_respuesta['sunat_responsecode'] );
            $o_VTA_FacturacionElectronicaDP->setAnuSunatSoapError( $a_respuesta['sunat_soap_error'] );
            $o_VTA_FacturacionElectronicaDP->setAnuPDFResult( $a_respuesta['enlace_del_pdf'] );
            $o_VTA_FacturacionElectronicaDP->setAnuXMLResult( $a_respuesta['enlace_del_xml'] );
            $o_VTA_FacturacionElectronicaDP->setAnuCDRResult( $a_respuesta['enlace_del_cdr'] );
            $o_VTA_FacturacionElectronicaDP->setAnuKey( $a_respuesta['key'] );
        }*/

        $o_VTA_FacturacionElectronicaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_VTA_FacturacionElectronicaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_FacturacionElectronicaDP->update();

        return true;
    }

    private function updateDocument( $a_respuesta, $o_VTA_FacturacionElectronicaBN )
    {
        $o_VTA_FacturacionElectronicaDP = new VTA_FacturacionElectronicaDP();
        $o_VTA_FacturacionElectronicaDP->setFactElecId( $o_VTA_FacturacionElectronicaBN->getFactElecId() );
        $o_VTA_FacturacionElectronicaDP->setEstado( "E" );

        if( isset( $a_respuesta['es_anulado'] ) )
        {
            if( $a_respuesta['es_anulado'] )
            {
                //$o_VTA_FacturacionElectronicaDP->setAnuAceptadaPorSunat( "NO" );
                //$o_VTA_FacturacionElectronicaDP->setEstadoWeb( VTA_DocumentoBN::ESTADO_ANULADO );
            }
        }

        if( isset( $a_respuesta['success'] ) && !$a_respuesta['success'] )
        {
            $o_VTA_FacturacionElectronicaDP->setEstado( "X" );
            $o_VTA_FacturacionElectronicaDP->setErrors( addslashes( $a_respuesta['message'] ) );
            $o_VTA_FacturacionElectronicaDP->setCodigoError( $a_respuesta['line']."" );
            $o_VTA_FacturacionElectronicaDP->setAceptadaxSunat( "NO" );
            $this->mensaje_error = "[ ".addslashes( $a_respuesta['message'] )." ]";
        }
        else
        {
            if( isset( $a_respuesta['success'] ) && $a_respuesta['success'] )
            {
                //ALTER TABLE VTA_FacturacionElectronica MODIFY COLUMN `CodigoHashQR` LONGTEXT DEFAULT NULL;

                $o_VTA_FacturacionElectronicaDP->setErrors( "" );
                $o_VTA_FacturacionElectronicaDP->setCodigoError( "" );
                $o_VTA_FacturacionElectronicaDP->setCodigoErrorDesc( "" );
                $o_VTA_FacturacionElectronicaDP->setEnlace( $a_respuesta['data']['filename'] );
                $o_VTA_FacturacionElectronicaDP->setAceptadaxSunat( ( $a_respuesta['data']['state_type_description'] == "Aceptado" || $a_respuesta['data']['state_type_description'] == "Registrado" ) ? "SI" : "NO" );
                $o_VTA_FacturacionElectronicaDP->setSunatResponseCode( addslashes( $a_respuesta['data']['external_id'] ) );
                $a_Concat1 = array();
                if( isset( $a_respuesta['response']['code'] ) )
                {
                    $a_Concat1[] = $a_respuesta['response']['code'];
                }
                if( isset( $a_respuesta['response']['description'] ) )
                {
                    $a_Concat1[] = $a_respuesta['response']['description'];
                }
                if( isset( $a_respuesta['response']['notes'] ) )
                {
                    $a_Concat1[] = json_encode( $a_respuesta['response']['notes'] );
                }

                $a_Concat1[] = $a_respuesta['data']['state_type_id'];
                //$a_Concat1[] = $a_respuesta['data']['number_to_letter'];
                $o_VTA_FacturacionElectronicaDP->setSunatNote( implode( "|", $a_Concat1 ) );
                $o_VTA_FacturacionElectronicaDP->setSunatDescripcion( addslashes( $a_respuesta['data']['state_type_description'] ) );
                $o_VTA_FacturacionElectronicaDP->setCodigoHash( $a_respuesta['data']['hash'] );
                $o_VTA_FacturacionElectronicaDP->setCodigoHashQR( $a_respuesta['data']['qr'] );
                $o_VTA_FacturacionElectronicaDP->setXMLResult( $a_respuesta['links']['xml'] );
                $o_VTA_FacturacionElectronicaDP->setPDFResult( $a_respuesta['links']['pdf'] );
                $o_VTA_FacturacionElectronicaDP->setCDRResult( $a_respuesta['links']['cdr'] );
            }
            else
            {
                if( isset( $a_respuesta['message'] ) )
                {
                    $b_Fnd = strpos( $a_respuesta['message'], "ya se encuentra registrado" );
                    if( $b_Fnd !== false )
                    {
                        $o_VTA_FacturacionElectronicaDP->setSunatDescripcion( $a_respuesta['message'] );
                    }
                    $o_VTA_FacturacionElectronicaDP->setCodigoErrorDesc( $a_respuesta['message'] );
                }
            }
        }

        $o_VTA_FacturacionElectronicaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
        $o_VTA_FacturacionElectronicaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
        $o_VTA_FacturacionElectronicaDP->update();

        return true;
    }

    private function findDocument( &$o_VTA_FacturacionElectronicaBN )
    {
        $a_data = array
        (
            "operacion"                         => "consultar_comprobante",
            "tipo_de_comprobante"               => $o_VTA_FacturacionElectronicaBN->getTipoComprobante(),
            "serie"                             => $o_VTA_FacturacionElectronicaBN->getSerie(),
            "numero"                            => intval( $o_VTA_FacturacionElectronicaBN->getNumero() )
        );

        $data_json = json_encode( $a_data );

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Invocamos el servicio de NUBEFACT
        $a_respuesta = $this->executeCurl( $data_json, $o_VTA_FacturacionElectronicaBN->getIdCompania() );

        //pr( $a_respuesta ); exit;

        $this->updateDocument( $a_respuesta, $o_VTA_FacturacionElectronicaBN );

        //buscamos en la bandeja
        $o_VTA_FacturacionElectronicaFN = new VTA_FacturacionElectronicaFN();
        $o_VTA_FacturacionElectronicaBN = $o_VTA_FacturacionElectronicaFN->selectByPK( $o_VTA_FacturacionElectronicaBN->getFactElecId() );
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        return true;
    }
}