<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>


<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>

<style>
body
{
    height: 0;
}
fieldset.scheduler-border 
{
    border: 1px solid #ccc !important;
    padding: 0 0.5em 0.5em 0.5em !important;
    /*margin: 0 0 0.5em 0 !important;*/
    margin: 5px !important;
    -webkit-box-shadow: 0px 0px 0px 0px #000;
    box-shadow: 0px 0px 0px 0px #000;
}

legend.scheduler-border 
{
    font-size: 1em !important;
    font-weight: bold !important;
    text-align: left !important;
    width: auto;
    padding: 0 5px;
    border-bottom: none;
    margin-bottom: 0;    
}
</style>

<?php if( $a_VTA_Documento ){ ?>
<fieldset class="scheduler-border">
    <legend class="scheduler-border">Resumen Anticipo</legend>
    <table id="example" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th width="2%" style="text-align: center;"> # </th>
                <th style="text-align: center;">Fecha</th>
                <th style="text-align: center;">Tipo</th>
                <th style="text-align: center;">Nro</th>
                <th style="text-align: center;">Moneda</th>
                <th style="text-align: center;">TC</th>
                <th style="text-align: center;">Sub-Total</th>
                <th style="text-align: center;">IGV</th>
                <th style="text-align: center;">Total</th>
                <th style="text-align: center;">Cobrado</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ( $a_VTA_Documento as $key => $o_VTA_DocumentoBN ) { ?>
            <tr>
                <td align="center"><?=$key+1?></td>
                <td align="center"><?=substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 )?></td>
                <td align="center"><?=$o_VTA_DocumentoBN->getDocumentoCod()?></td>
                <td align="center"><?=$o_VTA_DocumentoBN->getNumeroComprobante()?></td>
                <td align="center"><?=$o_VTA_DocumentoBN->getObjectMoneda()->getDescripcion()?></td>
                <td align="right"><?=number_format( $o_VTA_DocumentoBN->getTipodeCambio(), 3 )?></td>
                <td align="right"><?=number_format( $o_VTA_DocumentoBN->getMontoSubTotal(), 2 )?></td>
                <td align="right"><?=number_format( $o_VTA_DocumentoBN->getMontoImpuestos(), 2 )?></td>
                <td align="right"><?=number_format( $o_VTA_DocumentoBN->getMontoTotal(), 2 )?></td>
                <td align="center"><?=$o_VTA_DocumentoBN->getCobranzaEstadoDesc()?></td>
            </tr>    
        <?php } ?>
        </tbody>
    </table>
</fieldset>
<script type="text/javascript">
$('#example').DataTable
(
    {
        language: { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
        responsive: { details: true },
        searching: false,
        info:     false,
        lengthChange: false,
        paging:   false,
        dom: 'lrtip',
        fixedHeader: 
        {
            header: false,
            footer: false
        }
    }
);
</script>
<?php } ?>

<fieldset class="scheduler-border">
    <legend class="scheduler-border">Resumen Aplicaciones</legend>
    <table id="example2" class="table table-striped table-bordered" style="width:100%">
        <thead>
        <tr>
            <th width="2%" style="text-align: center;"> # </th>
            <th style="text-align: center;">Tipo Doc</th>
            <th style="text-align: center;">Nro Doc</th>
            <th style="text-align: center;">Fecha Doc</th>
            <th style="text-align: center;">Moneda Dod</th>
            <th style="text-align: center;">Importe Doc</th>
            <th style="text-align: center;">Medio Pago</th>
            <th style="text-align: center;">Fecha Aplica</th>
            <th style="text-align: center;">Moneda</th>
            <th style="text-align: center;">Tipo C</th>
            <th style="text-align: center;">Monto Aplica</th>
        </tr>
        </thead>
        <tbody>
        <?php if( $a_FCO_Aplicacion ){ ?>
            <?php foreach ( $a_FCO_Aplicacion as $key => $o_FCO_AplicacionBN ) { ?>
            <tr>
                <td align="center"><?=$key+1?></td>
                <td align="center"><?=$o_FCO_AplicacionBN->getCodDocRef()?></td>
                <td align="center"><?=$o_FCO_AplicacionBN->getSerieNumeroDocRef()?></td>
                <td align="center"><?=substr( $o_FCO_AplicacionBN->getFechaDocRef(), 0, 10 )?></td>
                <td align="center"><?=$o_FCO_AplicacionBN->getObjectMonedaDocRef()->getDescripcion()?></td>
                <td align="right"><?=number_format( $o_FCO_AplicacionBN->getMontoTotalDocRef(), 2 )?></td>
                <td align="center"><?=$o_FCO_AplicacionBN->getTipoPagoNombre()?></td>
                <td align="center"><?=substr( $o_FCO_AplicacionBN->getFechaAplicacion(), 0, 10 )?></td>
                <td align="center"><?=$o_FCO_AplicacionBN->getMonedaDes()?></td>
                <td align="right"><?=number_format( $o_FCO_AplicacionBN->getTipoCambio(), 2 )?></td>
                <td align="right"><?=number_format( $o_FCO_AplicacionBN->getMontoAplicado(), 2 )?></td>
            </tr>
            <?php } ?>
        <?php } ?>
        </tbody>
    </table>
</fieldset>
<?php if( $a_FCO_Aplicacion ){ ?>
    <script type="text/javascript">
        $('#example2').DataTable
        (
            {
                language: { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
                responsive: { details: true },
                searching: false,
                info:     false,
                lengthChange: false,
                paging:   false,
                dom: 'lrtip',
                fixedHeader:
                    {
                        header: false,
                        footer: false
                    }
            }
        );
    </script>
<?php } ?>