<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;

class cotcarActions extends wtActions
{
    public function executePrint2PDF()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'id' );
        
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );
        
        ///////////////////////////////////////////////////////////////////////////
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_VTA_OrdenBN->getCiaCod() );
        
        ///////////////////////////////////////////////////////////////////////////
        
        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $i_Id );
        $o_VTA_OrdenDetalleFN->addOrderBy( VTA_OrdenDetalleFN::OrdenDetalleNum );
        $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
        
        //AHORA SE BUSCA LAS CUENTAS CONTABLES
        $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_GSS_ParametroMastFN->setIdAplicacionCodigo( "CTA_BANCO" );
        $o_GSS_ParametroMastFN->addOrderBy( GSS_ParametroMastFN::IdParametroClave, false );
        $a_CuentasBancarias = $o_GSS_ParametroMastFN->select();
        
        $host_name = "localhost";
        if( $_SERVER['HTTP_HOST'] != "localhost" )
        {
            $host_name = $_SERVER['HTTP_HOST'];
        }
        
        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        (
                "o_GSS_CompaniaBN"   => $o_GSS_CompaniaBN,
                "o_VTA_OrdenBN"      => $o_VTA_OrdenBN,
                "a_VTA_OrdenDetalle" => $a_VTA_OrdenDetalle,
                "a_CuentasBancarias" => $a_CuentasBancarias
        );
        $s_vHtml = 0;
        //////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;

        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        $dompdf->stream( 'Orden_Venta_'.$o_VTA_OrdenBN->getOrdenNum(), array( "Attachment" => 0 ) );
        
        exit;
    }
    
    public function executePrintPDF()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'id' );
        
        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );

        ///////////////////////////////////////////////////////////////////////////
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $o_VTA_OrdenBN->getCiaCod() );

        ///////////////////////////////////////////////////////////////////////////
        
        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $i_Id );
        $o_VTA_OrdenDetalleFN->addOrderBy( VTA_OrdenDetalleFN::OrdenDetalleNum );
        $a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();
        
        //AHORA SE BUSCA LAS CUENTAS CONTABLES
        $o_GSS_ParametroMastFN = new GSS_ParametroMastFN();
        $o_GSS_ParametroMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_GSS_ParametroMastFN->setIdAplicacionCodigo( "CTA_BANCO" );
        $o_GSS_ParametroMastFN->addOrderBy( GSS_ParametroMastFN::IdParametroClave, false );
        $a_CuentasBancarias = $o_GSS_ParametroMastFN->select();
        
        $host_name = "localhost";
        if( $_SERVER['HTTP_HOST'] != "localhost" )
        {
            $host_name = $_SERVER['HTTP_HOST'];
        }

        //////////////////////////////////////////////////////////////////////////////////////
        //parametos
        $a_Data   = array
        ( 
            "o_GSS_CompaniaBN"   => $o_GSS_CompaniaBN, 
            "o_VTA_OrdenBN"      => $o_VTA_OrdenBN, 
            "a_VTA_OrdenDetalle" => $a_VTA_OrdenDetalle,
            "a_CuentasBancarias" => $a_CuentasBancarias
        );
        $s_vHtml = 0;
        //////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;
        
        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        $dompdf->stream( 'Orden_Venta_'.$o_VTA_OrdenBN->getOrdenNum(), array( "Attachment" => 0 ) );
        
        exit;
        //////////////////////////////////////////////////////////////////////////////////////
        
        //ViewResponse::getInstance()->setMethodAjax();
    }

    public function executeGuardarPromocion()
    {
        $s_IdItem    = $this->getRequestParameter( 'IdItem' );
        $s_IdAlmacen = $this->getRequestParameter( 'IdAlmacen' );

        $i_Id = intval( $this->getRequestParameter( 'i_Id' ) );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_VTA_OrdenDetalleBN->setOrdenId( $i_Id );
            $o_VTA_OrdenDetalleBN->setAlmacenCod( $s_IdAlmacen );
            $o_VTA_OrdenDetalleBN->setDocRefId( intval( $s_IdItem ) );
            $o_VTA_OrdenDetalleBN->setTipoProcPromo( "INSERT" );

            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $o_CotizacionesDetalleBL->iniciarProcesoPromocionGrupal( $o_VTA_OrdenDetalleBN );

            /*
            $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
            //$o_VTA_DocumentoDetalleBN->setSecuencia( ( int ) $s_Secuencia );
            //$o_VTA_DocumentoDetalleBN->setItemCodigo( $s_IdItem );
            $o_VTA_DocumentoDetalleBN->setIdCompania( ( int ) $s_IdCompania );
            $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $s_IdTipoDocumento );
            $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $s_NumeroDocumento );

            $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $s_IdAlmacen );
            $o_VTA_DocumentoDetalleBN->setRefParent( intval( $s_IdItem ) );
            $o_VTA_DocumentoDetalleBN->setTipoProcPromo( "INSERT" );

            $o_OrdenVentaDetalleBL = new OrdenVentaDetalleBL();
            $o_OrdenVentaDetalleBL->iniciarProcesoPromocionGrupal( $o_VTA_DocumentoDetalleBN );
            */
            $con->commit();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeListProyectos()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_IdPersona = $this->getRequestParameter( 'IdPersona' );

        $this->o_MST_PersonaMastBN = new MST_PersonaMastBN();

        if( myUser::getUser()->getObjectCompania()->getCarteraClienteFlag() )
        {
            if( $this->getRequestParameter( 'IdPersona' ) )
            {
                $o_MST_PersonaMastFN       = new MST_PersonaMastFN();
                $this->o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $this->s_IdPersona );
            }
        }
    }
    
    public function executeGridProyectos()
    {
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new VTA_PrsProyectosFN() );
        
        $o_GridAction->addAssignFilter( "IdPersona" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        $o_GridAction->addConditionFilter( "ClienteNroDocu", VTA_PrsProyectosFN::ClienteNroDocu, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "ClienteNombre", VTA_PrsProyectosFN::ClienteNombre, "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "OrdenNum", VTA_OrdenFN::OrdenNum, "LIKE", "%%s%" );
        //$o_GridAction->addConditionFilter( "NumeroFactura", ALM_OrdenGuiaFacturaFN::NumeroFactura, "LIKE", "%%s%" );
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            if( !myUser::getUser()->getObjectRol()->tieneRolAdministrativo() )
            {
                if( myUser::getUser()->getObjectCompania()->getCarteraClienteFlag() )
                {
                    $o_GridAction->addMethodDefault( "( SELECT VendedorCod FROM MST_ClienteMast WHERE MST_ClienteMast.IdCliente=VTA_PrsProyectos.IdPersona )", array( 'Condition'=>'=', 'Value' => "'".myUser::getUser()->getUserId()."'" ) );
                }
            }
        }

        //
        
        $o_GridAction->addOrderDefault( VTA_PrsProyectosFN::IdProyecto, true );
        
        $o_GridAction->addRowsToShow( "IdProyecto", "NombreProyecto", "Contacto", "TipoDocumento", "NroDocumento", "Direccion", "ClienteNombre", "ClienteNroDocu", "IdPersona" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->Titulo = "Registro de Visitas";

        $o_CotizacionesBL = new CotizacionesBL();
        $o_CotizacionesBL->anularOrdenesExpirados();
        
        $o_VIS_DestinoFN = new VIS_DestinoFN();
        $o_VIS_DestinoFN->setEstado("A");
        $this->a_o_VIS_DestinoFN =  $o_VIS_DestinoFN->select();
    }

    public function executeGrid()
    {
        $o_GridAction = $this->buildGrid();
        
        $o_GridAction->addOrderDefault( VTA_OrdenFN::OrdenNum, false );

        $o_GridAction->addRowsToShow
        ( 
            "OrdenId", "OrdenNum", "OrdenFecha", "AlmacenCod", "NumeroPase", "NombreDestino",  "Comentario", "ClienteDocNum","Color","CelularCliente","ClienteNombre", "OrdenMonedaDesc", "OrdenNeto", "OrdenEstadoDesc", "UsuarioCreacion","FechaCreacion", "VendedorOrden", "TipoOrdenComercialDesc", "TipoClasificacionDesc", "OrdenEstado", "OrdenTotalaPagar",
            "AdminComentario", "FormaPagoDesc", "DocReferenciaId", "CobranzaEstadoDesc", "OrdenObs", "Comision", "UsuarioActualizacion", "FechaActualizacion", "BilletraDigitalArchivo", "EstadoDespacho"
        );
    
        $o_GridAction->setNumberRecordsShow( 100 );
    
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson            = array();
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();

        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeExpexcel()
    {
        header( 'Content-Type: application/vnd.ms-excel' );
        header( 'Content-Disposition: attachment;filename="Documento_Pedido.xls"' );
        header( 'Cache-Control: max-age=0' );

        $o_GridAction = $this->buildGrid();
        $o_GridAction->setNumberRecordsShow( 9999 );
        $o_GridAction->setControlArray( false );

        $o_GridAction->initialize();
        $this->a_VTA_Orden = $o_GridAction->getResultSelect();
        //pr( $this->a_VTA_Orden );

        $o_GridAction->setMethodSelectCustom( "selectTotales" );
        $this->o_RowTotales = $o_GridAction->initialize();
        //pr( $this->o_RowTotales );

        ViewResponse::getInstance()->setMethodAjax();
    }

    public function executeEditsm()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        set_header_utf8();

        $this->s_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );

        $this->Titulo = "Nuevo Registro";

        $this->error_mensaje = "";

        try
        {

            $o_MST_UbigeoFN = new MST_UbigeoFN();
            $o_MST_UbigeoFN->setTipo( "DEPT" );
            $this->a_DptMST_Ubigeo = $o_MST_UbigeoFN->select();
            $this->a_PrvMST_Ubigeo  = array();
            $this->a_DstMST_Ubigeo  = array();

            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastFN->setEstado( "A" );
            //$o_GSS_MonedaMastFN->setIdMoneda( "LO" );
            $o_GSS_MonedaMastFN->addOrderBy( GSS_MonedaMastFN::IdMoneda, false );
            $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();

            $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();

            $o_VTA_VendedorFN = new VTA_VendedorFN();
            $o_VTA_VendedorFN->setEstado( "A" );
            $o_VTA_VendedorFN->addCondition( "(select EsEmpleado from MST_PersonaMast where IdPersona=VTA_Vendedor.IdPersona)" , "=", "SI" );
            $o_VTA_VendedorFN->addOrderBy( VTA_VendedorFN::FechaCreacion );
            $this->a_VTA_Vendedor = $o_VTA_VendedorFN->select();

            $s_OrdenFecha = date( "Y-m-d H:i:s" );
            $OrdenVenc = UtilDate::obtenerOrdenFechaVenc();

            $this->o_VTA_OrdenBN = new VTA_OrdenBN();
            $this->o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
            $this->o_VTA_OrdenBN->setOrdenTipoId( 2 );
            $this->o_VTA_OrdenBN->setDiasAlquiler( 30 );
            $this->o_VTA_OrdenBN->setCondicionVenta( "CONADE" );
            $this->o_VTA_OrdenBN->setOrdenTipoClasificacionId( 1 );
            $this->o_VTA_OrdenBN->setValidezOrden( 1 );
            $this->o_VTA_OrdenBN->setPlazaEntregaOrden( 1 );
            $this->o_VTA_OrdenBN->setFactRegla( "MER" );
            $this->o_VTA_OrdenBN->setOrdenTipoComercialId( 1 );
            $this->o_VTA_OrdenBN->setAlmacenCod( "A1101" );

            //moneda por defecto, segun maestro de precios
            $IdCompania = myUser::getUser()->getIdBusiness();
            $IdSucursal = myUser::getUser()->getIdSucursal();

            $s_CodMoneda = MST_ListaPrecioCabeceraFN::getMonedaCodeDefault();

            $this->o_VTA_OrdenBN->setMonedaCod( $s_CodMoneda );
            $this->o_VTA_OrdenBN->setClienteDocCod( "RUC" );

            if( $this->s_TipoProc == "upd" )
            {
                $this->Titulo = "Editar Cotizaci&oacute;n";

                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->s_Id );

                $o_MST_UbigeoFN = new MST_UbigeoFN();
                $o_MST_UbigeoFN->setTipo( "PROV" );
                $o_MST_UbigeoFN->setPertenece( $this->o_VTA_OrdenBN->getObjectCliente()->getDepartamento() );
                $this->a_PrvMST_Ubigeo  = $o_MST_UbigeoFN->select();

                $o_MST_UbigeoFN = new MST_UbigeoFN();
                $o_MST_UbigeoFN->setTipo( "DIST" );
                $o_MST_UbigeoFN->setPertenece( $this->o_VTA_OrdenBN->getObjectCliente()->getProvincia() );
                $this->a_DstMST_Ubigeo  = $o_MST_UbigeoFN->select();
            }

            $this->s_IdVendedor = null; //por defecto
            //SERMAQUI TRABAJA CON CLIENTES ESPECIFICOS ASOCIADOS A LOS VENDEDORES, POR LO TANTO EL VENDEDOR TIENE Q SER UNICO - 2021-09-30
            //$this->s_IdVendedor = myUser::getUser()->getUserId();

            //almacen
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastFN->setIdCompania( $IdCompania );
            //$o_ALM_AlmacenMastFN->setIdSucursal( $IdSucursal );
            $o_ALM_AlmacenMastFN->setAlmacenVentaFlag( "S" );
            $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();

            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            $this->error_mensaje = $o_Exception->getMessage();
        }
    }
    
     public function executeAddeditsalida()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        set_header_utf8();
        
        $this->s_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        
        $this->Titulo = "Salida";

        $this->error_mensaje = "";

        try 
        {

            $o_MST_UbigeoFN = new MST_UbigeoFN();
            $o_MST_UbigeoFN->setTipo( "DEPT" );
            $this->a_DptMST_Ubigeo = $o_MST_UbigeoFN->select();
            $this->a_PrvMST_Ubigeo  = array();
            $this->a_DstMST_Ubigeo  = array();

            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastFN->setEstado( "A" );
            //$o_GSS_MonedaMastFN->setIdMoneda( "LO" );
            $o_GSS_MonedaMastFN->addOrderBy( GSS_MonedaMastFN::IdMoneda, false );
            $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();
            
            $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            
            $o_VTA_VendedorFN = new VTA_VendedorFN();
            $o_VTA_VendedorFN->setEstado( "A" );
            $o_VTA_VendedorFN->addCondition( "(select EsEmpleado from MST_PersonaMast where IdPersona=VTA_Vendedor.IdPersona)" , "=", "SI" );
            $o_VTA_VendedorFN->addOrderBy( VTA_VendedorFN::FechaCreacion );
            $this->a_VTA_Vendedor = $o_VTA_VendedorFN->select();
            
            $s_OrdenFecha = date( "Y-m-d H:i:s" );
            $OrdenVenc = UtilDate::obtenerOrdenFechaVenc();

            $this->o_VTA_OrdenBN = new VTA_OrdenBN();
            $this->o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
            $this->o_VTA_OrdenBN->setOrdenTipoId( 2 );
            $this->o_VTA_OrdenBN->setDiasAlquiler( 30 );
            $this->o_VTA_OrdenBN->setCondicionVenta( "CONADE" );
            $this->o_VTA_OrdenBN->setOrdenTipoClasificacionId( 1 );
            $this->o_VTA_OrdenBN->setValidezOrden( 1 );
            $this->o_VTA_OrdenBN->setPlazaEntregaOrden( 1 );
            $this->o_VTA_OrdenBN->setFactRegla( "MER" );
            $this->o_VTA_OrdenBN->setOrdenTipoComercialId( 1 );
            $this->o_VTA_OrdenBN->setAlmacenDespacho( "A1103" );

            //moneda por defecto, segun maestro de precios
            $IdCompania = myUser::getUser()->getIdBusiness();
            $IdSucursal = myUser::getUser()->getIdSucursal();
            
            $s_CodMoneda = MST_ListaPrecioCabeceraFN::getMonedaCodeDefault();

            $this->o_VTA_OrdenBN->setMonedaCod( $s_CodMoneda );
            $this->o_VTA_OrdenBN->setClienteDocCod( "RUC" );

            if( $this->s_TipoProc == "upd" )
            {
                $this->Titulo = "Editar Cotizaci&oacute;n";

                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->s_Id );

                $o_MST_UbigeoFN = new MST_UbigeoFN();
                $o_MST_UbigeoFN->setTipo( "PROV" );
                $o_MST_UbigeoFN->setPertenece( $this->o_VTA_OrdenBN->getObjectCliente()->getDepartamento() );
                $this->a_PrvMST_Ubigeo  = $o_MST_UbigeoFN->select();

                $o_MST_UbigeoFN = new MST_UbigeoFN();
                $o_MST_UbigeoFN->setTipo( "DIST" );
                $o_MST_UbigeoFN->setPertenece( $this->o_VTA_OrdenBN->getObjectCliente()->getProvincia() );
                $this->a_DstMST_Ubigeo  = $o_MST_UbigeoFN->select();
            }

            $this->s_IdVendedor = null; //por defecto
            //SERMAQUI TRABAJA CON CLIENTES ESPECIFICOS ASOCIADOS A LOS VENDEDORES, POR LO TANTO EL VENDEDOR TIENE Q SER UNICO - 2021-09-30
            //$this->s_IdVendedor = myUser::getUser()->getUserId();

            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //SE CAMBIA EL PROCEDIMIENTO PARA CAJA, AHORA EXITE LA APERTURA DE CAJA ASOCIANDO AL CIERRE EN ESTADO ABIERTO - 2020-02-02
            /*$o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            $this->b_ControlCaja = false;
            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
                $this->b_ControlCaja   = true;
                $this->IdCajaSelect    = $a_FCO_Cierre[0]->getIdCaja();
                $this->DesCajaSelect   = $a_FCO_Cierre[0]->getObjectCaja()->getDescripcion();
                $this->IdTurnoSelect   = $a_FCO_Cierre[0]->getIdTurno();
                $this->DescTurnoSelect = $a_FCO_Cierre[0]->getObjectTurno()->getDescripcion();
            }*/
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            //almacen
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastFN->setIdCompania( $IdCompania );
            //$o_ALM_AlmacenMastFN->setIdSucursal( $IdSucursal );
            $o_ALM_AlmacenMastFN->setAlmacenVentaFlag( "S" );
            $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();

            //$this->s_AlmDefault = "A1103";
            //$this->o_VTA_OrdenBN->setAlmacenDespacho( $this->s_AlmDefault );
            
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            $this->error_mensaje = $o_Exception->getMessage();
        }
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        set_header_utf8();
        
        $this->s_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        
        $this->Titulo = "Ingreso";

        $this->error_mensaje = "";

        try 
        {

            $o_MST_UbigeoFN = new MST_UbigeoFN();
            $o_MST_UbigeoFN->setTipo( "DEPT" );
            $this->a_DptMST_Ubigeo = $o_MST_UbigeoFN->select();
            $this->a_PrvMST_Ubigeo  = array();
            $this->a_DstMST_Ubigeo  = array();

            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastFN->setEstado( "A" );
            //$o_GSS_MonedaMastFN->setIdMoneda( "LO" );
            $o_GSS_MonedaMastFN->addOrderBy( GSS_MonedaMastFN::IdMoneda, false );
            $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();
            
            $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            
            $o_VTA_VendedorFN = new VTA_VendedorFN();
            $o_VTA_VendedorFN->setEstado( "A" );
            $o_VTA_VendedorFN->addCondition( "(select EsEmpleado from MST_PersonaMast where IdPersona=VTA_Vendedor.IdPersona)" , "=", "SI" );
            $o_VTA_VendedorFN->addOrderBy( VTA_VendedorFN::FechaCreacion );
            $this->a_VTA_Vendedor = $o_VTA_VendedorFN->select();
            
            $s_OrdenFecha = date( "Y-m-d H:i:s" );
            $OrdenVenc = UtilDate::obtenerOrdenFechaVenc();

            $this->o_VTA_OrdenBN = new VTA_OrdenBN();
            $this->o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
            $this->o_VTA_OrdenBN->setOrdenTipoId( 2 );
            $this->o_VTA_OrdenBN->setDiasAlquiler( 30 );
            $this->o_VTA_OrdenBN->setCondicionVenta( "CONADE" );
            $this->o_VTA_OrdenBN->setOrdenTipoClasificacionId( 1 );
            $this->o_VTA_OrdenBN->setValidezOrden( 1 );
            $this->o_VTA_OrdenBN->setPlazaEntregaOrden( 1 );
            $this->o_VTA_OrdenBN->setFactRegla( "MER" );
            $this->o_VTA_OrdenBN->setOrdenTipoComercialId( 1 );
            $this->o_VTA_OrdenBN->setAlmacenDespacho( "A1103" );

            //moneda por defecto, segun maestro de precios
            $IdCompania = myUser::getUser()->getIdBusiness();
            $IdSucursal = myUser::getUser()->getIdSucursal();
            
            $s_CodMoneda = MST_ListaPrecioCabeceraFN::getMonedaCodeDefault();

            $this->o_VTA_OrdenBN->setMonedaCod( $s_CodMoneda );
            $this->o_VTA_OrdenBN->setClienteDocCod( "RUC" );

            if( $this->s_TipoProc == "upd" )
            {
                $this->Titulo = "Editar Cotizaci&oacute;n";

                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->s_Id );

                $o_MST_UbigeoFN = new MST_UbigeoFN();
                $o_MST_UbigeoFN->setTipo( "PROV" );
                $o_MST_UbigeoFN->setPertenece( $this->o_VTA_OrdenBN->getObjectCliente()->getDepartamento() );
                $this->a_PrvMST_Ubigeo  = $o_MST_UbigeoFN->select();

                $o_MST_UbigeoFN = new MST_UbigeoFN();
                $o_MST_UbigeoFN->setTipo( "DIST" );
                $o_MST_UbigeoFN->setPertenece( $this->o_VTA_OrdenBN->getObjectCliente()->getProvincia() );
                $this->a_DstMST_Ubigeo  = $o_MST_UbigeoFN->select();
            }

            $this->s_IdVendedor = null; //por defecto
            //SERMAQUI TRABAJA CON CLIENTES ESPECIFICOS ASOCIADOS A LOS VENDEDORES, POR LO TANTO EL VENDEDOR TIENE Q SER UNICO - 2021-09-30
            //$this->s_IdVendedor = myUser::getUser()->getUserId();

            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //SE CAMBIA EL PROCEDIMIENTO PARA CAJA, AHORA EXITE LA APERTURA DE CAJA ASOCIANDO AL CIERRE EN ESTADO ABIERTO - 2020-02-02
            /*$o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            $this->b_ControlCaja = false;
            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
                $this->b_ControlCaja   = true;
                $this->IdCajaSelect    = $a_FCO_Cierre[0]->getIdCaja();
                $this->DesCajaSelect   = $a_FCO_Cierre[0]->getObjectCaja()->getDescripcion();
                $this->IdTurnoSelect   = $a_FCO_Cierre[0]->getIdTurno();
                $this->DescTurnoSelect = $a_FCO_Cierre[0]->getObjectTurno()->getDescripcion();
            }*/
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            //almacen
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastFN->setIdCompania( $IdCompania );
            //$o_ALM_AlmacenMastFN->setIdSucursal( $IdSucursal );
            $o_ALM_AlmacenMastFN->setAlmacenVentaFlag( "S" );
            $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();

            //$this->s_AlmDefault = "A1103";
            //$this->o_VTA_OrdenBN->setAlmacenDespacho( $this->s_AlmDefault );
            
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            $this->error_mensaje = $o_Exception->getMessage();
        }
    }
    
    public function executeSaveAddEditSalida()
    {
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        $con = Conexion::getConexion();
        $con->begin();
        
        try
        {
            $o_VTA_OrdenDP = new VTA_OrdenDP();
    		$o_VTA_OrdenDP->setOrdenId(intval( $i_Id ));
    		$o_VTA_OrdenDP->setOrdenEstado(VTA_OrdenBN::ESTADO_FACTURA);
    		$o_VTA_OrdenDP->setFechaActualizacion(date( "Y-m-d H:i:s" ));
    		$o_VTA_OrdenDP->setUsuarioActualizacion(myUser::getUser()->getUserId());
    		$o_VTA_OrdenDP->update();
    		$con->commit();
            
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'id' );
        $s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        
        $IdCompania         = myUser::getUser()->getIdBusiness();
        
        $TipoDocCliente     = $this->getRequestParameter( 'TipoDocCliente' );
        $NumDocuCliente     = $this->getRequestParameter( 'NumDocuCliente' );
        $OrdenTipoId        = $this->getRequestParameter( 'OrdenTipoId' );
        $ClienteNumero      = trim( $this->getRequestParameter( 'ClienteNumero' ) );
        $ClienteNombre      = trim( $this->getRequestParameter( 'NombreCliente' ) );
        $CorreoCliente      = $this->getRequestParameter( 'CorreoCliente' );
        $CelularCliente     = $this->getRequestParameter( 'CelularCliente' );

        $Comentario         = trim( $this->getRequestParameter( 'Comentario' ) );
        $DireccionCliente   = trim( $this->getRequestParameter( 'DireccionCliente' ) );
        $Departamento       = $this->getRequestParameter( 'Departamento' );
        $Provincia          = $this->getRequestParameter( 'Provincia' );
        $Distrito           = $this->getRequestParameter( 'Distrito' );

        $f_TipoCambio       = $this->getRequestParameter( 'MonedaCambioValor' );
        
        $IdAlmacen          = $this->getRequestParameter( 'AlmacenCod' );
        $AlmacenDespacho    = $this->getRequestParameter( 'AlmacenDespacho' );
        
        $IdVendedor         = $this->getRequestParameter( 'IdVendedor' );
        $IdUbigeo           = $Distrito;
        
        $FactRegla          = $this->getRequestParameter( 'FactRegla' );

        $ValidezOrden       = $this->getRequestParameter( 'ValidezOrden' );
        $PlazaEntregaOrden  = $this->getRequestParameter( 'PlazaEntregaOrden' );
        $CondicionVenta     = $this->getRequestParameter( 'CondicionVenta' );
        $s_OrdenCompraRef   = $this->getRequestParameter( 'OrdenCompraRef' );
        
        $s_OrdenTipoComercialId     = $this->getRequestParameter( 'OrdenTipoComercialId' );
        $s_OrdenTipoClasificacionId = $this->getRequestParameter( 'OrdenTipoClasificacionId' );
        $s_DiasAlquiler             = $this->getRequestParameter( 'DiasAlquiler' );
        ///////////////////////////////////////////////////////////////////////////////////
        $s_pais                     = $this->getRequestParameter( 's_pais' );
        $s_placa                    = $this->getRequestParameter( 's_placa' );
        $s_Color                    = $this->getRequestParameter( 's_Color' );
        $s_NombreVehiculoTipo       = $this->getRequestParameter( 's_NombreVehiculoTipo' );
        $s_IdVehiculoTipo           = $this->getRequestParameter( 's_IdVehiculoTipo' );
        $s_IdVehiculoMarca          = $this->getRequestParameter( 's_IdVehiculoMarca' );
        $s_IdVehiculoModelo         = $this->getRequestParameter( 's_IdVehiculoModelo' );
        $s_NombreMarca              = $this->getRequestParameter( 's_NombreMarca' );
        $s_NombreModelo             = $this->getRequestParameter( 's_NombreModelo' );
        $s_Comision                 = floatval($this->getRequestParameter( 'Comision' ));
        $s_FlagComision             = $this->getRequestParameter( 'FlagComision' );
        
        $s_TipoDocumentoCliente     = $this->getRequestParameter( 's_TipoDocumentoCliente' );
        $s_NumeroDocumentoCliente   = $this->getRequestParameter( 's_NumeroDocumentoCliente' );
        $s_ClienteNombre            = $this->getRequestParameter( 's_ClienteNombre' );
        $s_NumeroPase               = $this->getRequestParameter( 's_NumeroPase' );
        $s_IdDestino                = $this->getRequestParameter( 's_IdDestino' );
        $s_Comentario               = $this->getRequestParameter( 's_Comentario' );
        $i_IdPersona                = $this->getRequestParameter( 'i_IdPersona' );
        
        
        /////////////////////////////////////////////////////////////////////////////////
        
        //$a_DataValidez = VTA_OrdenBN::getArrayValidezOrden( $ValidezOrden );
        $o_MST_ValidezOfFN = new MST_ValidezOfFN();
        $o_MST_ValidezOfBN = $o_MST_ValidezOfFN->selectByPK( $ValidezOrden );
        $OrdenVenc = UtilDate::obtenerOrdenFechaVenc( $o_MST_ValidezOfBN->getCantHoras() );
        //$OrdenVenc = UtilDate::obtenerOrdenFechaVenc( ( $s_DiasAlquiler * 24 ) );
        
        $MonedaCod          = $this->getRequestParameter( 'MonedaCod' );
        $MonedaCambioValor  = $this->getRequestParameter( 'MonedaCambioValor' );
        
        $IdProyecto  = $this->getRequestParameter( 'IdProyecto' );
        
        $a_Rs = array();
        
        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $o_VTA_OrdenBN = new VTA_OrdenBN();
            if( $s_TipoProc == "upd" )
            {
                $o_VTA_OrdenFN = new VTA_OrdenFN();
                $o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );
            }

            if( $NumDocuCliente == "00000000" )
            //if( $NumDocuCliente == "00000000" )
            {
                $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                $o_MST_PersonaMastDP->setIdPersona( intval( $ClienteNumero ) );
                $o_MST_PersonaMastDP->setIdPersona( intval( $NumDocuCliente ) );
                $o_MST_PersonaMastDP->setNombres( $ClienteNombre );
                $o_MST_PersonaMastDP->setApellidoMaterno( '' );
                $o_MST_PersonaMastDP->setApellidoPaterno( '' );
                $o_MST_PersonaMastDP->setNombreCompleto( $ClienteNombre );
                $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_MST_PersonaMastDP->update();
            }
			
			if($s_TipoProc == "upd"){
				if(!$s_FlagComision && $s_Comision <= 0.00){
					throw new Exception( "La comisión debe ser mayor que 0 (cero) o marque la casilla 'Sin comisión'." );
				}
				
				$o_VTA_OrdenDP = new VTA_OrdenDP();
				$o_VTA_OrdenDP->setOrdenId(intval( $i_Id ));
				if(intval($s_FlagComision)){
					$o_VTA_OrdenDP->setFlagSinComision(intval($s_FlagComision));
				}else{
					$o_VTA_OrdenDP->setFlagSinComision(-1);
				}
				
				$o_VTA_OrdenDP->update();
			}
			
            //INFO DE LA SUCURSAL
            $o_GSS_SucursalFN = new GSS_SucursalFN();
            $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( myUser::getUser()->getIdSucursal() );

            //se busca el cliente
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );
            if( !$o_MST_PersonaMastBN )
            {
                throw new Exception( "El Nro Documento ingresado no se encuentra registrado.".$ClienteNumero );
            }

            if( $o_MST_PersonaMastBN->getTipoPersona() == MST_PersonaMastBN::PERSONA_NATURAL )
            {
                if( $o_MST_PersonaMastBN->getDireccion() != $DireccionCliente )
                {
                    //se actualiza la direccion
                    $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                    $o_MST_PersonaMastDP->setIdPersona( $o_MST_PersonaMastBN->getIdPersona() );
                    $o_MST_PersonaMastDP->setDireccion( $DireccionCliente );
                    $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    //$o_MST_PersonaMastDP->update();
                }
            }

            if( !$o_MST_PersonaMastBN->getDistrito() )
            {
                //se actualiza la direccion
                $o_MST_PersonaMastDP = new MST_PersonaMastDP();
                $o_MST_PersonaMastDP->setIdPersona( $o_MST_PersonaMastBN->getIdPersona() );
                $o_MST_PersonaMastDP->setDepartamento( $Departamento );
                $o_MST_PersonaMastDP->setProvincia( $Provincia );
                $o_MST_PersonaMastDP->setDistrito( $Distrito );
                if( !$o_MST_PersonaMastBN->getDireccion() )
                {
                    $o_MST_PersonaMastDP->setDireccion( $DireccionCliente );
                }
                $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_MST_PersonaMastDP->update();

                $o_MST_PersonaMastFN = new MST_PersonaMastFN();
                $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );
            }
            
            $TipoDocCliente          = $o_MST_PersonaMastBN->getTipoDocumento();
            $NumDocuCliente          = $o_MST_PersonaMastBN->getDocumento();

            $ClienteDistritoDesc     = $o_MST_PersonaMastBN->getDistritoDesc();
            $ClienteDepartamentoDesc = $o_MST_PersonaMastBN->getDepartamentoDesc();
            $ProvinciaDesc           = $o_MST_PersonaMastBN->getProvinciaDesc();

            $VendedorAsigna     = $o_MST_PersonaMastBN->getVendedorAsignado();
            //$CanalCliente       = $o_MST_PersonaMastBN->getCanalCliente();
            $NivelPrecioCliente = $o_MST_PersonaMastBN->getNivelPrecioCliente();
            
            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenObs( $Comentario );
            $o_VTA_OrdenBN->setCelularCliente($CelularCliente);
            

            $o_VTA_OrdenBN->setOrdenImpuestoFlag( "Y" );
            $o_VTA_OrdenBN->setOrdenExoneradoFlag( "N" );

            //NUEVO PROCEDIMIENTO, POR EXONERACION DEL IGV - 2021-12-29
            if( $o_GSS_SucursalBN->getEstaExoneradoIGV() )
            {
                $o_VTA_OrdenBN->setOrdenImpuestoFlag( "N" );
                $o_VTA_OrdenBN->setOrdenExoneradoFlag( "Y" );
            }
            
            /////////////////////////////////////////////////////
            //echo $s_IdVehiculoMarca."<br>";
            if($s_TipoProc == "nvo" )
            {
                
                
            }
            
            $o_VIS_DestinoFN = new VIS_DestinoFN();
            $o_VIS_DestinoBN = $o_VIS_DestinoFN->selectByPk($s_IdDestino);
            $s_NombreDestinoC = $o_VIS_DestinoBN->getDescripcion();
            $o_VTA_OrdenBN->setNombreDestino( $s_NombreDestinoC );
            
            $o_VTA_OrdenBN->setClienteDocCod( $s_TipoDocumentoCliente );
            $o_VTA_OrdenBN->setClienteDocNum( $s_NumeroDocumentoCliente );
            $o_VTA_OrdenBN->setNumeroPase( $s_NumeroPase);
            $o_VTA_OrdenBN->setComentario( $s_Comentario);
            
            
            //////////////////////////////////////////////////////////////////
            
            $o_VTA_OrdenBN->setClienteId( ( int ) $i_IdPersona );
            //$o_VTA_OrdenBN->setClienteDocCod( $TipoDocCliente );
            //$o_VTA_OrdenBN->setClienteDocNum( $NumDocuCliente );
            $o_VTA_OrdenBN->setClienteNombre( $s_ClienteNombre );
            //$o_VTA_OrdenBN->setClienteSucursal( $ClienteDireccion );
            $o_VTA_OrdenBN->setIdDestino( (int)$s_IdDestino );
            $o_VTA_OrdenBN->setFactDirec1( $DireccionCliente );
            $o_VTA_OrdenBN->setFactDirec2( $ClienteDistritoDesc );
            $o_VTA_OrdenBN->setFactDirec3( $IdUbigeo );
            $o_VTA_OrdenBN->setPrecioNivel( $NivelPrecioCliente );
            $o_VTA_OrdenBN->setFactPais( $s_pais );
            $o_VTA_OrdenBN->setFactEstado( $ProvinciaDesc );
            $o_VTA_OrdenBN->setFactCiudad( $ClienteDepartamentoDesc );

            $o_VTA_OrdenBN->setValidezOrden( $ValidezOrden );
            $o_VTA_OrdenBN->setPlazaEntregaOrden( $PlazaEntregaOrden );
            $o_VTA_OrdenBN->setCondicionVenta( $CondicionVenta );
            $o_VTA_OrdenBN->setOrdenVenc( $OrdenVenc );
            $o_VTA_OrdenBN->setOrdenCompraRef( $s_OrdenCompraRef );
            
            $o_VTA_OrdenBN->setDiasAlquiler( intval( $s_DiasAlquiler ) );
            $o_VTA_OrdenBN->setIdProyecto( ( int ) $IdProyecto );

            //ahora se deja actualizar la moneda y el tipo de cambio. - 2020-07-15
            $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
            $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );
            
            $o_VTA_OrdenBN->setOrdenTipoId( ( int ) $OrdenTipoId );
            
            $o_VTA_OrdenBN->setComision((float)$s_Comision);

            if( $this->getRequestParameter( 'IdVendedor' ) )
            {
                $o_VTA_OrdenBN->setVendedorOrden( $this->getRequestParameter( 'IdVendedor' ) );
                $o_VTA_OrdenBN->setVendedorCliente( $this->getRequestParameter( 'IdVendedor' ) );
            }
            //$s_TipoProc = "nvo";
            if( $s_TipoProc == "upd" )
            {
                $o_VTA_OrdenBN->setOrdenId( ( int ) $i_Id );
                
                
                $o_CotizacionesBL = new CotizacionesBL();
                $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );
            }
            else
            {
                //UPDATE
                //NUEVO
                $o_VTA_OrdenBN->setOrdenTipoComercialId( intval( $s_OrdenTipoComercialId ) );
                
                $o_VTA_OrdenBN->setOrdenTipoClasificacionId( intval( $s_OrdenTipoClasificacionId ) );
                
                $o_VTA_OrdenBN->setCiaCod( ( int ) $IdCompania );
                $o_VTA_OrdenBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_VTA_OrdenBN->setPtoVtaCod( "LIM" );

                //$o_VTA_OrdenBN->setIdCaja( $IdCaja );
                //$o_VTA_OrdenBN->setIdTurno( $IdTurno );
                
                $s_OrdenFecha = date( "Y-m-d H:i:s" );
                
                $o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
                $o_VTA_OrdenBN->setAlmacenCod( $IdAlmacen );
                $o_VTA_OrdenBN->setAlmacenDespacho( $AlmacenDespacho );
                
                $o_VTA_OrdenBN->setVendedorCliente( $VendedorAsigna );

                //$o_VTA_OrdenBN->setVendedorOrden( myUser::getUser()->getUserId() );
                
                

                //$o_VTA_OrdenBN->setPrecioNivel(  );
                $o_VTA_OrdenBN->setFactRegla( $FactRegla );
                
                //$o_VTA_OrdenBN->setContactoMedio(  );
                //$o_VTA_OrdenBN->setContactoNombre(  );
                
                //$o_VTA_OrdenBN->setDocReferenciaTipo(  );
                //$o_VTA_OrdenBN->setDocReferenciaNum(  );
                //$o_VTA_OrdenBN->setDocReferenciaFecha(  );
                
                //$o_VTA_OrdenBN->setOrdenImpuestoFlag(  );
                
                $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
                $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );
                
                $o_VTA_OrdenBN->setOrdenEstado( "O" );
                
                $o_VTA_OrdenBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                //$o_VTA_OrdenBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                //$o_VTA_OrdenBN->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                //$o_VTA_OrdenBN->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                //pr( $o_VTA_OrdenBN ); exit;
                $o_CotizacionesBL = new CotizacionesBL();
                $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );
                
            }
            
            $i_Id = $o_VTA_OrdenBN->getOrdenId();

            //ahora se actualiza info del cliente
            $o_MST_PersonaMastDP = new MST_PersonaMastDP();
            $o_MST_PersonaMastDP->setIdPersona( $o_VTA_OrdenBN->getClienteId() );
            $o_MST_PersonaMastDP->setEmail( $CorreoCliente );
            $o_MST_PersonaMastDP->setCelular( $CelularCliente );
            $o_MST_PersonaMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_MST_PersonaMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_MST_PersonaMastDP->update();

            $con->commit();
            
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeDetailVta()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_OrdNum = $this->getRequestParameter( 'OrdNum' );
        $this->i_Id     = $this->getRequestParameter( 'i_Id' );
        $this->readonly = $this->getRequestParameter( 'readonly' );
        
        
        
        if( $this->getRequestParameter( 'OrdNum' ) )
        {
            $this->o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $this->s_OrdNum );
            if( !$this->o_VTA_OrdenBN )
            {
                $o_VTA_DocumentoFN = VTA_DocumentoFN::selectByDocumentNumber( $this->s_OrdNum );
                if( $o_VTA_DocumentoFN )
                {
                    $this->o_VTA_OrdenBN = $o_VTA_DocumentoFN->getObjectOrden();
                }
            }
            $this->i_Id          = $this->o_VTA_OrdenBN->getOrdenId();
            $OrdenNum = $this->getRequestParameter( 'OrdNum' );
        }
        else
        {
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->i_Id );
            $OrdenNum = $this->o_VTA_OrdenBN->getOrdenNum();
        }
        
        $this->s_Titulo = "# ".$OrdenNum." | Placa:";
        
        $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
        $this->o_GSS_MonedaMastBN = $o_GSS_MonedaMastFN->selectByPK( $this->o_VTA_OrdenBN->getMonedaCod() );
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $this->o_MST_PersonaMastFN = $o_MST_PersonaMastFN->setIdPersona( $this->o_VTA_OrdenBN->getClienteId() );
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();

        $i_IdProyecto = $this->o_VTA_OrdenBN->getIdProyecto();
        $o_VTA_PrsProyectosFN = new VTA_PrsProyectosFN();
        $this->o_VTA_PrsProyectosBN = $o_VTA_PrsProyectosFN->selectByPK( $i_IdProyecto );
        
        //FORMA DE PAGO
        $o_VTA_FormaPagoFN = new VTA_FormaPagoFN();
        $o_VTA_FormaPagoFN->setEstado( "O" );
        $o_VTA_FormaPagoFN->addOrderBy( VTA_FormaPagoFN::DescripcionLocal  );
        $this->a_VTA_FormaPago = $o_VTA_FormaPagoFN->select();

        //SE CONSULTA SI ESTA FACTURADO Y Q TIENE UN ROL ESPECIAL PARA RE-ABRIR ORDEN Y AGREGAR COSAS
        $this->i_CrtlEditParaDespacho = 0;
        if( myUser::getUser()->getRoleId() == "sys.adm" || myUser::getUser()->getRoleId() == "sys.goper" )
        {
            if( $this->o_VTA_OrdenBN->getOrdenEstado() != VTA_OrdenBN::ESTADO_ANULADO )
            {
                if( $this->o_VTA_OrdenBN->getDocReferenciaId() )
                {
                    if( $this->o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_FACTURA )
                    {
                        $this->i_CrtlEditParaDespacho = 1;
                    }
                    if( $this->o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_ABIERTO )
                    {
                        $this->i_CrtlEditParaDespacho = 2;
                    }
                }
            }
        }

        $this->b_CtrlVwDespacho = false;
        if( $this->o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_FACTURA )
        {
            $this->o_SR_MovimientoBN = SR_MovimientoFN::selectOneRefId( $this->o_VTA_OrdenBN->getDocReferenciaId() );
            if( $this->o_SR_MovimientoBN )
            {
                if( $this->o_SR_MovimientoBN->getEstadoAprob() == SR_MovimientoBN::APROBACION_COMPLETADO )
                {
                    $this->b_CtrlVwDespacho = true;
                }
                if( $this->o_SR_MovimientoBN->getImpresionEstado() == SR_MovimientoBN::ESTADO_IMP_C )
                {
                    if( $this->o_VTA_OrdenBN->getOrdenEstado() == VTA_OrdenBN::ESTADO_FACTURA )
                    {
                        $this->i_CrtlEditParaDespacho = 0;
                    }
                }
            }
        }
    }
    
    public function executeFindDetailVta()
    {
        $i_Id         = $this->getRequestParameter( 'i_Id' );
        $this->noedit = $this->getRequestParameter( 'noedit' );

        $o_VTA_OrdenFN = new VTA_OrdenFN();
        $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $i_Id );
        
        $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
        $o_VTA_OrdenDetalleFN->setOrdenId( $i_Id );
        $o_VTA_OrdenDetalleFN->addOrderBy( VTA_OrdenDetalleFN::OrdenDetalleNum );
        $this->a_VTA_OrdenDetalle = $o_VTA_OrdenDetalleFN->select();

        $this->b_MostrarMargen = myUser::getUser()->getObjectCompania()->getMostrarMargenVenta();
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            $this->b_MostrarMargen = false;
        }

        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeDeleteDetailVta()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $a_Rs = array();
        
        $a_Rs['error'] = false;

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            $a_Ids = explode( "_", $i_Id );
            $i_OrdenId         = $a_Ids[0];
            $i_OrdenDetalleNum = $a_Ids[1];

            $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
            $o_VTA_OrdenDetalle2BN = $o_VTA_OrdenDetalleFN->selectByPK( $i_OrdenId, $i_OrdenDetalleNum );

            $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_VTA_OrdenDetalleBN->setOrdenId( ( int ) $i_OrdenId );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleNum( ( int ) $i_OrdenDetalleNum );
            
            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $o_CotizacionesDetalleBL->eliminarLinea( $o_VTA_OrdenDetalleBN );

            $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenById( $i_OrdenId );
            if( $o_VTA_OrdenBN->getDocReferenciaId() )
            {
                $o_VTA_DocumentoBN = $o_VTA_OrdenBN->getObjectVTADocumento();

                //si existe factura
                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleFN->setItemCodigo( $o_VTA_OrdenDetalle2BN->getItemCod() );
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                if( $a_VTA_DocumentoDetalle )
                {
                    //si existe solo se actualiza la cantidad
                    $o_VTA_DocumentoDetalleBN = $a_VTA_DocumentoDetalle[0];
                    if( $o_VTA_DocumentoDetalleBN->getCantidadRecibida() > 0 )
                    {
                        throw new Exception( "No se puede eliminar por que tiene Despacho asociado." );
                    }

                    if( $o_VTA_DocumentoDetalleBN->getRefParent() == $i_OrdenDetalleNum )
                    {
                        $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP();
                        $o_VTA_DocumentoDetalleDP->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                        $o_VTA_DocumentoDetalleDP->setIdCompania( $o_VTA_DocumentoDetalleBN->getIdCompania() );
                        $o_VTA_DocumentoDetalleDP->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                        $o_VTA_DocumentoDetalleDP->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );
                        $o_VTA_DocumentoDetalleDP->delete();
                    }
                    else
                    {
                        throw new Exception( "No se puede eliminar por ser un detalle principal." );
                    }
                }
                else
                {
                    throw new Exception( "No se encontro Referencia del Detalle." );
                }
            }

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
            //$a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        
        echo json_encode( $a_Rs );
        
        return ViewResponse::NONE;
    }
    
    public function executeCambiarEstadoOrden()
    {
        $i_Id     = ( int ) $this->getRequestParameter( 'id' );
        $s_Estado = $this->getRequestParameter( 'estado' );
        
        $a_Rs['error'] = false;
        $a_Rs['mensaje_error'] = "";
        //exit;
        try
        {
			$o_VTA_OrdenFN = new VTA_OrdenFN();
			$o_VTA_OrdenBN2 = $o_VTA_OrdenFN->selectByPK($i_Id);
			
			if($o_VTA_OrdenBN2){
				if($o_VTA_OrdenBN2->getFlagSinComision() == -1 && ($o_VTA_OrdenBN2->getComision() == 0.00 || $o_VTA_OrdenBN2->getComision() == null)){
					throw new Exception( "Debe actualizar la comisión o marcar la casilla 'Sin Comision'." );
				}
			}
			
            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenId( $i_Id );
            $o_VTA_OrdenBN->setOrdenEstado( $s_Estado );
            if( $s_Estado == VTA_OrdenBN::ESTADO_ANULADO )
            {
                $s_MotivoAnulacion = $this->getRequestParameter( 'motivo_anulacion' );
                $o_VTA_OrdenBN->setAnulacionComentario( $s_MotivoAnulacion );
            }
            $o_CotizacionesBL = new CotizacionesBL();
            $o_CotizacionesBL->cambiarEstadoOrdenVenta( $o_VTA_OrdenBN );
            
            //cuando el estado es aprobado se activa el producto final
            foreach ( $o_VTA_OrdenBN->getArrayDetalles() as $o_VTA_OrdenDetalleBN )
            {
                if( $o_VTA_OrdenDetalleBN->getItemTipo() == VTA_OrdenDetalleBN::TIPO_PRODUCTO_FINAL )
                {
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $o_VTA_OrdenDetalleBN->getItemCod() );
                    if( $o_ALM_ItemMastBN )
                    {
                        $o_ALM_ItemMastDP = new ALM_ItemMastDP();
                        $o_ALM_ItemMastDP->setIdItem( $o_VTA_OrdenDetalleBN->getItemCod() );
                        
                        if( $s_Estado == VTA_OrdenBN::ESTADO_CERRADO )
                        {
                            $o_ALM_ItemMastDP->setEstado( ALM_ItemMastBN::ESTADO_ACTIVO );
                        }
                        if( $s_Estado != VTA_OrdenBN::ESTADO_CERRADO )
                        {
                            $o_ALM_ItemMastDP->setEstado( ALM_ItemMastBN::ESTADO_INACTIVO );
                        }
                        
                        $o_ALM_ItemMastDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_ALM_ItemMastDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $o_ALM_ItemMastDP->update();
                    }
                    else 
                    {
                        throw new Exception( "No se encontro el Producto Final." );
                    }
                }
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        
        echo json_encode( $a_Rs );
        
        return ViewResponse::NONE;
    }
    
    public function executeListPrecio()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_IdItem    = $this->getRequestParameter( 'id_item' );
        $this->i_Id        = $this->getRequestParameter( 'id' );
        $this->s_Secuencia = $this->getRequestParameter( 'secuencia' );
        
        try
        {
            myUser::getUser()->validar_session();
            
            $this->b_Error = false;
            
            if( !myUser::getUser()->getIdSucursal() )
            {
                throw new Exception( "Se tiene que seleccionar Sucursal." );
            }
            
            $o_VTA_OrdenFN = new VTA_OrdenFN();
            $this->o_VTA_OrdenBN = $o_VTA_OrdenFN->selectByPK( $this->i_Id );

            //$o_MST_RangoFN = new MST_RangoFN();
            //$this->o_MST_RangoBN = $o_MST_RangoFN->selectByPK( $this->o_VTA_OrdenBN->getOrdenTipoComercialId() );


            $o_VTA_OrdenDetalleFN = new VTA_OrdenDetalleFN();
            $this->o_VTA_DocumentoDetalleBN = $o_VTA_OrdenDetalleFN->selectByPK( $this->i_Id, $this->s_Secuencia );
            
            //$s_OrdenTipoCod = $this->o_VTA_OrdenBN->getOrdenTipoObject()->getOrdenTipoCod();
            
            $this->f_TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            
            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $this->o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $this->s_IdItem );

            $this->AfectoIGV = "Y";
            if( !$this->o_ALM_ItemMastBN->EsAfectoaIGV() )
            {
                $this->AfectoIGV = "N";
            }

            if( $this->o_VTA_OrdenBN->esExoneradodeIGV() )
            {
                $this->AfectoIGV = "N";
            }

            $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
            $o_MST_ListaPrecioCabeceraFN->setIdTipoLista( $this->o_VTA_OrdenBN->getOrdenTipoComercialId() );
            $o_MST_ListaPrecioCabeceraFN->addOrderBy( MST_ListaPrecioCabeceraFN::IdTipoLista );
            $a_MST_ListaPrecioCabecera = $o_MST_ListaPrecioCabeceraFN->select();
            $this->o_MST_ListaPrecioCabeceraBN = null;
            if( $a_MST_ListaPrecioCabecera )
            {
                $this->o_MST_ListaPrecioCabeceraBN = $a_MST_ListaPrecioCabecera[0];
            }
            else
            {
                throw new Exception( "El cabecera de precios no existe." );
            }

            //$this->o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
            
            $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
            $o_MST_ListaPrecioDetalleFN->setIdListaPreciCab( $this->o_MST_ListaPrecioCabeceraBN->getIdListaPreciCab() );
            $o_MST_ListaPrecioDetalleFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_MST_ListaPrecioDetalleFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_MST_ListaPrecioDetalleFN->setIdRango( $this->o_ALM_ItemMastBN->getIdRangoVenta() );
            $o_MST_ListaPrecioDetalleFN->setIdItem( $this->s_IdItem );
            $o_MST_ListaPrecioDetalleFN->setEstado( "A" );
            $o_MST_ListaPrecioDetalleFN->addOrderBy( MST_ListaPrecioDetalleFN::IdRangoDetalle );
            $this->a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();
            //$this->a_MST_ListaPrecioDetalle = array();
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
            exit;
        }
    }
    
    public function executeChangePrice()
    {
        $s_IdItem        = $this->getRequestParameter( 'id_item' );
        $s_Contrasenia   = trim( $this->getRequestParameter( 'contrasenia' ) );
        $i_Id            = intval( $this->getRequestParameter( 'id' ) );
        $s_Secuencia     = intval( $this->getRequestParameter( 'secuencia' ) );
        $s_IdTipoPrecio  = $this->getRequestParameter( 'tipo_precio' );
        $f_PrecioPersa   = floatval( $this->getRequestParameter( 'txt_precio' ) );
        $f_Descuento     = floatval( $this->getRequestParameter( 'descuento' ) );
        $f_DescuentoTot  = floatval( $this->getRequestParameter( 'descuento_tot' ) );
        $f_PorcDescuento = floatval( $this->getRequestParameter( 'por_dscto' ) );

        $a_Rs = array();
        
        try
        {
            myUser::getUser()->validar_session();
            
            $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_VTA_OrdenDetalleBN->setOrdenId( $i_Id );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleNum( $s_Secuencia );
            $o_VTA_OrdenDetalleBN->setItemCod( $s_IdItem );
            $o_VTA_OrdenDetalleBN->setOrdenDetallePrecioNivel( $s_IdTipoPrecio );
            $o_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuesto( $f_PrecioPersa );
            $o_VTA_OrdenDetalleBN->setContrasenia( $s_Contrasenia );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleDsctoUnidad( $f_DescuentoTot );
            $o_VTA_OrdenDetalleBN->setDescuentoUnitario( $f_Descuento );
            $o_VTA_OrdenDetalleBN->setOrdenDetallePorcDscto( $f_PorcDescuento );
            //$o_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidadMN( $f_PrecioPersa );

            //SE PENSO QUE SE PUEDE AGREGAR BAJAR EL PRECIO POR EL PORCENTAJE QUE SE LE ASIGNA AL VENDEDOR
            //LA MISMA LOGICA QUE EL DESCUENTO EN GLOBAL, CON LA CONTRASEÑA DEL UN ADMINISTRADOR

            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $o_CotizacionesDetalleBL->iniciarCambioPrecio( $o_VTA_OrdenDetalleBN );
            
            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeTotalesMaster()
    {
        try 
        {
            myUser::getUser()->validar_session();
            
            $o_GridAction = $this->buildGrid();
			
			$s_ClienteNombre    	= $this->getRequestParameter( 'ClienteNombre' );
			$s_OrdenEstado    		= $this->getRequestParameter( 'OrdenEstado' );
			$s_FechaDocumento1    	= $this->getRequestParameter( 'FechaDocumento1' );
			$s_FechaDocumento2    	= $this->getRequestParameter( 'FechaDocumento2' );
			$s_Placa		    	= $this->getRequestParameter( 'Placa' );
			$s_OrdenNum		    	= $this->getRequestParameter( 'OrdenNum' );
			$s_VendedorOrden	    = $this->getRequestParameter( 'VendedorOrden' );
			
			$o_VTA_OrdenFN = new VTA_OrdenFN();
			
			if($s_ClienteNombre) $o_VTA_OrdenFN->addCondition("ClienteNombre", "LIKE", "%".$s_ClienteNombre."%");
			if($s_OrdenEstado) $o_VTA_OrdenFN->setOrdenEstado($s_OrdenEstado);
			if($s_FechaDocumento1) $o_VTA_OrdenFN->addCondition("OrdenFecha", ">=", $s_FechaDocumento1.' 00:00:00');
			if($s_FechaDocumento2) $o_VTA_OrdenFN->addCondition("OrdenFecha", "<=", $s_FechaDocumento2.' 23:59:59');
			if($s_Placa) $o_VTA_OrdenFN->setPlaca($s_Placa);
			if($s_OrdenNum) $o_VTA_OrdenFN->addCondition("OrdenNum", "LIKE", $s_OrdenNum);
			if($s_VendedorOrden) $o_VTA_OrdenFN->setVendedorOrden($s_VendedorOrden);
			
			$a_o_VTA_OrdenBN = $o_VTA_OrdenFN->select();
			
			$this->f_IngresoTotal = 0.00;
			$this->f_ComisionTotal = 0.00;
			$this->f_TotaNeto = 0.00;
			
			foreach($a_o_VTA_OrdenBN as $o_VTA_OrdenBN){
				$this->f_IngresoTotal += $o_VTA_OrdenBN->getOrdenTotalaPagar();
				$this->f_ComisionTotal += $o_VTA_OrdenBN->getComision();
			}
			
			$this->f_TotaNeto = $this->f_IngresoTotal - $this->f_ComisionTotal;
			
			/*
            
            $o_GridAction->setMethodSelectCustom( "selectTotales" );
            $o_Row = $o_GridAction->initialize();
			//pr($o_Row);
            $o_MST_ListaPrecioCabeceraFN = new MST_ListaPrecioCabeceraFN();
            $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->selectByPK( myUser::getUser()->getIdBusiness(), myUser::getUser()->getIdSucursal() );
            if( !$o_MST_ListaPrecioCabeceraBN )
            {
                $o_MST_ListaPrecioCabeceraBN = $o_MST_ListaPrecioCabeceraFN->buscaListaPrecioAlternativo();
            }
            
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "LO" ) //MONEDA DE LA LISTA DE PRECIOS ES SOLES
            {
                $this->f_SumaOrdenAfecto   = $o_Row['SumaOrdenAfectoMN'];
                $this->f_SumaOrdenInafecto = $o_Row['SumaOrdenInafectoMN'];
                $this->f_SumaOrdenImpuesto = $o_Row['SumaOrdenImpuestoMN'];
                $this->f_SumaOrdenNeto     = $o_Row['SumaOrdenNetoMN'];
            }
            if( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() == "EX" ) //MONEDA DE LA LISTA DE PRECIOS ES DOLARES
            {
                $this->f_SumaOrdenAfecto   = $o_Row['SumaOrdenAfecto'];
                $this->f_SumaOrdenInafecto = $o_Row['SumaOrdenInafecto'];
                $this->f_SumaOrdenImpuesto = $o_Row['SumaOrdenImpuesto'];
                $this->f_SumaOrdenNeto     = $o_Row['SumaOrdenNeto'];
            }
            
            $this->s_MonedaPrf = GSS_MonedaMastFN::getSiglaxId( $o_MST_ListaPrecioCabeceraBN->getIdMoneda() );
			*/
        }
        catch ( Exception $o_Exception )
        {
            pr( $o_Exception->getMessage() );
        }
        
        ViewResponse::getInstance()->setMethodAjax();
    }

    public function executeConvertirOrdenEstandar()
    {
        $i_Id     = ( int ) $this->getRequestParameter( 'id' );

        $a_Rs = array();
        
        $a_Rs['error'] = false;
        $a_Rs['mensaje_error'] = "";

        $con = Conexion::getConexion();
        $con->begin();

        try
        {
            myUser::getUser()->validar_session();

            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenId( $i_Id );

            $o_CotizacionesBL = new CotizacionesBL();
            $o_CotizacionesBL->convertirOrdenEstandar( $o_VTA_OrdenBN );
            
            $a_Rs['id_orden']  = $o_VTA_OrdenBN->getOrdenId();
            $a_Rs['num_orden'] = $o_VTA_OrdenBN->getOrdenNum();

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeCopiarOrdenVenta()
    {
        $i_Id = ( int ) $this->getRequestParameter( 'id' );
        $i_DiasAlquiler = ( int ) $this->getRequestParameter( 'dias_alquiler' );

        $a_Rs = array();
        
        $a_Rs['error'] = false;
        $a_Rs['mensaje_error'] = "";

        try
        {
            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenId( $i_Id );
            $o_VTA_OrdenBN->setDiasAlquiler( $i_DiasAlquiler );

            $o_CotizacionesBL = new CotizacionesBL();
            $o_CotizacionesBL->copiarOrdenVenta( $o_VTA_OrdenBN );

            $i_IdFinal = $o_VTA_OrdenBN->getOrdenId();
            
            //pr( "Id Final -> $i_IdFinal || Padre -> ".$o_VTA_OrdenBN->getOrdenPadre() );

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_IdFinal;
        }
        catch( Exception $e )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error'] = $e->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    private function buildGrid()
    {
        $Placa = $this->getRequestParameter( "Placa" );
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new VTA_OrdenFN() );
        
        $o_GridAction->addAssignFilter( "OrdenTipoId" );
        $o_GridAction->addAssignFilter( "OrdenEstado" );
        //$o_GridAction->addAssignFilter( "OrdenNum" );
        $o_GridAction->addAssignFilter( "ClienteDocNum" );
        $o_GridAction->addAssignFilter( "VendedorOrden" );
        $o_GridAction->addAssignFilter( "OrdenTipoComercialId" );
        $o_GridAction->addAssignFilter( "OrdenTipoClasificacionId" );
        $o_GridAction->addAssignFilter( "Placa" );
        
        
        $o_GridAction->addConditionFilter( "Placa", VTA_OrdenFN::Placa, "=", $Placa  );
        $o_GridAction->addConditionFilter( "OrdenNum", VTA_OrdenFN::OrdenNum, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "ClienteNombre", VTA_OrdenFN::ClienteNombre, "LIKE", "%%s%" );
        
        $o_GridAction->addConditionFilter( "FechaDocumento1", VTA_OrdenFN::OrdenFecha,  ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", VTA_OrdenFN::OrdenFecha,  "<=", '23:59:59' );

        $o_GridAction->addMethodDefault( "CiaCod", myUser::getUser()->getIdBusiness() );
        $o_GridAction->addMethodDefault( "IdSucursal", myUser::getUser()->getIdSucursal() );

        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //FILTRO PARA QUE LOS VENDEDORES SOLO VEA SUS ORDENES
        if( !myUser::getUser()->getObjectRol()->tieneAccesoGlobal() )
        {
            if( !myUser::getUser()->getObjectRol()->tieneRolAdministrativo() )
            {
                //$o_GridAction->addMethodDefault( VTA_OrdenFN::UsuarioCreacion, array( 'Condition'=>'=', 'Value'=>"" ) );
                $o_GridAction->addMethodDefault( VTA_OrdenFN::UsuarioCreacion, myUser::getUser()->getUserId() );
            }
        }
        /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        if( $this->getRequestParameter( "ModuloPto" ) )
        {
            if( !$this->getRequestParameter( "OrdenEstado" ) )
            {
                $s_Sql1 = " SELECT OrdenId FROM VTA_Orden WHERE OrdenEstado='O' AND OrdenObs='' ";
                if( $this->getRequestParameter( "FechaDocumento1" ) )
                {
                    $s_Sql1 .= " AND OrdenFecha>='".$this->getRequestParameter( "FechaDocumento1" )." 00:00:00' ";
                }
                if( $this->getRequestParameter( "FechaDocumento2" ) )
                {
                    $s_Sql1 .= " AND OrdenFecha<='".$this->getRequestParameter( "FechaDocumento2" )." 23:59:59' ";
                }
                //$o_GridAction->addMethodDefault( VTA_OrdenFN::OrdenId, array( 'Condition'=>'NOT IN', 'Value'=>"( $s_Sql1 )" ) ); //AND coalesce(OrdenTotalaPagar,0)<=0
                $o_GridAction->addConditionFilter( "ModuloPto", VTA_OrdenFN::OrdenId, "NOT IN", "( $s_Sql1 )"  );

                $s_Sql2 = " SELECT OrdenId FROM VTA_Orden WHERE OrdenEstado='A' ";
                if( $this->getRequestParameter( "FechaDocumento1" ) )
                {
                    $s_Sql2 .= " AND OrdenFecha>='".$this->getRequestParameter( "FechaDocumento1" )." 00:00:00' ";
                }
                if( $this->getRequestParameter( "FechaDocumento2" ) )
                {
                    $s_Sql2 .= " AND OrdenFecha<='".$this->getRequestParameter( "FechaDocumento2" )." 23:59:59' ";
                }
                //$o_GridAction->addMethodDefault( VTA_OrdenFN::OrdenId, array( 'Condition'=>'NOT IN', 'Value'=>"( $s_Sql2 )" ) ); //AND coalesce(OrdenTotalaPagar,0)<=0
                $o_GridAction->addConditionFilter( "ModuloPto", VTA_OrdenFN::OrdenId, "NOT IN", "( $s_Sql2 )"  );
            }
        }

        if( $this->getRequestParameter( 'CobranzaEstado' ) )
        {
            $s_EstadoCob = $this->getRequestParameter( 'CobranzaEstado' );
            $o_GridAction->addMethodDefault( "( SELECT CobranzaEstado FROM VTA_Documento WHERE DocumentoParentId=VTA_Orden.OrdenId )", array( 'Condition'=>'=', 'Value'=>"'$s_EstadoCob'" ) );
        }
        /*
        if( $this->getRequestParameter( 'CodItem' ) )
        {
            $s_Cod = $this->getRequestParameter( 'CodItem' );
            ParameterWR::getInstance()->setVar( "CodItem", 1 );
            $o_GridAction->addConditionFilter( "CodItem", "( SELECT count(*) FROM VTA_OrdenDetalle where OrdenId=VTA_Orden.OrdenId and ItemCod in ('$s_Cod') )", ">=", "%s" );
        }
        */
        if( $this->getRequestParameter( 'IdItem' ) )
        {
            $o_GridAction->addMethodDefault( "OrdenId", array( "Condition" => "IN", "Value" => "( SELECT OrdenId FROM VTA_OrdenDetalle WHERE ItemCod LIKE '%".$this->getRequestParameter( 'IdItem' )."' )" ) );
        }
        
        return $o_GridAction; 
    }
}