<?php
class SaveOrdenVtaDetailAction extends wtActions
{
    public function execute()
    {
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $i_Id       = ( int ) $this->getRequestParameter( 'i_Id' );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            if( $s_TipoProc == "codigo_barras" )
            {
                $s_CodBarras = $this->getRequestParameter( 'CodigoBarras' );
                if( trim( $s_CodBarras ) != "" )
                {
                    $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                    $o_ALM_ItemMastFN->setCodigoBarrasFabricante( $s_CodBarras );
                    $a_ALM_ItemMast = $o_ALM_ItemMastFN->select();

                    if( !$a_ALM_ItemMast )
                    {
                        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_CodBarras );
                        if( $o_ALM_ItemMastBN )
                        {
                            $a_ALM_ItemMast[0] = $o_ALM_ItemMastBN;
                        }
                    }

                    if( $a_ALM_ItemMast )
                    {
                        $o_ALM_ItemMastBN = $a_ALM_ItemMast[0];

                        ParameterWR::getInstance()->setVar( "IdItem", $o_ALM_ItemMastBN->getIdItem() );
                    }

                }
            }

            $Secuencia      = is_null( $this->getRequestParameter( 'Secuencia' ) ) ? null : ( int ) $this->getRequestParameter( 'Secuencia' );
            $IdItem         = $this->getRequestParameter( 'IdItem' );
            $IdAlmacen      = $this->getRequestParameter( 'IdAlmacen' );
            $IdLote         = $this->getRequestParameter( 'IdLote' );
            $CantidadPedida = floatval( $this->getRequestParameter( 'CantidadPedida' ) );
            //$PrecioUnitario = floatval( $this->getRequestParameter( 'PrecioUnitario' ) ); //se tiene que modificar si se hace el proceso de bajar precio
            //$NoAfecImpuesto = $this->getRequestParameter( 'NoAfectoImpuestoVentasFlag' );
        
            $o_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_VTA_OrdenDetalleBN->setOrdenId( $i_Id );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleNum( $Secuencia );
            $o_VTA_OrdenDetalleBN->setItemCod( $IdItem );
            $o_VTA_OrdenDetalleBN->setAlmacenCod( $IdAlmacen );
            $o_VTA_OrdenDetalleBN->setLoteNum( $IdLote );
            $o_VTA_OrdenDetalleBN->setOrdenDetalleCantidad( $CantidadPedida );
            $o_VTA_OrdenDetalleBN->setLimpiarDscto( true );

            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $b_Result = $o_CotizacionesDetalleBL->iniciarProceso( $o_VTA_OrdenDetalleBN );

            //se agrega procedimiento para poder agregar detalles despues de la facturacion
            $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenById( $i_Id );

            $this->o_SR_MovimientoBN = SR_MovimientoFN::selectOneRefNum( $o_VTA_OrdenBN->getOrdenNum() );
            if( $this->o_SR_MovimientoBN )
            {
                if( $this->o_SR_MovimientoBN->getImpresionEstado() == SR_MovimientoBN::ESTADO_IMP_C )
                {
                    throw new Exception( "No se puede ejecutar ningun procedimiento por que el despacho se encuentra completado." );
                }
            }

            if( $o_VTA_OrdenBN->getDocReferenciaId() )
            {
                $o_VTA_DocumentoBN = $o_VTA_OrdenBN->getObjectVTADocumento();

                //si existe factura
                $o_VTA_DocumentoDetalleFN = new VTA_DocumentoDetalleFN();
                $o_VTA_DocumentoDetalleFN->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                $o_VTA_DocumentoDetalleFN->setItemCodigo( $o_VTA_OrdenDetalleBN->getItemCod() );
                $a_VTA_DocumentoDetalle = $o_VTA_DocumentoDetalleFN->select();
                if( $a_VTA_DocumentoDetalle )
                {
                    //si existe solo se actualiza la cantidad
                    $o_VTA_DocumentoDetalleBN = $a_VTA_DocumentoDetalle[0];

                    if( $o_VTA_OrdenDetalleBN->getOrdenDetalleCantidad() < $o_VTA_DocumentoDetalleBN->getCantidadRecibida() )
                    {
                        throw new Exception( "la cantidad a actualizar no puede ser menor a la cantidad entregada." );
                    }

                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP();
                    $o_VTA_DocumentoDetalleDP->setIdTipoDocumento( $o_VTA_DocumentoDetalleBN->getIdTipoDocumento() );
                    $o_VTA_DocumentoDetalleDP->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                    $o_VTA_DocumentoDetalleDP->setNumeroDocumento( $o_VTA_DocumentoDetalleBN->getNumeroDocumento() );
                    $o_VTA_DocumentoDetalleDP->setSecuencia( $o_VTA_DocumentoDetalleBN->getSecuencia() );
                    $o_VTA_DocumentoDetalleDP->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                    $o_VTA_DocumentoDetalleDP->setCantidadPedida( $o_VTA_OrdenDetalleBN->getOrdenDetalleCantidad() );
                    $o_VTA_DocumentoDetalleDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_VTA_DocumentoDetalleDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDetalleDP->update();
                }
                else
                {
                    //como no existe se acualiza con el monto 0
                    $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $o_VTA_OrdenDetalleBN->getItemCod() );

                    $o_VTA_DocumentoDetalleBN = new VTA_DocumentoDetalleBN();
                    $o_VTA_DocumentoDetalleBN->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                    $o_VTA_DocumentoDetalleBN->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                    $o_VTA_DocumentoDetalleBN->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );

                    $i_Id = VTA_DocumentoDetalleFN::recuperarId( $o_VTA_DocumentoBN->getIdTipoDocumento(), $o_VTA_DocumentoBN->getIdCompania(), $o_VTA_DocumentoBN->getNumeroDocumento() );
                    $o_VTA_DocumentoDetalleBN->setSecuencia( $i_Id );
                    $o_VTA_DocumentoDetalleBN->setTipoDetalle( VTA_OrdenDetalleBN::TIPO_PRODUCTO );
                    $o_VTA_DocumentoDetalleBN->setItemCodigo( $o_VTA_OrdenDetalleBN->getItemCod() );
                    $o_VTA_DocumentoDetalleBN->setAlmacenCodigo( $o_VTA_DocumentoBN->getAlmacenDespacho() );
                    $o_VTA_DocumentoDetalleBN->setLote( ALM_ItemAlmacenStockBN::LOTE_POR_DEFECTO );
                    $o_VTA_DocumentoDetalleBN->setCondicion( "1" );
                    $o_VTA_DocumentoDetalleBN->setIdUnidad( ( int ) $o_ALM_ItemMastBN->getUnidadVenta() );
                    $o_VTA_DocumentoDetalleBN->setIdItemTipo( $o_ALM_ItemMastBN->getIdItemTipo() );
                    $o_VTA_DocumentoDetalleBN->setIdTipoPrecio( "1" );
                    $o_VTA_DocumentoDetalleBN->setDescripcion( addslashes( $o_ALM_ItemMastBN->getDescripcionCompleta() ) );
                    $o_VTA_DocumentoDetalleBN->setIGVExoneradoFlag( "N" );
                    $o_VTA_DocumentoDetalleBN->setEstado( VTA_DocumentoDetalleBN::ESTADO_PREPARACION ); //por defecto cuando se trata de una orden de venta
                    $o_VTA_DocumentoDetalleBN->setCostoUnitarioProm( 0 );
                    $o_VTA_DocumentoDetalleBN->setCostoUnitarioMN( 0 );
                    $o_VTA_DocumentoDetalleBN->setCantidadPedida( $o_VTA_OrdenDetalleBN->getOrdenDetalleCantidad() );
                    $o_VTA_DocumentoDetalleBN->setRefParent( $o_VTA_OrdenDetalleBN->getOrdenDetalleNum() );

                    $o_VTA_DocumentoDetalleBN->setPrecioUnitario( 0 );
                    $o_VTA_DocumentoDetalleBN->setPrecioUnitarioMN( 0 );
                    $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidad( 0 );
                    $o_VTA_DocumentoDetalleBN->setMontoImpuestoUnidadMN( 0 );
                    $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidad( 0 );
                    $o_VTA_DocumentoDetalleBN->setMontoIncImpuestoUnidadMN( 0 );

                    $o_VTA_DocumentoDetalleBN->setMontoSubTotal( 0 );
                    $o_VTA_DocumentoDetalleBN->setMontoSubTotalMN( 0 );
                    $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuesto( 0 );
                    $o_VTA_DocumentoDetalleBN->setMontoSubTotalImpuestoMN( 0 );
                    $o_VTA_DocumentoDetalleBN->setMontoTotalNeto( 0 );
                    $o_VTA_DocumentoDetalleBN->setMontoTotalNetoMN( 0 );

                    $o_VTA_DocumentoDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                    $o_VTA_DocumentoDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                    $o_VTA_DocumentoDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $o_VTA_DocumentoDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );

                    $o_VTA_DocumentoDetalleDP = new VTA_DocumentoDetalleDP( $o_VTA_DocumentoDetalleBN );
                    $o_VTA_DocumentoDetalleDP->save();
                }
            }

            $con->commit();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}