<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/fixedheader/3.1.7/css/fixedHeader.dataTables.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/fixedheader/3.1.7/js/dataTables.fixedHeader.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>

<div id="content_alert" style=""></div>

<div id="content_archivos">

    <br>
    <?php if( $b_Control ){ ?>
    <form name="form1" id="form1" method="POST" action="" onsubmit="return false;" class=""  enctype="multipart/form-data">
        <input type="hidden" name="Id" id="Id" value="<?=$s_Id?>">
        <input type="hidden" name="TipoOpeArchivo" id="TipoOpeArchivo" value="NUEVO">
        <input type="hidden" name="SecuenciaArchivo" id="SecuenciaArchivo" value="">
    
        <div class="tab-content" id="myTabContent">
    
            <div class="form-row mx-0">
                <div class="col-md-6 mb-1">
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="customFile" name="customFile"  lang="es">
                        <label class="custom-file-label" for="customFile">Seleccionar Archivo</label>
                    </div>
                </div>
                <div class="col-md-3 mb-1">
                    <select class="form-control form-control-sm custom-select my-0 mr-sm-2" name="TipoArchivoId" id="TipoArchivoId" required>
                        <option value=""> - TIPO DOCUMENTO - </option>
                        <?php foreach ( VTA_OrdenTipoArchivoFN::selectActivos() as $o_VTA_OrdenTipoArchivoBN ){ ?>
                        <option value="<?=$o_VTA_OrdenTipoArchivoBN->getTipoId()?>"> <?=$o_VTA_OrdenTipoArchivoBN->getDescripcion()?> </option>
                        <?php } ?>
                    </select>
                </div>
                <div class="col-md-3 mb-1">
                    <button type="button" class="btn btn-info btn-block" onclick="$( '#SecuenciaArchivo' ).val( '' ); $( '#TipoOpeArchivo' ).val( 'NUEVO' ); guardarArchivo();">Guardar Archivo</button>
                </div>
            </div>
    
            <script>
            $( ".custom-file-input" ).on
            (
                "change", 
                function() 
                {
                    var fileName = $( this ).val().split( "\\" ).pop();
                    $( this ).siblings( ".custom-file-label" ).addClass( "selected" ).html( fileName );
                }
            );
            </script>
    
            <!-- <hr noshade="noshade" align="center" style="border-color: #CFCFCF;  color: #CFCFCF; height: 0.1px; text-align: center;"> -->
            
        </div>
        
    </form>
    <?php } ?>
    <table id="example" class="table table-striped table-bordered" style="width:100%">
        <thead>
            <tr>
                <th width="2%" style="text-align: center;"> # </th>
                <th style="text-align: center;">Nombre</th>
                <th style="text-align: center;">Tipo</th>
                <th style="text-align: center;">Fecha</th>
                <th style="text-align: center;">Usuario</th>
                <th style="text-align: center;">&nbsp;</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ( VTA_OrdenArchivosFN::getArrayObjArchhivos( $s_Id ) as $i_Key => $o_VTA_OrdenArchivosBN ) { ?>
            <tr>
                <td align="center"><?=$i_Key+1?></td>
                <td align="center" nowrap=""><?=$o_VTA_OrdenArchivosBN->getNombre()?></td>
                <td align="center"><?=$o_VTA_OrdenArchivosBN->getObjectOrdenTipoArchivo()->getDescripcion()?></td>
                <td align="center"><?=substr( $o_VTA_OrdenArchivosBN->getFechaCreacion(), 0, 10 )?></td>
                <td align="center"><?=$o_VTA_OrdenArchivosBN->getUsuarioCreacion()?></td>
                <td align="center">
                    <button class="btn" title="" onclick="window.open( '<?=$o_VTA_OrdenArchivosBN->getUbicacionURL()?>', '_BLANK' ); return false;"> <img src="<?=getUrlImage( "btnDisplay.gif" )?>" title="Ver Documento" style="cursor:pointer"> </button>
                     <?php if( $b_Control ){ ?>
                    <button class="btn" title="" onclick="$( '#SecuenciaArchivo' ).val( '<?=$o_VTA_OrdenArchivosBN->getIdSecuencia()?>' ); $( '#TipoOpeArchivo' ).val( 'ELIMINAR' ); guardarArchivo(); return false;">
                        <img src="<?=getUrlImage( "btnDelete.gif" )?>" title="Eliminar" style="cursor:pointer">
                    </button> 
                    <?php } ?>
                </td>
            </tr>
            <?php } ?>
        </tbody>
    </table>

</div>

<script type="text/javascript">
$('#example').DataTable
(
    {
        language: { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
        responsive: { details: true },
        searching: false,
        info:     false,
        lengthChange: false,
        //paging:   false,
        dom: 'lrtip',
        fixedHeader: 
        {
            header: true,
            footer: true
        }
    }
);
</script>

<script type="text/javascript">
guardarArchivo = function()
{
    if( $( '#SecuenciaArchivo' ).val() == ""  )
    {
        if( $( "#customFile" ).val() == "" )
        {
            showAlertBootStrap( 'content_alert', 'alert-danger', "Seleccione un archivo." );
            return false;
        }
    }
    if( $( "#TipoArchivoId" ).val() == "" )
    {
        if( $( '#TipoOpeArchivo' ).val() != "ELIMINAR" )
        {
            showAlertBootStrap( 'content_alert', 'alert-danger', "Seleccione el Tipo de Documento." );
            return false;
        }
    }
    
    x = confirm( "Esta seguro de realizar el procedimiento?" );
    if( x )
    {
        blockContent( 'content_archivos' );
        var formData = new FormData( document.getElementById( "form1" ) );
        $.ajax
        (
            {
                url: '<?php echo buildUrl( 'cot/guadarArchivoOrd', "" ) ?>',
                type: 'POST',
                data: formData,
                async: false,
                cache: false,
                contentType: false,
                enctype: 'multipart/form-data',
                processData: false,
                success: function ( response )
                {
                    var o_json = jQuery.parseJSON( response );
                    unBlockContent( 'content_archivos' );
                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        return false;
                    }
                    location.reload();
                }
            }
        );
    }
}
</script>