<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class cxpagarActions extends wtActions
{
    public function executeBuscarComprobantesProv()
    {
        $s_IdPersona = $this->getRequestParameter( 'IdPersona' );
        $s_IdMoneda  = $this->getRequestParameter( 'IdMoneda' );

        $s_FechaProgramacion  = $this->getRequestParameter( 'FechaProgramacion' );

        /*
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoFN->setClienteNumero( $s_IdPersona );
        $o_VTA_DocumentoFN->setEstado( VTA_DocumentoBN::ESTADO_CERRADO );
        $o_VTA_DocumentoFN->setCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_PENDIENTE );
        $o_VTA_DocumentoFN->setMonedaDocumento( $s_IdMoneda );
        //$o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::MontoSaldo, ">", 0 );
        $this->a_VTA_Documento = $o_VTA_DocumentoFN->select();
        */

        $o_CP_ObligacionesFN = new CP_ObligacionesFN();
        $o_CP_ObligacionesFN->setProveedorId( $s_IdPersona );
        $o_CP_ObligacionesFN->setIdMoneda( $s_IdMoneda );
        $o_CP_ObligacionesFN->setEstado( CP_ObligacionesBN::ESTADO_VALIDADO );
        $o_CP_ObligacionesFN->setEstadoPagado( CP_ObligacionesBN::ESTADO_PAG_PENDIENTE );
        $o_CP_ObligacionesFN->setFechaProgramacion( $s_FechaProgramacion );
        $this->a_CP_Obligaciones = $o_CP_ObligacionesFN->select();

        ViewResponse::getInstance()->setMethodAjax();
    }

    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }

    public function executeGridRecibo()
    {
        //set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new CP_DocReciboFN() );

        $o_GridAction->addAssignFilter( "TipoDocCliente" );
        $o_GridAction->addConditionFilter( "NumTipoDocCliente", CP_DocReciboFN::NumTipoDocCliente,  "LIKE", "%%s%" );
        $o_GridAction->addAssignFilter( "IdTipoPago" );
        $o_GridAction->addConditionFilter( "ReciboNumero", CP_DocReciboFN::ReciboNumero,  "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", CP_DocReciboFN::ReciboFecha,  ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", CP_DocReciboFN::ReciboFecha,  "<=", '23:59:59' );
        $o_GridAction->addAssignFilter( "IdMoneda" );
        $o_GridAction->addAssignFilter( "IdBanco" );
        $o_GridAction->addAssignFilter( "IdCuenta" );
        $o_GridAction->addAssignFilter( "Estado" );

        //$o_GridAction->addOrder( "Estado", FCO_CierreFN::Estado );

        $o_GridAction->addOrderDefault( CP_DocReciboFN::IdDocRecibo, true );

        $o_GridAction->addRowsToShow(
            "IdDocRecibo", "IdSucursal", "MonedaDes", "ReciboNumero", "ReciboFecha", "NombreCliente", "Monto", "Saldo",
            "TipoPagoNombre", "SucursalNombre", "FlujoEstadoDesc", "BancoDesc", "NumeroCuenta", "TipoDocCliente", "NumTipoDocCliente", "EstadoDesc"
        );

        $o_GridAction->setNumberRecordsShow( 100 );

        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->Titulo = "Cuenta por Pagar - Pagos";

        $this->s_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );

        $this->s_MensajeError = "";

        try
        {
            //se recupera la moneda por defecto para el sistema
            $this->s_MonedaSistema  = MST_ListaPrecioCabeceraFN::getMonedaCodeDefault();

            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastFN->setEstado( "A" );
            $o_GSS_MonedaMastFN->addOrderBy( GSS_MonedaMastFN::IdMoneda, false );
            $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();

            $this->o_FCO_DocReciboBN = new FCO_DocReciboBN();
            $this->o_FCO_DocReciboBN->setTipoDocCliente( "RUC" );

            $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            if( !$this->TipodeCambio )
            {
                throw new Exception( "No se encuentra registrado el Tipo de Cambio." );
            }

            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            $this->s_MensajeError = $o_Exception->getMessage();
        }
    }
}