<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<style type="text/css">
.ui-dialog .ui-dialog-titlebar-close 
{
    position: absolute;
    right: .3em;
    top: 50%;
    width: 20px;
    margin: -10px 0 0 0;
    padding: 1px;
    height: 20px;
    background-position: -96px -128px;
    /*background-image: url("images/ui-icons_056b93_256x240.png");*/
    background-image: url("<?=Constantes::ROOT_DIR_APP?>web/css/jquery/themes/start_1.12.1/images/ui-icons_056b93_256x240.png");
}
</style>

<script type="text/javascript">
saveForm = function()
{
    blockContent( 'content_buttons' );
    var strFormSerialize = $( 'form' ).serialize();
    
    executeAjaxJson
    ( 
        "<?php echo buildUrl( 'cot/saveAddEdit', "" ) ?>", 
        strFormSerialize,
        function( o_json )
        {
            unBlockContent( 'content_buttons' );
            if( o_json.error )
            {
                showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                //mostrarMensajeError( o_json.mensaje_error );
                return false;
            }
            
            location.href = "<?=buildUrl( 'cot/detailVta', "i_Id=" )?>" + o_json.id;
        } 
    );
    return false;
}

cargarComprobantesConSaldo = function()
{
	blockContent( 'content_comprobantes' );

    $( "#form1" )[0].reset();
    
	var a_Params  = [];
    
    var IdMoneda  = $( "#IdMonedaDocRef" ).val();
    a_Params.push( "IdMoneda=" + IdMoneda );
    var IdPersona = $( "#ClienteNumero" ).val();
    a_Params.push( "IdPersona=" + IdPersona );
    
    executeAjaxUpdater
    ( 
        "content_list_comprobantes", 
        "<?php echo buildUrl( 'caja/buscarComprobantes' ) ?>", 
        a_Params.join( "&" ), 
        function( response )
        {
        	unBlockContent( 'content_comprobantes' );

            if( !$( "#content_form" ).is( ":visible" ) )
            {
            	var options = {};
                $( "#content_form" ).toggle( "blind", options, 500 );
                $( "#btnCobranza" ).prop( 'disabled', false );
            }
            //aqui se ejecuta un nuevo proceso, para moneda y banco y cuenta 2021-05-17
            actualizarCambiosPorMoneda();
        } 
    );
}

cargarRecibosConSaldo = function()
{
    blockContent( 'content_recibos' );
    
    var IdPersona = $( "#ClienteNumero" ).val();
    var a_Params  = [];
    a_Params.push( "IdPersona=" + IdPersona );
    
    executeAjaxUpdater
    ( 
        "content_list_recibos", 
        "<?php echo buildUrl( 'caja/buscarRecibos' ) ?>", 
        a_Params.join( "&" ), 
        function( response )
        {
            unBlockContent( 'content_recibos' );
        } 
    );
}

actualizarSumaTotalReferencia = function()
{
	var elms = $( '#content_list_comprobantes' ).find( ':input[type=text]' );
    var sumaTotal = 0;
	$.each
    (
    	elms, function( index, item )
        {
            if( $( item ).val() != "" )
            {
            	sumaTotal = sumaTotal + parseFloat( $( item ).val() ); 
            }
        }
    );

	if( sumaTotal >= 1000 )
    {
        $( "#MontoTotalITF" ).prop( 'readonly', false );
        $( "#RegistrarITF" ).val( 1 );

        var FactorDiv = 0.005 / 100;
        var TotalITF  = redondear( sumaTotal * FactorDiv, 2 );
        $( "#MontoTotalITF" ).val( TotalITF );
    }
	else
    {
        $( "#MontoTotalITF" ).prop( 'readonly', true );
        $( "#MontoTotalITF" ).val( "" );
        $( "#RegistrarITF" ).val( 0 );
    }

    $( "#MontoTotalRef" ).val( redondear( sumaTotal, 2 ) );
    $( "#Monto" ).val( redondear( sumaTotal, 2 ) );
    $( "#IdMoneda" ).trigger( 'change' );
}

//funcion para realizar una cobranza, quiere decir que se aplica el recibo a comprobantes
actualizarSaldoDocumento = function()
{
    x = confirm( "Esta seguro de realizar la Cobranza?" );
    if( x )
    {
    	var serialice1 = $( "#content_comprobantes" ).find( "input, select" ).serialize();
        var serialice2 = $( "#form1" ).serialize();
        var IdPersona = $( "#ClienteNumero" ).val();
        var serialice = serialice1 + '&' + serialice2 + '&IdPersona=' + IdPersona + "&TipoProcRec=nvo&TipoProcApli=registrar";
    
        blockContent( 'content_formulario' );
    
        executeAjaxJson
        ( 
            "<?php echo buildUrl( 'caja/addeditRecibo', "" ) ?>", 
            serialice,
            function( o_json )
            {
                unBlockContent( 'content_formulario' );
                if( o_json.error )
                {
                    showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                    return false;
                }
                
                $( "#form1" )[0].reset();
                cargarComprobantesConSaldo();
                showAlertBootStrap( 'content_alert', 'alert-success', "Se realiz&oacute; la Cobranza Satisfactoriamente." );
                $( "#content_form" ).toggle( "blind", {}, 500 );
                $( '#IdTipoPago' ).trigger( 'change' );

                verPDF( o_json.IdDocRecibo );
            } 
        );    
    }
}

//se deja una funcion para solo crear recibos, se tiene a activar un checkbox que indique q solo es para crear recibo
crearNuevoRecibo = function()
{
    
}


verPDF = function( IdDocRecibo )
{
    window.open('<?=buildUrl( 'caja/cobranzaPDF' )?>/IdDocRecibo/' + IdDocRecibo, '_blank', '');
}
</script>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="form-row mx-0">
        <div class="col-md-10 mb-1">
            <?php if( $b_ControlCaja ){ ?>
                <h4 class="text-info text-nowrap mb-0"><?=$Titulo?> | <?=$DesCajaSelect?> - <?=$DescTurnoSelect?></h4>
            <?php }else{ ?>
                <div class="form-row mx-0">
                    <div class="col-md-8 mb-1">
                        <h4 class="text-info text-nowrap mb-0"><?=$Titulo?></h4>
                    </div>
                    <div class="col-md-2 mb-1">
                        <button type="button" class="form-control btn btn-primary" onclick="aperturarCaja();"> Aperturar Caja </button>
                    </div>
                </div>
            <?php } ?>
        </div>
        <div class="col-md-2 mb-1 text-right">
            <input type="button" class="form-control btn btn-primary" value="REGRESAR" onclick="location.href='<?=buildUrl('caja/list' )?>';" >
        </div>
    </div>
</div>

<div id="content_alert" style=""></div>

<div class="card" id="content_datos_cliente">
    <h5 class="card-header">Datos de Cliente</h5>
    <div class="card-body" style="padding: 10px;">
    
        <div class="form-row mx-0">
        
            <div class="col-md-2 mb-1">
                <label class="col-form-label" for="TipoDocCliente">Tipo Doc:</label>
                <select class="form-control custom-select my-0 mr-sm-2" name="TipoDocCliente" id="TipoDocCliente" onchange="" required>
                <?php foreach ( MST_PersonaMastBN::getArrayTipoDocumento() as $s_Key => $s_TipoDoc ){ ?>
                    <option value="<?=$s_Key?>" <?php if( $o_FCO_DocReciboBN->getTipoDocCliente() == $s_Key ){ echo "SELECTED"; } ?> > <?=$s_Key?> </option>
                <?php } ?>
                </select>
            </div>
            <div class="col-md-3 mb-1">
                <label class="col-form-label" for="NumDocuCliente">Documento:</label>
                <div class="input-group mb-0">
                    <input type="hidden" name="ClienteNumero" id="ClienteNumero" value="">
                    <input type="text" id="NumDocuCliente" name="NumDocuCliente" class="form-control" onfocus="this.select();" onkeypress="return NumCheckEntero( event, this );" required>
                </div>
            </div>
            <div class="col-md-5 mb-1">
                <label for="NombreCliente" class="col-form-label">Nombres:</label>
                <input type="text" class="form-control" id="NombreCliente" placeholder="" name="NombreCliente" value="" autocomplete="off" required>
            </div>
        </div>
    </div>
</div>
    
<div class="dropdown-divider"></div>

<script type="text/javascript">
activarInput = function( value )
{
    //una validacion solo para el tipo efecivo - el input esta en read-only
    
    switch ( value )
    {
        case "1":
            $( "#ReciboNumero" ).prop( 'readonly', true );
            $( "#ReciboNumero" ).prop( 'required', true );
            $( "#IdBanco" ).val( 15 );
            $( "#IdBanco" ).trigger( "change" );
        break;
        default:
            $( "#ReciboNumero" ).prop( 'readonly', false );
            $( "#ReciboNumero" ).prop( 'required', false );
        break; 
    } 
}
calcularFechaVen = function()
{
    if( $( '#TerminoPago' ).val().trim() != "" )
    {
        dias    = $( '#TerminoPago' ).val();
        dia     = parseInt( '<?php echo date('j')?>' ) + parseInt( dias );
        mes     = parseInt( '<?php echo date('n')?>' ) - 1;
        anio    = parseInt( '<?php echo date('Y')?>' );
        
        var fechaCalculada =  new Date( anio, mes, dia ); 
        
        diaS  = String( fechaCalculada.getDate() );
        mesS  = String( fechaCalculada.getMonth() + 1 );
        anioS = String( fechaCalculada.getFullYear() );
        
        dia  = str_pad( diaS, 2, '0', 'STR_PAD_LEFT' );
        mes  = str_pad( mesS, 2, '0', 'STR_PAD_LEFT' );
        anio = str_pad( anioS, 2, '0', 'STR_PAD_LEFT' );
        
        $( '#FechaVencimiento' ).val( anio + "-" + mes + "-" + dia );
    }
    else
    {
    	$( '#FechaVencimiento' ).val( "" );
    }
}
calcularMontoCambio = function( moneda_select )
{
    var monto_pagar   = parseFloat( $( "#MontoTotalRef" ).val() );
    if( monto_pagar > 0 )
    {
        //var moneda_select = $( "#IdMoneda" ).val();
        var moneda_cab    = "<?=$s_MonedaSistema?>";
        var moneda_ord    = $( "#IdMonedaDocRef" ).val();
        var tipo_cambio_c = <?=$TipodeCambio?>;
    
        var monto_cambio  = 0;

        pr( "moneda_cab: " + moneda_cab );
        pr( "moneda_ord: " + moneda_ord );
        pr( "moneda_select: " + moneda_select );
    
        if( moneda_cab == "LO" ) //moneda del sistema
        {
            if( moneda_select == moneda_ord )
            {
            	monto_cambio = monto_pagar;
            }
            else
            {
            	if( moneda_select == "LO" && moneda_ord == "EX" )
                {
                    pr( "ing 1" );
            		monto_cambio = redondear( monto_pagar * tipo_cambio_c, 2 );
                }
                if( moneda_select == "EX" && moneda_ord == "LO" )
                {
                	pr( "ing 2" );
                    monto_cambio = redondear( monto_pagar / tipo_cambio_c, 2 );
                }
            }
        }
        if( moneda_cab == "EX" ) //moneda del sistema
        {
            if( moneda_select == moneda_ord )
            {
                monto_cambio = monto_pagar;
            }
            else
            {
                if( moneda_select == "LO" && moneda_ord == "EX" )
                {
                    pr( "ing 1" );
                    monto_cambio = redondear( monto_pagar * tipo_cambio_c, 2 );
                }
                if( moneda_select == "EX" && moneda_ord == "LO" )
                {
                    pr( "ing 2" );
                    monto_cambio = redondear( monto_pagar / tipo_cambio_c, 2 );
                }
            }
        }
    
        $( "#Monto" ).val( monto_cambio );
    }
}

actualizarCambiosPorMoneda = function()
{
    blockContent( "content_form" );
	var IdMoneda = $( '#IdMoneda' ).val();
	calcularMontoCambio( IdMoneda );
    
    //se actualiza combo cuenta por la moneda
    //$( '#IdCuenta' )[0].options.length = 0;
    //publicForSelectAjaxJSON( '<?php echo buildUrl( 'caja/requestCaja' ) ?>', 'TipoProc=BuscarCuentaBancaria&IdBanco='+$('#IdBanco').val()+'&IdMoneda='+this.value, 'IdCuenta', null, false );

	$( '#IdBanco' )[0].options.length = 0;
	publicForSelectAjaxJSON( '<?php echo buildUrl( 'caja/requestCaja' ) ?>', 'TipoProc=BuscarBancos&IdMoneda='+IdMoneda, 'IdBanco', resultCambio, false );
}
resultCambio = function()
{
    pr( "termino carga de bancos" );
    pr( arguments );

    var IdMoneda = $( '#IdMoneda' ).val();
    
    //se actualiza combo cuenta por la moneda
    $( '#IdCuenta' )[0].options.length = 0;
    publicForSelectAjaxJSON( '<?php echo buildUrl( 'caja/requestCaja' ) ?>', 'TipoProc=BuscarCuentaBancaria&IdBanco='+$('#IdBanco').val()+'&IdMoneda='+IdMoneda, 'IdCuenta', resultCambioBancos, false );
}
resultCambioBancos = function()
{
    unBlockContent( "content_form" );
    $( "#IdTipoPago" ).trigger( "change" );
}
</script>

<div class="card" id="content_formulario">
    <h5 class="card-header" style="display: inline-flex;">
        Formulario&nbsp;
        <button id="btnCobranza" type="button" class="btn btn-primary btn-sm" onclick="$( '#content_form' ).toggle( 'blind', {}, 500 );" disabled="disabled">Cobrar</button>
    </h5>
    <div class="card-body" style="padding: 10px; display: none;" id="content_form">
        <div class="card-body" style="padding-top: 0px; padding-bottom: 0px;">
            <form name="form1" id="form1" method="POST" action="" onsubmit="return false;">
            
                <div class="form-row mx-0">
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="TipoCambio">Tipo Cambio</label>
                        <input type="text" autocomplete="off" class="form-control text-center" name="TipoCambio" id="TipoCambio" value="<?=$TipodeCambio?>" readonly="readonly">
                    </div>
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="MontoTotalRef">Suma Total Ref</label>
                        <input type="text" autocomplete="off" class="form-control text-center" name="MontoTotalRef" id="MontoTotalRef" value="" readonly="readonly">
                    </div>

                    <div class="col-md-3 mb-1">
                        &nbsp;
                    </div>
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="MontoTotalITF">ITF 0.005 %</label>
                        <input type="text" autocomplete="off" class="form-control text-center" name="MontoTotalITF" id="MontoTotalITF" value="" readonly="readonly">
                        <input type="hidden" name="RegistrarITF" id="RegistrarITF" value="0" >
                    </div>
                </div>
                
                <div class="dropdown-divider"></div>
                
                <div class="form-row mx-0">
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="IdMoneda">Moneda</label>
                        <select class="form-control custom-select my-0 mr-sm-2" name="IdMoneda" id="IdMoneda" onchange="actualizarCambiosPorMoneda();" required >
                            <?php foreach ( GSS_MonedaMastFN::selectAll() as $o_GSS_MonedaMastBN ){ ?>
                            <option value="<?=$o_GSS_MonedaMastBN->getIdMoneda()?>" <?php if( $s_MonedaSistema==$o_GSS_MonedaMastBN->getIdMoneda() ){ echo "selected"; } ?> > <?=$o_GSS_MonedaMastBN->getDescripcion()?> </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="IdTipoPago">Forma de Pago</label>
                        <select class="form-control custom-select my-0 mr-sm-2" name="IdTipoPago" id="IdTipoPago" onchange="activarInput( this.value );" required>
                            <?php foreach ( FCO_TipoPagoFN::selectActivos() as $o_FCO_TipoPagoBN) { ?>
                            <option value="<?=$o_FCO_TipoPagoBN->getIdTipoPago()?>" <?php if( ""==$o_FCO_TipoPagoBN->getIdTipoPago() ){ echo "SELECTED"; } ?> > <?=$o_FCO_TipoPagoBN->getNombre()?> </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="Monto">Monto</label>
                        <input type="text" autocomplete="off" class="form-control text-center" onfocus="this.select();" name="Monto" id="Monto" value="" readonly="readonly" required>
                    </div>
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="ReciboFecha">Fecha de Pago</label>
                        <div class="">
                            <div class="input-group mb-2">
                                <div class="input-group-prepend">
                                    <div class="input-group-text" style="padding: .1rem .75rem;"><svg class="svg-inline--fa fa-calendar-alt fa-w-14" aria-hidden="true" focusable="false" data-prefix="far" data-icon="calendar-alt" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512" data-fa-i2svg=""><path fill="currentColor" d="M148 288h-40c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v40c0 6.6-5.4 12-12 12zm108-12v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm96 0v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm-96 96v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm-96 0v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm192 0v-40c0-6.6-5.4-12-12-12h-40c-6.6 0-12 5.4-12 12v40c0 6.6 5.4 12 12 12h40c6.6 0 12-5.4 12-12zm96-260v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V112c0-26.5 21.5-48 48-48h48V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h128V12c0-6.6 5.4-12 12-12h40c6.6 0 12 5.4 12 12v52h48c26.5 0 48 21.5 48 48zm-48 346V160H48v298c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z"></path></svg><!-- <i class="far fa-calendar-alt"></i> --></div>
                                </div>
                                <input type="text" class="form-control text-center" id="ReciboFecha" name="ReciboFecha" style="border-radius: .2rem;" value="<?=date( "Y-m-d" )?>" readonly="">
                                <script type="text/javascript">
                                //$( "#FechaDocumento1" ).datepicker( { dateFormat: "yy-mm-dd", changeYear:true, yearRange: "-5:+0", changeMonth: true, onClose: function (){ this.focus(); } } );
                                </script>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-row mx-0">
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="ReciboNumero">Nro de Operaci&oacute;n</label>
                        <input type="text" class="form-control " name="ReciboNumero" id="ReciboNumero" placeholder="" value="" aria-describedby="basic-addon2" required>
                    </div>
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="IdBanco">Banco</label>
                        <select class="form-control custom-select my-0 mr-sm-2" name="IdBanco" id="IdBanco"
                            onchange="$('#IdCuenta')[0].options.length = 0; publicForSelectAjaxJSON('<?php echo buildUrl( 'caja/requestCaja' ) ?>', 'TipoProc=BuscarCuentaBancaria&IdBanco='+this.value+'&IdMoneda='+$('#IdMoneda').val(), 'IdCuenta',null,false);" 
                                >
                            <!-- <option value=""> - SELECCIONE - </option> -->
                            <?php foreach ( GSS_BancoFN::selectActivoCuenta() as $o_GSS_BancoBN ){ ?>
                            <option value="<?=$o_GSS_BancoBN->getIdBanco()?>" > <?=$o_GSS_BancoBN->getDescripcionLocal()?> </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="IdCuenta">Cuenta Deposito</label>
                        <select class="form-control custom-select my-0 mr-sm-2" name="IdCuenta" id="IdCuenta" onchange="" required>
                            <option value=""> - SELECCIONE - </option>
                        </select>
                    </div>
                    <div class="col-md-3 mb-1">
                        <label class="col-form-label" for="TerminoPago">Fecha Vencimiento</label>
                        <div class="row">
                            <div class="col">
                                <input type="text" class="form-control text-center" placeholder="Dia" name="TerminoPago" id="TerminoPago" onblur="calcularFechaVen();" onkeypress="return NumCheckEntero( event, this );">
                            </div>
                            <div class="col">
                                <input type="text" class="form-control text-center" placeholder="Fec. Vencimiento" name="FechaVencimiento" id="FechaVencimiento">
                            </div>
                        </div>
                    </div>
                </div>
        
                <div class="form-row mx-0" style="" id="content_buttons">
                    <div class="col-md-6 mb-1">
                        <button type="reset" class="btn btn-danger btn-sm btn-block" onclick="">LIMPIAR</button>
                    </div>
                    <div class="col-md-6 mb-1">
                        <button type="button" class="btn btn-primary btn-sm btn-block" onclick="actualizarSaldoDocumento();">REALIZAR COBRANZA</button>
                    </div>
                </div>
                
            </form>
        </div>

    </div>
</div>

<div class="dropdown-divider"></div>

<div class="card" id="content_comprobantes">
    <h5 class="card-header" style="display: inline-flex;">
        Comprobantes Pendientes &nbsp;
        <select class="form-control " name="IdMonedaDocRef" id="IdMonedaDocRef" onchange="cargarComprobantesConSaldo();" style="width: 150px;">
            <?php foreach ( GSS_MonedaMastFN::selectActivos() as $o_GSS_MonedaMastBN ){ ?>
            <option value="<?=$o_GSS_MonedaMastBN->getIdMoneda()?>" <?php if( $s_MonedaSistema==$o_GSS_MonedaMastBN->getIdMoneda() ){ echo "selected"; } ?> > <?=$o_GSS_MonedaMastBN->getDescripcion()?> </option>
            <?php } ?>
        </select>
    </h5>
    <div class="card-body" style="padding: 10px;">
        <div class="form-row mx-0" id="content_list_comprobantes">
        
            <div class="table-responsive">
                <table class="table table-sm table-bordered table-hover">
                    <thead class="thead-light">
                        <tr>
                            <th width="10%" style="text-align: center;" scope="col">Emitido</th>
                            <th width="10%" style="text-align: center;" scope="col">TipoDoc</th>
                            <th width="10%" style="text-align: center;" scope="col">Nro Documento</th>
                            <th width="10%" style="text-align: center;" scope="col">Vence</th>
                            <th width="10%" style="text-align: center;" scope="col">Moneda</th>
                            <th width="10%" style="text-align: center;" scope="col">Monto</th>
                            <th width="10%" style="text-align: center;" scope="col">Deuda</th>
                            <th width="10%" style="text-align: center;" scope="col">Aplicar</th>
                        </tr>
                    </thead>
                    
                </table>
            </div>
            
        </div>
    </div>
</div>
    
<div class="dropdown-divider"></div>    
<!--
<div class="" style="text-align: right; ">
    <button type="button" class="btn btn-primary btn-sm" aria-label="Right Align" onclick="abrirPopupRecibo();">
        <i class="fas fa-file"></i>
        Agregar Pago
    </button>
</div>
<div class="card" id="content_recibos">
    <h5 class="card-header">Recibos Pendientes</h5>
    <div class="card-body" style="padding: 10px;" id="content_list_recibos">
        
        <div class="row" style="margin-right:0; margin-left:0;">
            <div class="col-12" style="padding-right: 20px; padding-left: 20px;">
                <div class="table-responsive">
                    <table class="table table-sm table-bordered table-hover" style="margin-bottom: 0;">
                        <thead class="thead-light">
                            <tr>
                                <th width="10%" style="text-align: center;" scope="col">Medio Pago</th>
                                <th width="10%" style="text-align: center;" scope="col">Nro Doc</th>
                                <th width="10%" style="text-align: center;" scope="col">Fecha Doc</th>
                                <th width="10%" style="text-align: center;" scope="col">Monto</th>
                                <th width="10%" style="text-align: center;" scope="col">Saldo</th>
                                <th width="10%" style="text-align: center;" scope="col">Banco</th>
                                <th width="10%" style="text-align: center;" scope="col">Cuenta</th>
                            </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
        <div class="row" style="margin-right:0; margin-left:0;">
            <div class="col-12" style="padding-right: 0; padding-left: 0;">
                <div class="list-group" id="list-tab" role="tablist">
                    <div class="list-group-item list-group-item-action" id="list-home-list" data-toggle="list" role="tab" aria-controls="home">
                        <div class="table-responsive">
                            <table class="table table-sm table-bordered table-hover" style="margin-bottom: 0;">
                                <thead class="">
                                    <tr>
                                        <td width="10%" class="table-light" style="color:black; text-align: center;">No</td>
                                        <td width="10%" class="table-light" style="color:black; text-align: center;">C&oacute;digo</td>
                                        <td width="10%" class="table-light" style="color:black; text-align: center;">Descripci&oacute;n</td>
                                        <td width="10%" class="table-light" style="color:black; text-align: center;">Stock</td>
                                        <td width="10%" class="table-light" style="color:black; text-align: center;">Cant</td>
                                        <td width="10%" class="table-light" style="color:black; text-align: center;">Precio</td>
                                        <td width="10%" class="table-light" style="color:black; text-align: center;">Sub Total</td>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>

                    <div class="list-group-item list-group-item-action" id="list-profile-list" data-toggle="list" role="tab" aria-controls="profile">Profile</div>
                    <div class="list-group-item list-group-item-action" id="list-messages-list" data-toggle="list" role="tab" aria-controls="messages">Messages</div>
                    <div class="list-group-item list-group-item-action" id="list-settings-list" data-toggle="list" role="tab" aria-controls="settings">Settings</div>

                </div>
            </div>
        </div>

        
    </div>
</div>
-->
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<style type="text/css">
.modal
{
 padding: 0 !important;
}
.modal-dialog {
  max-width: 95% !important;
  height: 90%;
/*  padding: 0;
  margin: 0;*/
}

.modal-content {
  /*border-radius: 0 !important;*/
  height: 70%;
}
</style>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<!-- Modal - NUEVO CLIENTE -->
<div class="modal hide fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">---</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id" src="" style="zoom:0.60;" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>

<script type="text/javascript">
abrirPopupRecibo = function()
{
	var IdPersona = $( "#ClienteNumero" ).val();
    var frameSrc = "<?=buildUrl( 'caja/addeditRecibo', 'TipoProc=nvo' )?>/IdPersona/" + IdPersona ;
    $( '#iframe_id' ).attr( "src", frameSrc );
    $( "#exampleModalLongTitle" ).html( "Nuevo Recibo" );
    $( '#exampleModalCenter' ).modal( { show:true } );    
}
asignarValores = function()
{
	
    ocultarModal();
}
ocultarModal = function()
{
    $( '#exampleModalCenter' ).modal( 'hide' );
}
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<!--APERTURA DE CAJA-->
<style type="text/css">
    #exampleModalCenter3 .modal
    {
        padding: 0 !important;
    }
    #exampleModalCenter3 .modal-dialog
    {
        max-width: 95% !important;
        height: 90%;
    }

    #exampleModalCenter3 .modal-content
    {
        /*border-radius: 0 !important;*/
        height: 90%;
    }
</style>
<div class="modal hide fade" id="exampleModalCenter3" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle2" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle2">Aperturar Caja</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id2" src="" style="zoom:0.60" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    aperturarCaja = function()
    {
        $( '#iframe_id2' ).attr( "src", "<?=buildUrlComplet( 'tsr.php/caja/aperturarCaja' )?>" );
        $( '#exampleModalCenter3' ).modal( { show:true } );
    }
    recargarPagina = function()
    {
        location.reload();
    }
    cerrarPopupBootstrap = function()
    {
        $( '#exampleModalCenter3' ).modal( 'hide' );
    }
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<script type="text/javascript">
$( '#IdBanco' ).trigger( 'change' );
$( '#IdTipoPago' ).trigger( 'change' );

$( "#NumDocuCliente" ).autocomplete
(
    {
        source: function(request, response) 
        {
            $.getJSON
            (
                "<?=buildUrlComplet( 'vta.php/recephabit/requestUbicacion' )?>",
                { term:request.term, tipo_proc:'AutocompleteDoc', tipo_doc: $( '#TipoDocCliente' ).val() }, 
                response
            );
        },
        minLength: 2,
        select: function( event, ui ) 
        {
            $( "#ClienteNumero" ).val( ui.item.id );
            blockContent( 'content_datos_cliente' );
            buscarInfoCliente();
        }
    }
);

$( "#NombreCliente" ).autocomplete
(
    {
        source: "<?=buildUrlComplet( 'vta.php/recephabit/requestUbicacion', "tipo_proc=Autocomplete" )?>",
        minLength: 2,
        select: function( event, ui ) 
        {
            $( "#ClienteNumero" ).val( ui.item.id );
            $( "#TipoDocCliente" ).val( ui.item.tipo_doc );
            $( "#NumDocuCliente" ).val( ui.item.num_doc );
            blockContent( 'content_datos_cliente' );
            buscarInfoCliente();
        }
    }
);

buscarInfoCliente = function()
{
    //limpiarValores();
    /////////
    
    var ClienteNumero = $( "#ClienteNumero" ).val();
    var strFormSerialize = "tipo_proc=getClienteInfo&ClienteNumero=" + ClienteNumero;
    
    executeAjaxJson
    ( 
        "<?php echo buildUrlComplet( 'vta.php/recephabit/requestUbicacion', "" ) ?>", 
        strFormSerialize,
        function( o_json )
        {
            console.log( o_json );
            
            if( o_json.error )
            {
                //mostrarMensajeError( o_json.mensaje_error );
                return false;
            }
            $( "#NombreCliente" ).val( o_json.Nombre );
            $( "#NumDocuCliente" ).val( o_json.Documento );
            $( "#TipoDocCliente" ).val( o_json.TipoDocumento );
            //$( "#DireccionCliente" ).val( o_json.Direccion );
            //$( "#IdVendedor" ).val( o_json.CodVendedor );
            //$( "#sDepartamento" ).val( o_json.DepartamentoDesc );
            //$( "#sProvincia" ).val( o_json.ProvinciaDesc );
            //$( "#sDistrito" ).val( o_json.DistritoDesc );
            //$( "#IdUbigeo" ).val( o_json.IdUbigeo );
            //$( "#cboCanal" ).val( o_json.CanalCliente );
            //$( "#sPais" ).val( "PERU" );
            
            unBlockContent( 'content_datos_cliente' );
            cargarComprobantesConSaldo();
        }
    );
}
<?php if( $s_MensajeError ){ ?>
showAlertBootStrap( 'content_alert', 'alert-danger', '<?=str_replace( "'", "", $s_MensajeError )?>' );
<?php } ?>

<?php if( $b_ControlFact ){ ?>
$( "#NombreCliente" ).val( "<?=$NombreCliente?>" );
$( "#ClienteNumero" ).val( "<?=$ClienteNumero?>" );
$( "#TipoDocCliente" ).val( "<?=$TipoDocCliente?>" );
$( "#NumDocuCliente" ).val( "<?=$NumDocuCliente?>" );
blockContent( 'content_datos_cliente' );
buscarInfoCliente();
<?php } ?>
</script>

<?php if( !$b_ControlCaja ){ ?>
<script>aperturarCaja();</script>
<?php } ?>