<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class cajaActions extends wtActions
{
    public function executeCierreCajaPDF()
    {
        $s_IdCierre   = $this->getRequestParameter( 'id_cierre' );
        //$s_IdVendedor = $this->getRequestParameter( 'id_vendedor' );
        $s_Title      = "";

        if( $this->getRequestParameter( 'id_cierre' ) )
        {
            $s_Title = "CIERRE DE CAJA Nº $s_IdCierre";
            $o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreBN = $o_FCO_CierreFN->selectByPK( $s_IdCierre );
            if( !$o_FCO_CierreBN )
            {
                pr( "No se aperturo ninguna Caja." );
                exit;
            }
        }
        else
        {
            $s_Title = "RESUMEN DE CAJA - DIARIO";

            $o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            if( !$a_FCO_Cierre )
            {
                pr( "No se aperturo ninguna Caja." );
                exit;
            }
            if( count( $a_FCO_Cierre ) > 1 )
            {
                pr( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
                exit;
            }
            $o_FCO_CierreBN = $a_FCO_Cierre[0];
        }

        $s_IdCaja       = $o_FCO_CierreBN->getIdCaja();
        $s_IdVendedor   = $o_FCO_CierreBN->getCodVendedor();
        $i_IdTurno      = $o_FCO_CierreBN->getIdTurno();

        $s_FechaInicio     = substr( $o_FCO_CierreBN->getFechaCreacion(), 0, 10 );
        $s_FechaFin    = !$o_FCO_CierreBN->getFechaCierre() ? date( "Y-m-d" ) : $o_FCO_CierreBN->getFechaCierre();

        if( $s_FechaInicio )
        {
            $s_FechaResumenDia = $s_FechaInicio;
        }
        if( $s_FechaFin )
        {
            $s_FechaResumenDia .= " | ".$s_FechaFin;
        }

        $s_FechaHoraCierre = $s_FechaFin;


        $o_FCO_CajaFN = new FCO_CajaFN();
        $o_FCO_CajaBN = $o_FCO_CajaFN->selectByPK( $s_IdCaja );
        //pr( $o_FCO_CajaBN );
        //pr( $o_FCO_CajaBN->getObjectSucursal() );

        //$s_FechaInicio = !$this->getRequestParameter( 'FechaInicio' ) ? date( "Y-m-d" ) : $this->getRequestParameter( 'FechaInicio' );
        //$s_FechaFin    = !$this->getRequestParameter( 'FechaFin' ) ? date( "Y-m-d" ) : $this->getRequestParameter( 'FechaFin' );
        
        /*
        
        $s_FechaApertura   = $o_FCO_CierreBN->getFechaCreacion();
        $s_FechaHoraCierre = "";
        if( $b_Control )
        {
            $s_FechaHoraCierre = $o_FCO_CierreBN->getFechaCierre();
        }*/

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //se recupera info para el cajero
        $s_NombreCajero = myUser::getUser()->getName();

        /*$o_FCO_CajaUsuarioFN = new FCO_CajaUsuarioFN();
        if( $s_IdVendedor )
        {
            $o_FCO_CajaUsuarioBN = $o_FCO_CajaUsuarioFN->selectByPK( $s_IdCaja, $s_IdVendedor );
        }
        else
        {
            $o_FCO_CajaUsuarioBN = $o_FCO_CajaUsuarioFN->selectByPK( $s_IdCaja, myUser::getUser()->getUserId() );
        }
        if( !$o_FCO_CajaUsuarioBN )
        {
            $o_FCO_CajaUsuarioBN = new FCO_CajaUsuarioBN();
        }*/
        //pr( $o_FCO_CajaUsuarioBN );
        //pr( $o_FCO_CajaUsuarioBN->getObjectUsuario() );

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //aqui se recupera el resumen de documentos
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoFN->setIdCaja( $s_IdCaja );
        $o_VTA_DocumentoFN->setIdTurno( $i_IdTurno );
        $o_VTA_DocumentoFN->addCondition(  VTA_DocumentoFN::FechaDocumento, ">=", $s_FechaInicio." 00:00:00" );
        $o_VTA_DocumentoFN->addCondition(  VTA_DocumentoFN::FechaDocumento, "<=", $s_FechaFin." 23:59:59" );
        if( $s_IdVendedor )
        {
            //$o_VTA_DocumentoFN->setVendedor( $s_IdVendedor );
        }
        $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::Estado, 'IN', "( 'CE','AN')", false );
        if( !$this->getRequestParameter( 'id_cierre' ) )
        {
            $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::IdCierre, 'IS', "NULL", false );
        }
        else
        {
            $o_VTA_DocumentoFN->setIdCierre( $this->getRequestParameter( 'id_cierre' ) );
        }
        $o_VTA_DocumentoFN->addOrderBy( VTA_DocumentoFN::DocumentoCod );
        $o_VTA_DocumentoFN->addOrderBy( VTA_DocumentoFN::DocumentoSerie );
        $o_VTA_DocumentoFN->addOrderBy( VTA_DocumentoFN::DocumentoNumero );
        $a_VTA_Documento = $o_VTA_DocumentoFN->select();
        //pr( $a_VTA_Documento );
        $a_ResumenDocumentos = array();
        $a_Usuarios = array();
        foreach ( $a_VTA_Documento as $o_VTA_DocumentoBN ) 
        {
            $s_DocumentoCod    = $o_VTA_DocumentoBN->getDocumentoCod();
            $s_DocumentoSerie  = $o_VTA_DocumentoBN->getDocumentoSerie();
            $s_DocumentoNumero = $o_VTA_DocumentoBN->getDocumentoNumero();
            $s_Estado          = $o_VTA_DocumentoBN->getEstado();
            $s_EstadoCob       = $o_VTA_DocumentoBN->getCobranzaEstado();
            $s_Comision       = $o_VTA_DocumentoBN->getComision();
            $s_Vendedor       = $o_VTA_DocumentoBN->getVendedor();

            if( !isset( $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie] ) )
            {
                $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['Cant']    = 0;
                $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['CantAnu'] = 0;
                $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['CantPen'] = 0;
                $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['Total']   = 0;
                $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['Inicio']  = $s_DocumentoNumero;
            }
            
            if( !isset( $a_ResumenDocumentosComi[$s_Vendedor] ) )
            {
                $a_ResumenDocumentosComi[$s_Vendedor]['Comision'] = 0;
            }
            
            
            $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['Total'] += $o_VTA_DocumentoBN->getMontoTotal();
            
            $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['Fin'] = $s_DocumentoNumero;
            $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['Cant']++;
            
            $a_ResumenDocumentosComi[$s_Vendedor]['Comision'] += $o_VTA_DocumentoBN->getComision();
            
            if( $s_Estado == "AN" )
            {
                $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['CantAnu']++;
            }
            if( $s_Estado == "CE" && $s_EstadoCob == "PE" )
            {
                $a_ResumenDocumentos[$s_DocumentoCod."_".$s_DocumentoSerie]['CantPen']++;
            }

            $a_Usuarios[$o_VTA_DocumentoBN->getUsuarioCreacion()] = $o_VTA_DocumentoBN->getUsuarioCreacion();
        }
        //pr( $a_ResumenDocumentos );

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //SE BUSCA COMPROBANTES - NOTA DE CREDITO
        $o_VTA_DocumentoFN->a_Condition = array();
        $o_VTA_DocumentoFN->addCondition(  VTA_DocumentoFN::FechaDocumento, ">=", $s_FechaInicio." 00:00:00" );
        $o_VTA_DocumentoFN->addCondition(  VTA_DocumentoFN::FechaDocumento, "<=", $s_FechaFin." 23:59:59" );
        $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::Estado, 'IN', "( 'CE')", false );
        $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::IdTipoDocumento, 'IN', "( 'NC')", false );
        if( !$this->getRequestParameter( 'id_cierre' ) )
        {
            $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::IdCierre, 'IS', "NULL", false );
        }
        else
        {
            $o_VTA_DocumentoFN->setIdCierre( $this->getRequestParameter( 'id_cierre' ) );
        }
        $a_DOC_NC_VTA_Documento = $o_VTA_DocumentoFN->select();
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        ///
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //SE BUSCA COMPROBANTES ANULADOS
        $o_VTA_DocumentoFN->a_Condition = array();
        $o_VTA_DocumentoFN->addCondition(  VTA_DocumentoFN::FechaDocumento, ">=", $s_FechaInicio." 00:00:00" );
        $o_VTA_DocumentoFN->addCondition(  VTA_DocumentoFN::FechaDocumento, "<=", $s_FechaFin." 23:59:59" );
        $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::Estado, 'IN', "( 'AN')", false );
        if( !$this->getRequestParameter( 'id_cierre' ) )
        {
            $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::IdCierre, 'IS', "NULL", false );
        }
        else
        {
            $o_VTA_DocumentoFN->setIdCierre( $this->getRequestParameter( 'id_cierre' ) );
        }
        $a_DOC_VTA_Documento = $o_VTA_DocumentoFN->select();
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //SE BUSCA COMPROBANTES PENDIENTES DE COBRO Y LA CONDICION ASIGNADA
        $o_VTA_DocumentoFN->a_Condition = array();
        $o_VTA_DocumentoFN->addCondition(  VTA_DocumentoFN::FechaDocumento, ">=", $s_FechaInicio." 00:00:00" );
        $o_VTA_DocumentoFN->addCondition(  VTA_DocumentoFN::FechaDocumento, "<=", $s_FechaFin." 23:59:59" );
        $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::Estado, 'IN', "( 'CE')", false );
        $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::CobranzaEstado, 'IN', "( 'PE')", false );
        if( !$this->getRequestParameter( 'id_cierre' ) )
        {
            $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::IdCierre, 'IS', "NULL", false );
        }
        else
        {
            $o_VTA_DocumentoFN->setIdCierre( $this->getRequestParameter( 'id_cierre' ) );
        }
        $a_PE_VTA_Documento = $o_VTA_DocumentoFN->select();
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //aqui se recupera el resumen de caja
        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
        $o_FCO_AplicacionFN->setIdCaja( $s_IdCaja );
        $o_FCO_AplicacionFN->setIdTurno( $i_IdTurno );
        $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::Estado, 'IN', "( 'AP','AN')", false );
        $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::FechaAplicacion, ">=", $s_FechaInicio." 00:00:00" );
        $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::FechaAplicacion, "<=", $s_FechaFin." 23:59:59" );
        if( !$this->getRequestParameter( 'id_cierre' ) )
        {
            $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::IdCierre, 'IS', "NULL", false );
        }
        else
        {
            $o_FCO_AplicacionFN->setIdCierre( $this->getRequestParameter( 'id_cierre' ) );
        }
        if( $s_IdVendedor )
        {
            //$o_FCO_AplicacionFN->setCodVendedorRef( $s_IdVendedor );
        }
        $o_FCO_AplicacionFN->addOrderBy( FCO_AplicacionFN::TipoPagoNombre );
        $o_FCO_AplicacionFN->addOrderBy( FCO_AplicacionFN::IdMoneda );
        $o_FCO_AplicacionFN->addOrderBy( FCO_AplicacionFN::FechaAplicacion );
        $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
        $a_ResumnenCaja = array();
        $a_ResumnenCajaVendedor = array();
        
        foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN ) 
        {
            $i_IdTipoPago = $o_FCO_AplicacionBN->getIdTipoPago();
            $s_IdMoneda   = $o_FCO_AplicacionBN->getIdMoneda();
            $i_IdBanco    = $o_FCO_AplicacionBN->getIdBanco();
            $i_IdCuenta   = $o_FCO_AplicacionBN->getIdCuenta();
            $s_Estado     = $o_FCO_AplicacionBN->getEstado();
            $s_CodVendedorRef     = $o_FCO_AplicacionBN->getCodVendedorRef();
            $s_IdDocNumRef     = $o_FCO_AplicacionBN->getIdDocNumRef();
            
            if( $s_Estado == FCO_AplicacionBN::ESTADO_APLICADO )
            {
            
                $s_Key = $i_IdTipoPago."_".$s_IdMoneda."_".$i_IdBanco."_".$i_IdCuenta;
                
                $s_KeyVendedor = $s_CodVendedorRef;
                
                //echo $s_KeyVendedor;
    
                if( !isset( $a_ResumnenCaja[$s_Key] ) )
                {
                    $a_ResumnenCaja[$s_Key]['MontoAplicado'] = 0;
                    $a_ResumnenCaja[$s_Key]['CantTrx'] = 0;
                    $a_ResumnenCaja[$s_Key]['CantTrxAnu'] = 0;
                    $a_ResumnenCaja[$s_Key]['MontoAplicadoAnu'] = 0;
                    
                    
                }
                
                if( !isset( $a_ResumnenCajaVendedor[$s_KeyVendedor] ) )
                {
                   
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['MontoAplicado'] = 0;
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['Comision'] = 0;
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['CantTrx'] = 0;
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['CantTrxAnu'] = 0;
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['MontoAplicadoAnu'] = 0;
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['NumOrdenes'] = null;
                    
                }
                
                if( !isset( $a_ordenes[$s_KeyVendedor] ) )
                {
                   
                    
                    $a_ordenes[$s_KeyVendedor] = null;
                }
    
                if( $s_Estado != "AN" )
                {
                    $a_ResumnenCaja[$s_Key]['MontoAplicado']  += $o_FCO_AplicacionBN->getMontoAplicado();
                    $a_ResumnenCaja[$s_Key]['MonedaDes']      = $o_FCO_AplicacionBN->getMonedaDes();
                    $a_ResumnenCaja[$s_Key]['BancoDesc']      = $o_FCO_AplicacionBN->getBancoDesc();
                    $a_ResumnenCaja[$s_Key]['CuentaBancaria'] = $o_FCO_AplicacionBN->getObjectCuentaBancaria()->getNumeroCuenta();
                    $a_ResumnenCaja[$s_Key]['TipoPagoNombre'] = $o_FCO_AplicacionBN->getTipoPagoNombre();
                    $a_ResumnenCaja[$s_Key]['CantTrx']++;
                    
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['MontoAplicado']  += $o_FCO_AplicacionBN->getMontoAplicado();
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['MonedaDes']      = $o_FCO_AplicacionBN->getMonedaDes();
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['BancoDesc']      = $o_FCO_AplicacionBN->getBancoDesc();
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['CuentaBancaria'] = $o_FCO_AplicacionBN->getObjectCuentaBancaria()->getNumeroCuenta();
                    $o_FCO_AplicacionBN->getTipoPagoNombre();
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['Comision'] = $a_ResumenDocumentosComi[$s_KeyVendedor]['Comision'];
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['CantTrx']++;
                    
                    $a_ordenes[$s_KeyVendedor][$s_IdDocNumRef] =1;
                    
                    $a_ResumnenCajaVendedor[$s_KeyVendedor]['NumOrdenes'] = $a_ordenes[$s_KeyVendedor];
                    
                }
    
                if( $s_Estado == "AN" )
                {
                    //$a_ResumnenCaja[$s_Key]['CantTrxAnu']++;
                    //$a_ResumnenCaja[$s_Key]['MontoAplicadoAnu']  += $o_FCO_AplicacionBN->getMontoAplicado();
                }
            }
        }
        //pr( $a_ResumnenCaja );
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //Detalle de Movimiento de Caja
        //pr( $a_FCO_Aplicacion );
        $a_DetMovimiento = array();
        foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN ) 
        {
            $s_TipoPagoNombre = $o_FCO_AplicacionBN->getTipoPagoNombre();
            $i_IdTipoPago = $o_FCO_AplicacionBN->getIdTipoPago();
            $s_IdMoneda   = $o_FCO_AplicacionBN->getIdMoneda();
            $i_IdBanco    = $o_FCO_AplicacionBN->getIdBanco();
            $i_IdCuenta   = $o_FCO_AplicacionBN->getIdCuenta();
            $s_Estado     = $o_FCO_AplicacionBN->getEstado();

            $s_Key1 = $i_IdTipoPago."_".$s_IdMoneda."_".$i_IdBanco."_".$i_IdCuenta;
            $s_Key2 = $s_IdMoneda."_".$i_IdBanco."_".$i_IdCuenta;
            
            if( $s_Estado != "AN" )
            {
                $a_DetMovimiento[$s_Key1]['TipoPagoNombre'] = $o_FCO_AplicacionBN->getTipoPagoNombre();
                $a_DetMovimiento[$s_Key1]['MonedaDes']      = $o_FCO_AplicacionBN->getMonedaDes();
                $a_DetMovimiento[$s_Key1]['BancoDesc']      = $o_FCO_AplicacionBN->getBancoDesc();
                $a_DetMovimiento[$s_Key1]['CuentaBancaria'] = $o_FCO_AplicacionBN->getObjectCuentaBancaria()->getNumeroCuenta();
                $a_DetMovimiento[$s_Key1]["DetCaja"][]      = $o_FCO_AplicacionBN;
            }

        }
        //pr( $a_DetMovimiento );
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        echo $html;         exit;

        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );

        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();

        //For Footer
        $canvas = $dompdf->get_canvas();
        $footer = $canvas->open_object();
        $font = "";
        $font_metrics = $dompdf->getFontMetrics();
        $font = $font_metrics->getFont( "helvetica", "bold" );
        //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 250, 823, "Pagina:  {PAGE_NUM} of {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
        $canvas->close_object();
        $canvas->add_object( $footer, "all" );

        $dompdf->stream( 'Documento_', array( "Attachment" => 0 ) );
        
        exit;
    }
    
    public function executeBuscarComprobantes()
    {
        $s_IdPersona = $this->getRequestParameter( 'IdPersona' );
        $s_IdMoneda  = $this->getRequestParameter( 'IdMoneda' );
        
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoFN->setClienteNumero( $s_IdPersona );
        $o_VTA_DocumentoFN->setEstado( VTA_DocumentoBN::ESTADO_CERRADO );
        $o_VTA_DocumentoFN->setCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_PENDIENTE );
        $o_VTA_DocumentoFN->setMonedaDocumento( $s_IdMoneda );
        //$o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::MontoSaldo, ">", 0 );
        $this->a_VTA_Documento = $o_VTA_DocumentoFN->select();
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeBuscarRecibos()
    {
        $s_IdPersona = $this->getRequestParameter( 'IdPersona' );
        
        $o_FCO_DocReciboFN = new FCO_DocReciboFN();
        $o_FCO_DocReciboFN->setIdPersona( $s_IdPersona );
        $o_FCO_DocReciboFN->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO );
        $o_FCO_DocReciboFN->setFlujoEstado( FCO_DocReciboBN::FLUESTADO_APROBADO );
        $o_FCO_DocReciboFN->addCondition( FCO_DocReciboFN::Saldo, ">", 0 );
        $this->a_FCO_DocRecibo = $o_FCO_DocReciboFN->select();
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->Titulo = "Edici&oacute;n de Cobranza";
        
        $this->s_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );

        $this->s_MensajeError = "";
        $this->b_ControlFact  = false;
        $this->b_ControlCaja = false;

        try
        {
            //se recupera la moneda por defecto para el sistema
            $this->s_MonedaSistema  = MST_ListaPrecioCabeceraFN::getMonedaCodeDefault();
            
            $o_GSS_MonedaMastFN = new GSS_MonedaMastFN();
            $o_GSS_MonedaMastFN->setEstado( "A" );
            $o_GSS_MonedaMastFN->addOrderBy( GSS_MonedaMastFN::IdMoneda, false );
            $this->a_GSS_MonedaMast = $o_GSS_MonedaMastFN->select();
            
            $this->o_FCO_DocReciboBN = new FCO_DocReciboBN();
            $this->o_FCO_DocReciboBN->setTipoDocCliente( "RUC" );
            
            $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            if( !$this->TipodeCambio )
            {
                $s_FechaSel = date( "Y-m-d" );

                $o_iVentas = new iVentas();
                $o_iVentas->registrarTipoCambio( $s_FechaSel );

                $this->TipodeCambio     = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
                if( !$this->TipodeCambio )
                {
                    throw new Exception( "No se encuentra registrado el Tipo de Cambio." );
                }
            }

            if( $this->getRequestParameter( "IdComprobante" ) )
            {
                $this->b_ControlFact  = true;

                $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->getRequestParameter( "IdComprobante" ) );

                $this->NombreCliente  = $o_VTA_DocumentoBN->getClienteNombre();
                $this->ClienteNumero  = $o_VTA_DocumentoBN->getClienteNumero();
                $this->TipoDocCliente = $o_VTA_DocumentoBN->getClienteTipoDoc();
                $this->NumDocuCliente = $o_VTA_DocumentoBN->getClienteRUC();
            }

            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //SE CAMBIA EL PROCEDIMIENTO PARA CAJA, AHORA EXITE LA APERTURA DE CAJA ASOCIANDO AL CIERRE EN ESTADO ABIERTO - 2020-02-02
            $o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();

            if( count( $a_FCO_Cierre ) == 1 )
            {
                $o_FCO_CierreBN = $a_FCO_Cierre[0];
                $this->b_ControlCaja   = true;
                $this->IdCajaSelect    = $a_FCO_Cierre[0]->getIdCaja();
                $this->DesCajaSelect   = $a_FCO_Cierre[0]->getObjectCaja()->getDescripcion();
                $this->IdTurnoSelect   = $a_FCO_Cierre[0]->getIdTurno();
                $this->DescTurnoSelect = $a_FCO_Cierre[0]->getObjectTurno()->getDescripcion();
            }
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            
            myUser::getUser()->validar_session();
        }
        catch ( Exception $o_Exception )
        {
            $this->s_MensajeError = $o_Exception->getMessage();
        }
    }
    
    public function executeListcierre()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_IdCaja       = "";
        $this->s_IdVendedor   = "";

        $o_FCO_CierreFN = new FCO_CierreFN();
        $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
        $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
        $a_FCO_Cierre = $o_FCO_CierreFN->select();
        if( count( $a_FCO_Cierre ) == 1 )
        {
            $o_FCO_CierreBN     = $a_FCO_Cierre[0];
            $this->s_IdCaja     = $o_FCO_CierreBN->getIdCaja();
            $this->s_IdVendedor = $o_FCO_CierreBN->getCodVendedor();
        }
    }

    public function executeGridRecibo()
    {
        //set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new FCO_DocReciboFN() );
        
        $o_GridAction->addAssignFilter( "TipoDocCliente" );
        $o_GridAction->addConditionFilter( "NumTipoDocCliente", FCO_DocReciboFN::NumTipoDocCliente,  "LIKE", "%%s%" );
        $o_GridAction->addAssignFilter( "IdTipoPago" );
        $o_GridAction->addConditionFilter( "ReciboNumero", FCO_DocReciboFN::ReciboNumero,  "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", FCO_DocReciboFN::ReciboFecha,  ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", FCO_DocReciboFN::ReciboFecha,  "<=", '23:59:59' );
        $o_GridAction->addAssignFilter( "IdMoneda" );
        $o_GridAction->addAssignFilter( "IdBanco" );
        $o_GridAction->addAssignFilter( "IdCuenta" );
        $o_GridAction->addAssignFilter( "Estado" );
        
        //$o_GridAction->addOrder( "Estado", FCO_CierreFN::Estado );
        
        $o_GridAction->addOrderDefault( FCO_DocReciboFN::IdDocRecibo, true );
        
        $o_GridAction->addRowsToShow( 
                                        "IdDocRecibo", "IdSucursal", "MonedaDes", "ReciboNumero", "ReciboFecha", "NombreCliente", "Monto", "Saldo",
                                        "TipoPagoNombre", "SucursalNombre", "FlujoEstadoDesc", "BancoDesc", "NumeroCuenta", "TipoDocCliente", "NumTipoDocCliente", "EstadoDesc"
                                    );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE; 
    }

    public function executeGridCierre()
    {
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new FCO_CierreFN() );
        
        $o_GridAction->addAssignFilter( "IdCierre" );
        $o_GridAction->addAssignFilter( "IdCaja" );
        $o_GridAction->addAssignFilter( "IdTurno" );
        $o_GridAction->addAssignFilter( "CodVendedor" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", FCO_CierreFN::FechaCreacion,  ">=", '00:00:00' );
        $o_GridAction->addConditionFilter( "FechaDocumento2", FCO_CierreFN::FechaCreacion,  "<=", '23:59:59' );
        //$o_GridAction->addConditionFilter( "Nombre", FCO_CierreFN::Nombre, "LIKE", "%%s%" );
        
        //$o_GridAction->addOrder( "Estado", FCO_CierreFN::Estado );
        
        $o_GridAction->addOrderDefault( FCO_CierreFN::IdCierre, true );
        
        $o_GridAction->addRowsToShow( "IdCierre", "IdSucursal", "IdCaja", "FechaCierre", "TotalSoles", "SucursalNombre", "CajaNombre", "UsuarioCreacion", "CodVendedor", "EstadoDesc", "Estado", "TipoTunoDesc", "FechaCreacion" );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE; 
    }

    public function executeResumen()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $i_IdDocRecibo = $this->getRequestParameter( 'i_Id' );
        
        $o_FCO_DocReciboFN = new FCO_DocReciboFN();
        $this->o_FCO_DocReciboBN = $o_FCO_DocReciboFN->selectByPK( $i_IdDocRecibo );
    }
}