<?php
class RequestCajaAction extends wtActions 
{
    public function execute()
    {
        $s_TipoProc = $this->getRequestParameter( 'TipoProc' );
        $a_Result   = array( "Result" => false, "error" => false );

        try
        {
            switch ( $s_TipoProc )
            {
                case "BuscarBancosOrden":

                    $s_IdMoneda = $this->getRequestParameter( 'IdMoneda' );

                    $o_GSS_BancoFN = new GSS_BancoFN();
                    $o_GSS_BancoFN->setEstado( "A" );
                    $o_GSS_BancoFN->addOrderBy( GSS_BancoFN::DescripcionLocal );
                    $a_GSS_Banco = $o_GSS_BancoFN->select();
                    //pr($a_GSS_Banco);
                    $a_Result = array();
                    foreach ( $a_GSS_Banco as $o_GSS_BancoBN )
                    {
                        $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
                        $o_MST_CuentaBancariaFN->setIdBanco( $o_GSS_BancoBN->getIdBanco() );
                        $o_MST_CuentaBancariaFN->setIdMoneda( $s_IdMoneda );
                        $a_MST_CuentaBancaria = $o_MST_CuentaBancariaFN->select();
                        if( $a_MST_CuentaBancaria )
                        {
                            if( count( $a_MST_CuentaBancaria ) == 1 )
                            {
                                if( $a_MST_CuentaBancaria[0]->getFlagDetraccion() )
                                {
                                    $o_GSS_BancoBN->setDescripcionLocal( $o_GSS_BancoBN->getDescripcionLocal()." - DETRACCION" );
                                }
                            }
                            $a_Result[] = array( "Id" => $o_GSS_BancoBN->getIdBanco(), "Descripcion" => $o_GSS_BancoBN->getDescripcionLocal() );
                        }
                    }

                break;
                case "BuscarBancos":
                    $s_IdMoneda = $this->getRequestParameter( 'IdMoneda' );
                    
                    $o_GSS_BancoFN = new GSS_BancoFN();
                    $o_GSS_BancoFN->setEstado( "A" );
                    $o_GSS_BancoFN->addOrderBy( GSS_BancoFN::DescripcionLocal );
                    $a_GSS_Banco = $o_GSS_BancoFN->select();
                    //pr($a_GSS_Banco);
                    $a_Result = array();
                    foreach ( $a_GSS_Banco as $o_GSS_BancoBN )
                    {
                        $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
                        $o_MST_CuentaBancariaFN->setIdBanco( $o_GSS_BancoBN->getIdBanco() );
                        $o_MST_CuentaBancariaFN->setIdMoneda( $s_IdMoneda );
                        $a_MST_CuentaBancaria = $o_MST_CuentaBancariaFN->select();
                        if( $a_MST_CuentaBancaria )
                        {
                            if( count( $a_MST_CuentaBancaria ) == 1 )
                            {
                                if( $a_MST_CuentaBancaria[0]->getFlagDetraccion() )
                                {
                                    $o_GSS_BancoBN->setDescripcionLocal( $o_GSS_BancoBN->getDescripcionLocal()." - DETRACCION" );
                                }
                            }
                            $a_Result[$o_GSS_BancoBN->getIdBanco()] = ( $o_GSS_BancoBN->getDescripcionLocal() );
                        }
                    }
                    //array_multisort( $a_Result, SORT_ASC );
                    //asort ( $a_Result );
                    //asort( $a_Result, SORT_STRING | SORT_FLAG_CASE | SORT_NATURAL );
                    //natcasesort( $a_Result );
                    asort( $a_Result );
                break;
                case "AnularRecibo":
                    
                    $s_IdDocRecibo = $this->getRequestParameter( 'IdDocRecibo' );
                    $con = Conexion::getConexion();
                    $con->begin();
                    try 
                    {
                        myUser::getUser()->validar_session();
                        
                        $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                        $o_FCO_DocReciboBN = $o_FCO_DocReciboFN->selectByPK( $s_IdDocRecibo );
                        
                        //se anula el recibo
                        $o_FCO_DocReciboDP = new FCO_DocReciboDP();
                        $o_FCO_DocReciboDP->setIdDocRecibo( ( int ) $s_IdDocRecibo );
                        $o_FCO_DocReciboDP->setSaldo( 0 );
                        $o_FCO_DocReciboDP->setSaldoME( 0 );
                        $o_FCO_DocReciboDP->setSaldoMN( 0 );
                        $o_FCO_DocReciboDP->setEstado( FCO_DocReciboBN::ESTADO_ANULADO );
                        $o_FCO_DocReciboDP->update();
                        
                        //ahora se busca si tiene aplicaciones
                        $o_FCO_AplicacionFN = new FCO_AplicacionFN();
                        //$o_FCO_AplicacionFN->setDebug( true );
                        $o_FCO_AplicacionFN->setIdDocRecibo( $s_IdDocRecibo );
                        $o_FCO_AplicacionFN->setEstado( FCO_AplicacionBN::ESTADO_APLICADO );
                        $o_FCO_AplicacionFN->addCondition( FCO_AplicacionFN::IdParent, "IS", 'NULL', false );
                        $a_FCO_Aplicacion = $o_FCO_AplicacionFN->select();
                        
                        foreach ( $a_FCO_Aplicacion as $o_FCO_AplicacionBN )
                        {
                            //primero vamos a anular la aplicacion
                            $o_FCO_AplicacionDP = new FCO_AplicacionDP();
                            $o_FCO_AplicacionDP->setIdAplicacion( $o_FCO_AplicacionBN->getIdAplicacion() );
                            $o_FCO_AplicacionDP->setEstado( FCO_AplicacionBN::ESTADO_ANULADO );
                            $o_FCO_AplicacionDP->update();
                            
                            //busco comprobante para actualizar saldos
                            $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_FCO_AplicacionBN->getIdDocNumRef() );
                            
                            $o_VTA_DocumentoDP = new VTA_DocumentoDP();
                            $o_VTA_DocumentoDP->setIdTipoDocumento( $o_VTA_DocumentoBN->getIdTipoDocumento() );
                            $o_VTA_DocumentoDP->setIdCompania( $o_VTA_DocumentoBN->getIdCompania() );
                            $o_VTA_DocumentoDP->setNumeroDocumento( $o_VTA_DocumentoBN->getNumeroDocumento() );
                            if( $o_VTA_DocumentoBN->getMonedaDocumento() == "LO" )
                            {
                                $o_VTA_DocumentoDP->setMontoPagado( $o_VTA_DocumentoBN->getMontoPagado() - $o_FCO_AplicacionBN->getMontoAplicacionMN() );
                                $o_VTA_DocumentoDP->setMontoPagadoMN( $o_VTA_DocumentoBN->getMontoPagado() - $o_FCO_AplicacionBN->getMontoAplicacionMN() );
                                $o_VTA_DocumentoDP->setMontoSaldo( $o_VTA_DocumentoBN->getMontoSaldo() + $o_FCO_AplicacionBN->getMontoAplicacionMN() );
                                $o_VTA_DocumentoDP->setMontoSaldoMN( $o_VTA_DocumentoBN->getMontoSaldo() + $o_FCO_AplicacionBN->getMontoAplicacionMN() );
                                $o_VTA_DocumentoDP->setCobranzaEstado( VTA_DocumentoBN::ESTADO_COB_PENDIENTE );
                            }
                            //pr( $o_VTA_DocumentoDP );
                            $o_VTA_DocumentoDP->update();
                            
                            //busco comprobante para ver el ultimo saldo
                            $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $o_FCO_AplicacionBN->getIdDocNumRef() );
                            
                            //ahora se anula el recibo
                            $i_IdAplicacion = FCO_AplicacionDP::recuperarId();
                            $o_TMP_FCO_AplicacionBN = clone $o_FCO_AplicacionBN;
                            $o_TMP_FCO_AplicacionBN->setIdAplicacion( $i_IdAplicacion );
                            $o_TMP_FCO_AplicacionBN->setIdParent( $o_FCO_AplicacionBN->getIdAplicacion() );
                            $o_TMP_FCO_AplicacionBN->setSaldoDocRef( $o_VTA_DocumentoBN->getMontoSaldo() );
                            $o_TMP_FCO_AplicacionBN->setMontoAplicado( $o_FCO_AplicacionBN->getMontoAplicado() * -1 );
                            $o_TMP_FCO_AplicacionBN->setMontoAplicacionMN( $o_FCO_AplicacionBN->getMontoAplicacionMN() * -1 );
                            $o_TMP_FCO_AplicacionBN->setMontoAplicacionME( $o_FCO_AplicacionBN->getMontoAplicacionME() * -1 );
                            $o_TMP_FCO_AplicacionBN->setMostrar( "N" );
                            $o_TMP_FCO_AplicacionBN->setEstado( FCO_AplicacionBN::ESTADO_ANULADO );
                            $o_TMP_FCO_AplicacionBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                            $o_TMP_FCO_AplicacionBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                            $o_TMP_FCO_AplicacionBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                            $o_TMP_FCO_AplicacionBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                            //pr( $o_TMP_FCO_AplicacionBN );
                            
                            $o_FCO_AplicacionDP = new FCO_AplicacionDP( $o_TMP_FCO_AplicacionBN );
                            //pr( $o_FCO_AplicacionDP );
                            $o_FCO_AplicacionDP->save();
                        }
                        
                        $con->commit();
                    }
                    catch ( Exception $e )
                    {
                        $con->rollback();
                        $a_Result['error']         = true;
                        $a_Result['mensaje_error'] = $e->getMessage();
                    }
                    
                break;
                case "EliminarDocRecibo":
                    
                    $s_IdDocRecibo = intval( $this->getRequestParameter( 'IdDocRecibo' ) );
                    
                    $o_FCO_DocReciboDP = new FCO_DocReciboDP();
                    $o_FCO_DocReciboDP->setIdDocRecibo( $s_IdDocRecibo );
                    //$o_FCO_DocReciboDP->delete();
                    
                break;
                case "AplicarComprobante":
                    
                    $s_IdNumeroDocumento = $this->getRequestParameter( 'IdNumeroDocumento' );
                    $s_IdDocRecibo = intval( $this->getRequestParameter( 'IdDocRecibo' ) );
                    $f_MontoAplicar = floatval( $this->getRequestParameter( 'MontoAplicar' ) );
                    
                    $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $s_IdNumeroDocumento );
                    $s_IdMonedaDoc = $o_VTA_DocumentoBN->getMonedaDocumento();
                    $f_MontoTotal = $o_VTA_DocumentoBN->getMontoTotal();
                    
                    $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                    $o_FCO_DocReciboBN = $o_FCO_DocReciboFN->selectByPK( $s_IdDocRecibo );
                    $s_IdMonedaRec = $o_FCO_DocReciboBN->getIdMoneda();
                    
                    $f_MontoResta = $f_MontoTotal - $f_MontoAplicar;
                    
                break;
                case "BuscarCuentaBancaria":
                    
                    $s_IdBanco  = $this->getRequestParameter( 'IdBanco' );
                    $s_IdMoneda = $this->getRequestParameter( 'IdMoneda' );
                    if( $s_IdBanco != "" && $s_IdMoneda != "" )
                    {
                        $o_MST_CuentaBancariaFN = new MST_CuentaBancariaFN();
                        $o_MST_CuentaBancariaFN->setIdBanco( $s_IdBanco );
                        $o_MST_CuentaBancariaFN->setIdMoneda( $s_IdMoneda );
                        $o_MST_CuentaBancariaFN->setEstado( "A" );
                        $a_MST_CuentaBancaria = $o_MST_CuentaBancariaFN->select();
                        $a_Result = array();
                        foreach ( $a_MST_CuentaBancaria as $i_Key => $o_MST_CuentaBancariaBN )
                        {
                            $a_Result[$o_MST_CuentaBancariaBN->getIdCuenta()] = ( $o_MST_CuentaBancariaBN->getNumeroCuenta() );
                        }
                        //array_multisort( $a_Result, SORT_ASC );
                    }
                    else
                    {
                        $a_Result = array();
                    }
                    
                break;
            }
        }
        catch ( Exception $o_Exception )
        {
            $a_Result['error']         = true;
            $a_Result['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Result );
        return ViewResponse::NONE;
    }
}