<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class ReporteBancosPDFAction extends wtActions
{
    public function execute()
    {
        $s_FechaDocumento1 = $this->getRequestParameter( 'FechaDocumento1' );
        $s_FechaDocumento2 = empty( $this->getRequestParameter( 'FechaDocumento2' ) ) ? date( "Y-m-d" ) : $this->getRequestParameter( 'FechaDocumento2' );
        $s_FechaDocumento2 = UtilDate::sumarDias( $s_FechaDocumento2, 1 );

        $a_GSS_Banco = GSS_BancoFN::buscarBancoCuencaBancaria( $this->getRequestParameterAll() );

        $startDate = new DateTime( $s_FechaDocumento1 );
        $endDate   = new DateTime( $s_FechaDocumento2 );

        $interval = DateInterval::createFromDateString( '1 day' );
        $period   = new DatePeriod( $startDate, $interval, $endDate );

        $a_DataResult = array();
        foreach ( $a_GSS_Banco as $a_Data )
        {
            //AQUI SE TENDRIA Q HACER EL SALDO INICIAL:
            $a_Data['SaldoInicialDebe'] = 0;
            $a_Data['SaldoInicialHaber'] = 0;
            $a_Data['SaldoInicialSaldo'] = 0;
            $a_Data['SaldoInicialSaldoMN'] = 0;

            $a_DataRecibos = array();
            foreach( $period as $date )
            {
                //pr( $date );
                $o_FCO_DocReciboFN = new FCO_DocReciboFN();
                //$o_FCO_DocReciboFN->setDebug( true );
                $o_FCO_DocReciboFN->setIdBanco( $a_Data['IdBanco'] );
                $o_FCO_DocReciboFN->setIdCuenta( $a_Data['IdCuenta'] );
                $o_FCO_DocReciboFN->setIdMoneda( $a_Data['IdMoneda'] );
                $o_FCO_DocReciboFN->setEstado( FCO_DocReciboBN::ESTADO_ACTIVO );
                $o_FCO_DocReciboFN->setReciboFecha( $date->format( "Y-m-d" ) );
                $o_FCO_DocReciboFN->addOrderBy( FCO_DocReciboFN::IdDocRecibo );
                $a_FCO_DocRecibo = $o_FCO_DocReciboFN->select();
                if( $a_FCO_DocRecibo )
                {
                    $a_DataRecibos = array_merge( $a_DataRecibos, $a_FCO_DocRecibo );
                }

                //AHORA SE AGREGA LOS PAGOS A LOS PROVEEDORES O ADICNALES QUE ESTARIAN EN LA COLUMNA DEL HABER - 2021-07-24 01:45:00
                $o_FCO_DocReciboFN = new CP_DocReciboFN();
                //$o_FCO_DocReciboFN->setDebug( true );
                $o_FCO_DocReciboFN->setIdBanco( $a_Data['IdBanco'] );
                $o_FCO_DocReciboFN->setIdCuenta( $a_Data['IdCuenta'] );
                $o_FCO_DocReciboFN->setIdMoneda( $a_Data['IdMoneda'] );
                $o_FCO_DocReciboFN->setEstado( CP_DocReciboBN::ESTADO_ACTIVO );
                $o_FCO_DocReciboFN->setReciboFecha( $date->format( "Y-m-d" ) );
                $o_FCO_DocReciboFN->addOrderBy( CP_DocReciboFN::IdDocRecibo );
                $a_FCO_DocRecibo = $o_FCO_DocReciboFN->select();
                if( $a_FCO_DocRecibo )
                {
                    $a_DataRecibos = array_merge( $a_DataRecibos, $a_FCO_DocRecibo );
                }
            }

            $a_Data["a_DocRecibo"] = $a_DataRecibos;

            $a_DataResult[] = $a_Data;
        }

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdBusiness() );
        
        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();
        
        //echo $html;         exit;
        
        $options = new Options();
        //$options->set( 'isRemoteEnabled', TRUE );
        $options->setIsPhpEnabled( true );
        
        //$dompdf = new Dompdf();
        $dompdf = new Dompdf( $options );
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        
        //For Footer
        $canvas = $dompdf->get_canvas();
        $footer = $canvas->open_object();
        $font = "";
        $font_metrics = $dompdf->getFontMetrics();
        $font = $font_metrics->getFont( "helvetica", "bold" );
        //$canvas->page_text(35, 823, "HiveDesk Screenshot Report", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 250, 823, "Pagina:  {PAGE_NUM} de {PAGE_COUNT}", $font, 8, array( 0, 0, 0 ) );
        $canvas->page_text( 500, 823, date( "Y-m-d H:i:s" ), $font, 8, array( 0, 0, 0 ) );
        $canvas->close_object();
        $canvas->add_object( $footer, "all" );
        
        $dompdf->stream( 'Documento_', array( "Attachment" => 0 ) );
        
        exit;
    }
}