<?php
class GuardarAperturaCajaAction extends wtActions
{
    public function execute()
    {
        $s_IdCaja        = $this->getRequestParameter( 'IdCaja' );
        $s_IdTurno       = $this->getRequestParameter( 'IdTurno' );
        $s_IdVendedor    = $this->getRequestParameter( 'IdVendedor' );
        $s_Estado        = $this->getRequestParameter( 'Estado' );
        $s_Observaciones = $this->getRequestParameter( 'Observaciones' );
        $i_IdCierre      = intval( $this->getRequestParameter( 'id_cierre' ) );

        $a_Rs = array( "error" => false );

        $con = Conexion::getConexion();
        $con->begin();

        try
        {
            myUser::getUser()->validar_session();

            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $o_FCO_CierreFN = new FCO_CierreFN();
            $o_FCO_CierreFN->setEstado( FCO_CierreBN::ESTADO_ABIERTO );
            $o_FCO_CierreFN->setCodVendedor( myUser::getUser()->getUserId() );
            $a_FCO_Cierre = $o_FCO_CierreFN->select();
            if( count( $a_FCO_Cierre ) > 1 )
            {
                throw new Exception( "Incongruencia de datos, por favor de revisar el Cierre de Caja." );
            }
            if( $a_FCO_Cierre )
            {
                if( !$i_IdCierre )
                {
                    throw new Exception( "Actualmente ya se encuentra aperturado la Caja." );
                }
            }
            //////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $o_FCO_CierreDP = new FCO_CierreDP();
            //$o_FCO_CierreDP->setFechaCierre( date( "Y-m-d H:i:s" ) );
            $o_FCO_CierreDP->setTotalSoles( 0 );
            $o_FCO_CierreDP->setTotalDolares( 0 );
            $o_FCO_CierreDP->setObservaciones( $s_Observaciones );

            if( $i_IdCierre )
            {
                //se actualiza
                $o_FCO_CierreDP->setIdCierre( intval( $i_IdCierre ) );
                $o_FCO_CierreDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_CierreDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_FCO_CierreDP->update();
            }
            else
            {
                //nuevo registro

                $i_IdCierre = FCO_CierreDP::recuperarId(); //se genera el cierre
                
                $o_FCO_CierreDP->setIdCompania( myUser::getUser()->getIdBusiness() );
                $o_FCO_CierreDP->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_FCO_CierreDP->setIdTurno( intval( $s_IdTurno ) );
                $o_FCO_CierreDP->setIdCaja( intval( $s_IdCaja ) );
                $o_FCO_CierreDP->setIdCierre( $i_IdCierre );
                if( $s_IdVendedor )
                {
                    $o_FCO_CierreDP->setCodVendedor( $s_IdVendedor );
                }
                else
                {
                    $o_FCO_CierreDP->setCodVendedor( myUser::getUser()->getUserId() );
                }
                $o_FCO_CierreDP->setPeriodo( date( "Y-m" ) );
                $o_FCO_CierreDP->setEstado( $s_Estado );
                $o_FCO_CierreDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_CierreDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_FCO_CierreDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_FCO_CierreDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_FCO_CierreDP->save();
            }
            //pr( $o_FCO_CierreDP );

            $a_Rs['id_cierre'] = $i_IdCierre;

            $con->commit();
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error'] = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}