<?php
class businessAdapter extends myUser
{
    protected $IdUsuario;
    protected $Contrasenia;
    protected $IdRol;
    protected $IdCompania;
    protected $IdSucursal;

    public function getIdUsuario()
    {
        return $this->IdUsuario;
    }

    public function setIdUsuario($IdUsuario)
    {
        $this->IdUsuario = $IdUsuario;
    }

    public function getIdRol()
    {
        if( !$this->IdRol )
        {
            $this->IdRol = $this->getObjectUsuario()->getIdRol();
        }
        return $this->IdRol;
    }

    public function setIdRol($IdRol)
    {
        $this->IdRol = $IdRol;
    }

    public function getContrasenia()
    {
        return $this->Contrasenia;
    }

    public function setContrasenia($Contrasenia)
    {
        $this->Contrasenia = $Contrasenia;
    }

    public function setIdCompania( $v )
    {
        $this->IdCompania = $v;
    }
    
    public function getIdCompania()
    {
        return $this->IdCompania;
    }
    
    public function setIdSucursal( $v )
    {
        $this->IdSucursal = $v;
    }
    
    public function getIdSucursal()
    {
        return $this->IdSucursal;
    }

    public function getObjectUsuario( $UserId = null )
    {
        if( !is_null( $UserId ) )
        {
            $o_SEG_UsuarioFN = new SEG_UsuarioFN();
            $o_SEG_UsuarioBN = $o_SEG_UsuarioFN->selectByPK( $UserId );
            return $o_SEG_UsuarioBN;
        }
        if( $this->getIdUsuario() )
        {
            $o_SEG_UsuarioFN = new SEG_UsuarioFN();
            $o_SEG_UsuarioBN = $o_SEG_UsuarioFN->selectByPK( $this->getIdUsuario() );
            return $o_SEG_UsuarioBN;
        }
        return null;
    }
    
    public function signInWithBusiness()
    {
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( $this->getIdCompania() );
        if( $o_GSS_CompaniaBN )
        {
            $this->setAttribute( 'IdCompania', $o_GSS_CompaniaBN->getIdCompania(), Constantes::APP_CREDENTIALS );
            $this->setAttribute( 'CompaniaNombre', $o_GSS_CompaniaBN->getDescripcionCorta(), Constantes::APP_CREDENTIALS );
            if( $this->getIdSucursal() )
            {
                $o_GSS_SucursalFN = new GSS_SucursalFN();
                $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( $this->getIdSucursal() );
                if( $o_GSS_SucursalBN )
                {
                    $this->setAttribute( 'IdSucursal', $o_GSS_SucursalBN->getIdSucursal(), Constantes::APP_CREDENTIALS );
                    $this->setAttribute( 'SucursalNombre', $o_GSS_SucursalBN->getDescripcion(), Constantes::APP_CREDENTIALS );
                }
            }
        }

        $o_SEG_UsuarioSesionDP = new SEG_UsuarioSesionDP();
        $o_SEG_UsuarioSesionDP->setIdUsuario( $this->getIdUsuario() );
        $o_SEG_UsuarioSesionDP->setIdRol( $this->getIdRol() );
        $o_SEG_UsuarioSesionDP->guardarSesion();
    }
}