<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class atencionActions extends wtActions
{
    public function executePrintPDF()
    {
        ////////////////////////////////////////////////////////////////////////////////////////////
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdBusiness() );
        
        $Id = $this->getRequestParameter( 'Id' );
        $Ste_SertTecFN =  new STE_ServicioTecnicoFN();
        $Data       = $Ste_SertTecFN->selectByPK( $Id );
        $SerTecId   = "STE-" . str_pad( $Data->getIdServicio(),8,0,STR_PAD_LEFT );

        $s_vHtml = 0;
       
        ////////////////////////////////////////////////////////////////////////////////////////////
        
        $s_Class   = ParameterWR::getInstance()->getModule();
        $s_Module  = strtolower( $s_Class );
        $s_Action  = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );
        
        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";
        
        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();
        
        //echo $html;         exit;
        
        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'portrait' );
        $dompdf->render();
        $dompdf->stream( 'Atencion_Sertec_'.$Id, array( "Attachment" => 0 ) );
        
        exit;
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->Titulo = "Atenci&oacute;n Servicio Tecnico";

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
    	$o_GSS_CompaniaFN->addOrderBy( GSS_CompaniaFN::DescripcionCorta );
    	$this->a_GSS_Compania = $o_GSS_CompaniaFN->select();
    	
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new STE_ServicioTecnicoFN() );

        $o_GridAction->addAssignFilter( "SerieItem" );
         $o_GridAction->addAssignFilter( "DiagnosticoUsuario" );
        //$o_GridAction->addAssignFilter( "IdServicio" );
        $o_GridAction->addConditionFilter( "IdServicio", STE_ServicioTecnicoFN::IdServicio, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "ClienteNombre", STE_ServicioTecnicoFN::ClienteNombre, "LIKE", "%%s%" );
        $o_GridAction->addAssignFilter( "Estado" );
        // $o_GridAction->addAssignFilter( "OrdenId" );
        $o_GridAction->addConditionFilter( "OrdenId", STE_ServicioTecnicoFN::OrdenId, "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "FechaDocumento1", "LEFT(".STE_ServicioTecnicoFN::RecepcionFecha.",10)", ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", "LEFT(".STE_ServicioTecnicoFN::RecepcionFecha.",10)", "<=" );

        /*if( !$this->getRequestParameter( 'Estado' ) )
        {
            $o_GridAction->addMethodDefault( "Estado", array( 'Condition'=>'IN', 'Value' => "('1','2')" ) );
        }*/

        $o_GridAction->addOrderDefault( 1 , false );
        
        $o_GridAction->addRowsToShow( "IdServicio", "SerieItem", "DiagnosticoUsuario", "ClienteNombre", "Estado", "OrdenId", "OrdenNum", 'RecepcionFecha', "EstadoDesc", "TipoServicioDesc" );
              
        $o_GridAction->setNumberRecordsShow( 15 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeSaveAtencion()
    {
        $s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $SerieItem           = trim( $this->getRequestParameter( 'SerieItem' ) );
        $IdItem              = $this->getRequestParameter( 'IdItem' );

        $ClienteNumero       = intval( $this->getRequestParameter( 'ClienteNumero' ) );
        $ProductoDescripcion = $this->getRequestParameter( 'ProductoDescripcion' );
        $DireccionCliente    = $this->getRequestParameter( 'DireccionCliente' );
        $ClienteTelefono     = $this->getRequestParameter( 'ClienteTelefono' );
        $ClienteCorreo       = $this->getRequestParameter( 'ClienteCorreo' );
        //$OrdenId             = $this->getRequestParameter( 'OrdenId' );
        //$FechaOV             = $this->getRequestParameter( 'FechaOV' );
        //$IdUsuario           = myUser::getUser()->getUserId();
        //$Estado              = $this->getRequestParameter( 'Estado' );
        //$FechaRegistro       = $this->getRequestParameter( 'FechaRegistro' );
        //$NombreAtendido      = $this->getRequestParameter( 'NombreAtendido' );
        $DescargoCliente     = $this->getRequestParameter( 'DescargoCliente' );
        $RevisionRecepcion   = $this->getRequestParameter( 'RevisionRecepcion' );
        //$AccionesRecepcion   = $this->getRequestParameter( 'AccionesRecepcion' );
        $ComentarioRecepcion = $this->getRequestParameter( 'ComentarioRecepcion' );
        $PlazoEntrega        = $this->getRequestParameter( 'PlazoEntrega' );

        $con = Conexion::getConexion();
        $con->begin();
        try 
        {
            myUser::getUser()->validar_session();

            $i_TipoServicio = STE_ServicioTecnicoBN::SERVICIO_TECNICO;
            $i_SerieExiste  = 0;

            $o_SR_SerieBN = null;

            //validaciones
            $o_SR_SerieFN = new SR_SerieFN();
            $o_SR_SerieFN->setSerieNumero( $SerieItem );
            $a_SR_Serie = $o_SR_SerieFN->select();
            if( !$a_SR_Serie )
            {
                //throw new Exception( "La Serie no existe." );
                $i_TipoServicio = STE_ServicioTecnicoBN::SERVICIO_ADICIONAL;
            }
            else
            {
                $i_SerieExiste  = 1;
                $o_SR_SerieBN = $a_SR_Serie[0];
                $IdItem = $o_SR_SerieBN->getProductoId();
            }

            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $IdItem );
            if( !$o_ALM_ItemMastBN )
            {
                throw new Exception( "El Producto no existe." );
            }
            if( $IdItem != $o_ALM_ItemMastBN->getIdItem() )
            {
                throw new Exception( "El Producto no existe por URL." );
            }

            $o_MST_TipoGarantiaBN = $o_ALM_ItemMastBN->getObjectTipoGarantia();
            $TipoGarantiaId = $o_MST_TipoGarantiaBN->getTipoGarantiaId();

            $EstadoGarantia     = "SIN GARANTIA" ;
            $OrdenId            = "";
            $s_ReferenciaNumero = "";
            $o_VTA_DocumentoBN  = new VTA_DocumentoBN();

            if( $o_SR_SerieBN )
            {
                $o_SR_SerieEscaneoFN = new SR_SerieEscaneoFN();
                $o_SR_SerieEscaneoFN->setSerieId( $o_SR_SerieBN->getSerieId() );
                $o_SR_SerieEscaneoFN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                $o_SR_SerieEscaneoFN->setProductoId( $IdItem );
                $o_SR_SerieEscaneoFN->addOrderBy( SR_SerieEscaneoFN::Fecha, false );
                $a_SR_SerieEscaneo = $o_SR_SerieEscaneoFN->select();
                if( !$a_SR_SerieEscaneo )
                {
                    throw new Exception( "No se encontro Movimientos por la Serie." );
                }
                $o_SR_SerieEscaneoBN = $a_SR_SerieEscaneo[0];

                $s_ReferenciaNumero = $o_SR_SerieEscaneoBN->getReferenciaNumero();

                $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $s_ReferenciaNumero );
                $OrdenId = $o_VTA_OrdenBN->getOrdenId();

                $o_VTA_DocumentoBN = $o_VTA_OrdenBN->getObjectVTADocumento();

                if( $ClienteNumero != $o_VTA_DocumentoBN->getClienteNumero() )
                {
                    //throw new Exception( "No concuerda el Id del Cliente." );
                }

                $FechaOrden     = substr( $o_VTA_DocumentoBN->getFechaDocumento(),0,10 );
                $Date_diff      = UtilDate::diferenciaEntreFecha( date( "Y-m-d" ), $FechaOrden );

                if( $Date_diff > $o_MST_TipoGarantiaBN->getNumeroDias() )
                {
                    $EstadoGarantia = "La Garantia ha caducado";
                }

                if( $Date_diff < $o_MST_TipoGarantiaBN->getNumeroDias() )
                {
                    $EstadoGarantia = "La Garantia esta vigente";
                }
                if( $o_MST_TipoGarantiaBN->getNumeroDias() == 0 )
                {
                    $EstadoGarantia = "La Garantia no es valida";
                }
            }

            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );

            $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();

            $o_STE_ServicioTecnicoDP->setDescargoCliente( $DescargoCliente );
            $o_STE_ServicioTecnicoDP->setRevisionRecepcion( $RevisionRecepcion );
            //$o_STE_ServicioTecnicoDP->setAccionesRecepcion( $AccionesRecepcion );
            $o_STE_ServicioTecnicoDP->setComentarioRecepcion( $ComentarioRecepcion );
            $o_STE_ServicioTecnicoDP->setPlazoEntrega( ( int ) $PlazoEntrega );
            if( $this->getRequestParameter( 'DiagnosticoMontoIncIGV' ) )
            {
                $o_STE_ServicioTecnicoDP->setDiagnosticoMontoIncIGV( floatval( $this->getRequestParameter( 'DiagnosticoMontoIncIGV' ) ) );
            }

            $o_STE_ServicioTecnicoDP->setIdPersona( $ClienteNumero );
            $o_STE_ServicioTecnicoDP->setClienteNombre( $o_MST_PersonaMastBN->getNombreCompleto() );
            $o_STE_ServicioTecnicoDP->setClienteTipoDoc( $o_MST_PersonaMastBN->getTipoDocumento() );
            $o_STE_ServicioTecnicoDP->setClienteNumeroDoc( $o_MST_PersonaMastBN->getDocumento() );
            if( $DireccionCliente )
            {
                $o_STE_ServicioTecnicoDP->setClienteDireccionFiscal( $DireccionCliente );
            }
            else
            {
                $o_STE_ServicioTecnicoDP->setClienteDireccionFiscal( $o_MST_PersonaMastBN->getDireccion() );
            }

            $o_STE_ServicioTecnicoDP->setClienteTelefono( $ClienteTelefono );
            $o_STE_ServicioTecnicoDP->setClienteCorreo( $ClienteCorreo );

            if( $s_TipoProc == "nvo" )
            {
                if( $i_TipoServicio == STE_ServicioTecnicoBN::SERVICIO_ADICIONAL )
                {
                    $o_STE_ServicioTecnicoDP->setCubreGarantiaFlag( 0 );
                }
                $o_STE_ServicioTecnicoDP->setSerieExisteFlag( $i_SerieExiste );
                $o_STE_ServicioTecnicoDP->setTipoServicio( $i_TipoServicio );
                $o_STE_ServicioTecnicoDP->setOrdenId( ( string ) $OrdenId );
                $o_STE_ServicioTecnicoDP->setOrdenNum( $s_ReferenciaNumero );
                $o_STE_ServicioTecnicoDP->setComprobanteId( $o_VTA_DocumentoBN->getNumeroDocumento() );
                $o_STE_ServicioTecnicoDP->setComprobanteNumero( $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero() );
                $o_STE_ServicioTecnicoDP->setComprobanteFecha( $o_VTA_DocumentoBN->getFechaDocumento() );

                $o_STE_ServicioTecnicoDP->setSerieItem( $SerieItem );
                $o_STE_ServicioTecnicoDP->setIdItem( $IdItem );
                $o_STE_ServicioTecnicoDP->setTipoGarantiaId( ( string ) $TipoGarantiaId );
                $o_STE_ServicioTecnicoDP->setProductoDescripcion( $o_ALM_ItemMastBN->getDescripcionCompleta() );
                $o_STE_ServicioTecnicoDP->setRecepcionUsuario( myUser::getUser()->getUserId() );
                $o_STE_ServicioTecnicoDP->setEstado( STE_ServicioTecnicoBN::ESTADO_RECEPCIONADO );
                $o_STE_ServicioTecnicoDP->setRecepcionFecha( date( "Y-m-d H:i:s" ) );
                $o_STE_ServicioTecnicoDP->setGaratiaEstadoDesc( $EstadoGarantia );
                $o_STE_ServicioTecnicoDP->setDiagnosticoExisteCobranzaFlag( 0 );

                $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
                $o_STE_ServicioTecnicoFN->setSerieItem( $SerieItem );
                $o_STE_ServicioTecnicoFN->addCondition( STE_ServicioTecnicoFN::Estado, "IN", "('1','2')", false );
                $a_STE_ServicioTecnico = $o_STE_ServicioTecnicoFN->select();
                if( $a_STE_ServicioTecnico )
                {
                    throw new Exception( "Actualmente la Serie se encuentra en Proceso." );
                }

                $i_IdServicio = STE_ServicioTecnicoDP::recuperarId();
                $o_STE_ServicioTecnicoDP->setIdServicio( $i_IdServicio );
                $o_STE_ServicioTecnicoDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_STE_ServicioTecnicoDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                //pr( $o_STE_ServicioTecnicoDP );

                //pr( $_REQUEST ); exit;

                $o_STE_ServicioTecnicoDP->save();
            }
            else
            {
                //update
                $o_STE_ServicioTecnicoDP->setIdServicio( ( int ) $i_Id );
                $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                $o_STE_ServicioTecnicoDP->update();
                
                $i_IdServicio = $i_Id;
            }

            $con->commit();

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_IdServicio;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->addCondition( "IdUsuario", "=", myUser::getUser()->getUserId());
        $a_MST_PersonaMast = $o_MST_PersonaMastFN->select();
        $this->s_Vendedor = $a_MST_PersonaMast[0]->getNombreCompleto();
        $IdPersona = $a_MST_PersonaMast[0]->getIdPersona();
        
        $this->s_TipoProc = $this->getRequestParameter( 'tipo_proc' );
        $this->Id = $this->getRequestParameter( 'i_Id' );
        
        $this->a_DetallesSerie = "";
        $this->DetallesSerie = array( "SerieId" => "",  "MovimientoId" => "", "ProductoId" => "", "SerieNumero" => "", "UltimaOperacion" => "", "DescripcionCompleta" => "", "ReferenciaNumero" => "", "OrdenFecha" => "", "Nombre" => "", "EstadoGarantia" => "" );
        
        $this->o_Default = new STE_ServicioTecnicoBN();
        $this->o_Default->setRecepcionFecha( date( "Y-m-d" ) );

        $this->b_ControlComprobante           = false;
        $this->b_ControlReparacionComprobante = false;

        if( $this->s_TipoProc == "upd" || $this->s_TipoProc == "shw" )
        {
            $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
            $this->o_Default = $o_STE_ServicioTecnicoFN->selectByPK( $this->Id );

            $this->DetallesSerie = STE_ServicioTecnicoFN::buscarDetallesPorSerie( $this->o_Default->getSerieItem() );
            $this->a_DetallesSerie = $this->DetallesSerie['ProductoId'] . ": " . $this->DetallesSerie['DescripcionCompleta'];

            $Date_diff = UtilDate::diferenciaEntreFecha(date( "Y-m-d" ), substr( $this->DetallesSerie['OrdenFecha'],0,10 ) );
            $EstadoGarantia = "" ;

            if ($Date_diff > $this->DetallesSerie['NumeroDias'])
            {
                $EstadoGarantia = "La Garantia ha caducado";
            }

            if ($Date_diff < $this->DetallesSerie['NumeroDias'])
            {
                $EstadoGarantia = "La Garantia esta vigente";
            }
            if( $this->DetallesSerie['NumeroDias'] == 0 )
            {
                $EstadoGarantia = "La Garantia no es valida";
            }
            $this->DetallesSerie['EstadoGarantia'] = $EstadoGarantia;

            if( $this->o_Default->getDiagnosticoComprobanteId() )
            {
                $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->o_Default->getDiagnosticoComprobanteId() );
                if( $o_VTA_DocumentoBN->getEstado() == VTA_DocumentoBN::ESTADO_CERRADO )
                {
                    $this->b_ControlComprobante = true;
                }
            }

            if( $this->o_Default->getReparacionComprobanteId() )
            {
                $o_VTA_DocumentoBN = VTA_DocumentoFN::selectByDocumentNumber( $this->o_Default->getReparacionComprobanteId() );
                if( $o_VTA_DocumentoBN->getEstado() == VTA_DocumentoBN::ESTADO_CERRADO )
                {
                    $this->b_ControlReparacionComprobante = true;
                }
            }
        }

        if( myUser::getUser()->getUserId() )
        {
            $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
            $o_GSS_UsuarioSucuDocumentoFN->setIdUsuario( myUser::getUser()->getUserId() );
            $o_GSS_UsuarioSucuDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_GSS_UsuarioSucuDocumentoFN->addOrderBy( GSS_UsuarioSucuDocumentoFN::IdTipoDocumento );
            $a_GSS_UsuarioSucuDocumento = $o_GSS_UsuarioSucuDocumentoFN->select();
            foreach ( $a_GSS_UsuarioSucuDocumento as $key => $o_GSS_UsuarioSucuDocumentoBN )
            {
                //AQUI SE INTERVIENE LA NOTA DE CREDITO:
                if( $o_GSS_UsuarioSucuDocumentoBN->getIdTipoDocumento() == "NC" )
                {
                    continue;
                }

                $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                $o_GSS_SucursalDocumentoBN = $o_GSS_SucursalDocumentoFN->selectByPK( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );
                if( $o_GSS_SucursalDocumentoBN->getEstado() != "A" )
                {
                    continue;
                }

                $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
                $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $o_GSS_SucursalDocumentoBN->getIdTipoDocumento() );
                if( $o_VTA_TipoDocumentoBN->getGenerarProvisionFlag() != "S" )
                {
                    continue;
                }

                $this->a_VTA_TipoDocumento[] = $o_VTA_TipoDocumentoBN;
            }
        }
        else
        {
            $this->a_VTA_TipoDocumento = array();
        }

    }
    
    public function executeRequest()
    {
        
        set_header_utf8();
        $SerieItem = $this->getRequestParameter( 'SerieItem' );
        $TipoProc  = $this->getRequestParameter( 'TipoProc' );

        $a_lst = array( "error" => false );

        try
        {
            switch ( $TipoProc )
            {
                case "AprobarReparacion":

                    $s_IdServicico  = $this->getRequestParameter( 'IdServicico' );

                    $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
                    $o_STE_ServicioTecnicoBN = $o_STE_ServicioTecnicoFN->selectByPK( $s_IdServicico );
                    if( !$o_STE_ServicioTecnicoBN )
                    {
                        throw new Exception( "No se encontro el registro $s_IdServicico" );
                    }

                    $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
                    $o_STE_ServicioTecnicoDP->setIdServicio( intval( $s_IdServicico ) );
                    $o_STE_ServicioTecnicoDP->setEstado( STE_ServicioTecnicoBN::ESTADO_APROB_REPARA );
                    $o_STE_ServicioTecnicoDP->setReparacionAprobacionUsuario( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->setReparacionAprobacionFecha( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setDiagnosticoFechaIni( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setDiagnosticoUsuario( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->update();

                break;
                case "RechazarRegistro":

                    $s_IdServicico  = $this->getRequestParameter( 'IdServicico' );

                    $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
                    $o_STE_ServicioTecnicoBN = $o_STE_ServicioTecnicoFN->selectByPK( $s_IdServicico );
                    if( !$o_STE_ServicioTecnicoBN )
                    {
                        throw new Exception( "No se encontro el registro $s_IdServicico" );
                    }

                    $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
                    $o_STE_ServicioTecnicoDP->setIdServicio( intval( $s_IdServicico ) );
                    $o_STE_ServicioTecnicoDP->setEstado( STE_ServicioTecnicoBN::ESTADO_RECHAZADO );
                    $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                    $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                    $o_STE_ServicioTecnicoDP->update();

                break;
                
                case "buscarInfoWebservice":

                    if( trim( $SerieItem ) == "" )
                    {
                        throw new Exception( "No se encontro Serie. " );
                    }
                    //se hace una validacion
                    $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
                    $o_STE_ServicioTecnicoFN->setSerieItem( $SerieItem );
                    $o_STE_ServicioTecnicoFN->addOrderBy( STE_ServicioTecnicoFN::IdServicio, false );
                    $a_STE_ServicioTecnico = $o_STE_ServicioTecnicoFN->select();
                    if( $a_STE_ServicioTecnico )
                    {
                        $s_EstadoRef = $a_STE_ServicioTecnico[0]->getEstadoDesc();
                        throw new Exception( "Actualmente la Serie se encuentra registrado con un estado $s_EstadoRef. " );
                    }

                    //$a_DetallesSerie = STE_ServicioTecnicoFN::buscarDetallesPorSerie( $SerieItem );
                    $a_DetallesSerie = array(
                        "SerieId" => "",  "MovimientoId" => "", "ProductoId" => "", "SerieNumero" => "", "UltimaOperacion" => "", "DescripcionCompleta" => "", "ReferenciaNumero" => "", "OrdenFecha" => "", "NumeroDias" => "", "GarantiaNombre" => "",
                        "ComprobanteFecha" => "", "ComprobanteNumero" => "", "IdPersona" => ""
                    );

                    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    //validaciones
                    $o_SR_SerieFN = new SR_SerieFN();
                    $o_SR_SerieFN->setSerieNumero( $SerieItem );
                    $a_SR_Serie = $o_SR_SerieFN->select();
                    if( !$a_SR_Serie )
                    {
                        throw new Exception( "La Serie no existe." );
                    }
                    $o_SR_SerieBN = $a_SR_Serie[0];

                    if( $o_SR_SerieBN )
                    {
                        $IdItem = $o_SR_SerieBN->getProductoId();

                        $o_ALM_ItemMastFN = new ALM_ItemMastFN();
                        $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $IdItem );
                        if( !$o_ALM_ItemMastBN )
                        {
                            throw new Exception( "El Producto no existe." );
                        }

                        $o_MST_TipoGarantiaBN = $o_ALM_ItemMastBN->getObjectTipoGarantia();
                        $TipoGarantiaId       = $o_MST_TipoGarantiaBN->getTipoGarantiaId();

                        $o_SR_SerieEscaneoFN = new SR_SerieEscaneoFN();
                        $o_SR_SerieEscaneoFN->setSerieId( $o_SR_SerieBN->getSerieId() );
                        $o_SR_SerieEscaneoFN->setOperacion( ALM_TransaccionCabeceraBN::TIPO_SALIDA );
                        $o_SR_SerieEscaneoFN->setProductoId( $IdItem );
                        $o_SR_SerieEscaneoFN->addOrderBy( SR_SerieEscaneoFN::Fecha, false );
                        $a_SR_SerieEscaneo = $o_SR_SerieEscaneoFN->select();
                        if( !$a_SR_SerieEscaneo )
                        {
                            throw new Exception( "No se encontro Movimientos por la Serie." );
                        }
                        $o_SR_SerieEscaneoBN = $a_SR_SerieEscaneo[0];

                        $s_ReferenciaNumero = $o_SR_SerieEscaneoBN->getReferenciaNumero();

                        $o_VTA_OrdenBN = VTA_OrdenFN::findOrdenByNum( $s_ReferenciaNumero );
                        $OrdenId = $o_VTA_OrdenBN->getOrdenId();

                        $o_VTA_DocumentoBN = $o_VTA_OrdenBN->getObjectVTADocumento();

                        $a_DetallesSerie = array(
                            "SerieId" => $o_SR_SerieEscaneoBN->getSerieId(),  "MovimientoId" => $o_SR_SerieEscaneoBN->getMovimientoId(), "ProductoId" => $o_ALM_ItemMastBN->getIdItem(), "SerieNumero" => $SerieItem,
                            "UltimaOperacion" => $o_SR_SerieEscaneoBN->getOperacion(), "DescripcionCompleta" => $o_ALM_ItemMastBN->getDescripcionCompleta(), "ReferenciaNumero" => $o_VTA_OrdenBN->getOrdenNum(),
                            "ComprobanteFecha" => substr( $o_VTA_DocumentoBN->getFechaDocumento(), 0, 10 ), "NumeroDias" => $o_MST_TipoGarantiaBN->getNumeroDias(), "GarantiaNombre" => $o_MST_TipoGarantiaBN->getNombre(),
                            "ComprobanteNumero" => $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero(), "IdPersona" => $o_VTA_DocumentoBN->getClienteNumero()
                        );
                    }

                    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
                    
                    $FechaOrden = substr($a_DetallesSerie['ComprobanteFecha'],0,10);
                    $Date_diff = UtilDate::diferenciaEntreFecha(date( "Y-m-d" ), $FechaOrden);
                    $EstadoGarantia = "" ;
                    
                    if (!$a_DetallesSerie['ReferenciaNumero'])
                        {
                            $DescripcionCompleta = "Producto no Registrado";
                            $a_DetallesSerie['DescripcionCompleta'] = $DescripcionCompleta;
                        }
            
                    if ($Date_diff > $a_DetallesSerie['NumeroDias'])
                        {
                            $EstadoGarantia = "La Garantia ha caducado";
                        }
                    
                    if ($Date_diff < $a_DetallesSerie['NumeroDias'])
                        {
                            $EstadoGarantia = "La Garantia esta vigente";
                        }
                    if ($a_DetallesSerie['NumeroDias'] == 0)
                        {
                            $EstadoGarantia = "La Garantia no es valida";
                        }
                    $a_DetallesSerie['EstadoGarantia'] = $EstadoGarantia;
                        
                    $a_lst = $a_DetallesSerie;
                    $a_lst['error'] = false;
                break;
            }
        }
        catch ( Exception $e )
        {
            $a_lst['error'] = true;
            $a_lst['mensaje_error'] = $e->getMessage();
        }
        
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
}