<?php
class GenerarComprobanteAction extends wtActions
{
    public function execute()
    {
        $i_IdServicio       = intval( $this->getRequestParameter( 'IdServicio' ) );
        $s_TipoProc         = $this->getRequestParameter( 'tipo_proc' );
        $f_MontoIGV         = floatval( $this->getRequestParameter( 'MontoIGV' ) );
        $s_TipoComprobante  = $this->getRequestParameter( 'DiagnosticoComprobanteTipo' );

        $con = Conexion::getConexion();
        $con->begin();
        try
        {
            myUser::getUser()->validar_session();

            $o_STE_ServicioTecnicoFN = new STE_ServicioTecnicoFN();
            $o_STE_ServicioTecnicoBN = $o_STE_ServicioTecnicoFN->selectByPK( $i_IdServicio );

            $IdCompania         = myUser::getUser()->getIdBusiness();

            $o_GSS_CompaniaBN   = GSS_CompaniaFN::buscarCompania( $IdCompania );

            $OrdenTipoId                = 2;
            $ClienteNumero              = $o_STE_ServicioTecnicoBN->getIdPersona();

            $Comentario                 = "";
            $IdAlmacen                  = "";
            $AlmacenDespacho            = "";
            $IdVendedor                 = myUser::getUser()->getUserId();
            $FactRegla                  = "MER";
            $ValidezOrden               = "1";
            $PlazaEntregaOrden          = "1";
            $CondicionVenta             = null;
            $s_OrdenCompraRef           = null;
            $s_OrdenTipoComercialId     = 1;
            $s_OrdenTipoClasificacionId = VTA_OrdenBN::TIPO_SERTEC;
            $s_DiasAlquiler             = null;
            $s_CondicionVentaId         = "008"; //AL CONTADO
            $s_FormaPagoDesc            = "CONTADO";

            //$a_DataValidez = VTA_OrdenBN::getArrayValidezOrden( $ValidezOrden );
            $o_MST_ValidezOfFN = new MST_ValidezOfFN();
            $o_MST_ValidezOfBN = $o_MST_ValidezOfFN->selectByPK( $ValidezOrden );
            $OrdenVenc = UtilDate::obtenerOrdenFechaVenc( $o_MST_ValidezOfBN->getCantHoras() );
            //$OrdenVenc = UtilDate::obtenerOrdenFechaVenc( ( $s_DiasAlquiler * 24 ) );

            if( !GSS_TipoCambioFN::getStaticTipoCambioCobranza() )
            {
                $s_FechaSel = date( "Y-m-d" );

                $o_iVentas = new iVentas();
                $o_iVentas->registrarTipoCambio( $s_FechaSel );
            }

            $MonedaCod          = "LO";
            $MonedaCambioValor  = GSS_TipoCambioFN::getStaticTipoCambioCobranza();
            $IdProyecto         = null;
            $IdUbigeo           = $this->getRequestParameter( 'IdUbigeo' );

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se prepara el almacen por defecto:
            $o_GSS_SucursalFN = new GSS_SucursalFN();
            $o_GSS_SucursalBN = $o_GSS_SucursalFN->selectByPK( myUser::getUser()->getIdSucursal() );

            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $o_GSS_SucursalBN->getIdAlmacen() );

            //$a_ALM_AlmacenMast = ALM_AlmacenMastFN::recuperarAlmacenParaVentas( myUser::getUser()->getIdSucursal() );
            if( $o_ALM_AlmacenMastBN )
            {
                $IdAlmacen       = $o_ALM_AlmacenMastBN->getIdAlmacen();
                $AlmacenDespacho = $IdAlmacen;
            }
            else
            {
                throw new Exception( "Se tiene que seleccionar un Almacen." );
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //se busca el cliente
            $o_MST_PersonaMastFN = new MST_PersonaMastFN();
            $o_MST_PersonaMastBN = $o_MST_PersonaMastFN->selectByPK( $ClienteNumero );
            if( !$o_MST_PersonaMastBN )
            {
                throw new Exception( "El Nro Documento ingresado no se encuentra registrado." );
            }

            $TipoDocCliente          = $o_MST_PersonaMastBN->getTipoDocumento();
            $NumDocuCliente          = $o_MST_PersonaMastBN->getDocumento();
            $ClienteDireccion        = $o_MST_PersonaMastBN->getDireccion();
            $ClienteDistritoDesc     = $o_MST_PersonaMastBN->getDistritoDesc();
            $ClienteDepartamentoDesc = $o_MST_PersonaMastBN->getDepartamentoDesc();
            $ProvinciaDesc           = $o_MST_PersonaMastBN->getProvinciaDesc();
            $ClienteNombre           = $o_MST_PersonaMastBN->getNombreCompletoLLeno();
            $VendedorAsigna          = $o_MST_PersonaMastBN->getVendedorAsignado();
            $CanalCliente            = $o_MST_PersonaMastBN->getCanalCliente();
            $NivelPrecioCliente      = $o_MST_PersonaMastBN->getNivelPrecioCliente();
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $o_VTA_OrdenBN = new VTA_OrdenBN();
            $o_VTA_OrdenBN->setOrdenObs( $Comentario );
            $o_VTA_OrdenBN->setOrdenImpuestoFlag( "Y" );
            $o_VTA_OrdenBN->setOrdenExoneradoFlag( "N" );
            $o_VTA_OrdenBN->setReferenciaTipoDocId( $s_TipoComprobante );

            //NUEVO PROCEDIMIENTO, POR EXONERACION DEL IGV - 2021-12-29
            if( $o_GSS_SucursalBN->getEstaExoneradoIGV() )
            {
                $o_VTA_OrdenBN->setOrdenImpuestoFlag( "N" );
                $o_VTA_OrdenBN->setOrdenExoneradoFlag( "Y" );
            }

            $o_VTA_OrdenBN->setClienteId( ( int ) $ClienteNumero );
            $o_VTA_OrdenBN->setClienteDocCod( $TipoDocCliente );
            $o_VTA_OrdenBN->setClienteDocNum( $NumDocuCliente );
            $o_VTA_OrdenBN->setClienteNombre( $ClienteNombre );
            //$o_VTA_OrdenBN->setClienteSucursal( $ClienteDireccion );
            $o_VTA_OrdenBN->setFactDirec1( $ClienteDireccion );
            $o_VTA_OrdenBN->setFactDirec2( $ClienteDistritoDesc );
            $o_VTA_OrdenBN->setFactDirec3( $IdUbigeo );
            $o_VTA_OrdenBN->setPrecioNivel( $NivelPrecioCliente );
            $o_VTA_OrdenBN->setFactPais( "PERU" );
            $o_VTA_OrdenBN->setFactEstado( $ProvinciaDesc );
            $o_VTA_OrdenBN->setFactCiudad( $ClienteDepartamentoDesc );

            $o_VTA_OrdenBN->setValidezOrden( $ValidezOrden );
            $o_VTA_OrdenBN->setPlazaEntregaOrden( $PlazaEntregaOrden );
            $o_VTA_OrdenBN->setCondicionVenta( $CondicionVenta );
            $o_VTA_OrdenBN->setOrdenVenc( $OrdenVenc );
            $o_VTA_OrdenBN->setOrdenCompraRef( $s_OrdenCompraRef );

            $o_VTA_OrdenBN->setDiasAlquiler( intval( $s_DiasAlquiler ) );
            $o_VTA_OrdenBN->setIdProyecto( ( int ) $IdProyecto );

            //ahora se deja actualizar la moneda y el tipo de cambio. - 2020-07-15
            $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
            $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );

            $o_VTA_OrdenBN->setOrdenTipoId( ( int ) $OrdenTipoId );
            $o_VTA_OrdenBN->setCondicionVentaId( $s_CondicionVentaId );
            $o_VTA_OrdenBN->setFormaPagoDesc( $s_FormaPagoDesc );

            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $o_VTA_OrdenBN->setOrdenTipoComercialId( intval( $s_OrdenTipoComercialId ) );
                $o_VTA_OrdenBN->setOrdenTipoClasificacionId( intval( $s_OrdenTipoClasificacionId ) );
                $o_VTA_OrdenBN->setCiaCod( ( int ) $IdCompania );
                $o_VTA_OrdenBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
                $o_VTA_OrdenBN->setPtoVtaCod( "LIM" );
                $o_VTA_OrdenBN->setOrdenBloqueado( "Y" );

                $s_OrdenFecha = date( "Y-m-d H:i:s" );

                $o_VTA_OrdenBN->setOrdenFecha( $s_OrdenFecha );
                $o_VTA_OrdenBN->setAlmacenCod( $IdAlmacen );
                $o_VTA_OrdenBN->setAlmacenDespacho( $AlmacenDespacho );
                $o_VTA_OrdenBN->setVendedorCliente( $VendedorAsigna );
                $o_VTA_OrdenBN->setVendedorOrden( myUser::getUser()->getUserId() );
                $o_VTA_OrdenBN->setFactRegla( $FactRegla );
                $o_VTA_OrdenBN->setMonedaCod( $MonedaCod );
                $o_VTA_OrdenBN->setMonedaCambioValor( floatval( $MonedaCambioValor ) );
                $o_VTA_OrdenBN->setOrdenEstado( VTA_OrdenBN::ESTADO_ABIERTO );
                $o_VTA_OrdenBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_OrdenBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_VTA_OrdenBN->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
                $o_VTA_OrdenBN->setUsuarioActualizacion( myUser::getUser()->getUserId() );
                $o_CotizacionesBL = new CotizacionesBL();
                $o_CotizacionesBL->iniciarOrdenVenta( $o_VTA_OrdenBN );
            }
            else
            {

            }

            $i_Id = $o_VTA_OrdenBN->getOrdenId();

            //ahora se actualiza los ID de las cotizacion al servicio tecnico
            $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
            $o_STE_ServicioTecnicoDP->setIdServicio( $i_IdServicio );
            $o_STE_ServicioTecnicoDP->setDiagnosticoCotizacionId( $o_VTA_OrdenBN->getOrdenId() );
            $o_STE_ServicioTecnicoDP->setDiagnosticoCotizacionNum( $o_VTA_OrdenBN->getOrdenNum() );
            $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
            $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
            $o_STE_ServicioTecnicoDP->update();

            //AHORA SE ASOCIA LOS DETALLES QUE ES UN SERVICIO:
            //00216
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            //submit, se agrega el comentario
            $i_IdDet = VTA_OrdenDetalleDP::recuperarId( $o_VTA_OrdenBN->getOrdenId() );
            $s_CodigoServicio = "00220"; //00216

            $o_ALM_ItemMastFN = new ALM_ItemMastFN();
            $o_ALM_ItemMastBN = $o_ALM_ItemMastFN->selectByPK( $s_CodigoServicio );
            if( !$o_ALM_ItemMastBN )
            {
                throw new Exception( "El Servicio no se ecneuntra registrado." );
            }

            //////////////////////////////////////////////////////////////////////////////////////////
            $s_OrdenMonedaCod = $o_VTA_OrdenBN->getMonedaCod();
            $f_TipoCob = $o_VTA_OrdenBN->getMonedaCambioValor();
            //////////////////////////////////////////////////////////////////////////////////////////
            //SE RECUPERA VALOR DE IGV ACTUAL
            $f_ValorIGV       = GSS_ParametroMastFN::getValorPorTipo( "AL", "IGV" ); //0.18
            $f_ValorIGVMasUno = $f_ValorIGV + 1;  //1.18
            //////////////////////////////////////////////////////////////////////////////////////////

            $o_Tmp_VTA_OrdenDetalleBN = new VTA_OrdenDetalleBN();
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenId( $o_VTA_OrdenBN->getOrdenId() );
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenDetalleNum( $i_IdDet );
            $o_Tmp_VTA_OrdenDetalleBN->setItemCod( $s_CodigoServicio );
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenDetalleCantidad( 1 );
            $o_Tmp_VTA_OrdenDetalleBN->setAlmacenCod( $o_VTA_OrdenBN->getAlmacenCod() );
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenDetallePrecioNivel( "1" );
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenDetalleAfectoImpuesto( "Y" );
            $o_Tmp_VTA_OrdenDetalleBN->setItemTipo( VTA_OrdenDetalleBN::TIPO_PRODUCTO_SERVICIO );
            $o_Tmp_VTA_OrdenDetalleBN->setIdItemTipo( "02" );
            $o_Tmp_VTA_OrdenDetalleBN->setIdUnidad( 58 );
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenDetalleDescripcion( $o_ALM_ItemMastBN->getDescripcionCompleta() );
            //$o_Tmp_VTA_OrdenDetalleBN->setDocRefTipoCod( $s_IdItemTipo );
            //$o_Tmp_VTA_OrdenDetalleBN->setDocRefId( $i_IdPromoCab );
            //$o_Tmp_VTA_OrdenDetalleBN->setDocRefNum( $s_CodigoPromo );
            $o_Tmp_VTA_OrdenDetalleBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
            $o_Tmp_VTA_OrdenDetalleBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_Tmp_VTA_OrdenDetalleBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_Tmp_VTA_OrdenDetalleBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );

            //$f_CostoUnidadIncImpuesto = round( $o_MKT_ItemPromocionBN->getCostoConIGVCalculado() / $f_ValorIGVMasUno, 2 );
            //$f_CostoUnidadIncImpuestoMN = $f_CostoUnidadIncImpuesto;
            $f_CostoUnidadIncImpuesto = round( $f_MontoIGV / $f_ValorIGVMasUno, 2 );
            $f_CostoUnidadIncImpuestoMN = $f_CostoUnidadIncImpuesto;

            $f_PrecioUnidadIncImpuesto = $f_MontoIGV;
            $f_PrecioUnidadIncImpuestoMN = $f_MontoIGV;
            $f_OrdenDetallePrecioUnidad = round( $f_MontoIGV / $f_ValorIGVMasUno, 2 );
            $f_OrdenDetallePrecioUnidadMN = $f_OrdenDetallePrecioUnidad;
            $f_OrdenDetalleImpuestoUnidad = $f_PrecioUnidadIncImpuesto - $f_OrdenDetallePrecioUnidad;
            $f_OrdenDetalleImpuestoUnidadMN = $f_PrecioUnidadIncImpuestoMN - $f_OrdenDetallePrecioUnidadMN;

            $o_Tmp_VTA_OrdenDetalleBN->setCostoUnidadIncImpuesto( $f_CostoUnidadIncImpuesto );
            $o_Tmp_VTA_OrdenDetalleBN->setCostoUnidadIncImpuestoMN( $f_CostoUnidadIncImpuestoMN );
            $o_Tmp_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuesto( $f_PrecioUnidadIncImpuesto );
            $o_Tmp_VTA_OrdenDetalleBN->setPrecioUnidadIncImpuestoMN( $f_PrecioUnidadIncImpuestoMN );
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidad( $f_OrdenDetallePrecioUnidad );
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenDetallePrecioUnidadMN( $f_OrdenDetallePrecioUnidadMN );
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenDetalleImpuestoUnidad( $f_OrdenDetalleImpuestoUnidad );
            $o_Tmp_VTA_OrdenDetalleBN->setOrdenDetalleImpuestoUnidadMN( $f_OrdenDetalleImpuestoUnidadMN );

            $o_CotizacionesDetalleBL = new CotizacionesDetalleBL();
            $o_CotizacionesDetalleBL->validarValoresxDefecto( $o_Tmp_VTA_OrdenDetalleBN ); //asigna precio final con impuestos

            $o_VTA_OrdenDetalleDP = new VTA_OrdenDetalleDP( $o_Tmp_VTA_OrdenDetalleBN );
            $o_VTA_OrdenDetalleDP->save();

            $o_CotizacionesDetalleBL->actualizarMontosCabcecera( $o_Tmp_VTA_OrdenDetalleBN );
            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            /// AHORA SE GENERA EL COMPROBANTE SELECCIONADO:

            if( $o_VTA_OrdenBN->getClienteDocCod() == "RUC" )
            {
                $IdTipoDocumento = "FC";
            }
            else
            {
                $IdTipoDocumento = "BV";
                if( $o_VTA_OrdenBN->getReferenciaTipoDocId() )
                {
                    $IdTipoDocumento = $o_VTA_OrdenBN->getReferenciaTipoDocId();
                }
            }

            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //ahora el procedimiento cambia para recuperar serie - numero [PUNO - JULIACA]
            $o_GSS_UsuarioSucuDocumentoFN = new GSS_UsuarioSucuDocumentoFN();
            $o_GSS_UsuarioSucuDocumentoFN->setIdusuario( myUser::getUser()->getUserId() );
            $o_GSS_UsuarioSucuDocumentoFN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $a_GSS_UsuarioSucuDocumento = $o_GSS_UsuarioSucuDocumentoFN->select();

            $o_GSS_SucursalDocumentoBN = null;
            foreach ( $a_GSS_UsuarioSucuDocumento as $key => $o_GSS_UsuarioSucuDocumentoBN )
            {
                $o_GSS_SucursalDocumentoFN = new GSS_SucursalDocumentoFN();
                $o_GSS_SucursalDocumentoBN = $o_GSS_SucursalDocumentoFN->selectByPK( $o_GSS_UsuarioSucuDocumentoBN->getIdSucursalDocumento() );

                if( $o_GSS_SucursalDocumentoBN->getIdTipoDocumento() == $IdTipoDocumento )
                {
                    break; //se interrumpe el bucle por que ya se encontro el tipo de documento que se buscaba
                }
            }

            if( $o_GSS_SucursalDocumentoBN )
            {
                //$o_GSS_SucursalDocumentoBN = $a_GSS_SucursalDocumento[0];

                $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
                $o_VTA_TipoDocumentoBN = $o_VTA_TipoDocumentoFN->selectByPK( $IdTipoDocumento );
                $s_TipoCod = "";
                if( $o_VTA_TipoDocumentoBN )
                {
                    $s_TipoCod = $o_VTA_TipoDocumentoBN->getTipoDocumentoCod();
                }

                $s_Serie  = str_pad( $o_GSS_SucursalDocumentoBN->getSerieFormato(), 4, "0", STR_PAD_LEFT );
                $s_Numero = str_pad( ( $o_GSS_SucursalDocumentoBN->getNumeroActual() + 1 ), 10, "0", STR_PAD_LEFT );

                //$a_lst = array( "Result" => true, "Serie" => $s_Serie, "Numero" => $s_Numero, "IdTipoDocumento" => $IdTipoDocumento, "TipoDocumentoCod" => $s_TipoCod );
            }
            else
            {
                throw new Exception( "No encontro Tipo de Documentos asociados a la Compañia." );
            }
            ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            $IdCompania         = myUser::getUser()->getIdBusiness();
            $ClienteNumero      = $o_VTA_OrdenBN->getClienteId();

            $Comentario         = "";
            //$f_TipoCambio       = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );

            $TipoDocumentoCod   = $s_TipoCod;
            $DocumentoSerie     = $s_Serie;
            $DocumentoNumero    = $s_Numero;
            $NaceAnulado        = false;

            $TipoVenta          = "MER";
            //$IdAlmacen          = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $IdVendedor         = myUser::getUser()->getUserId();

            //$s_MonedaDocumento  = $this->getRequestParameter( 'MonedaDocumento' );
            //$f_TipodeCambio     = floatval( $this->getRequestParameter( 'MonedaCambioValor' ) );
            //$f_Descuento        = floatval( $this->getRequestParameter( 'txt_descuento' ) );
            //$f_MontoSubTotal    = floatval( $this->getRequestParameter( 'txt_subtotal' ) );
            //$f_TotalImpuesto    = floatval( $this->getRequestParameter( 'txt_impuesto' ) );
            //$f_MontoTotal       = floatval( $this->getRequestParameter( 'txt_total' ) );

            $o_VTA_DocumentoBN = new VTA_DocumentoBN();
            $o_VTA_DocumentoBN->setDocumentoParentId( $o_VTA_OrdenBN->getOrdenId() );
            $o_VTA_DocumentoBN->setDocumentoParentCod( $o_VTA_OrdenBN->getOrdenNum() );
            $o_VTA_DocumentoBN->setFacturacionDirecta( true );
            //$o_VTA_DocumentoBN->setForzarMovimientoInventario( true );

            //PARAMETROS PARA LA DETRACCION
            $DetracconTipoId     = 0;
            $DetracconPorcentaje = 0;
            $DetracconMedPagoId  = 0;
            $DetracconTotal      = 0;

            //SETEO PARA DETRACCIONES
            $o_VTA_DocumentoBN->setDetraccionTipoId( intval( $DetracconTipoId ) );
            $o_VTA_DocumentoBN->setDetraccionMedPagoId( intval( $DetracconMedPagoId ) );
            $o_VTA_DocumentoBN->setDetraccionPorcentaje( floatval( $DetracconPorcentaje ) );
            $o_VTA_DocumentoBN->setDetraccionTotal( floatval( $DetracconTotal ) );

            //PARAMETROS PARA RETENCION
            $RetencionTipoId        = 0;
            $RetencionBaseImponible = 0;
            $RetencionTotal         = 0;

            //SETEO PARA RETENCION
            $o_VTA_DocumentoBN->setRetencionTipoId( intval( $RetencionTipoId ) );
            $o_VTA_DocumentoBN->setRetencionBaseImponible( floatval( $RetencionBaseImponible ) );
            $o_VTA_DocumentoBN->setRetencionTotal( floatval( $RetencionTotal ) );

            $o_VTA_DocumentoBN->setIdTipoDocumento( $IdTipoDocumento );
            //$o_VTA_DocumentoBN->setIdCompania( ( int ) $IdCompania );
            $o_VTA_DocumentoBN->setEstado( VTA_DocumentoBN::ESTADO_PREPARACION ); //por defecto
            //$o_VTA_DocumentoBN->setIdAlmacen( $IdAlmacen );
            //$o_VTA_DocumentoBN->setClienteNumero( $ClienteNumero );

            //$o_VTA_DocumentoBN->setMonedaDocumento( $s_MonedaDocumento );
            //$o_VTA_DocumentoBN->setTipodeCambio( $f_TipodeCambio );
            //$o_VTA_DocumentoBN->setMontoSubTotal( $f_MontoSubTotal );
            //$o_VTA_DocumentoBN->setMontoImpuestos( $f_TotalImpuesto );
            //$o_VTA_DocumentoBN->setMontoTotal( $f_MontoTotal );

            $FechaDocumento   = date( "Y-m-d H:i:s" );
            $FechaVencimiento = $FechaDocumento;

            $o_VTA_DocumentoBN->setFechaDocumento( $FechaDocumento );
            $o_VTA_DocumentoBN->setTipoFacturacion( "N" );
            $o_VTA_DocumentoBN->setDocumentoCod( $TipoDocumentoCod );
            $o_VTA_DocumentoBN->setDocumentoSerie( $DocumentoSerie );
            $o_VTA_DocumentoBN->setDocumentoNumero( $DocumentoNumero );
            $o_VTA_DocumentoBN->setNumeroComprobante( $DocumentoSerie."-".$DocumentoNumero );
            $o_VTA_DocumentoBN->setFechaVencimiento( $FechaVencimiento );
            $o_VTA_DocumentoBN->setTipoVenta( $TipoVenta );
            $o_VTA_DocumentoBN->setComentario( $Comentario );
            $o_VTA_DocumentoBN->setVendedor( myUser::getUser()->getUserId() );
            if( $this->getRequestParameter( 'IdVendedor' ) )
            {
                $o_VTA_DocumentoBN->setVendedor( $IdVendedor );
            }

            $o_OrdenVentaBL = new OrdenVentaBL();
            $o_OrdenVentaBL->guardarDocumentoPorOrden( $o_VTA_DocumentoBN );

            $a_Rs['id_concat'] = $o_VTA_DocumentoBN->getIdConcat();
            $a_Rs['id_comprobante'] = $o_VTA_DocumentoBN->getNumeroDocumento();

            //ahora se actualiza los ID de las cotizacion al servicio tecnico
            $o_STE_ServicioTecnicoDP = new STE_ServicioTecnicoDP();
            $o_STE_ServicioTecnicoDP->setIdServicio( $i_IdServicio );
            $o_STE_ServicioTecnicoDP->setDiagnosticoExisteCobranzaFlag( 1 );
            $o_STE_ServicioTecnicoDP->setDiagnosticoComprobanteTipo( $o_VTA_DocumentoBN->getIdTipoDocumento() );
            $o_STE_ServicioTecnicoDP->setDiagnosticoComprobanteNumero( $o_VTA_DocumentoBN->getDocumentoTipoSerieNumero() );
            $o_STE_ServicioTecnicoDP->setDiagnosticoComprobanteId( $o_VTA_DocumentoBN->getNumeroDocumento() );
            $o_STE_ServicioTecnicoDP->setDiagnosticoComprobanteFecha( $o_VTA_DocumentoBN->getFechaDocumento() );
            $o_STE_ServicioTecnicoDP->setDiagnosticoCobranzaEstado( $o_VTA_DocumentoBN->getCobranzaEstado() );
            $o_STE_ServicioTecnicoDP->setDiagnosticoMontoIncIGV( $f_MontoIGV );
            $o_STE_ServicioTecnicoDP->setUsuarioActualizacion( myUser::getUser()->getUserId() );
            $o_STE_ServicioTecnicoDP->setFechaActualizacion( date( "Y-m-d H:i:s" ) );
            $o_STE_ServicioTecnicoDP->update();

            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            //AQUI SE HACE UNA VALIDACION, DE Q LOS DETALLES DE LA ORDEN SON IGUALES A LA DEL COMPROBANTE
            $a_VTA_OrdenDetalle = $o_VTA_OrdenBN->getArrayDetalles();

            $a_VTA_DocumentoDetalle = $o_VTA_DocumentoBN->getArrayObjectDetalles();

            if( count( $a_VTA_OrdenDetalle ) != count( $a_VTA_DocumentoDetalle ) )
            {
                throw new Exception( "La cantidad de Detalles en el comprobante no es igual." );
            }

            foreach( $a_VTA_DocumentoDetalle as $o_VTA_DocumentoDetalleBN )
            {
                $b_ControlExiste = false;
                foreach( $a_VTA_OrdenDetalle as $o_VTA_OrdenDetalleBN )
                {
                    if( $o_VTA_DocumentoDetalleBN->getItemCodigo() == $o_VTA_OrdenDetalleBN->getItemCod() )
                    {
                        $b_ControlExiste = true;
                        continue;
                    }
                }
                if( !$b_ControlExiste )
                {
                    throw new Exception( "No se encontro relacion [".$o_VTA_DocumentoDetalleBN->getItemCodigo()."] entre Orden de Venta y Comprobante" );
                }
            }
            ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

            /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
            $con->commit();

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $con->rollback();
            $a_Rs['error']        = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
}
