<?php
class repActions extends wtActions
{
    public function executeListStock()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block = $this->getRequestParameter( 'block' );
        $this->IdCompania = myUser::getUser()->getIdBusiness();
        
        $this->GlobalAccess = myUser::getUser()->hasGlobalAccess();

        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( myUser::getUser()->getIdBusiness() );
        $o_ALM_AlmacenMastFN->setIdSucursal( myUser::getUser()->getIdSucursal() );
        $o_ALM_AlmacenMastFN->addCondition( ALM_AlmacenMastFN::Estado ,"<>", "I" );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        $this->a_ALM_AlmacenMastOrg = $o_ALM_AlmacenMastFN->select();

        $o_ALM_MarcaFN = new ALM_MarcaFN();
        $o_ALM_MarcaFN->setEstado( "A" );
        $o_ALM_MarcaFN->addOrderBy( ALM_MarcaFN::DescripcionLocal );
        $this->a_ALM_Marca = $o_ALM_MarcaFN->select();

        $o_MST_PersonaMastFN = new MST_PersonaMastFN();
        $o_MST_PersonaMastFN->setEsProveedor( "SI" );
        $o_MST_PersonaMastFN->setEstado( "A" );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::NombreCompleto );
        $o_MST_PersonaMastFN->addOrderBy( MST_PersonaMastFN::Nombres );
        $this->a_MST_PersonaMast = $o_MST_PersonaMastFN->select();

        $o_MST_ReferenciaProductoFN = new MST_ReferenciaProductoFN();
        $o_MST_ReferenciaProductoFN->setEstado( MST_ReferenciaProductoFN::ESTADO_COMPLETO );
        //$o_MST_ReferenciaProductoFN->setIdProveedor( $this->IdProveedor );
        $this->a_MST_ReferenciaProducto = $o_MST_ReferenciaProductoFN->select();

        $o_MST_ColorFN = new MST_ColorFN();
        $o_MST_ColorFN->setEstado( MST_ColorBN::ESTADO_ACTIVO );
        $o_MST_ColorFN->addOrderBy( "substr(Codigo,1,1)" );
        $o_MST_ColorFN->addOrderBy( "cast(substr(Codigo,2,10) as UNSIGNED)" );
        $this->a_MST_Color = $o_MST_ColorFN->select();

        $o_MST_CategoriaTallaFN = new MST_CategoriaTallaFN();
        //$o_MST_CategoriaTallaFN->setIdProveedor( $this->IdProveedor );
        $o_MST_CategoriaTallaFN->setEstado( MST_CategoriaTallaBN::ESTADO_ACTIVO );
        $this->a_MST_CategoriaTalla = $o_MST_CategoriaTallaFN->select();
    }
    
    public function buildFndListStock( $b_Control = true )
    {
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_ItemAlmacenStockFN() );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdSucursal" );
        $o_GridAction->addAssignFilter( "IdItem" );
        $o_GridAction->addAssignFilter( "IdAlmacen" );

        $o_GridAction->addAssignFilter( "IdProveedor" );
        $o_GridAction->addAssignFilter( "IdReferencia" );
        $o_GridAction->addAssignFilter( "IdColor" );
        $o_GridAction->addAssignFilter( "IdCatTalla" );
        $o_GridAction->addAssignFilter( "IdTalla" );
        
        if( !is_null( $this->getRequestParameter( 'OpcionesRadio' ) ) )
        {
            switch ( $this->getRequestParameter( 'OpcionesRadio' ) )
            {
                case "F":
                    $o_GridAction->addMethodDefault( ALM_ItemAlmacenStockFN::StockFisico, array( 'Condition'=>'>', 'Value'=>"0" ) );
                    break;
            }
        }

        $o_GridAction->addConditionFilter( "DescripcionCompleta", "( SELECT DescripcionCompleta FROM ALM_ItemMast WHERE IdItem=ALM_ItemAlmacenStock.IdItem )", "LIKE", "%%s%" );
        $o_GridAction->addConditionFilter( "CodigoBarras", "( SELECT CodigoBarras FROM ALM_ItemMast WHERE IdItem=ALM_ItemAlmacenStock.IdItem )", "LIKE", "%%s%" );
        
        //BUSCAR POR ITEM ACTIVO
        ParameterWR::getInstance()->setVar( "ItemEstado", 'A' );
        $o_GridAction->addConditionFilter( "ItemEstado", "ALM_ItemMast.Estado",  "=" );
        //$o_GridAction->addConditionFilter( "NumeroInterno", COM_OrdenCompraCabeceraFN::NumeroInterno, "LIKE", "%%s%" );
        
        $o_GridAction->addConditionFilter( "IdItemTipo", "( SELECT IdItemTipo FROM ALM_ItemMast WHERE IdItem=ALM_ItemAlmacenStock.IdItem )",  "=" );
        
        $o_GridAction->addConditionFilter( "IdLinea", "( SELECT IdLinea FROM ALM_ItemMast WHERE IdItem=ALM_ItemAlmacenStock.IdItem )",  "=" );
        $o_GridAction->addConditionFilter( "IdFamilia", "( SELECT IdFamilia FROM ALM_ItemMast WHERE IdItem=ALM_ItemAlmacenStock.IdItem )",  "=" );
        $o_GridAction->addConditionFilter( "IdSubFamilia", "( SELECT IdSubFamilia FROM ALM_ItemMast WHERE IdItem=ALM_ItemAlmacenStock.IdItem )",  "=" );
        $o_GridAction->addConditionFilter( "IdMarca", "( SELECT IdMarca FROM ALM_ItemMast WHERE IdItem=ALM_ItemAlmacenStock.IdItem )",  "=" );
        
        //buscar po fecha de vencimiento
        $o_GridAction->addConditionFilter( "FechaVencimiento1", "FechaVencimiento",  ">=" );
        $o_GridAction->addConditionFilter( "FechaVencimiento2", "FechaVencimiento",  "<=" );
        
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        //cambios por los hoteles 2019-12-04
        //condicion especial para no mostrar los hoteles
        //solo se muestran todos los registros que se pueden registrar en transacciones
        //es parametro es para cuando se usa -> selectdos
        //$o_GridAction->addMethodDefault( "( SELECT TransacciondelSistemaFlag FROM ALM_ItemMast LEFT JOIN ALM_ItemTipo ON ALM_ItemMast.IdItemTipo=ALM_ItemTipo.IdItemTipo WHERE IdItem=ALM_ItemAlmacenStock.IdItem )", array( 'Condition'=>'=', 'Value'=>"1" ) );
        //$o_GridAction->addMethodDefault( "TransacciondelSistemaFlag", array( 'Condition'=>'=', 'Value'=>"1" ) );
        ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        //$o_GridAction->addOrderDefault( "MST_ClaseLinea.Descripcion, ALM_ItemMast.DescripcionCompleta", true );
        $o_GridAction->addOrderDefault( "ALM_ItemMast.DescripcionCompleta", true );
        //$o_GridAction->addMethodDefault( "COALESCE( ( SELECT Estado FROM ALM_Lote WHERE LoteNumero=ALM_ItemAlmacenStock.IdLote AND IdItem=ALM_ItemAlmacenStock.IdItem ), 'A' )", array( 'Condition'=>'=', 'Value'=>"'A'" ) );

        $this->IncluirLote = false;
        if( is_null( $this->getRequestParameter( 'IncluirLote' ) ) )
        {
            ALM_ItemAlmacenStockFN::setGroupByAlmacen( 1 );
        }
        else
        {
            $this->IncluirLote = true;
            $o_GridAction->addOrderDefault( ALM_ItemAlmacenStockFN::FechaVencimiento, true );
        }
        
        /*
         $o_GridAction->addRowsToShow
         (
         "IdAlmacen", "IdLote", "FechaVencimiento", "IdItem", "DescripcionItem", "StockActual",
         "FechaCreacion", "UsuarioCreacion", "UltimoCostoItem", "FechaModificacion", "UsuarioModificacion",
         "AlmacenDesc"
         );
         */
        if( $b_Control )
        {
            $o_GridAction->setNumberRecordsShow( 100 );
        }
        else
        {
            $o_GridAction->setNumberRecordsShow( 99999 );
        }
        
        //para recuperar en array
        $o_GridAction->setControlArray( false );

        $o_GridAction->setMethodSelectCustomRs( "selectdos" ); //FUNCION PERSONALIZADO PARA BUSQUEDA
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        return $o_GridAction;
    }
    
    public function executeGrid()
    {
        $s_PrmIdAlmacen = $this->getRequestParameter( "IdAlmacen" );

        $o_GridAction   = $this->buildFndListStock();
        
        $a_ResultSelect = $o_GridAction->getResultSelect();

        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        //$a_ResultJson['rows']    = $o_GridAction->getResultArray();
        
        $a_Rs = array();

        $s_IdFechaFin = $this->getRequestParameter( 'FechaDocumento2' ) ? $this->getRequestParameter( 'FechaDocumento2' )." 23:59:59" : "";

        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            $s_IdItem     = $o_ObjClassBN->getIdItem();
            $i_IdCompania = $o_ObjClassBN->getIdCompania();
            $s_IdAlmacen  = $o_ObjClassBN->getIdAlmacen();

            $i_SaldoInicia = 0;
            if( $this->getRequestParameter( 'FechaDocumento2' ) )
            {
                $a_LstTransKardex = ALM_KardexFN::recuperarTransxRango( $i_IdCompania, $s_IdAlmacen, "", $s_IdItem, "", $s_IdFechaFin );
                foreach ( $a_LstTransKardex as $o_ALM_KardexBN_Trx )
                {
                    $i_Cantidad_Trx  = floatval( $o_ALM_KardexBN_Trx->getCantidad() );
                    if( $o_ALM_KardexBN_Trx->getTipoOperacion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                    {
                        $i_SaldoInicia = $i_SaldoInicia + $i_Cantidad_Trx;
                    }
                    else
                    {
                        $i_SaldoInicia = $i_SaldoInicia - $i_Cantidad_Trx;
                    }
                }
            }
            else
            {
                $i_SaldoInicia = is_null( $o_ObjClassBN->getStockFisico() ) ? 0 : $o_ObjClassBN->getStockFisico();
            }

            if( $s_PrmIdAlmacen )
            {
                $a_DataRepoStock = MST_StockReposicionDetalleFN::getDataStocksPorAlmacen( $s_IdItem, $s_PrmIdAlmacen );
            }
            else
            {
                $a_DataRepoStock = MST_StockReposicionDetalleFN::getDataStocksMin( $s_IdItem );
            }
            $i_StockMinimo = intval( $a_DataRepoStock['StockMinimo'] );
            $i_StockMaximo = intval( $a_DataRepoStock['StockMaximo'] );

            $a_Rs[] = array
            (  
                "SucursalDesc"        => $o_ObjClassBN->getSucursalDesc(),
                "AlmacenDesc"         => $o_ObjClassBN->getAlmacenDesc(),
                "IdLote"              => $o_ObjClassBN->getIdLote(),
                "FechaVencimiento"    => $o_ObjClassBN->getFechaVencimiento(),
                "IdAlmacen"           => $o_ObjClassBN->getIdAlmacen(),
                "IdItem"              => $o_ObjClassBN->getIdItem(),
                //"UnidadDesc"                => $o_ObjClassBN->getObjectItem()->getObjectUnidadVenta()->getDescripcionCorta(),
                "UnidadDesc"          => $o_ObjClassBN->getUnidadVentaDesc(),
                "DescripcionItem"     => $o_ObjClassBN->getDescripcionItem(),
                "StockActual"         => $i_SaldoInicia,
                "UsuarioCreacion"     => $o_ObjClassBN->getUsuarioCreacion(),
                "UsuarioModificacion" => $o_ObjClassBN->getUsuarioModificacion(),
                "LineaDescripcion"    => $o_ObjClassBN->getLineaDescripcion(),
                "FamiliaDescripcion"  => $o_ObjClassBN->getFamiliaDescripcion(),
                "SerieFlag"           => $o_ObjClassBN->getSerieFlag(),
                "StockMinimo"         => $i_StockMinimo,
                "StockMaximo"         => $i_StockMaximo,
            );
        }

        $a_ResultJson['rows'] = $a_Rs;
        echo json_encode( $a_ResultJson );
        return ViewResponse::NONE;
    }
    
    public function executePrintStock()
    {
        $this->Excel    = $this->getRequestParameter( 'excel' );
        $s_PrmIdAlmacen = $this->getRequestParameter( "IdAlmacen" );
        
        if( $this->Excel )
        {
            header( 'Content-Type: application/vnd.ms-excel' );
            header( 'Content-Disposition: attachment;filename="reporte_stock_'.date( "Ymd" ).'.xls"' );
            header( 'Cache-Control: max-age=0' );
        }
        
        $o_GridAction = $this->buildFndListStock( false );
        
        $a_ResultSelect = $o_GridAction->getResultSelect();
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        
        $a_Rs = array();
        
        $s_IdFechaFin = $this->getRequestParameter( 'FechaDocumento2' ) ? $this->getRequestParameter( 'FechaDocumento2' )." 23:59:59" : "";
        
        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            $s_IdItem     = $o_ObjClassBN->getIdItem();
            $i_IdCompania = $o_ObjClassBN->getIdCompania();
            $s_IdAlmacen  = $o_ObjClassBN->getIdAlmacen();
            
            $i_SaldoInicia = 0;
            if( $this->getRequestParameter( 'FechaDocumento2' ) )
            {
                $a_LstTransKardex = ALM_KardexFN::recuperarTransxRango( $i_IdCompania, $s_IdAlmacen, "", $s_IdItem, "", $s_IdFechaFin );
                foreach ( $a_LstTransKardex as $o_ALM_KardexBN_Trx )
                {
                    $i_Cantidad_Trx  = floatval( $o_ALM_KardexBN_Trx->getCantidad() );
                    if( $o_ALM_KardexBN_Trx->getTipoOperacion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                    {
                        $i_SaldoInicia = $i_SaldoInicia + $i_Cantidad_Trx;
                    }
                    else
                    {
                        $i_SaldoInicia = $i_SaldoInicia - $i_Cantidad_Trx;
                    }
                }
            }
            else
            {
                $i_SaldoInicia = $o_ObjClassBN->getStockFisico();
            }

            if( $s_PrmIdAlmacen )
            {
                $a_DataRepoStock = MST_StockReposicionDetalleFN::getDataStocksPorAlmacen( $s_IdItem, $s_PrmIdAlmacen );
            }
            else
            {
                $a_DataRepoStock = MST_StockReposicionDetalleFN::getDataStocksMin( $s_IdItem );
            }
            $i_StockMinimo = intval( $a_DataRepoStock['StockMinimo'] );
            $i_StockMaximo = intval( $a_DataRepoStock['StockMaximo'] );
            
            $a_Rs[] = array
            (
                    "SucursalDesc"          => $o_ObjClassBN->getSucursalDesc(),
                    "AlmacenDesc"           => $o_ObjClassBN->getAlmacenDesc(),
                    "IdLote"                => $o_ObjClassBN->getIdLote(),
                    "FechaVencimiento"      => $o_ObjClassBN->getFechaVencimiento(),
                    "IdAlmacen"             => $o_ObjClassBN->getIdAlmacen(),
                    "IdItem"                => $o_ObjClassBN->getIdItem(),
                    "DescripcionItem"       => $o_ObjClassBN->getDescripcionItem(),
                    "LineaDesc"             => $o_ObjClassBN->getLineaDescripcion(),
                    "StockActual"           => $i_SaldoInicia,
                    "UsuarioCreacion"       => $o_ObjClassBN->getUsuarioCreacion(),
                    "UsuarioModificacion"   => $o_ObjClassBN->getUsuarioModificacion(),
                    "MarcaDesc"             => $o_ObjClassBN->getMarcaDesc(),
                    "PartNumber"            => $o_ObjClassBN->getPartNumber(),
                    "StockMinimo"           => $i_StockMinimo,
                    "StockMaximo"           => $i_StockMaximo
            );
        }
        //pr( $a_Rs ); exit;
        
        $this->a_Rs = $a_Rs;
        
        $this->s_DescripcionAlmacen = "";
        if( $this->getRequestParameter( 'IdAlmacen' ) )
        {
            $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
            $o_ALM_AlmacenMastBN = $o_ALM_AlmacenMastFN->selectByPK( $this->getRequestParameter( 'IdAlmacen' ) );
            
            if( $o_ALM_AlmacenMastBN )
            {
                $this->s_DescripcionAlmacen = $o_ALM_AlmacenMastBN->getDescripcionLocal();
            }
        }

        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeListMov()
    {
        $this->s_IdItem = $this->getRequestParameter( 'IdIem' );
        
        $this->IdCompania = myUser::getUser()->getIdBusiness();
        
        $this->GlobalAccess = myUser::getUser()->hasGlobalAccess();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( $this->IdCompania );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        
        $this->opt_seleccione = $this->GlobalAccess;
        if( !$this->GlobalAccess )
        {
            $s_IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $o_ALM_AlmacenMastFN->setIdAlmacen( $s_IdAlmacen );
        }
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $this->FechaInicio = date( "Y-m" )."-01";
        $this->FechaFin = UtilDate::getFechaFinMes( date( "Y"), date( "m" ) );
    }
    
    public function executeGridMov()
    {
        set_header_utf8();
        
        $s_FechaInicio = $this->getRequestParameter( 'FechaDocumento1' );
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_KardexFN() );
        
        $o_GridAction->addMethodDefault( "IdCompania", myUser::getUser()->getIdBusiness() );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdItem" );
        $o_GridAction->addAssignFilter( "IdAlmacen" );
        
        $o_GridAction->addConditionFilter( "FechaDocumento1", ALM_KardexFN::IdFecha,    ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", "LEFT(".ALM_KardexFN::IdFecha.",10)",    "<=" );
        
        //$o_GridAction->addOrderDefault( ALM_KardexFN::IdCompania, true );
        //$o_GridAction->addOrderDefault( ALM_KardexFN::IdAlmacen, true );
        $o_GridAction->addOrderDefault( ALM_KardexFN::IdLote, true );
        $o_GridAction->addOrderDefault( ALM_KardexFN::IdFecha, true );
        $o_GridAction->addOrderDefault( ALM_KardexFN::IdItem, true );
        
        
        /*
        $o_GridAction->addRowsToShow
        (
            "IdAlmacen", "IdLote", "IdItem", "UnidadDescripcion", "DescripcionItem", "PrecioUnitario", 
            "StockIngreso", "StockSalida", "FechaTransaccion", "UsuarioCreacion", "IdTransaccion", 
            "ReferenciaNumeroDocumento", "Cantidad", "DocumentoRefFiscal", "ReferenciaTipoDocumento",
            "DescripcionItem", "PerProvClieDescripcion", "Cantidad"
        );
        */
        $o_GridAction->setControlArray( false );
        $o_GridAction->setNumberRecordsShow( 9999 );
        
        $o_GridAction->initialize();
        
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();

        //echo json_encode( $a_ResultJson );
        
        $a_ResultSelect    = $o_GridAction->getResultSelect();
        $a_Rs = array();
        
        $a_Acumulado = array();
        $i_Acumulado = 0;
        $i_SaldoInicia = 0;
        $a_SaldoInicialItem = array();
        
        foreach ( $a_ResultSelect as $iKey => $o_ObjClassBN )
        {
            $i_IdCompania = $o_ObjClassBN->getIdCompania();
            
            $s_IdItem    = $o_ObjClassBN->getIdItem();
            $s_IdAlmacen = $o_ObjClassBN->getIdAlmacen();
            $s_IdLote    = $o_ObjClassBN->getIdLote();
            $s_IdFecha   = $o_ObjClassBN->getIdFecha();
            $i_Cantidad  = $o_ObjClassBN->getCantidad();
            
            $s_AlmacenDesc = $o_ObjClassBN->getDescripcionAlmacen();
            
            $s_Periodo = substr( str_replace( "-", "", $s_IdFecha ), 0, 6 );
            
            $s_PeriodoAnt = substr( $s_Periodo, 0, 4 ).str_pad( ( intval( substr( $s_Periodo, -2 ) ) - 1 ), 2, "0", STR_PAD_LEFT );
            //$s_PeriodoSig = substr( $s_Periodo, 0, 4 ).str_pad( ( intval( substr( $s_Periodo, -2 ) ) + 1 ), 2, "0", STR_PAD_LEFT );
            
            $s_PeriodoAntShow = substr( $s_PeriodoAnt, 0, 4 )."-".substr( $s_PeriodoAnt, -2 );
            $s_PeriodoShow    = substr( $s_Periodo, 0, 4 )."-".substr( $s_Periodo, -2 );
            
            $s_Key = $s_IdItem."_".$s_IdLote."_".$s_PeriodoAnt;
            
            if( !isset( $a_SaldoInicialItem[$s_Key] ) )
            {
                $a_SaldoInicialItem[$s_Key] = ALM_KardexFN::buscarStockSaldo( $s_IdAlmacen, $s_IdLote, $s_IdItem, $s_PeriodoAnt );
                $i_SaldoInicia = $a_SaldoInicialItem[$s_Key];
                
                //AHORA SE RECUPERA LOS TRANSACCIONES ANTERIORES PARA RESTARLO
                $s_IdFechaIni = $s_PeriodoShow."-01";
                $s_IdFechaFin = $s_FechaInicio;
                $a_LstTransKardex = ALM_KardexFN::recuperarTransxRango( $i_IdCompania, $s_IdAlmacen, $s_IdLote, $s_IdItem, $s_IdFechaIni, $s_IdFechaFin );
                foreach ( $a_LstTransKardex as $o_ALM_KardexBN_Trx )
                {
                    $i_Cantidad_Trx  = floatval( $o_ALM_KardexBN_Trx->getCantidad() );
                    if( $o_ALM_KardexBN_Trx->getTipoOperacion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
                    {
                        $i_SaldoInicia = $i_SaldoInicia + $i_Cantidad_Trx;
                    }
                    else
                    {
                        $i_SaldoInicia = $i_SaldoInicia - $i_Cantidad_Trx;
                    }
                }
                //$b_CtrlSaldoInicial = true;
                $i_Acumulado = $i_SaldoInicia;
                
                $a_Acumulado[$s_IdAlmacen] = $i_Acumulado;
                
                $a_Rs[] = array(  
                                    "DescripcionAlmacen"        => "", 
                                    "IdLote"                    => "<b>".$s_IdLote."</b>", 
                                    "IdItem"                    => "", 
                                    "DescripcionItem"           => "", 
                                    "PrecioUnitario"            => "", 
                                    "StockIngreso"              => "", 
                                    "StockSalida"               => "", 
                                    "StockActual"               => "<b>".$i_SaldoInicia."</b>", 
                                    "FechaTransaccion"          => "<b>".$s_PeriodoAntShow."</b>", 
                                    "UsuarioCreacion"           => "", 
                                    "IdTransaccion"             => "", 
                                    "DocumentoRefFiscal"        => "", 
                                    "ReferenciaTipoDocumento"   => "",
                                    "PerProvClieDescripcion"    => "<b>Saldo Inicial - $s_IdItem</b>",
                                    "IdConcatTrx"               => ""
                               );
            }
            
            if( !isset( $a_Acumulado[$s_IdAlmacen] ) )
            {
                $a_Acumulado[$s_IdAlmacen] = ALM_KardexFN::buscarStockSaldo( $s_IdAlmacen, $s_IdLote, $s_IdItem, $s_PeriodoAnt );
            }
            if( $o_ObjClassBN->getTipoOperacion() == ALM_TransaccionCabeceraBN::TIPO_INGRESO )
            {
                $i_Acumulado = $i_Acumulado + $i_Cantidad;
                $a_Acumulado[$s_IdAlmacen] = $a_Acumulado[$s_IdAlmacen] + $i_Cantidad;
            }
            else
            {
                $i_Acumulado = $i_Acumulado - $i_Cantidad;
                $a_Acumulado[$s_IdAlmacen] = $a_Acumulado[$s_IdAlmacen] - $i_Cantidad;
            }
            
            /////////////////////////////////////////////////////////////////////////////////
            //CAMPOS CON PERSONALIZACION
            $s_DescripcionCliente = $o_ObjClassBN->getPerProvClieDescripcion();
            /////////////////////////////////////////////////////////////////////////////////
            
            $s_DescTransaccion = $o_ObjClassBN->getIdTransaccionDesc();
            
            if( $o_ObjClassBN->getIdTransaccion() == ALM_KardexBN::INGRESO_POR_BONIFICACION )
            {
                $o_ALM_TransaccionCabeceraBN = $o_ObjClassBN->getObjectTransaccionCabecera();
                $s_DescripcionCliente = $o_ALM_TransaccionCabeceraBN->getComentario(); //PRIMERO ESO, POR QUE LA SIGUIENTE LINEA SETEA OTRO VALOR
                
                $s_DescTrans = $o_ObjClassBN->getIdTransaccionDesc();
                $o_ObjClassBN->setReferenciaTipoDocumento( $o_ObjClassBN->getReferenciaTipoDocumento()." - ".$s_DescTrans );
            }
            
            $a_Rs[] = array(  
                                "DescripcionAlmacen"        => $s_AlmacenDesc, 
                                "IdLote"                    => $s_IdLote, 
                                "IdItem"                    => $s_IdItem, 
                                "DescripcionItem"           => $o_ObjClassBN->getDescripcionItem(), 
                                "PrecioUnitario"            => number_format( $o_ObjClassBN->getPrecioUnitario(), 2 ), 
                                "StockIngreso"              => $o_ObjClassBN->getStockIngreso(), 
                                "StockSalida"               => $o_ObjClassBN->getStockSalida(), 
                                "StockActual"               => $a_Acumulado[$s_IdAlmacen], //$i_Acumulado, 
                                "FechaTransaccion"          => $o_ObjClassBN->getFechaTransaccion(), 
                                "UsuarioCreacion"           => $o_ObjClassBN->getUsuarioCreacion(), 
                                "IdTransaccion"             => $o_ObjClassBN->getIdTransaccion(), 
                                "DocumentoRefFiscal"        => $o_ObjClassBN->getDocumentoRefFiscal(), 
                                "ReferenciaTipoDocumento"   => $o_ObjClassBN->getReferenciaTipoDocumento(),
                                "TransaccionDesc"           => $o_ObjClassBN->getReferenciaTipoDocumento()."-".$o_ObjClassBN->getIdTransaccionDesc(),
                                "PerProvClieDescripcion"    => $s_DescripcionCliente, 
                                "IdConcatTrx"               => $o_ObjClassBN->getIdCompania()."_".$o_ObjClassBN->getReferenciaTipoDocumento()."_".$o_ObjClassBN->getReferenciaNumeroDocumento()
                           );
        }
        
        $a_ResultJson['rows'] = $a_Rs;
        
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }
    
    public function executeListKardex()
    {
        $this->IdCompania = myUser::getUser()->getIdBusiness();
        
        $this->GlobalAccess = myUser::getUser()->hasGlobalAccess();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( $this->IdCompania );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        
        $this->opt_seleccione = $this->GlobalAccess;
        if( !$this->GlobalAccess )
        {
            $s_IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $o_ALM_AlmacenMastFN->setIdAlmacen( $s_IdAlmacen );
        }
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $this->FechaInicio = date( "Y-m" )."-01";
        $this->FechaFin = UtilDate::getFechaFinMes( date( "Y"), date( "m" ) );
    }
    
    public function executeGridKardex()
    {
        set_header_utf8();
        
        $this->b_NoExpExcel = true;
        $export_excel = $this->getRequestParameter( 'export_excel' );
        if( $export_excel )
        {
            header( 'Content-Type: application/vnd.ms-excel' );
            header( 'Content-Disposition: attachment;filename="kardex_'.date( "Ymd" ).'.xls"' );
            header( 'Cache-Control: max-age=0' );
            $this->b_NoExpExcel = false;
        }
        $this->s_FechaInicio = $this->getRequestParameter( 'FechaDocumento1' );
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new ALM_KardexFN() );
        
        $o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "IdItem" );
        $o_GridAction->addAssignFilter( "IdAlmacen" );
        
        $o_GridAction->addConditionFilter( "FechaDocumento1", ALM_KardexFN::IdFecha,    ">=" );
        $o_GridAction->addConditionFilter( "FechaDocumento2", "LEFT(".ALM_KardexFN::IdFecha.",10)",    "<=" );
        
        $o_GridAction->addOrderDefault( ALM_KardexFN::IdCompania, true );
        $o_GridAction->addOrderDefault( ALM_KardexFN::IdAlmacen, true );
        $o_GridAction->addOrderDefault( ALM_KardexFN::IdLote, true );
        $o_GridAction->addOrderDefault( ALM_KardexFN::IdItem, true );
        $o_GridAction->addOrderDefault( ALM_KardexFN::FechCreacion , true );
        
        $o_GridAction->addRowsToShow
        (
            "IdAlmacen", "IdLote", "IdItem", "UnidadDescripcion", "DescripcionItem", "PrecioUnitario", 
            "StockIngreso", "StockSalida", "FechaTransaccion", "UsuarioCreacion", "IdTransaccion", 
            "ReferenciaNumeroDocumento", "Cantidad", "DocumentoRefFiscal", "ReferenciaTipoDocumento",
            "DescripcionItem", "PerProvClieDescripcion", "Cantidad"
        );
        
        $o_GridAction->setControlArray( false );
        $o_GridAction->setNumberRecordsShow( 9999 );
        
        $o_GridAction->initialize();
        $this->a_ALM_Kardex = $o_GridAction->getResultSelect();

        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeShowTrans()
    {
        $i_IdCompania = myUser::getUser()->getIdBusiness();
        $s_IdItem            = $this->getRequestParameter( 'IdItem' );
        $s_IdTipoDocumento   = $this->getRequestParameter( 'Tipo' );
        $s_IdNumeroDocumento = $this->getRequestParameter( 'Numero' );
        
        $o_ALM_TransaccionCabeceraFN = new ALM_TransaccionCabeceraFN();
        $this->o_ALM_TransaccionCabeceraBN = $o_ALM_TransaccionCabeceraFN->selectByPK( $i_IdCompania, $s_IdTipoDocumento, $s_IdNumeroDocumento );
        
        $o_ALM_TransaccionDetalleFN = new ALM_TransaccionDetalleFN();
        $o_ALM_TransaccionDetalleFN->setIdCompania( $i_IdCompania );
        $o_ALM_TransaccionDetalleFN->setIdTipoDocumento( $s_IdTipoDocumento );
        $o_ALM_TransaccionDetalleFN->setIdNumeroDocumento( $s_IdNumeroDocumento );
        $o_ALM_TransaccionDetalleFN->setIdItem( $s_IdItem );
        $this->a_ALM_TransaccionDetalle = $o_ALM_TransaccionDetalleFN->select();
        
        ViewResponse::getInstance()->setMethodAjax();
    }
    	
    public function executeListVentas()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->IdCompania = myUser::getUser()->getIdBusiness();
        
        $this->GlobalAccess = myUser::getUser()->hasGlobalAccess();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        //$o_ALM_AlmacenMastFN->setIdCompania( $this->IdCompania );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::IdAlmacen );
        
        $this->opt_seleccione = $this->GlobalAccess;
        if( !$this->GlobalAccess )
        {
            $s_IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $o_ALM_AlmacenMastFN->setIdAlmacen( $s_IdAlmacen );
        }
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $this->FechaInicio = date( "Y-m" )."-01";
        $this->FechaFin = UtilDate::getFechaFinMes( date( "Y"), date( "m" ) );
        
        $o_VTA_VendedorFN = new VTA_VendedorFN();
        $o_VTA_VendedorFN->addOrderBy( VTA_VendedorFN::FechaCreacion );
        $this->a_VTA_Vendedor = $o_VTA_VendedorFN->select();

        $o_VTA_TipoDocumentoFN = new VTA_TipoDocumentoFN();
        $o_VTA_TipoDocumentoFN->setEstado( "A" );
        $o_VTA_TipoDocumentoFN->addCondition( VTA_TipoDocumentoFN::CodigoFiscal, "<>", "" );
        $this->a_VTA_TipoDocumento = $o_VTA_TipoDocumentoFN->select();
        
        $this->s_Titulo = "Registro de Ventas";
    }
    
    public function executeGridVentas()
    {
        set_header_utf8();
        
        $this->b_NoExpExcel = true;
        $export_excel = $this->getRequestParameter( 'export_excel' );
        if( $export_excel )
        {
            header( 'Content-Type: application/vnd.ms-excel' );
            header( 'Content-Disposition: attachment;filename="Reg_Ventas_'.date( "Ymd" ).'.xls"' );
            header( 'Cache-Control: max-age=0' );
            $this->b_NoExpExcel = false;
        }
        
        //$this->s_FechaInicio = $this->getRequestParameter( 'FechaDocumento1' );
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        
        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdCompania() );
        
        $o_VTA_DocumentoFN = new VTA_DocumentoFN();
        $o_VTA_DocumentoFN->setIdCompania( $this->getRequestParameter( 'IdCompania' ) );
        $o_VTA_DocumentoFN->setIdAlmacen( $this->getRequestParameter( 'IdAlmacen' ) );
        $o_VTA_DocumentoFN->setIdTipoDocumento( $this->getRequestParameter( 'IdTipoDocumento' ) );

        $this->s_Ejercicio = $this->getRequestParameter( 'FechaDocumento1' );
        $this->s_Periodo   = $this->getRequestParameter( 'FechaDocumento2' );

        $o_VTA_DocumentoFN->setPeriodo( $this->s_Ejercicio.$this->s_Periodo );

        /*
        $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::FechaDocumento, ">=", $this->getRequestParameter( 'FechaDocumento1' ) );
        if( $this->getRequestParameter( 'FechaDocumento2' ) )
        {
            $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::FechaDocumento, "<=", $this->getRequestParameter( 'FechaDocumento2' ) );
        }
        */
        $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::IdTipoDocumento, "IN", "('FC','BV','NC')", false );
        $o_VTA_DocumentoFN->addCondition( VTA_DocumentoFN::Estado, "IN", "('CE','AN')", false );
        $o_VTA_DocumentoFN->addOrderBy( VTA_DocumentoFN::DocumentoCod );
        $o_VTA_DocumentoFN->addOrderBy( VTA_DocumentoFN::DocumentoNumero );
        $this->a_VTA_Documento = $o_VTA_DocumentoFN->select();

        ViewResponse::getInstance()->setMethodAjax();
    }
    
    public function executeListCompras()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->IdCompania = myUser::getUser()->getIdBusiness();
        
        $this->GlobalAccess = myUser::getUser()->hasGlobalAccess();
        
        $o_ALM_AlmacenMastFN = new ALM_AlmacenMastFN();
        $o_ALM_AlmacenMastFN->setIdCompania( $this->IdCompania );
        $o_ALM_AlmacenMastFN->addOrderBy( ALM_AlmacenMastFN::DescripcionLocal );
        
        $this->opt_seleccione = $this->GlobalAccess;
        if( !$this->GlobalAccess )
        {
            $s_IdAlmacen = GSS_SucursalFN::recuperarIdAlmacen( myUser::getUser()->getIdSucursal() );
            $o_ALM_AlmacenMastFN->setIdAlmacen( $s_IdAlmacen );
        }
        $this->a_ALM_AlmacenMast = $o_ALM_AlmacenMastFN->select();
        
        $this->FechaInicio = date( "Y-m" )."-01";
        $this->FechaFin = UtilDate::getFechaFinMes( date( "Y"), date( "m" ) );
        
        $this->s_Titulo = "Registro de Compras";
    }
    
    public function executeGridCompras()
    {
        set_header_utf8();

        $this->b_NoExpExcel = true;
        $export_excel = $this->getRequestParameter( 'export_excel' );
        if( $export_excel )
        {
            header( 'Content-Type: application/vnd.ms-excel' );
            header( 'Content-Disposition: attachment;filename="Reg_Compras_'.date( "Ymd" ).'.xls"' );
            header( 'Cache-Control: max-age=0' );
            $this->b_NoExpExcel = false;
        }
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $this->o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdCompania() );

        $this->s_Ejercicio = $this->getRequestParameter( 'FechaDocumento1' );
        $this->s_Periodo   = $this->getRequestParameter( 'FechaDocumento2' );

        $o_CP_ObligacionesFN = new CP_ObligacionesFN();
        $o_CP_ObligacionesFN->setPeriodo( $this->s_Ejercicio.$this->s_Periodo );
        $o_CP_ObligacionesFN->setEstado( CP_ObligacionesBN::ESTADO_VALIDADO );
        $o_CP_ObligacionesFN->addOrderBy( CP_ObligacionesFN::FechaEmision );
        $this->a_CP_Obligaciones = $o_CP_ObligacionesFN->select();

        ViewResponse::getInstance()->setMethodAjax();
    }
}