<?php
class EditAdicionalPrdAction extends wtActions
{
    public function execute()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->s_IdOrdenCab = $this->getRequestParameter( 'IdOrdenCab' );
        $this->s_Tipo       = $this->getRequestParameter( 'Tipo' );
        
        $this->b_Control = false;
        
        if( $this->getRequestParameter( 'Control' ) )
        {
            $f_Cantidad       = floatval( $this->getRequestParameter( 'Cantidad' ) );
            $f_PrecioUnitario = floatval( $this->getRequestParameter( 'PrecioUnitario' ) );
            $f_PrecioTotal    = floatval( $this->getRequestParameter( 'PrecioTotal' ) );
            
            $i_IdOrdenDet = PRD_OrdenDetDP::recuperarId();
            
            $o_PRD_OrdenDetDP = new PRD_OrdenDetDP();
            $o_PRD_OrdenDetDP->setIdOrdenCab( ( int ) $this->s_IdOrdenCab );
            $o_PRD_OrdenDetDP->setIdOrdenDet( $i_IdOrdenDet );
            //$o_PRD_OrdenDetDP->setIdItem(  );
            $o_PRD_OrdenDetDP->setIdUnidad( 58 );
            $o_PRD_OrdenDetDP->setCantidadPedida( $f_Cantidad );
            $o_PRD_OrdenDetDP->setCantidadRecibida( $f_Cantidad );
            $o_PRD_OrdenDetDP->setPrecioCostoUnit( $f_PrecioUnitario );
            $o_PRD_OrdenDetDP->setPrecioCostoTotal( round( $f_Cantidad * $f_PrecioUnitario, 2 ) );
            $o_PRD_OrdenDetDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
            $o_PRD_OrdenDetDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
            $o_PRD_OrdenDetDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
            $o_PRD_OrdenDetDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
            
            if( $this->s_Tipo == "MANO_OBRA" )
            {
                $i_IdManoObra = intval( $this->getRequestParameter( 'IdManoObra' ) );
                
                $o_PRD_ManoObraFN = new PRD_ManoObraFN();
                $o_PRD_ManoObraBN = $o_PRD_ManoObraFN->selectByPK( $i_IdManoObra );
                
                $o_PRD_OrdenDetDP->setItemTipo( "PM" );
                $o_PRD_OrdenDetDP->setDescripcionItem( $o_PRD_ManoObraBN->getDescripcion() );
            }
            if( $this->s_Tipo == "EQUIPO_HERRA" )
            {
                $i_IdEquiHerr = intval( $this->getRequestParameter( 'IdEquiHerr' ) );
                
                $o_PRD_EquipoHerramientaFN = new PRD_EquipoHerramientaFN();
                $o_PRD_EquipoHerramientaBN = $o_PRD_EquipoHerramientaFN->selectByPK( $i_IdEquiHerr );
                
                $o_PRD_OrdenDetDP->setItemTipo( "PE" );
                $o_PRD_OrdenDetDP->setDescripcionItem( $o_PRD_EquipoHerramientaBN->getDescripcion() );
            }
            if( $this->s_Tipo == "SERVICIO_EXTERNO" )
            {
                $i_IdServExt = intval( $this->getRequestParameter( 'IdServExt' ) );
                
                $o_PRD_ServicioExternoFN = new PRD_ServicioExternoFN();
                $o_PRD_ServicioExternoBN = $o_PRD_ServicioExternoFN->selectByPK( $i_IdServExt );
                
                $o_PRD_OrdenDetDP->setItemTipo( "PS" );
                $o_PRD_OrdenDetDP->setDescripcionItem( $o_PRD_ServicioExternoBN->getDescripcion() );
            }
            
            $o_PRD_OrdenDetDP->save();
            
            $this->b_Control = true;
            
        }
    }
}
