<?php
$sDirBase = dirname(__FILE__).'/../../../../../';
require $sDirBase.'plugins/dompdf-master/vendor/autoload.php';

use Dompdf\Dompdf;
use Dompdf\Options;

class GridRepaAction extends wtActions
{
    public function execute()
    {
        $this->s_Tipo     = $this->getRequestParameter( 'Tipo' );

        $this->s_IdProyecto     = $this->getRequestParameter( 'IdProyecto' );
        $this->s_NombreProyecto = $this->getRequestParameter( 'NombreProyecto' );
        $this->s_FechaCorte     = $this->getRequestParameter( 'FechaDocumento1' );

        $this->a_DataRs = array();
        //if( $this->s_IdProyecto && trim( $this->s_FechaCorte ) != "" )
        if( $this->s_IdProyecto )
        {
            $s_Sql = "SELECT * FROM SR_CotizacionDevolucionCab WHERE IdProyecto={$this->s_IdProyecto} "; //AND EstadoCorte='P';
            $o_ResultSet = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
            if( $o_ResultSet->getRecordCount() > 0 )
            {
                while ( $o_ResultSet->next() )
                {
                    $a_SQLRow = $o_ResultSet->getRow();

                    $s_IdItem = $a_SQLRow['IdItem'];

                    $o_ALM_ItemMastBN = ALM_ItemMastFN::buscarItemxId( $s_IdItem );

                    //se recupera el precio por alquiler
                    $o_MST_ListaPrecioDetalleFN = new MST_ListaPrecioDetalleFN();
                    //$o_MST_ListaPrecioDetalleFN->setIdTipoLista( 2 ); //ALQUILER
                    //$o_MST_ListaPrecioDetalleFN->setIdRango( $o_ALM_ItemMastBN->getIdRangoAlquiler() ); //RANGO ALQUILER
                    $o_MST_ListaPrecioDetalleFN->setIdTipoLista( 1 ); //VENTA
                    $o_MST_ListaPrecioDetalleFN->setIdRango( $o_ALM_ItemMastBN->getIdRangoVenta() ); //RANGO ALQUILER
                    $o_MST_ListaPrecioDetalleFN->setIdItem( $s_IdItem );
                    $a_MST_ListaPrecioDetalle = $o_MST_ListaPrecioDetalleFN->select();
                    foreach ( $a_MST_ListaPrecioDetalle as $o_TMP_MST_ListaPrecioDetalleBN )
                    {
                        $f_PrecioSinIGV = $o_TMP_MST_ListaPrecioDetalleBN->getPrecioVenta();
                    }

                    //INFORMACION PARA DEVOLUCION
                    $a_RowTMP = array();
                    $s_Sql = "SELECT c.FechaDevolucion FechaInicioAlq, 'DEVOLUCION' Tipo, LPAD( c.DevolucionCabId, 10, '0' ) Documento, d.IdItem, d.ItemDescripcion Descripcion, ( d.CantidadDevolucion ) Cantidad, d.EstadoDevolucionId, d.ComentarioDevolucion,
                                     COALESCE( d.EstadoFacturacion, 'P' ) EstadoFacturacion
                                FROM SR_DevolucionCabecera c
                                  LEFT JOIN SR_DevolucionDetalle d ON d.DevolucionCabId=c.DevolucionCabId
                                WHERE 1=1
                                  AND c.IdProyecto={$this->s_IdProyecto} AND d.IdItem='$s_IdItem' AND d.EstadoDevolucionId='RP';"; //AND c.EstadoCorte='P'
                    //pr( $s_Sql );
                    $o_ResultSet2 = Conexion::getConexion()->prepareStatement( $s_Sql )->executeQuery();
                    while ( $o_ResultSet2->next() )
                    {
                        $a_SQLRow2 = $o_ResultSet2->getRow();
                        $a_SQLRow2['FechaFinAlq'] = $a_SQLRow2['FechaInicioAlq'];
                        $a_SQLRow2['PrecioUnitarioAlq'] = $f_PrecioSinIGV;

                        $a_SQLRow2['EstadoFacturacionDesc'] = $a_SQLRow2['EstadoFacturacion'] == "P" || $a_SQLRow2['EstadoFacturacion'] == "" ? "PENDIENTE" : "REGISTRADO";

                        $o_SR_EstadoDevolucionFN  = new SR_EstadoDevolucionFN();
                        $o_SR_EstadoDevolucionBN  = $o_SR_EstadoDevolucionFN->selectByPK( $a_SQLRow2['EstadoDevolucionId'] );
                        if( $o_SR_EstadoDevolucionBN )
                        {
                            $s_EstadoDesc = strtoupper( $o_SR_EstadoDevolucionBN->getDescripcion() );
                        }
                        $a_SQLRow2['EstadoDesc'] = $s_EstadoDesc;

                        //$a_SQLRow2['Total'] = $a_SQLRow2['Cantidad'] * $f_PrecioSinIGV;
                        $a_SQLRow2['Total'] = 0;

                        $this->a_DataRs[$s_IdItem][] = $a_SQLRow2;
                    }
                }
            }

            if( $this->s_Tipo == "EXCEL" )
            {
                header( 'Content-Type: application/vnd.ms-excel' );
                header( 'Content-Disposition: attachment;filename="Liquidacion_Alquiler.xls"' );
                header( 'Cache-Control: max-age=0' );
            }

            if( $this->s_Tipo == "PDF" )
            {
                $this->generarPDF();
            }
        }

        //pr( $this->a_DataRs );

        ViewResponse::getInstance()->setMethodAjax();

    }

    public function generarPDF()
    {
        $s_Tipo             = $this->s_Tipo;
        $a_DataRs           = $this->a_DataRs;
        $s_IdProyecto       = $this->s_IdProyecto;
        $s_NombreProyecto   = $this->s_NombreProyecto;
        $s_FechaCorte       = $this->s_FechaCorte;

        $o_GSS_CompaniaFN = new GSS_CompaniaFN();
        $o_GSS_CompaniaBN = $o_GSS_CompaniaFN->selectByPK( myUser::getUser()->getIdCompania() );

        $s_Class  = ParameterWR::getInstance()->getModule();
        $s_Module = strtolower( $s_Class );
        $s_Action = ParameterWR::getInstance()->getActions();
        $s_Methods = ucwords( $s_Action );

        $s_FileTemp = SF_ROOT_DIR.DIRECTORY_SEPARATOR.'apps'.DIRECTORY_SEPARATOR.SF_APP.DIRECTORY_SEPARATOR."modules".DIRECTORY_SEPARATOR.$s_Module.DIRECTORY_SEPARATOR."templates".DIRECTORY_SEPARATOR.$s_Action."Success.php";

        ob_start();
        require( $s_FileTemp );
        $html = ob_get_contents();
        ob_end_clean();

        //echo $html;         exit;

        $dompdf = new Dompdf();
        $dompdf->loadHtml( $html );
        $dompdf->setPaper( 'A4', 'landscape' );
        $dompdf->render();
        $dompdf->stream( 'Liquidacion_'.date( "Ymd" ), array( "Attachment" => 0 ) );

        exit;
    }
}


