<?php
class tipoubicacionActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_TipoUbicacionFN() );
        
        $o_GridAction->addConditionFilter( "Nombre", MST_TipoUbicacionFN::Nombre, "LIKE", "%%s%" );
        
        $o_GridAction->addOrder( "Estado", MST_TipoUbicacionFN::Estado );
        
        $o_GridAction->addOrderDefault( MST_TipoUbicacionFN::IdTipoUbicacion, true );
        
        $o_GridAction->addRowsToShow( "IdTipoUbicacion", "Nombre", "Estado" );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;   
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Tipo Ubicacion";

        $this->o_ObjectBN = new MST_TipoUbicacionBN();

        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Tipo de Ubicacion";
            $o_MST_TipoUbicacionFN = new MST_TipoUbicacionFN();
            $this->o_ObjectBN = $o_MST_TipoUbicacionFN->selectByPK( $this->i_Id );
        }
    }

    public function executeSaveAddEdit()
    {
        $i_Id         = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc   = $this->getRequestParameter( 's_TipoProc' );
        $s_ImagenSave = $this->getRequestParameter( 'imagen_save' );

        $s_DestinoUrl  = Constantes::ROOT_DIR_IMG."no_disponible.png";
        $s_Nombre = $this->getRequestParameter( 'Nombre' );
        $s_Estado = $this->getRequestParameter( 'Estado' );
        $s_Nivel  = $this->getRequestParameter( 'Nivel' );

        try 
        {
            $o_ObjectBN = new MST_TipoUbicacionDP();
            //$o_ObjectBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            //$o_ObjectBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_ObjectBN->setNombre( $s_Nombre );
            $o_ObjectBN->setEstado( $s_Estado );
            $o_ObjectBN->setNivel( ( int ) $s_Nivel );
            $o_ObjectBN->setImagenUbicacion( $s_DestinoUrl );

            if( $s_TipoProc == "nvo" )
            {
                //nuevo
                $i_IdTabla = MST_TipoUbicacionDP::recuperarId();
                $o_ObjectBN->setIdTipoUbicacion( $i_IdTabla );
                $o_ObjectBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ObjectBN->save();
                $i_Id = $i_IdTabla;
            }
            else
            {
                if( !$s_ImagenSave )
                {
                    //actualizar
                    $o_ObjectBN->setIdTipoUbicacion( intval( $i_Id ) );
                    $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                    $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                    $b_Result = $o_ObjectBN->update();
                }
                else
                {
                    if( $s_ImagenSave == "file_to_upload" )
                    {
                        if ( isset( $_FILES['file_upload'] ) ) 
                        {
                            $PATH_UPLOAD_IMAGES_ROUTE    = $_SERVER['DOCUMENT_ROOT'].Constantes::ROOT_DIR_IMG."common/propiedades/";

                            $fileTmpPath   = $_FILES['file_upload']['tmp_name'];
                            $fileName      = $_FILES['file_upload']['name'];
                            $fileSize      = $_FILES['file_upload']['size'];
                            $fileType      = $_FILES['file_upload']['type'];
                            $fileNameCmps  = explode( ".", $fileName );
                            $fileExtension = strtolower( end( $fileNameCmps ) );

                            //$newFileName   = $o_GSS_CompaniaBN->getRuc().".".$fileExtension;

                            $uploadFileDir = $PATH_UPLOAD_IMAGES_ROUTE;
                            $dest_path     = $uploadFileDir . $fileName;
                            $s_DestinoUrl  = Constantes::ROOT_DIR_IMG."common/propiedades/".$fileName;
                             
                            //if( move_uploaded_file( $fileTmpPath, $dest_path ) )
                            if ( copy( $fileTmpPath, $dest_path ) ) 
                            {
                                //aqui se atualiza la url de la imagen
                                $o_ObjectBN = new MST_TipoUbicacionDP();
                                $o_ObjectBN->setIdTipoUbicacion( intval( $i_Id ) );
                                $o_ObjectBN->setImagenUbicacion( $s_DestinoUrl );
                                $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                                $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                                $b_Result = $o_ObjectBN->update();
                            }
                            else
                            {
                            }
                        }
                    }
                    if( $s_ImagenSave == "file_to_upload_del" )
                    {
                        $s_DestinoUrl  = Constantes::ROOT_DIR_IMG."no_disponible.png";

                        $o_ObjectBN = new MST_TipoUbicacionDP();
                        $o_ObjectBN->setIdTipoUbicacion( intval( $i_Id ) );
                        $o_ObjectBN->setImagenUbicacion( $s_DestinoUrl );
                        $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                        $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                        $b_Result = $o_ObjectBN->update();
                    }

                    //redirect
                    $s_Dir = Constantes::ROOT_DIR_APP;
                    header( "Location:".$s_Dir."mst.php/tipoubicacion/addedit/s_TipoProc/upd/i_Id/".$i_Id );
                    exit;
                }
            }

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $this->s_Titulo = "Tipo Ubicacion";

        $o_ObjectFN = new MST_TipoUbicacionFN();
        $this->o_ObjectBN = $o_ObjectFN->selectByPK( $i_Id );
    }

    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );

        $this->s_Topico = "Tipo Ubicacion";

        $o_ObjectFN = new MST_TipoUbicacionFN();
        $this->o_ObjectBN = $o_ObjectFN->selectByPK( $i_Id );
    }
}