<?php
class tallaActions extends wtActions
{
    public function executeIndex()
    {
    }

    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Listado Talla";
    }

    public function executeGrid()
    {
        $page  = $this->getRequestParameter( 'page' );

        //*set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_TallaFN() );
        //$o_GridAction->addAssignFilter( "IdCompania" );
        $o_GridAction->addAssignFilter( "Estado" );
        $o_GridAction->addConditionFilter( "Descripcion", MST_TallaFN::Descripcion, "LIKE", "%%s%" );

        $o_GridAction->addOrderDefault( MST_TallaFN::IdTalla, true );

        $o_GridAction->addRowsToShow( "IdTalla", "Descripcion", "Estado", "EstadoDesc" );

        $o_GridAction->setNumberRecordsShow( 100 );

        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeAdd()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Nueva Talla";
        $this->s_TipoProc = "nvo";
    }

    public function executeEdit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo = "Editar Talla";
        $this->i_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = "edit";

        $o_DefaultFN = new MST_TallaFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        if( !$this->o_DefaultBN )
        {
            $this->o_DefaultBN = new MST_TallaBN();
        }
    }

    public function executeSaveAddEdit()
    {
        $s_TipoProc    = $this->getRequestParameter( 'tipoProc' );

        $s_Descripcion = $this->getRequestParameter( 'Descripcion' );
        $s_Estado      = $this->getRequestParameter( 'Estado' );

        $i_IdCompania  = intval( myUser::getUser()->getIdCompania() );
        $i_IdSucursal  = intval( myUser::getUser()->getIdSucursal() );

        try
        {
            $o_DefaultDP = new MST_TallaDP();
            $o_DefaultDP->setDescripcion( $s_Descripcion );
            $o_DefaultDP->setEstado( $s_Estado );

            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $i_Id = MST_TallaDP::recuperarId();
                $o_DefaultDP->setIdTalla( $i_Id );
                $o_DefaultDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->save();
            }
            else
            {
                //UPDATE
                $i_Id = intval( $this->getRequestParameter( 'id' ) );
                $o_DefaultDP->setIdTalla( $i_Id );
                $o_DefaultDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_DefaultDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $o_DefaultDP->update();
            }

            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }

        echo json_encode( $a_Rs );

        return ViewResponse::NONE;
    }

    public function executeView()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->s_Titulo   = "Mostrar Talla";
        $this->i_Id       = $this->getRequestParameter( 'id' );
        $this->s_TipoProc = $this->getRequestParameter( 'tipoProc' );

        $o_DefaultFN = new MST_TallaFN();
        $this->o_DefaultBN = $o_DefaultFN->selectByPK( $this->i_Id );
        if( !$this->o_DefaultBN )
        {
            $this->o_DefaultBN = new MST_TallaBN();
        }
    }
}