<?php
class subfamiliaActions extends wtActions
{
    public function executeIndex()
    {
        
    }
    
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block = $this->getRequestParameter( 'block' );
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $this->a_MST_ClaseLineaBN = $o_MST_ClaseLineaFN->select();
        
        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
        $this->a_MST_ClaseFamiliaBN = $o_MST_ClaseFamiliaFN->select();
        
    }
    
    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_ClaseSubFamiliaFN() );
        
        $o_GridAction->addAssignFilter( "IdLinea" );
        $o_GridAction->addAssignFilter( "IdFamilia" );
        $o_GridAction->addAssignFilter( "Estado" );
          
        $o_GridAction->addConditionFilter( "Descripcion", MST_ClaseSubFamiliaFN::Descripcion, "LIKE", "%%s%" );
        
        $o_GridAction->addOrder( "Descripcion", MST_ClaseSubFamiliaFN::Descripcion );
        //$o_GridAction->addOrder( "Estado", MST_ClaseSubFamiliaFN::Estado );
        
        //$o_GridAction->addOrderDefault( MST_ClaseSubFamiliaFN::IdSubFamilia , true );
        
        $o_GridAction->addRowsToShow( "IdSubFamilia", "IdLinea","IdFamilia", "Estado", "ClaseLineaDesc", "ClaseFamiliaDesc", "DescripcionSubFamilia" );
        
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );
        
        return ViewResponse::NONE;
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nueva Sub-Familia";
        
        $this->o_MST_ClaseSubFamiliaBN = new MST_ClaseSubFamiliaBN();
        $this->o_MST_ClaseSubFamiliaBN->setEstado( "A" );
        
        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Sub-Familia";
            
            $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
            $this->o_MST_ClaseSubFamiliaBN = $o_MST_ClaseSubFamiliaFN->selectByPK( $this->i_Id  );
        }
    }
   
    public function executeSaveAddEdit()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );
        
        $IdLinea   = $this->getRequestParameter( 'IdLinea' );
        $IdFamilia = $this->getRequestParameter( 'IdFamilia' );
        $Descripcion = trim( $this->getRequestParameter( 'Descripcion' ) );
        $Codigo      = $this->getRequestParameter( 'Codigo' );
        $Estado      = $this->getRequestParameter( 'Estado' );
        
        $EsParaVenta              = is_null( $this->getRequestParameter( 'EsParaVenta' ) ) ? "NO"    : "SI";
        $EsParaAlquiler           = is_null( $this->getRequestParameter( 'EsParaAlquiler' ) ) ? "NO" : "SI";
        $IdRangoAlquiler          = $this->getRequestParameter( 'IdRangoAlquiler' );
        $IdRangoVenta             = $this->getRequestParameter( 'IdRangoVenta' );
        $TieneDescuentoAdelanto   = is_null( $this->getRequestParameter( 'TieneDescuentoAdelanto' ) ) ? "NO" : "SI";
        $TieneDescuentoContado    = is_null( $this->getRequestParameter( 'TieneDescuentoContado' ) ) ? "NO"  : "SI";
        $IdRangoDescuentoContado  = $TieneDescuentoContado == "SI" ? 12 : 0;
        $IdRengoDescuentoAdelanto = $TieneDescuentoAdelanto == "SI" ? 13 : 0;
        try 
        {
            $o_MST_ClaseSubFamiliaDP = new MST_ClaseSubFamiliaDP();
            $o_MST_ClaseSubFamiliaDP->setIdLinea( ( int) $IdLinea );
            $o_MST_ClaseSubFamiliaDP->setIdFamilia( ( int ) $IdFamilia );
            $o_MST_ClaseSubFamiliaDP->setDescripcion( $Descripcion );
            //$o_MST_ClaseSubFamiliaDP->setCodigo( $Codigo );
            $o_MST_ClaseSubFamiliaDP->setEstado( $Estado );
            
            $o_MST_ClaseSubFamiliaDP->setEsParaVenta( $EsParaVenta );
            $o_MST_ClaseSubFamiliaDP->setEsParaAlquiler( $EsParaAlquiler );
            $o_MST_ClaseSubFamiliaDP->setIdRangoAlquiler( ( int ) $IdRangoAlquiler );
            $o_MST_ClaseSubFamiliaDP->setIdRangoVenta( ( int ) $IdRangoVenta );
            $o_MST_ClaseSubFamiliaDP->setTieneDescuentoAdelanto( $TieneDescuentoAdelanto );
            $o_MST_ClaseSubFamiliaDP->setTieneDescuentoContado( $TieneDescuentoContado );
            $o_MST_ClaseSubFamiliaDP->setIdRangoDescuentoContado( $IdRangoDescuentoContado );
            $o_MST_ClaseSubFamiliaDP->setIdRengoDescuentoAdelanto( $IdRengoDescuentoAdelanto );
            
            if( $s_TipoProc == "nvo" )
            {
                //NUEVO
                $IdSubFamilia = MST_ClaseSubFamiliaFN::recuperarIdSubFamilia( $IdLinea, $IdFamilia );

                $Codigo = substr( $Descripcion, 0, 2 ).$IdSubFamilia;
                $o_MST_ClaseSubFamiliaDP->setCodigo( $Codigo );

                $o_MST_ClaseSubFamiliaDP->setIdSubfamilia( ( int ) $IdSubFamilia );
                $o_MST_ClaseSubFamiliaDP->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_MST_ClaseSubFamiliaDP->setUsuarioCreacion( myUser::getUser()->getUserId() );
                
                $b_Result = $o_MST_ClaseSubFamiliaDP->save();
                $i_Id = $IdSubFamilia;
            }
            else 
            {
                //UPDATE
                $o_MST_ClaseSubFamiliaDP->setIdSubFamilia( ( int ) $i_Id );
                $o_MST_ClaseSubFamiliaDP->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_MST_ClaseSubFamiliaDP->setUsuarioModificacion( myUser::getUser()->getUserId() );
              
                $b_Result = $o_MST_ClaseSubFamiliaDP->update();
            }
            
            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );
        
        $a_Ids = explode( "_", $i_Id );
        $i_IdLinea      = $a_Ids[0];
        $i_IdFamilia    = $a_Ids[1];
        $i_IdSubFamilia = $a_Ids[2];
        
        $this->s_Topico = "SubFamilia";
        $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
        $this->o_ObjectBN = $o_MST_ClaseSubFamiliaFN->selectByPK( $i_IdLinea, $i_IdFamilia, $i_IdSubFamilia  );
    }
    
    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $this->block      = $this->getRequestParameter( 'block' );
        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );

        $this->s_Titulo = "Subfamiia";

        $o_MST_ClaseSubFamiliaFN = new MST_ClaseSubFamiliaFN();
        $this->o_MST_ClaseSubFamiliaBN = $o_MST_ClaseSubFamiliaFN->selectByPK( $this->i_Id );
        
        $o_MST_ClaseLineaFN = new MST_ClaseLineaFN();
        $this->a_MST_ClaseLinea = $o_MST_ClaseLineaFN->select();
        
        $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
        $o_MST_ClaseFamiliaFN->setIdLinea( $this->o_MST_ClaseSubFamiliaBN->getIdLinea() );
        $this->a_MST_ClaseFamilia = $o_MST_ClaseFamiliaFN->select();
    }
    
    public function executeDeleteRow()
    {
        $block      = $this->getRequestParameter( 'block' );
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        try 
        {

            $o_MST_ClaseSubFamiliaDP = new MST_ClaseSubFamiliaDP();
            $o_MST_ClaseSubFamiliaDP->setIdSubFamilia( ( int ) $i_Id  );
            $o_MST_ClaseSubFamiliaDP->setEstado( "I" );
            $o_MST_ClaseSubFamiliaDP->update();

            $a_Rs['error']   = false;
            $a_Rs['id']      = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']   = true;
            $a_Rs['mensaje_error_ex'] = $o_Exception->getMessage();
            $a_Rs['mensaje_error'] = "No se pudo eliminar el registro.";
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }
    
    public function executeRequest()
    {
        
        $block      = $this->getRequestParameter( 'block' );
        $IdLinea = $this->getRequestParameter( 'IdLinea' );
        $IdFamilia = $this->getRequestParameter( 'IdFamilia' );
        $TipoProc   = $this->getRequestParameter( 'TipoProc' );
        
        switch ( $TipoProc )
        {
            case "ClaseFamilia":
                if(!$IdLinea) exit;
                $o_MST_ClaseFamiliaFN = new MST_ClaseFamiliaFN();
                $o_MST_ClaseFamiliaFN->addOrderBy( MST_ClaseFamiliaFN::Descripcion, true );
                $o_MST_ClaseFamiliaFN->setIdLinea( $IdLinea);
                $a_Result  = $o_MST_ClaseFamiliaFN->select();
                $s_NameId  = "getIdFamilia";
                $s_NameDes = "getDescripcion";
            break;
          
        }
        foreach ( $a_Result as $i_Key => $o_ObjectBN )
        {
            $a_lst[$o_ObjectBN->$s_NameId()] = $o_ObjectBN->$s_NameDes();
        }
        echo json_encode( $a_lst );
        return ViewResponse::NONE;
    }
}