<?php use_helper('UrlFunctions'); ?>
<?php use_helper( 'IncludePartial' ); ?>

<?php
/** @var MST_PersonaMastBN[] $a_MST_PersonaMast */
/** @var MST_ColorBN $o_DefaultBN */
?>
<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0"><?=$s_Titulo?></h4>
        </div>
    </div>
</div>
<div id="content_alert" style=""></div>
<form id="form1" name="form1" method="POST" onsubmit="return ejecutarGuardar();"  enctype="multipart/form-data">
    <div class="card mb-2" id="content_form">
        <div class="container">
            <div class="form-row mx-0">
                <div class="col-md-6 mb-1">
                    <label class="col-form-label" for="Codigo">Codigo</label>
                    <input type="text" class="form-control text-center" name="" id="" autocomplete="off" value="<?=$o_DefaultBN->getIdReferencia()?>" disabled >
                </div>
            </div>
            <div class="form-row mx-0">
                <div class="col-md-12 mb-1">
                    <label class="col-form-label" for="IdProveedor">Proveedor</label>
                    <select class="form-control form-control-sm custom-select my-0 mr-sm-2" name="IdProveedor" id="IdProveedor" required>
                        <option value=""> - Seleccione - </option>
                        <?php foreach ( $a_MST_PersonaMast as $o_MST_PersonaMastBN ){ ?>
                            <option value="<?=$o_MST_PersonaMastBN->getIdPersona()?>"  <?php if( $o_DefaultBN->getIdProveedor()==$o_MST_PersonaMastBN->getIdPersona() ){ echo "selected"; } ?> > <?=$o_MST_PersonaMastBN->getNombreCompleto()?> </option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="form-row mx-0">
                <div class="col-md-12 mb-1">
                    <label class="col-form-label" for="Descripcion">Descripci&oacute;n</label>
                    <input type="text" class="form-control" name="Descripcion" id="Descripcion" autocomplete="off" value="<?=$o_DefaultBN->getDescripcion()?>"  required >
                </div>
            </div>
            <div class="form-row mx-0">
                <div class="col-md-6 mb-1">
                    <label class="col-form-label" for="">Estado</label>
                    <input type="text" class="form-control" name="" id="" autocomplete="off" value="<?=$o_DefaultBN->getEstadoDesc()?>" DISABLED >
                </div>
            </div>
            <div class="dropdown-divider"></div>
            <?php
            $s_ProfileActiveTab     = "";
            $s_ProfileActiveContent = "";
            $s_HomeActiveTab        = "active";
            $s_HomeActiveContent    = "show active";
            ?>
            <ul class="nav nav-tabs" id="myTab" role="tablist">
                <?php if( $o_DefaultBN->getEstado() == MST_ReferenciaProductoBN::ESTADO_COMPLETO ){ ?>
                    <?php
                    $s_ProfileActiveTab     = "active";
                    $s_ProfileActiveContent = "show active";
                    $s_HomeActiveTab        = "";
                    $s_HomeActiveContent    = "";
                    ?>
                    <li class="nav-item">
                        <a class="nav-link <?=$s_ProfileActiveTab?>" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="true" >Productos</a>
                    </li>
                <?php } ?>
                <li class="nav-item">
                    <a class="nav-link <?=$s_HomeActiveTab?>" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="false" >General</a>
                </li>
            </ul>

            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade <?=$s_ProfileActiveContent?>" id="profile" role="tabpanel" aria-labelledby="profile-tab" >
                    <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125); padding: 1rem;">
                        <div class="form-row mx-0 mt-1 mb-1">
                            <div class="col-md-12">
                                <div class="card" id="content_datos_cliente">
                                    <h5 class="card-header">Productos</h5>
                                    <div class="card-body" style="padding: 10px;">
                                        <div class="table-responsive">
                                            <table class="table table-hover">
                                                <thead>
                                                <tr>
                                                    <th scope="col">#</th>
                                                    <th scope="col">Codigo</th>
                                                    <th scope="col">Descripcion</th>
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <?php foreach ( $a_MST_RelacionReferenciaProducto as $i_Key =>  $o_MST_RelacionReferenciaProductoBN ){ ?>
                                                    <?php
                                                    $o_ALM_ItemMastBN = $o_MST_RelacionReferenciaProductoBN->getObjectItem();
                                                    ?>
                                                    <tr>
                                                        <th scope="row"><?=($i_Key+1)?></th>
                                                        <td><?=$o_ALM_ItemMastBN->getIdItem()?></td>
                                                        <td><?=$o_ALM_ItemMastBN->getDescripcionCompleta()?></td>
                                                    </tr>
                                                <?php } ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane fade <?=$s_HomeActiveContent?>" id="home" role="tabpanel" aria-labelledby="profile-tab">
                    <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125); padding: 1rem;">
                        <div class="form-row mx-0 mt-1 mb-1">
                            <div class="col-md-12">
                                <div class="card" id="content_datos_cliente">
                                    <h5 class="card-header">Resumen</h5>
                                    <div class="card-body" style="padding: 10px;">
                                        <table class="table">
                                            <?php foreach ( $a_MST_ReferenciaProductoColor as $o_MST_ReferenciaProductoColorBN ){ ?>
                                                <?php $o_MST_ColorBN = $o_MST_ReferenciaProductoColorBN->getObjectColor(); ?>
                                                <tr>
                                                    <th width="70%" scope="col" colspan="3"><?=$o_MST_ColorBN->getCodigo()?> - <?=$o_MST_ColorBN->getDescripcion()?></th>
                                                    <td rowspan="<?=(count($o_MST_ReferenciaProductoColorBN->getArrayReferenciaProductoCatTalla())+1)?>">
                                                        <div class="row row-cols-1 row-cols-md-2">
                                                            <div class="col mb-4">
                                                                <div class="card p-2">
                                                                    <img src="<?=$o_MST_ReferenciaProductoColorBN->getImagenReferenciaWeb()?>" class="card-img-top align-self-center" alt="" style="width: 100px;">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <?php foreach ( $o_MST_ReferenciaProductoColorBN->getArrayReferenciaProductoCatTalla() as $o_MST_ReferenciaProductoCatTallaBN ){ ?>
                                                    <?php
                                                    $o_MST_CategoriaTallaBN = $o_MST_ReferenciaProductoCatTallaBN->getObjectCategoriaTalla();
                                                    ?>
                                                    <tr>
                                                        <td>&nbsp;</td>
                                                        <td><?=$o_MST_CategoriaTallaBN->getDescripcion()?></td>
                                                        <td>
                                                            <?php foreach ( $o_MST_CategoriaTallaBN->getArrayTallaRelacion() as $o_MST_CategoriaTallaRelacionBN ){ ?>
                                                                <span class="border p-2"> <?=$o_MST_CategoriaTallaRelacionBN->getObjectTalla()->getDescripcion()?> </span>&nbsp;
                                                            <?php } ?>
                                                        </td>
                                                    </tr>
                                                <?php } ?>
                                            <?php } ?>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="form-group col-14">
                <div class="dropdown-divider"></div>
            </div>
        </div>
    </div>
    <div class="form-row mx-0">
        <div class="col-md-6 mb-1">
            <button type="button" class="btn btn-danger btn-lg btn-block" onclick="parent.closeWindow()">CERRAR</button>
        </div>
        <div class="col-md-6 mb-1">
            &nbsp;
        </div>
    </div>
</form>

