<?php use_helper('UrlFunctions'); ?>
<?php use_helper( 'IncludePartial' ); ?>

<?php
/** @var MST_ReferenciaProductoBN $o_DefaultBN */
/** @var MST_PersonaMastBN[] $a_MST_PersonaMast */
/** @var MST_ReferenciaProductoColorBN[] $a_MST_ReferenciaProductoColor */
/** @var MST_ReferenciaProductoCatTallaBN[] $a_MST_ReferenciaProductoCatTalla */
/** @var MST_RelacionReferenciaProductoBN[] $a_MST_RelacionReferenciaProducto */
?>

<script>
    ejecutarGuardar = function()
    {
        x = confirm( "Esta seguro de crear los productos en base a la Talla y Color?" )
        if( x )
        {
            blockContent( 'form1' );
            var strFormSerialize = $( 'form' ).serialize();
            executeAjaxJson
            (
                "<?php echo buildUrl( 'prodref/saveAddEditProd' ) ?>",
                strFormSerialize,
                function (o_json)
                {
                    unBlockContent('form1');
                    if (o_json.error)
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        return false;
                    }
                    location.href = "<?=buildUrl( 'prodref/edit', "id=".$i_Id )?>";
                }
            );
        }
        return false;
    }

    ejecutarActualizar = function()
    {
        x = confirm( "Esta seguro de actualizar?" )
        if( x )
        {
            blockContent( 'form1' );
            var strFormSerialize = $('form').serialize();
            executeAjaxJson
            (
                "<?php echo buildUrl( 'prodref/saveAddEdit' ) ?>",
                strFormSerialize,
                function (o_json)
                {
                    unBlockContent('form1');
                    if (o_json.error)
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        return false;
                    }
                }
            );
        }
        return false;
    }
</script>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0"><?=$s_Titulo?></h4>
        </div>
    </div>
</div>
<style>
    .custom-file-label {
        font-size: 14px;
        margin: 0;
    }
    .custom-file-label {
        font-size: 12px;
        height: 27px;
    }
    .custom-file-label::after {
        height: 25px;
    }
    .custom-file .input-group-text {
        height: 27px;
    }

</style>
<div id="content_alert" style=""></div>
<div class="card mb-2" id="content_form">
    <div class="container">
        <form id="form1" name="form1" method="POST" onsubmit="return ejecutarGuardar();"  enctype="multipart/form-data">
            <input type="hidden" name="tipoProc" id="tipoProc" value="<?=$s_TipoProc?>">
            <input type="hidden" name="id" id="id" value="<?=$i_Id?>">
            <div class="form-row mx-0">
                <div class="col-md-6 mb-1">
                    <label class="col-form-label" for="Codigo">Codigo</label>
                    <input type="text" class="form-control text-center" name="" id="" autocomplete="off" value="<?=$o_DefaultBN->getIdReferencia()?>" disabled >
                </div>
            </div>
            <div class="form-row mx-0">
                <div class="col-md-12 mb-1">
                    <label class="col-form-label" for="IdProveedor">Proveedor</label>
                    <select class="form-control form-control-sm custom-select my-0 mr-sm-2" name="IdProveedor" id="IdProveedor" required>
                        <option value=""> - Seleccione - </option>
                        <?php foreach ( $a_MST_PersonaMast as $o_MST_PersonaMastBN ){ ?>
                            <option value="<?=$o_MST_PersonaMastBN->getIdPersona()?>"  <?php if( $o_DefaultBN->getIdProveedor()==$o_MST_PersonaMastBN->getIdPersona() ){ echo "selected"; } ?> > <?=$o_MST_PersonaMastBN->getNombreCompleto()?> </option>
                        <?php } ?>
                    </select>
                </div>
            </div>
            <div class="form-row mx-0">
                <div class="col-md-12 mb-1">
                    <label class="col-form-label" for="Descripcion">Codigo de Zapatilla</label>
                    <input type="text" class="form-control" name="Descripcion" id="Descripcion" autocomplete="off" value="<?=$o_DefaultBN->getDescripcion()?>"  required >
                </div>
            </div>
            <div class="form-row mx-0">
                <div class="col-md-6 mb-1">
                    <label class="col-form-label" for="">Estado</label>
                    <input type="text" class="form-control" name="" id="" autocomplete="off" value="<?=$o_DefaultBN->getEstadoDesc()?>" DISABLED >
                </div>
            </div>
        </form>
        <?php if( $o_DefaultBN->getEstado() == MST_ReferenciaProductoBN::ESTADO_PENDIENTE ){ ?>
        <div class="form-row mx-0 mt-2">
            <div class="col-md-6 mb-1">
                <button type="button" class="btn btn-primary btn-lg btn-block" onclick="abrirPopupAddEditColor()">Seleccionar Color y Talla</button>
            </div>
            <div class="col-md-6 mb-1">
                <button type="button" class="btn btn-primary btn-lg btn-block" onclick="ejecutarActualizar();">ACTUALIZAR</button>
            </div>
        </div>
        <?php } ?>

        <div class="dropdown-divider"></div>

        <?php
        $s_ProfileActiveTab     = "";
        $s_ProfileActiveContent = "";
        $s_HomeActiveTab        = "active";
        $s_HomeActiveContent    = "show active";
        ?>
        <ul class="nav nav-tabs" id="myTab" role="tablist">
            <?php if( $o_DefaultBN->getEstado() == MST_ReferenciaProductoBN::ESTADO_COMPLETO ){ ?>
                <?php
                $s_ProfileActiveTab     = "active";
                $s_ProfileActiveContent = "show active";
                $s_HomeActiveTab        = "";
                $s_HomeActiveContent    = "";
                ?>
                <li class="nav-item">
                    <a class="nav-link <?=$s_ProfileActiveTab?>" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="true" >Productos</a>
                </li>
            <?php } ?>
            <li class="nav-item">
                <a class="nav-link <?=$s_HomeActiveTab?>" id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="false" >General</a>
            </li>
        </ul>

        <div class="tab-content" id="myTabContent">
            <div class="tab-pane fade <?=$s_ProfileActiveContent?>" id="profile" role="tabpanel" aria-labelledby="profile-tab" >
                <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125); padding: 1rem;">
                    <div class="form-row mx-0 mt-1 mb-1">
                        <div class="col-md-12">
                            <div class="card" id="content_datos_cliente">
                                <h5 class="card-header">Productos</h5>
                                <div class="card-body" style="padding: 10px;">
                                    <div class="table-responsive">
                                        <table class="table table-hover">
                                            <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">Codigo</th>
                                                <th scope="col">Descripcion</th>
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <?php foreach ( $a_MST_RelacionReferenciaProducto as $i_Key =>  $o_MST_RelacionReferenciaProductoBN ){ ?>
                                                <?php
                                                $o_ALM_ItemMastBN = $o_MST_RelacionReferenciaProductoBN->getObjectItem();
                                                ?>
                                                <tr>
                                                    <th scope="row"><?=($i_Key+1)?></th>
                                                    <td><?=$o_ALM_ItemMastBN->getIdItem()?></td>
                                                    <td><?=$o_ALM_ItemMastBN->getDescripcionCompleta()?></td>
                                                </tr>
                                            <?php } ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="tab-pane fade <?=$s_HomeActiveContent?>" id="home" role="tabpanel" aria-labelledby="profile-tab">
                <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125); padding: 1rem;">
                    <div class="form-row mx-0 mt-1 mb-1">
                        <div class="col-md-12">
                            <div class="card" id="content_datos_cliente">
                                <h5 class="card-header">Resumen</h5>
                                <div class="card-body" style="padding: 10px;">
                                    <div class="form-row mx-0 mt-2">
                                        <div class="col-md-3 mb-1">
                                            <button type="button" class="btn btn-primary btn-lg btn-block" onclick="abrirPopupAniadirColor()">A&ntilde;adir</button>
                                        </div>
                                    </div>
                                    <table class="table">
                                        <?php foreach ( $a_MST_ReferenciaProductoColor as $o_MST_ReferenciaProductoColorBN ){ ?>
                                            <?php
                                            $i_IdColor = $o_MST_ReferenciaProductoColorBN->getIdColor();
                                            $i_IdReferencia = $o_MST_ReferenciaProductoColorBN->getIdReferencia();
                                            $o_MST_ColorBN = $o_MST_ReferenciaProductoColorBN->getObjectColor();
                                            ?>
                                            <tr>
                                                <th width="70%" scope="col" colspan="3"><?=$o_MST_ColorBN->getCodigo()?> - <?=$o_MST_ColorBN->getDescripcion()?></th>
                                                <td rowspan="<?=(count($o_MST_ReferenciaProductoColorBN->getArrayReferenciaProductoCatTalla())+1)?>">
                                                    <form name="form2" id="form2" method="POST" action="<?php echo buildUrl( 'prodref/guardarImagen' ) ?>" enctype="multipart/form-data">
                                                        <input type="hidden" name="id" id="id" value="<?=$i_Id?>">
                                                        <input type="hidden" name="idColor" id="idColor" value="<?=$o_MST_ColorBN->getIdColor()?>">
                                                        <input type="hidden" name="tipoProcImg" id="tipoProcImg_<?=$i_IdColor?>" value="">
                                                        <div class="row row-cols-1 row-cols-md-2">
                                                            <div class="col mb-4">
                                                                <div class="card">
                                                                    <img src="<?=$o_MST_ReferenciaProductoColorBN->getImagenReferenciaWeb()?>" class="card-img-top align-self-center" alt="" style="width: 100px;">
                                                                    <div class="card-body align-self-center" style="padding: 8px;">
                                                                        <div class="custom-file">
                                                                            <input type="file" name="file_upload" id="file_upload_<?=$i_IdColor?>" class="" style="border: 1px solid #ced4da" id="customFileLang" lang="es">
                                                                        </div>
                                                                        <table width="100%">
                                                                            <tr>
                                                                                <td align="center"><button type="submit" class="btn btn-danger btn-sm" onclick="$('#tipoProcImg_<?=$i_IdColor?>').val('file_to_upload_del');">Eliminar</button>&nbsp;</td>
                                                                                <td align="center"><button type="submit" class="btn btn-primary btn-sm" onclick="$('#tipoProcImg_<?=$i_IdColor?>').val('file_to_upload');">Grabar</button></td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </td>
                                            </tr>
                                                <?php foreach ( $o_MST_ReferenciaProductoColorBN->getArrayReferenciaProductoCatTalla() as $o_MST_ReferenciaProductoCatTallaBN ){ ?>
                                                <?php
                                                $o_MST_CategoriaTallaBN = $o_MST_ReferenciaProductoCatTallaBN->getObjectCategoriaTalla();
                                                ?>
                                            <tr>
                                                <td>&nbsp;</td>
                                                <td><?=$o_MST_CategoriaTallaBN->getDescripcion()?></td>
                                                <td>
                                                    <?php foreach ( $o_MST_CategoriaTallaBN->getArrayTallaRelacion() as $o_MST_CategoriaTallaRelacionBN ){ ?>
                                                        <span class="border p-2"> <?=$o_MST_CategoriaTallaRelacionBN->getObjectTalla()->getDescripcion()?> </span>&nbsp;
                                                    <?php } ?>
                                                </td>
                                            </tr>
                                                <?php } ?>
                                        <?php } ?>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group col-14">
            <div class="dropdown-divider"></div>
        </div>
    </div>
</div>

<div class="form-row mx-0">
    <div class="col-md-6 mb-1">
        <button type="button" class="btn btn-danger btn-lg btn-block" onclick="location.href='<?php echo buildUrl( 'prodref/list' ) ?>'">CANCELAR</button>
    </div>
    <div class="col-md-6 mb-1">
        <?php if( $o_DefaultBN->getEstado() == MST_ReferenciaProductoBN::ESTADO_PENDIENTE ){ ?>
        <button type="button" class="btn btn-primary btn-lg btn-block" onclick="$( '#form1' ).submit();">GENERAR PRODUCTOS</button>
        <?php } ?>
    </div>
</div>


<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<style type="text/css">
    .modal
    {
        padding: 0 !important;
    }
    .modal-dialog {
        max-width: 95% !important;
        height: 90%;
        /*  padding: 0;
          margin: 0;*/
    }

    .modal-content {
        /*border-radius: 0 !important;*/
        height: 90%;
    }
</style>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<!-- Modal - NUEVO CLIENTE -->
<div class="modal hide fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle">Nuevo Cliente</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id" src="" style="" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    abrirPopupAniadirColor = function()
    {
        var frameSrc = "<?=buildUrl( 'prodref/aniadirNuevoColor', 'idReferencia=' )?>" + $( "#id" ).val();
        $( "#exampleModalLongTitle" ).html( "Añadir Color" );
        $( '#iframe_id' ).attr( "src", frameSrc );
        $( '#exampleModalCenter' ).modal( { show:true } );
    }
    abrirPopupAddEditColor = function()
    {
        var frameSrc = "<?=buildUrl( 'prodref/addeditColor', 'idReferencia=' )?>" + $( "#id" ).val();
        $( "#exampleModalLongTitle" ).html( "Asociar Color" );
        $( '#iframe_id' ).attr( "src", frameSrc );
        $( '#exampleModalCenter' ).modal( { show:true } );
    }
    abrirPopupAddEditCatTalla = function()
    {
        var frameSrc = "<?=buildUrl( 'prodref/addeditCatTall', 'idReferencia=' )?>" + $( "#id" ).val();
        $( "#exampleModalLongTitle" ).html( "Asociar Categoria Talla" );
        $( '#iframe_id' ).attr( "src", frameSrc );
        $( '#exampleModalCenter' ).modal( { show:true } );
    }
    ocultarModal = function()
    {
        $( '#exampleModalCenter' ).modal( 'hide' );
    }
    $('#exampleModalCenter').on('hidden.bs.modal', function ( event )
    {
        blockContent( 'form1' );
        console.log( "Me cierro!" );
        location.reload();
    });
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->