<?php use_helper('UrlFunctions'); ?>
<?php use_helper( 'IncludePartial' ); ?>

<?php
/** @var MST_ColorBN[] $a_MST_Color */
/** @var MST_CategoriaTallaBN[] $a_MST_CategoriaTalla */
?>
<script>
    validarCheck = function( elm, ref )
    {
        if( !$( elm ).is( ':checked' ) )
        {
            $( '[refcolor="' + ref + '"]' ).each
            (
                function ( index, domEle )
                {
                    $( domEle ).prop( "checked", false );
                }
            );
        }
    }

    actualizaControl = function()
    {
        $( "#form1" ).submit();
    }
</script>
<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0"><?=$s_Titulo?></h4>
        </div>
    </div>
</div>

<div id="content_alert" style=""></div>

<form class="needs-validation" name="form1" id="form1" method="POST" action="" onsubmit="">
    <input type="hidden" name="control" id="control" value="1">
    <input type="hidden" name="idReferencia" id="idReferencia" value="<?=$idReferencia?>">
    <div id="accordion" class="mb-2">
        <div class="card">
            <div class="card-body pb-1">
                <div class="form-row mx-0">
                    <div class="col-md-4 mb-1">
                        <label class="col-form-label" for="CodigoColor">Codigo Color</label>
                        <input type="text" class="form-control" name="CodigoColor" id="CodigoColor" placeholder="" autocomplete="off" value="<?=$s_CodigoColor?>">
                    </div>
                    <div class="col-md-4 mb-1">
                        <label class="col-form-label" for="CatTalla">Categoria Talla</label>
                        <select class="form-control" name="CatTalla" id="CatTalla" >
                            <option value=""> - SELECCIONE - </option>
                            <?php foreach ( $a_FndCatTalla as $o_FND_MST_CategoriaTallaBN ){ ?>
                            <option value="<?=$o_FND_MST_CategoriaTallaBN->getIdCatTalla()?>" <?php if( $s_CatTalla==$o_FND_MST_CategoriaTallaBN->getIdCatTalla() ){ echo "selected"; } ?> >
                                <?=$o_FND_MST_CategoriaTallaBN->getDescripcion()?> 
                            </option>
                            <?php } ?>
                        </select>
                    </div>
                    <div class="text-center mt-2">
                        <button class="btn btn-primary text-center" type="button" onclick="actualizaControl();">Buscar</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <br>
    <div class="container">
        <div class="form-row mx-0">
            <div class="col-md-4 mb-1">
                &nbsp;
            </div>
            <div class="col-md-4 mb-1">
                <button type="submit" class="btn btn-primary btn-lg btn-block" onclick="">ACTUALIZAR</button>
            </div>
            <div class="col-md-4 mb-1">
                &nbsp;
            </div>
        </div>
        <div class="card">
            <div class="form-row mx-0 mt-1 mb-1">
                <div class="col-md-12">
                    <div class="card" id="content_datos_cliente">
                        <h5 class="card-header">Resumen</h5>
                        <div class="card-body" style="padding: 10px;">

                            <table class="table">

                                <?php foreach ( $a_MST_Color as $o_MST_ColorBN ){ ?>
                                    <?php
                                    $s_IdColor = $o_MST_ColorBN->getIdColor();
                                    $o_MST_ReferenciaProductoColorFN = new MST_ReferenciaProductoColorFN();
                                    $o_ObjectBN = $o_MST_ReferenciaProductoColorFN->selectByPK( $idReferencia, $s_IdColor );
                                    ?>
                                    <tr>
                                        <th scope="col" colspan="2">
                                            <div class="col-md-6 mb-2">
                                                <div class="custom-control custom-checkbox">
                                                    <input type="checkbox" class="custom-control-input" id="color_<?=$s_IdColor?>" name="idColor[<?=$s_IdColor?>]" value="<?=$s_IdColor?>" <?php if( $o_ObjectBN ){ echo "checked"; } ?>
                                                            onclick="validarCheck( this, <?=$s_IdColor?> );"
                                                        >
                                                    <label class="custom-control-label" for="color_<?=$s_IdColor?>"><?=$o_MST_ColorBN->getCodigo()?> - <?=$o_MST_ColorBN->getDescripcion()?></label>
                                                </div>
                                            </div>
                                        </th>
                                    </tr>
                                    <?php foreach ( $a_MST_CategoriaTalla as $o_MST_CategoriaTallaBN ){ ?>
                                        <?php
                                        $s_IdCatTalla = $o_MST_CategoriaTallaBN->getIdCatTalla();
                                        $o_MST_ReferenciaProductoCatTallaFN = new MST_ReferenciaProductoCatTallaFN();
                                        $o_Object2BN = $o_MST_ReferenciaProductoCatTallaFN->selectByPK( $idReferencia, $s_IdColor, $s_IdCatTalla );
                                        ?>
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td>
                                            <div class="custom-control custom-checkbox">
                                                <input type="checkbox" class="custom-control-input" refcolor="<?=$s_IdColor?>" id="catetalla_<?=$s_IdColor?>_<?=$s_IdCatTalla?>" name="idCatTalla[<?=$s_IdColor?>][<?=$s_IdCatTalla?>]" value="<?=$s_IdCatTalla?>" <?php if( $o_Object2BN ){ echo "checked"; } ?> >
                                                <label class="custom-control-label" for="catetalla_<?=$s_IdColor?>_<?=$s_IdCatTalla?>"><?=$o_MST_CategoriaTallaBN->getDescripcion()?></label>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php } ?>
                                <?php } ?>

                            </table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        <br>
        <div class="form-row mx-0">
            <div class="col-md-4 mb-1">
                &nbsp;
            </div>
            <div class="col-md-4 mb-1">
                <button type="submit" class="btn btn-primary btn-lg btn-block" onclick="">ACTUALIZAR</button>
            </div>
            <div class="col-md-4 mb-1">
                &nbsp;
            </div>
        </div>
    </div>
</form>