<?php
class pisosActions extends wtActions
{
    public function executeList()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
    }

    public function executeGrid()
    {
        $block = $this->getRequestParameter( 'block' );
        $page  = $this->getRequestParameter( 'page' );
        
        set_header_utf8();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $o_GridAction = new GridAction();
        $o_GridAction->setClassFind( new MST_UbicacionFN() );
        
        $o_GridAction->addConditionFilter( "Nombre", MST_UbicacionFN::Nombre, "LIKE", "%%s%" );

        $o_GridAction->addMethodDefault( MST_UbicacionFN::IdUbicacionPertenece, array( 'Condition'=>'=', 'Value'=>"0" ) );
        
        $o_GridAction->addOrder( "Estado", MST_UbicacionFN::Estado );
        
        $o_GridAction->addOrderDefault( MST_UbicacionFN::IdUbicacion, true );
        
        $o_GridAction->addRowsToShow( "IdUbicacion", "Nombre", "Estado" );
              
        $o_GridAction->setNumberRecordsShow( 100 );
        
        $o_GridAction->initialize();
        ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
        $a_ResultJson['page']    = $o_GridAction->getPage();
        $a_ResultJson['total']   = $o_GridAction->getTotalPage();
        $a_ResultJson['records'] = $o_GridAction->getTotalRecords();
        $a_ResultJson['rows']    = $o_GridAction->getResultArray();
        //pr( $a_ResultJson );
        echo json_encode( $a_ResultJson );

        return ViewResponse::NONE;
    }

    public function executeAddedit()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();

        $this->i_Id       = $this->getRequestParameter( 'i_Id' );
        $this->s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        
        $this->s_Titulo = "Nuevo Piso";

        $this->o_ObjectBN = new MST_UbicacionBN();

        if( $this->s_TipoProc == "upd" )
        {
            $this->s_Titulo = "Editar Piso";
            $o_MST_PisosMastFN = new MST_UbicacionFN();
            $this->o_ObjectBN = $o_MST_PisosMastFN->selectByPK( $this->i_Id );
        }
    }

    public function executeSaveAddEdit()
    {
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        $s_TipoProc = $this->getRequestParameter( 's_TipoProc' );
        $TypeSub    = $this->getRequestParameter( 'TypeSub' );

        $s_Nombre          = $this->getRequestParameter( 'Nombre' );
        $s_Estado          = $this->getRequestParameter( 'Estado' );
        $s_Descripcion     = $this->getRequestParameter( 'Descripcion' );
        $s_IdTipoUbicacion = $this->getRequestParameter( 'IdTipoUbicacion' );

        try 
        {
            $o_ObjectBN = new MST_UbicacionDP();
            $o_ObjectBN->setIdCompania( myUser::getUser()->getIdBusiness() );
            $o_ObjectBN->setIdSucursal( myUser::getUser()->getIdSucursal() );
            $o_ObjectBN->setIdTipoUbicacion( intval( $s_IdTipoUbicacion ) );
            $o_ObjectBN->setIdUbicacionPertenece( 0 );
            $o_ObjectBN->setNombre( $s_Nombre );
            $o_ObjectBN->setDescripcion( $s_Descripcion );
            $o_ObjectBN->setEstado( $s_Estado );

            if( $s_TipoProc == "nvo" )
            {
                //nuevo
                $i_IdTabla = MST_UbicacionDP::recuperarId();
                $o_ObjectBN->setIdUbicacion( $i_IdTabla );
                $o_ObjectBN->setFechaCreacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioCreacion( myUser::getUser()->getUserId() );
                $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ObjectBN->save();
                $i_Id = $i_IdTabla;
            }
            else
            {
                //actualizar
                $o_ObjectBN->setIdUbicacion( intval( $i_Id ) );
                $o_ObjectBN->setFechaModificacion( date( "Y-m-d H:i:s" ) );
                $o_ObjectBN->setUsuarioModificacion( myUser::getUser()->getUserId() );
                $b_Result = $o_ObjectBN->update();
            }

            $a_Rs['type_sub'] = $TypeSub;
            $a_Rs['error']    = false;
            $a_Rs['id']       = $i_Id;
        }
        catch ( Exception $o_Exception )
        {
            $a_Rs['error']         = true;
            $a_Rs['mensaje_error'] = $o_Exception->getMessage();
        }
        echo json_encode( $a_Rs );
        return ViewResponse::NONE;
    }

    public function executeViewdel()
    {
        LayoutTemplate::getInstance()->setUseBootstrap();
        
        $i_Id       = $this->getRequestParameter( 'i_Id' );
        
        $this->s_Titulo = "Piso";

        $o_MST_PisosMastFN = new MST_UbicacionFN();
        $this->o_ObjectBN = $o_MST_PisosMastFN->selectByPK( $i_Id );
    }

    public function executeAudi()
    {
        $block          = $this->getRequestParameter( 'block' );
        $i_Id           = $this->getRequestParameter( 'i_Id' );

        $this->s_Topico = "Pisos";

        $o_MST_PisosMastFN = new MST_UbicacionFN();
        $this->o_ObjectBN = $o_MST_PisosMastFN->selectByPK( $i_Id );
    }
}