<?php use_helper( 'UrlFunctions' ); ?>
<?php use_helper( 'IncludePartial' ); ?>
<?php use_helper( 'UtilFunctions' ); ?>

<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/dataTables.bootstrap4.min.css" />
<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/responsive/2.2.5/css/responsive.bootstrap4.min.css" />
<!--<link rel="stylesheet" type="text/css" media="screen" href="https://cdn.datatables.net/1.10.21/css/jquery.dataTables.min.css" />-->

<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/1.10.21/js/dataTables.bootstrap4.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/dataTables.responsive.min.js"></script>
<script type="text/javascript" src="https://cdn.datatables.net/responsive/2.2.5/js/responsive.bootstrap4.min.js"></script>

<div class="shadow-sm p-3 mb-2 bg-white rounded card card-body">
    <div class="row">
        <div class="col mb-1">
            <h4 class="text-info text-nowrap mb-0"><?=$s_Titulo?></h4>
        </div>
    </div>
</div>

<div id="content_alert" style=""></div>

<ul class="nav nav-tabs" id="myTab" role="tablist">
    <li class="nav-item">
        <a class="nav-link " id="home-tab" data-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true" onclick="location.href='<?=buildUrl( 'persona/addedit', "s_TipoProc=$s_TipoProc&i_Id=".$o_MST_PersonaMastBN->getIdPersona() )?>';">General</a>
    </li>
    <li class="nav-item">
        <a class="nav-link active" id="profile-tab" data-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false" onclick="location.href='<?=buildUrl( 'persona/addeditprj', "s_TipoProc=$s_TipoProc&i_Id=".$o_MST_PersonaMastBN->getIdPersona() )?>';">Proyectos</a>
    </li>
</ul>

<div class="tab-content" id="myTabContent">
    <div class="tab-pane fade show active" id="profile" role="tabpanel" aria-labelledby="profile-tab">
        <div class="" style="border-left: 1px solid rgba(0,0,0,.125); border-right: 1px solid rgba(0,0,0,.125); border-bottom: 1px solid rgba(0,0,0,.125); padding: 1rem;">

            <div class="form-row mx-0">
                <div class="col-md-8 mb-1">
                    <div class="table-responsive" id="content_form">
                        <table class="table table-borderless" style="">
                            <tbody>
                            <tr>
                                <th class="text-nowrap" width="5%">Codigo:</th>
                                <td class="text-nowrap" width="5%"><?=$o_MST_PersonaMastBN->getIdPersona()?></td>
                                <th class="text-nowrap" width="5%">Nombre / Razon Social:</th>
                                <td class="text-nowrap" width="20%"><?=$o_MST_PersonaMastBN->getNombreCompleto()?></td>
                                <th class="text-nowrap" width="5%"><?=$o_MST_PersonaMastBN->getTipoDocumento()?>:</th>
                                <td class="text-nowrap" width="5%"><?=$o_MST_PersonaMastBN->getDocumento()?></td>
                                <td class="text-nowrap" width="40%">&nbsp;</td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="col-md-2 mb-1">
                    <button type="button" class="btn btn-primary btn-block" id="btnProyectoBus" style="margin-top: 0;" onclick="">NUEVO PROYECTO</button>
                    <script>
                        actualizarProyecto = function( IdProyecto, Nombre )
                        {
                            $( '#example' ).DataTable().ajax.reload();
                            ocultarModal();
                        }
                        $( "#btnProyectoBus" )
                            .click
                            (
                                function()
                                {
                                    var frameSrc = "<?=buildUrlComplet( 'vta.php/cot/addeditProy', 'TipoProc=nvo&IdPersona='.$o_MST_PersonaMastBN->getIdPersona() )?>";
                                    $( "#exampleModalLongTitle" ).html( "Nuevo Proyecto" );
                                    $( '#iframe_id' ).attr("src", frameSrc );
                                    $( '#exampleModalCenter' ).modal( { show: true } );
                                }
                            );
                    </script>
                </div>
                <div class="col-md-2 mb-1">
                    <button type="button" class="btn btn-danger btn-block" onclick="location.href='<?php echo buildUrl( 'persona/list' ) ?>'">CANCELAR</button>
                </div>
            </div>

            <div class="dropdown-divider"></div><br>

            <div id="content_grid">
                <table id="example" class="table table-striped table-bordered" style="width:100%">
                </table>
            </div>

        </div>
    </div>
</div>


<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->
<style type="text/css">
    .modal
    {
        padding: 0 !important;

    }
    .modal-dialog {
        max-width: 95% !important;
        height: 90%;
        /*  padding: 0;
          margin: 0;*/
    }

    .modal-content {
        /*border-radius: 0 !important;*/
        height: 90%;
    }
    .modal-body{
        overflow-y: auto;
    }
</style>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<!-- Modal -  -->
<div class="modal hide fade" id="exampleModalCenter" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLongTitle"></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <iframe id="iframe_id" src="" style="zoom:0.60;" width="99.6%" height="99.6%" frameborder="0"></iframe>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal" onclick="">Cerrar</button>
                <!--<button type="button" class="btn btn-primary">Save changes</button>-->
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
    ocultarModal = function()
    {
        $( '#exampleModalCenter' ).modal( 'hide' );
    }

    abrirModal = function( IdProyecto )
    {
        var frameSrc = "<?=buildUrlComplet( 'vta.php/cot/proyectos', '' )?>IdProyecto/" + IdProyecto;
        $( "#exampleModalLongTitle" ).html( "Resumen Proyecto" );
        $( '#iframe_id' ).attr( "src", frameSrc );
        $( '#exampleModalCenter' ).modal( { show:true } );
    }

    anularAbrirModal = function( IdProyecto )
    {
        x = confirm( "Esta seguro de anular el Proyecto?" );
        if( x )
        {
            blockContent( 'content_grid' );
            strFormSerialize = "IdPersona=<?=$o_MST_PersonaMastBN->getIdPersona()?>&IdProyecto=" + IdProyecto + "&TipoProc=AnularProyecto";
            executeAjaxJson
            (
                "<?php echo buildUrl( 'persona/request' ) ?>",
                strFormSerialize,
                function( o_json )
                {
                    unBlockContent( 'content_grid' );
                    if( o_json.error )
                    {
                        showAlertBootStrap( 'content_alert', 'alert-danger', o_json.mensaje_error );
                        return false;
                    }

                    $( '#example' ).DataTable().ajax.reload();
                }
            );
        }
    }
</script>
<!-- //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// -->

<script>
    $( '#example' ).DataTable
    (
        {
            ajax: '<?=buildUrl( 'persona/request', "TipoProc=BuscarProyectos&IdPersona=".$o_MST_PersonaMastBN->getIdPersona() )?>',
            language: { "url": "//cdn.datatables.net/plug-ins/9dcbecd42ad/i18n/Spanish.json" },
            //responsive: { details: true },
            responsive: true,
            //destroy: true,
            bRetrieve: true,
            aoColumns :
                [
                    { "mData": "s_NombreProyecto", 'sClass': 'text-center', "title": "Nombre" },
                    { "mData": "s_Contacto", 'sClass': 'text-center', "title": "Contacto" },
                    { "mData": "Documento", 'sClass': 'text-center', "title": "Clasificacion" },
                    { "mData": "s_Cargo", 'sClass': 'text-center', "title": "Cargo" },
                    { "mData": "s_Telefono", 'sClass': 'text-center', "title": "Telefono" },
                    { "mData": "s_Correo", 'sClass': 'text-center', "title": "Correo" },
                    { "mData": "EstadoDesc", 'sClass': 'text-center', "title": "Estado" },
                    {
                        'sClass': 'text-center',
                        "title": "",
                        'mData': function ( data, type, full )
                        {
                            if( data.s_Estado == "P" )
                            {
                                return '<a href=\'javascript:void(0);\' title="VER DETALLES" ><i class=\'ace-icon far fa-file bigger-130\' onclick="abrirModal(\'' + data.i_IdProyecto + '\')" ></i></a>';
                            }
                            else
                            {
                                return "";
                            }
                        }
                    },
                    {
                        'sClass': 'text-center',
                        "title": "",
                        'mData': function ( data, type, full )
                        {
                            if( data.s_Estado == "P" )
                            {
                                return '<a href=\'javascript:void(0);\' title="ANULAR" ><i class=\'ace-icon fas fa-ban bigger-130\' onclick="anularAbrirModal(\'' + data.i_IdProyecto + '\')" ></i></a>';
                            }
                            else
                            {
                                return "";
                            }
                        }
                    }
                ]
        }
    );

    $( '#exampleModalCenter' ).on
    (
        'hidden.bs.modal', function ( e )
        {
            pr( "Se cerro" );
            $( '#example' ).DataTable().ajax.reload();
        }
    );
</script>

<style>
    #example tbody tr.even:hover, #example tbody tr.even td.highlighted
    {
        background-color: #becedf;
    }

    #example tbody tr.odd:hover, #example tbody tr.odd td.highlighted
    {
        background-color: #becedf;
    }

    #example td.highlight
    {
        background-color: #b8daff !important;
    }
</style>